
По сравнению с некоторыми (в первую очередь функциональными) языками, определение функции в JavaScript выглядит довольно громоздко:

```javascript
const square = (x) => {
  return x ** 2;
};
```

Здесь используется много дополнительных символов и слово `return`. С версии es6, в языке появился альтернативный, сокращенный синтаксис, который, в некоторых ситуациях, значительно упрощает восприятие и сокращает количество кода.

```javascript
// Требуется немного времени на привыкание к этой форме
// но потом вы не сможете без неё жить
const double = (x) => x ** 2;
```

Отличия от полного определения два: пропали фигурные скобки и инструкция `return`. Сокращенная запись функции делает возврат автоматически. Подразумевается, что внутри такой функции ровно одно выражение, которое вычисляется, и её результат сразу возвращается наружу.

Подчеркнём, что отличия исключительно синтаксические, с точки зрения использования различий нет. Пример с двумя аргументами:

Полная версия

```javascript
const sum = (a, b) => {
  return a + b;
};
```

Сокращенная версия

```javascript
const sum = (a, b) => a + b;
```

https://replit.com/@hexlet/js-basics-define-functions-short-syntax

Обратите внимание на отсутствие фигурных скобок. Разработчики, которые не привыкли использовать такой синтаксис, иногда пишут подобный код `const sum = (a, b) => { a + b };`, а потом долго не могут понять, почему он не работает. Ответ очень простой: если стоят фигурные скобки, то это не сокращенная форма, а значит, чтобы функция вернула значение, придётся поставить `return`.
