
Функции могут не только возвращать значения, но и принимать их в виде параметров (ещё называют аргументами). С параметрами функций мы уже сталкивались много раз:

```javascript
// Принимает на вход параметр любого типа
console.log('я параметр');
// Принимает на вход два строковых параметра
// первый – что ищем, второй – на что меняем
'google'.replace('go', 'mo'); // moogle
// Принимает на вход два числовых параметра
// первый – начальный индекс (включая), второй – конечный индекс (не включая)
'hexlet'.slice(1, 3); // ex
```

В этом уроке мы научимся создавать функции, которые принимают на вход параметры. Представим, что перед нами стоит задача – реализовать функцию `getLastChar()`, возвращающую последний символ в строке, переданной ему на вход как параметр. Вот как будет выглядеть использование этой функции:

```javascript
// Передача параметров напрямую без переменных
getLastChar('Hexlet'); // t
// Передача параметров через переменные
const name1 = 'Hexlet';
getLastChar(name1); // t
const name2 = 'Goo';
getLastChar(name2); // o
```

Из описания и примеров кода мы можем сделать следующие выводы:

* Нам нужно определить функцию `getLastChar()`
* Функция должна принимать на вход один параметр строкового типа
* Функция должна возвращать значение строкового типа

Определение функции:

```javascript
const getLastChar = (text) => {
  // Вычисляем индекс последнего символа как длина строки - 1
  return text[text.length - 1];
};
```

Разберем его. В скобках указывается имя переменой `text`, которая служит нам параметром. Имя параметра может быть любым. Главное, чтобы оно отражало смысл того значения, которое содержится внутри. Мы могли бы определить функцию и вот так:

```javascript
const getLastChar = (str) => {
  return str[str.length - 1];
};
```

Конкретное значение параметра будет зависеть от вызова этой функции.

```javascript
// Внутри функции str будет равна 'hexlet'
getLastChar('hexlet'); // t

// Внутри функции str будет равна 'code'
getLastChar('code'); // e

// Внутри функции str будет равна 'Winter is coming'
// Имя переменной снаружи не связанно с именем переменной в определении функции
const text = 'Winter is coming';
getLastChar(text); // g
```

Точно таким же образом можно указывать два, три и более параметра. Каждый параметр отделяется от другого запятой:

```javascript
// функция по нахождению среднего числа
const average = (a, b) => {
  return (a + b) / 2;
};

average(1, 5); // 3
average(1, 2); // 1.5
```

https://replit.com/@hexlet/js-basics-define-functions-parameters

То же самое относится и к методам. Они могут требовать на вход любое количество параметров, которое им нужно для работы:

```javascript
// первый параметр – что ищем
// второй параметр – на что меняем
'google'.replace('go', 'mo'); // moogle
````

Для создания таких функций и методов, нужно в определении указать нужное количество параметров через запятую, дав им понятные имена. Ниже пример определения функции `replace()`, которая заменяет в слове одну часть строки на другую:

```javascript
const replace = (text, from, to) => {
  // здесь тело функции, но мы его
  // опускаем, чтобы не отвлекаться
};

replace('google', 'go', 'mo'); // moogle
```

Когда параметров два и более, то практически для всех функций становится важен порядок передачи этих параметров. Если его поменять, то функция отработает по-другому:

```javascript
// ничего не заменилось,
// так как внутри google нет mo
replace('google', 'mo', 'go'); // google
```
