
Функции, которые мы определяли в предыдущих уроках, заканчивали свою работу тем, что печатали на экран какие-то данные:

```javascript
const greeting = () => {
  console.log('Hello, Hexlet!');
};
```

Пользы от таких функций не очень много, так как результатом их работы невозможно воспользоваться внутри программы. Рассмотрим это на примере.

Возьмем задачу обработки электронной почты. Когда пользователь регистрируется на каком-то сайте, то он может ввести email любым способом:

* Добавив случайно пробелы в начале или в конце `_support@hexlet.io__`
* Использовав буквы в разном регистре `SUPPORT@hexlet.io`

Если мы сохраним его в таком виде в базу данных, то пользователь, скорее всего, не сможет войти на сайт, так как будет вбивать адрес без пробелов и используя другой регистр символов. Чтобы этого не произошло, email нужно подготовить к записи в базу, привести его к нижнему регистру и обрезать пробельные символы по краям строки. Вся задача решается в пару строчек:

```javascript
const saveEmail = () => {
  // В реальности email приходит из формы
  const email = '  SuppORT@hexlet.IO';
  // обрезаем пробельные символы
  const trimmedEmail = email.trim();
  const preparedEmail = trimmedEmail.toLowerCase();
  console.log(preparedEmail);
  // здесь будет запись в базу данных
};
```

Этот код стал возможен только благодаря возврату значения. Методы `trim()` и `toLowerCase()` ничего не печатают на экран (в консоль), они **возвращают** результат своей работы и поэтому мы можем записать его в константы. Если бы они вместо этого печатали на экран, мы бы не могли присвоить результат их работы константе. Как мы не можем сделать с определенной выше функцией `greeting()`:

```javascript
const message = greeting();
console.log(message); // => undefined
```

Изменим функцию `greeting()` таким образом, чтобы она начала возвращать данные, вместо их печати. Для этого нам понадобится выполнить возврат вместо печати на экран

```javascript
const greeting = () => {
  return 'Hello, Hexlet!';
};
```

`return` – особая инструкция, которая берёт выражение, записанное справа. Затем она отдаёт это выражение наружу, тому коду, который вызвал функцию. Как только JavaScript натыкается на `return`, выполнение функции на этом завершается.

```javascript
// Теперь мы можем использовать результат работы функции
const message = greeting();
console.log(message); // => Hello, Hexlet!
// И даже выполнить какие-то действия над результатом
console.log(message.toUpperCase()); // => HELLO, HEXLET!
```

Любой код после `return` не выполняется:

```javascript
const greetingWithCodeAfterReturn = () => {
  return 'Hello, Hexlet!';
  console.log('Я никогда не выполнюсь');
};
```

Даже если функция возвращает данные, это не ограничивает её в том, что она печатает. Кроме возврата данных мы можем и печатать:

```javascript
const greetingWithReturnAndPrinting = () => {
  console.log('Я появлюсь в консоли');
  return 'Hello, Hexlet!';
};

// И напечатает текст на экран и вернет значение
const message = greetingWithReturnAndPrinting ();
```

Возвращать можно не только конкретное значение. Так как `return` работает с выражениями, то справа от него может появиться почти все что угодно. Здесь нужно руководствоваться принципами читаемости кода:

```javascript
const greeting = () => {
  const message = 'Hello, Hexlet!';
  return message;
};
```

Здесь мы не возвращаем переменную, возвращается всегда значение, которое находится в этой переменной. Ниже пример с вычислениями:

```javascript
const doubleFive = () => {
  // или return 5 + 5
  const result = 5 + 5;
  return result;
};
```

Вопрос на самопроверку. Что вернет вызов, определенной ниже, функции `run()`?

```javascript
// Определение
const run = () => {
  return 5;
  return 10;
};

// Что будет выведено на экран?
console.log(run());
```

<details>
<summary>Ответ</summary>

На экран будет выведено `5`.

</details>

https://replit.com/@hexlet/js-basics-functions-return
