
Определение собственных функций значительно упрощает написание и поддержку программ. Функции позволяют объединять сложные (составные) операции в одну. Например, отправка письма на сайте - это достаточно сложный процесс, включающий в себя взаимодействие с внешними системами (интернет). Благодаря возможности определять функции, вся сложность может быть скрыта за одной простой функцией:

```javascript
// Гипотетический пример
// Место откуда берется функция
import { send } from 'mailer';

const email = 'support@hexlet.io';
const title = 'Помогите';
const body = 'Я написал историю успеха, как я могу получить скидку?';

// Один маленький вызов — и много логики внутри
send(email, title, body);
```

Внутри себя подобный вызов выполняет довольно много логики. Соединяется с почтовым сервером, формирует правильный запрос на основе заголовка и тела сообщения, а затем все это отправляет, не забыв закрыть соединение.

Создадим нашу первую функцию. Ее задача - вывести на экран приветствие:

<pre class='hexlet-basics-output'>Hello, Hexlet!</pre>

```javascript
// Определение функции
// Определение не вызывает и не выполняет функцию
// Мы лишь говорим, что теперь такая функция существует
const showGreeting = () => {
  // Внутри тела отступ 2 пробела для удобства чтения
  const text = 'Hello, Hexlet!';
  console.log(text);
}

// Вызов функции
showGreeting(); // => Hello, Hexlet!
```

https://replit.com/@hexlet/js-basics-functions-define

В отличие от обычных данных, функции выполняют действия, поэтому их имена практически всегда должны быть глаголами: «построить что-то», «нарисовать что-то», «открыть что-то».

Всё, что описывается внутри фигурных скобок `{}`, называется телом функции. Внутри тела можно описывать любой код. Считайте, что это маленькая самостоятельная программа, набор произвольных инструкций. Тело выполняется ровно в тот момент, когда запускается функция. Причём каждый вызов функции запускает тело независимо от других вызовов. Кстати, тело может быть пустым:

```javascript
// Минимальное определение функции
const noop = () => {
  // Тут мог бы быть код, но его нет
}

noop();
```

Определение функции подозрительно похоже на создание константы. Действительно, в реальности, определение функции состоит из двух частей: собственно определения и присваивания константе:

1. Определение: `() => { }`
2. Присваивание `const nameOfFunction = ...`

Технически возможно создать функцию, которая просто определена, но ей невозможно воспользоваться, потому что нет имени:

```javascript
() => {
  // Работающий, но бесполезный код
};
```

Понятие «создать функцию» имеет много синонимов: «реализовать», «определить» и даже «заимплементить» (от слова implement). Все они встречаются в повседневной практике на работе.
