
У чисел есть метод, который преобразует их в строку:

```javascript
const peopleCount = 5;
peopleCount.toString(); // 5
```

Попробуйте ответить на вопрос, заработает ли следующий код — и если да, то что он напечатает на экран?

```javascript
const name = 'Tirion';
console.log(name.length.toString());
```

Синтаксис нескольких подряд идущих точек мы видим впервые, но все операции, которые здесь встречаются, нам знакомы. Всё, что произошло в этом коде — это объединение уже известных возможностей языка. Такое в программировании происходит довольно часто. Даже не зная синтаксиса, можно пробовать комбинировать различные подходы, и есть неплохая вероятность, что они заработают.

Самый простой способ понять как работает этот код — разбить цепочку на отдельные операции:

```javascript
const name = 'Tirion';
const len = name.length;
console.log(len.toString());
```

Эти примеры абсолютно эквивалентны. Мы можем выполнять операции последовательно с промежуточным созданием констант, а можем строить непрерывную цепочку из свойств и методов. В цепочках вычисления всегда идут слева направо.

Ещё один пример для закрепления:

```javascript
const name = 'Tirion';
console.log(name.toUpperCase().toLowerCase());
```

Подобный код требует небольших умственных усилий. Важно понимать, что `.toLowerCase()` применяется к результату вызова метода, который находится левее. А метод `toUpperCase()` возвращает строку. Новички часто делают ошибки в цепочках с методами, забывая ставить вызов:

```javascript
const name = 'Tirion';
// Этот код отработает неверно!
console.log(name.toUpperCase.toLowerCase());
```

Продолжая эту идею, возможно строить бесконечно длинные (хотя, в данном случае, бесполезные) цепочки:

```javascript
// Чему равен результат такого вызова?
console.log(name.toUpperCase().toLowerCase().length.toString().length);
```

*С функциями подобный трюк не сработает, так как при обычном использовании они вкладываются друг в друга f(f(f())), что значительно ухудшает анализ. Но это не значит, что нельзя сделать красиво — можно и даже нужно. В других языках это реализуется через композицию функций или пайплайн-оператор, который, кстати говоря, постепенно начинает использоваться и в самом JavaScript: https://github.com/tc39/proposal-pipeline-operator.*
