
Кроме свойств, у данных существуют методы — функции, находящиеся внутри свойств. С практической точки зрения это значит, что метод работает и вызывается как функция, но делает это как свойство, через точку.

```javascript
const name = 'Robb';
const upperName = name.toUpperCase();
console.log(upperName); // => ROBB
```

https://replit.com/@hexlet/js-basics-properties-methods

Встроенные методы всегда оперируют теми данными, с которыми они связаны. Метод `.toUpperCase()` возвращает ту же строку, но преобразуя все символы в верхний регистр. Методов у данных обычно значительно больше, чем свойств, например, для строк их [несколько десятков](https://developer.mozilla.org/ru/docs/Web/JavaScript/Reference/Global_Objects/String). В документации, на первый взгляд, они описаны немного странно: *String.prototype.toLowerCase()*. Это описание раскрывает некоторые внутренние детали реализации, которые сейчас не важны, да и мы не изучили всей необходимой базы для разговора о прототипах.

Методы есть и у [чисел](https://developer.mozilla.org/ru/docs/Web/JavaScript/Reference/Global_Objects/Number):

```javascript
const temperature = 22.93;
// Округление до одного знака после запятой
const roundedTemperature = temperature.toFixed(1);
// Метод возвращает строку, которая содержит преобразованное число
console.log(roundedTemperature); // => 22.9

// Напрямую можно вызывать так
// Скобки нужны обязательно, иначе не заработает
(22.93).toFixed(1); // 22.9
```

*Хозяйке на заметку. Технически всё несколько сложнее. Методы есть не у самих чисел, а у данных (объектов) типа Number. Числа, записанные в переменные или константы, автоматически преобразуются к данному типу во время обращения к ним, в это время происходит так называемый boxing.*

Возникает закономерный вопрос: зачем нужны методы, почему не просто функции? С числами ситуация ещё сложнее. Часть операций реализована в виде методов самих чисел, например, `.toFixed()`, а ещё большая часть — в виде методов, доступных через `Math`.

Есть две причины почему так сделано:

1. Исторически так сложилось. JavaScript разрабатывался слишком быстро и поэтому не все было продумано хорошо
2. Далеко не все функции имеют отношение к конкретному значению. Возьмем для примера `Math.min()`. Эта функция находит минимальное число среди всех, которые ему были переданы. Эту функцию нелогично делать методом конкретного числа, например, так — `(1).min()`. Она не имеет никакой связи с конкретным числом

С другой стороны, функции, работающие с конкретным числом, для единообразия должны быть реализованы как методы. К таким функциям относится получение модуля числа. То есть вместо такого вызова `Math.abs(-10)`, логично иметь такой: `(-10).abs()`.

Что касается методов в целом, то не все так однозначно. Есть языки, в которых методов нет и там всё прекрасно, есть языки, где методы — это основной способ работы с функциями, но даже в этих языках всегда, наряду с методами, используются обычные функции. JavaScript — язык, в котором прижились оба подхода, в нём активно используются как обычные функции, так и методы. О плюсах и минусах подобных подходов подробно рассказывается в курсах [посвященных ООП](https://ru.hexlet.io/programs/js-oop).
