
Данные, которыми мы оперируем в своих программах, могут обладать важными свойствами — например, у строк есть длина. Как вы увидите далее, это свойство очень важно для реализации алгоритмов, связанных с преобразованием строки (как пример — переворот строки). Как узнать длину строки? Во многих языках длина строки вычисляется с помощью специальной функции и выглядит это примерно так:

```javascript
import { length } from 'hexlet-basics/string';

const name = 'Robb';
console.log(length(name)); // => 4
```

В JavaScript свойства встроены прямо в язык. Они указываются через точку сразу после переменной (или константы):

```javascript
const name = 'Robb';
const len = name.length;
console.log(len); // => 4
```

https://replit.com/@hexlet/js-basics-properties-properties-syntax

Свойства связаны с данными, у которых они берутся. Для примитивных типов все свойства описаны в документации, как например, у [строк](https://developer.mozilla.org/ru/docs/Web/JavaScript/Reference/Global_Objects/String). При этом у чисел вообще нет свойств.

JavaScript позволяет обращаться к свойствам, которые не существуют (например, при опечатках). В таком случае их значением является `undefined`:

```javascript
const name = 'Robb';
console.log(name.whatIsThat); // => undefined
```

*Вопрос для самопроверки. Что распечатает код `console.log(name[name.length])` для `name`, определенного выше? Почему ответ такой?*

<details>
<summary>Ответ</summary>

Код распечатает `undefined`, потому что происходит обращение по индексу, который выходит за границу строки. В этом случае `name.length` — 4, а индекс последнего символа в строке — 3.

</details>
