
The data we use in our programs can have important properties, such as strings having length. As you will see later, this property is required to implement string conversion algorithms (e.g., string reversal). So how do you find out the length of a string? In many languages, string length is calculated with a special function, and it looks a bit like this:

```javascript
import { length } from 'hexlet-basics/string';

const name = 'Robb';
console.log(length(name)); // => 4
```

In JavaScript, properties are built into the language. They are written with a dot right after a variable (or a constant):

```javascript
const name = 'Robb';
const len = name.length;
console.log(len); // => 4
```

Properties are linked with the data they are taken from. For primitive types, e.g. [strings](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/String), all property descriptions are described in the documentation. However, numbers have no properties at all.

JavaScript allows you to call properties that do not exist (e.g. in the case of typos). In this case their value is `undefined`:

```javascript
const name = 'Robb';
console.log(name.whatIsThat); // => undefined
```

_Self-сheck. What will `console.log(name[name.length])` print for the variable `name` above? Why is the result like that?_
