
Независимо от того, какой язык программирования используется, функции внутри него обладают некоторыми фундаментальными свойствами. Зная эти свойства, легче прогнозировать поведение функций, способы их тестирования и место их использования. К таким свойствам относится детерминированность. Функция называется детерминированной тогда, когда для одних и тех же входных параметров она возвращает один и тот же результат. Например, функция, считающая количество символов, детерминированная:

```javascript
import { length } from 'hexlet-basics/string';

length('hexlet'); // 6
length('hexlet'); // 6

length('wow'); // 3
length('wow'); // 3
```

Сколько бы раз мы ни вызывали эту функцию, передавая туда значение `'hexlet'`, она всегда вернет `6`. В свою очередь функция, возвращающая случайное число, не является детерминированной, так как у одного и того же входа (даже если он пустой, то есть параметры не принимаются) мы получим всегда разный результат. Насколько он разный - не важно, даже если хотя бы один из миллиона вызовов вернет что-то другое, эта функция автоматически считается недетерминированной.

```javascript
// Функция, возвращающая случайное число
Math.random(); // 0.09856613113197676
Math.random(); // 0.8839904367241888
```

Зачем это нужно знать? Детерминированность серьезно влияет на многие аспекты. Детерминированные функции удобны в работе, их легко оптимизировать, легко тестировать. Если есть возможность сделать функцию детерминированной, то лучше ее такой и сделать
