
Интересная особенность некоторых функций — принимать переменное число параметров. Речь не идет о значениях по умолчанию. Посмотрите на этот пример:

```javascript
Math.max(1, 10, 3); // 10
```

Функция `Math.max()` находит максимальное значение среди переданных параметров. Как вы думаете, сколько параметров она ожидает на вход? Если открыть документацию этой функции, то мы увидим странную конструкцию:

  ```
  Math.max([value1[, value2[, ...]]])
  ```

  Такая запись говорит о том, что эта функция принимает на вход любое число параметров (и даже может быть вызвана без них). Необязательность передаваемых параметров описывается скобками *[ ]*, точно так же описываются и опциональные параметры, у которых есть значения по умолчанию. Возможность передачи любого числа параметров зашита в этой части *[, ...]*.

  ```javascript
  Math.max(1, -3, 2, 3, 2); // 3
  ```

  Все, что указывается в квадратных скобках, не обязательно. В такой записи `Math.max([value1[, value2[, ...]]])` таких скобок несколько, и они вложены друг в друга. Разберем каждую из них:

  * Первые квадратные скобки содержат `[value1[, value2[, ...]]]`, это значит, что можно вызывать функцию без параметров, так как эти квадратные скобки содержат все, что передается в функцию. Если убрать все содержимое этих скобок и сами скобки, то останется `Math.max()` — вызов без параметров.
  * Вторые квадратные скобки вложены в первые и содержат `[, value2[, ...]]`. Они указывают на то, что если мы указали первый параметр, то можно опционально указать второй параметр. Без этих скобок и их содержимого, будет запись вида `Math.max([value1])`.
  * Третьи квадратные скобки вложены во вторые и содержат `[, ...]`. Многоточие указывает на то, что параметров может быть сколько угодно. Если убрать эти скобки и их содержимое, то получится запись вида `Math.max([value1[, value2]])`.

  Запятая стоит внутри квадратных скобок, так как если мы не указываем параметр, то запятая не нужна. Иначе вызов с одним параметром выглядел бы так `Math.max(value1,)`.
