
В программировании выражение – нечто, возвращающее результат, который можно использовать. Мы уже знаем достаточно много о выражениях и о принципах их построения. Математические операции (сложение, вычитание), строковые операции (конкатенация) – все это выражения:

```javascript
1 + 5 * 3;
'Hex' + 'Let';
// Переменные могут быть частью выражения
rate * 5;
```

Особенность выражений в том, что они возвращают результат, который можно, например, присвоить константе или вывести на экран. Например:

```javascript
// Тут выражение это 1 + 5
const sum = 1 + 5;
console.log(1 + 5);
```

Но не все в программировании является выражением. Определение переменной – это инструкция, она не может быть частью выражения. То есть такой код выдаст ошибку:

```javascript
// Бессмысленный код, который не сработает
10 + const sum = 1 + 5;
```

Почему об этом важно знать? Как вы увидите дальше, выражения можно комбинировать, получая все более сложное поведение в самых неожиданных местах и самым неожиданным образом. Вы будете лучше понимать, как можно соединять части кода, чтобы получить нужный результат.

Поговорим о функциях. Вызов функции - это выражение или нет? Мы знаем, что функции возвращают результат, то есть да, они выражения. Из этого автоматически следует много интересного. Например, мы можем использовать вызов функции прямо в математических операциях. Вот как можно получить индекс последнего символа в слове:

```javascript
import { length } from 'hexlet-basics/string';

const name = 'JavaScript';
// Индексы начинаются с нуля
// Вызов метода и вычитание вместе!
const lastIndex = length(name) - 1;
console.log(lastIndex); // 9
```

В этом коде нет нового синтаксиса. Мы всего лишь соединили уже известные части, опираясь на их природу. Можно пойти еще дальше:

```javascript
console.log(length(name) - 1); // 9
```

Все это справедливо для любых функций, например строковых:

```javascript
import { length } from 'hexlet-basics/string';

const name = 'JavaScript';
// Используется интерполяция
console.log(`Последний символ: ${name[length(name) - 1]}`);
// 'Последний символ: t'
```
