
Рассмотрим функцию `round()`, которая округляет целое число:

```javascript
const result = round(10.25, 0); // 10
```

Мы передали в неё два параметра: число, которое нужно округлить, и точность округления. `0` означает, что округление будет до целого значения, то есть дробная часть просто отбрасывается.

Чаще всего нужно округлять именно до целого числа (а не до десятых, например), поэтому создатели функции `round()` сделали второй параметр **необязательным** и задали ему внутри функции **значение по умолчанию `0`**. Значит, можно не указывать второй параметр, а результат будет тем же:

```javascript
const result = round(10.25); // 10
```

Если нужна другая точность, то можно передать параметр:

```javascript
// округление до одного знака после запятой
const result = round(10.25, 1); // 10.3
```

Если функция в JavaScript принимает необязательные параметры, то они всегда стоят после обязательных. Их количество может быть любым (это зависит от самой функции), но они всегда идут рядом и в конце списка аргументов.
