
Объяснение функций в JavaScript немного осложняется структурой языка. Изначально он появился в браузерах и имел сильно ограниченные возможности по сравнению с языками общего назначения. Со временем все изменилось — JavaScript стал мощным языком, захватившим клиентскую разработку и активно использующимся на сервере. Однако наследие осталось, так как нужно поддерживать обратную совместимость. Поэтому в некоторых местах есть несостыковки, которые нельзя объяснить системой: на них можно только махнуть рукой и сказать: «Так исторически сложилось».

К подобным «местам» относятся математические функции. В предыдущем задании мы использовали самописную функцию `pow()` (мы, как создатели курса, добавили ее в практику), а теперь давайте рассмотрим её версию, встроенную в сам язык.

```javascript
Math.pow(2, 3); // 8
```

https://replit.com/@hexlet/js-basics-calling-functions-math

Что такое `Math`? Технически — это объект, доступный из любого места программы, но перед тем, как говорить об объектах, нужно проделать очень большой путь. Сейчас достаточно запомнить, что функции для математических операций вызываются через `Math.`. Наличие этой приставки никак не влияет на понятие функции, которое мы рассмотрели ранее и будем рассматривать позже.

Полный список функций Math доступен в [документации](https://developer.mozilla.org/ru/docs/Web/JavaScript/Reference/Global_Objects/Math). О том, как её правильно читать, мы поговорим далее.
