
Что произойдет, если попытаться изменить символ в строке?

```javascript
let firstName = 'Alexander';
// Код выполнится без ошибок
firstName[0] = 'B';
console.log(firstName); // => Alexander
```

Как это ни странно, но значение переменной `firstName` останется прежним, хотя код выполнится без ошибок. Так происходит из-за неизменяемости примитивных типов в JavaScript — язык не дает никакой физической возможности поменять строку. Неизменяемость примитивных типов важна по многим причинам, ключевая — производительность. Но что делать, если нам действительно нужно её изменить? Для этого и существуют переменные:

```javascript
let firstName = 'Alexander';
// Код выполнится без ошибок
firstName = 'Blexander';
console.log(firstName); // => Blexander
```

Есть большая разница между изменением значения переменной и изменением самого значения. Примитивные типы в JavaScript поменять нельзя (а вот составные можно, подробнее о них уже на самом Хекслете), а заменить значение переменной — без проблем.
