
Что произойдет, если мы попробуем умножить число на строку? JavaScript вернет `NaN` (не число) — то самое значение. Оно возникает там, где вместе используются несовместимые значения. В данном случае число и строка:

```javascript
3 * 'Dracarys'; // NaN
```

Внутри высокоуровневых языков программирования данные разделяются по типам. Любая строка относится к типу String, а числа — к типу Number и BigInt (очень большие числа). Зачем нужны типы? Для защиты программы от трудноотловимых ошибок. Типы определяют две вещи:

* Возможные (допустимые) значения. Например, числа в JavaScript делятся на два типа: Number и BigInt. Первые — это все числа ниже определенного порога (его можно посмотреть), вторые — выше. Такое разделение связано с техническими особенностями работы аппаратуры.
* Набор операций, которые можно выполнять над этим типом. Например, операция умножения имеет смысл для типа «целые числа». Но не имеет смысла для типа «строки»: умножать слово «мама» на слово «блокнот» — бессмыслица.

JavaScript ведет себя двояко, когда встречается с нарушениями. В некоторых ситуациях, он ругается на недопустимость операции и завершается с ошибкой. В других — программа продолжает работать. В этом случае недопустимая операция возвращает что-то похожее на `NaN`, как в примере выше.

Каким образом JavaScript понимает, что за тип данных перед ним? Достаточно просто. Любое значение где-то инициализируется и, в зависимости от способа инициализации, становится понятно, что перед нами. Например, числа — это просто числа без дополнительных символов, кроме  точки для рациональных чисел. А вот строки всегда ограничены специальными символами (в JavaScript три разных варианта). Например, такое значение `'234'` – строка, несмотря на то, что внутри нее записаны цифры.

JavaScript позволяет узнать тип данных с помощью оператора `typeof`:

```javascript
typeof 3; // number
typeof 'Game'; // string
```

https://replit.com/@hexlet/js-basics-data-types-primitive-data-types

Типы данных Number, BigInt и String — это *примитивные* типы. Но есть и другие. В JavaScript встроен составной тип Object (а на его базе массивы, даты и другие). С его помощью можно объединять данные разных типов в одно значение, например, мы можем создать пользователя добавив к нему имя и возраст.

```javascript
// Этот синтаксис изучается на Хекслете
const user = { name: 'Toto', age: 33 };
```

По-английски строки в программировании называются "strings", а строчки текстовых файлов — "lines". Например, в коде выше есть две строчки (lines), но только одна строка (strings). В русском иногда может быть путаница, поэтому во всех уроках мы будем говорить **строка** для обозначения типа данных «строка», и **строчка** для обозначения строчек (lines) в файлах.
