
What happens if we try to multiply a number by a string? JavaScript will return the `NaN` (not a number) value we've seen before. This happens whenever incompatible values are used together. In this case, a number and a string:

```javascript
3 * 'Dracarys'; // NaN
```

In high-level programming languages, data are categorized by type. A string refers to the String type, while numbers refer to Number and BigInt (very large numbers). What are these data types for? They help to protect your program from hard-to-find errors. Types determine two things:

* Possible values. For example, numbers in JavaScript are divided into two types: Number and BigInt. All numbers below a certain threshold (you can check it) belong to the Numbers data type, and all numbers above it belong to the Biglnt type. They're divided this way due to the hardware's technical features
* A set of operations applied to this data type. For example, you can multiply integers, but not strings. Multiplying the word "mother" by the word "notepad" makes no sense

Javascript may act in one of two possible ways when it sees a violation. In some situations, it'll terminate the program with an error. In others, the program will continue to work, though an invalid operation will return something like `NaN` as in the example above.

How does JavaScript detect the data type? It's quite simple. Any value is initialized somewhere and, based on an initialization method, it understands what type of data it is. Numbers, for instance, are just numbers without any extra characters, apart from the point (.) for rational numbers. Strings, on the other hand, always require enclosing with special characters (there are three ways to write strings in JavaScript). For example, `'234'` is a string, even though there are numbers in quotes.

You can find out a data type using `typeof` operator:

```javascript
typeof 3; // 'number'
typeof 'Game'; // 'string'
```

The Number, BigInt, and String data types are *primitive* types. But there is more. JavaScript has a built-in composite type Object (as well as arrays, dates and others based on it). It serves to combine data of different types into a single value, e.g. we can create a user combining his name and age.

```javascript
// You can learn this notation on Hexlet
const user = { name: 'Toto', age: 33 };
```
