
Иногда нужно получить один символ из строки. Например, если сайт знает имя и фамилию пользователя, и в какой-то момент требуется вывести эту информацию в формате *A. Ivanov*, то нужно взять первый символ из имени.

```javascript
const firstName = 'Tirion';

console.log(firstName[0]); // => T
```

Квадратные скобки с цифрой — это специальный синтаксис извлечения символа из строки. Цифра называется **индексом** — позицией символа внутри строки. Индексы начинаются с 0 почти во всех языках программирования — поэтому, чтобы получить первый символ, нужно указать индекс `0`. Индекс последнего элемента равен длине строки минус единица:

```javascript
// Длина строки 6, поэтому последний индекс — это 5
const firstName = 'Tirion';

console.log(firstName[5]); // => n
```

Вопрос на самопроверку. Что выведет этот код?

```
const magic = '\nyou';
console.log(magic[1]); // => ?
```

<details>
<summary>Ответ</summary>

Данный код выведет символ `y`

</details>

Индексом может быть не только конкретное число, но и значение переменной. Вот пример, который приведёт к тому же результату — выводу на экран символа *T*, но индекс внутри квадратных скобок записан не числом, а константой:

```javascript
const firstName = 'Tirion';
const index = 0;

console.log(firstName[index]); // => T
```

Технически можно указать индекс и за пределами слова. Для нашего примера — это числа от 6 и выше. JavaScript не считает такое поведение ошибкой. Обращение по несуществующему индексу вернет значение `undefined`.

```javascript
const firstName = 'Tirion';

console.log(firstName[10]); // => undefined
```

https://replit.com/@hexlet/js-basics-symbols
