
В уроке про конкатенацию перед нами стояла задача создать заголовок письма из двух констант и знаков препинания. Вы, скорее всего, решили задачу так:

```javascript
const firstName = 'Joffrey';
const greeting = 'Hello';

console.log(greeting + ', ' + firstName + '!');
// => Hello, Joffrey!
```

Это довольно простой случай, но даже здесь нужно приложить усилия, чтобы увидеть, какая в итоге получится строка. Нужно следить за несколькими кавычками и пробелами, и без вглядывания не понять, где что начинается и кончается.

Есть другой, более удобный и изящный способ решения той же задачи — **интерполяция**. Вот, как это выглядит:

```javascript
const firstName = 'Joffrey';
const greeting = 'Hello';

// Обратите внимание на ограничители строки, это бектики
// Интерполяция не работает с одинарными и двойными кавычками
console.log(`${greeting}, ${firstName}!`);
// => Hello, Joffrey!
```

https://replit.com/@hexlet/js-basics-interpolation

Мы просто создали одну строку и «вставили» в неё в нужные места константы с помощью знака доллара и фигурных скобок `${ }`. Получился как будто бланк, куда внесены нужные значения. И нам не нужно больше заботиться об отдельных строках для знаков препинания и пробелов — все эти символы просто записаны в этой строке-шаблоне.

В одной строке можно делать сколько угодно подобных блоков.

Интерполяция работает только со строками в [бэктиках](https://ru.wikipedia.org/wiki/Машинописный_обратный_апостроф). Это символ `.

Почти во всех языках интерполяция предпочтительнее конкатенации для объединения строк. Строка при этом получается склеенная, и внутри неё хорошо просматриваются пробелы и другие символы. Во-первых, интерполяция позволяет не путать строки с числами (из-за знака +), а во-вторых, так гораздо проще (после некоторой практики) понимать строку целиком.
