
Во всем модуле подавляющее большинство примеров кода использовало переменные в качестве имен (псевдонимы) конкретных значений, а не как переменные, которые меняют свое значение со временем.

```javascript
let dollarsInEuro = 1.25;
let rublesInDollar = 60;

let dollarsCount = 50 * dollarsInEuro; // 62.5
let rublesCount = dollarsCount * rublesInDollar; // 3750

console.log(rublesCount);
```

В программировании принято называть такие имена константами, и многие языки поддерживают константы как конструкцию. JavaScript, как раз, относится к таким языкам, и его стандарты кодирования [говорят прямо](https://eslint.org/docs/rules/prefer-const) — если значение не меняется, то мы имеем дело с константой. Перепишем пример выше на использование констант:

```javascript
const dollarsInEuro = 1.25;
const rublesInDollar = 60;

const euros = 1000;
const dollars = euros * dollarsInEuro;    // 1250
const rubles = dollars * rublesInDollar; // 75000

console.log(rubles);
```

https://replit.com/@hexlet/js-basics-variables

Единственное изменение заключается в том, что ключевое слово `let` заменилось на `const`, но это только синтаксис. Теперь, если попытаться изменить любую константу, то мы получим сообщение об ошибке. В остальном они используются точно так же, как и переменные.

```javascript
const pi = 3.14;
pi = 5; // TypeError: Assignment to constant variable.
```

Зачем такие сложности? Почему бы не оставить только переменные? Даже если бы мы оставили только переменные, то это не отменяет того факта, что они часто использовались бы как константы, более того, код на JavaScript можно и идиоматично писать без использования переменных вообще. Посмотрите на пример из [реального кода Хекслета](https://github.com/Hexlet/hexlet-exercise-kit/blob/main/import-documentation/index.js). На текущем этапе вы его вряд ли поймете, но попробуйте посчитать количество констант и переменных внутри него, вы увидите, что здесь ровно одна переменная, и целая куча констант.

Константы значительно проще для анализа, когда мы видим константу в коде, то нам сразу понятно, что ее значение всегда остается прежним. При использовании констант отсутствует понятие времени. С переменными все не так, мы не можем быть уверены в их значении, приходится анализировать весь код, чтобы понять, как они могли измениться.

Переменные жизненно необходимы только в одном случае (во всех остальных гарантировано можно обойтись без них) - при работе с циклами, до которых мы ещё дойдем.

В дальнейшем мы будем предпочитать константы и использовать переменные только тогда, когда без них никак.
