
`greeting` — пример простого имени, но не все имена так просты. Довольно часто они составные, то есть включают в себя несколько слов. Например, «имя пользователя». В разных языках применяются разные стили кодирования, и имя переменной будет отличаться.

В именовании переменных можно выделить четыре основных подхода, которые иногда комбинируют друг с другом. Все эти подходы проявляют себя, когда имя переменной состоит из нескольких слов:

* kebab-case — составные части переменной разделяются дефисом. Например: `my-super-var`.
* snake_case — для разделения используется подчеркивание. Например: `my_super_var`.
* CamelCase  — каждое слово в переменной пишется с заглавной буквы. Например: `MySuperVar`.
* lowerCamelCase — каждое слово в переменной пишется с заглавной буквы, кроме первого. Например: `mySuperVar`.

В Javascript используется CamelCase и его вариация lowerCamelCase, при котором первая буква первого слова — строчная. Именно lowerCamelCase применяется для переменных. Это значит, что имена соединяются друг с другом, при этом все имена кроме первого становятся с заглавной буквы: `userName`. С тремя словами это выглядит так: `mySuperVariable`.
