
`greeting` is an example of a simple name, although not all of them are that simple. Often, they are a combination of several words. For example, "user password". Different languages have different naming styles for variables.

Four main variable naming conventions are sometimes combined. These conventions apply to variable names consisting of several words:

* kebab-case – a hyphen separates the parts of the name. For example, `my-super-var`
* snake_case - an underscore is used as a separator. For example, `my_super_var`
* CamelCase - each word in the name is capitalized. For example, `MySuperVar`
* lowerCamelCase - each word is capitalized except the first. For example, `mySuperVar`

Javascript uses CamelCase and its variation lowerCamelCase, with the first letter of the first word in lowercase. We use lowerCamelCase for variables. It means we concatenate the words, and all the words apart from the first are capitalized: `userName`. With three words it looks like this: `mySuperVariable`.
