
Переменные полезны не только для хранения и переиспользования информации, но и для упрощения сложных вычислений. Давайте рассмотрим пример: нужно перевести евро в юани через доллары. Подобные конвертации через промежуточную валюту часто делают банки при покупках за рубежом.

Для начала переведем 50 евро в доллары. Допустим, что один евро — 1.25 долларов:

```javascript
let dollarsCount = 50 * 1.25;
console.log(dollarsCount); // => 62.5
```

В предыдущем уроке мы записывали в переменную конкретное значение. А здесь `let dollarsCount = 50 * 1.25;` справа от знака равно находится **выражение**. Интерпретатор вычислит результат — `62.5` — и запишет его в переменную. С точки зрения интерпретатора не важно, что перед ним: `62.5` или `50 * 1.25`, для него оба варианта — выражения, которые надо вычислить. И они вычисляются в одно и то же значение — `62.5`.

Любая строка — выражение. Конкатенация строк — тоже выражение. Когда интерпретатор видит выражение, он обрабатывает его и генерирует результат — **значение выражения**. Вот несколько примеров выражений, а в комментариях справа от каждого выражения — итоговое значение:

```javascript
62.5             // 62.5
50 * 1.25        // 62.5
120 / 10 * 2     // 24

'hello'          // hello
'Good' + 'will'  // Goodwill
```

Правила построения кода (грамматика языка) таковы, что в тех местах, где ожидается выражение, можно поставить любое вычисление (не только математическое, но и, например, строковое — как конкатенация), и программа останется работоспособной. По этой причине невозможно описать и показать все случаи использования всех операций.

Программы состоят из множества комбинаций выражений, и понимание этой концепции — один из ключевых шагов на вашем пути.

Основываясь на сказанном выше, подумайте, сработает ли такой код?

```javascript
let who = "dragon's" + 'mother';
console.log(who);
```

Запустите его на [repl.it](https://repl.it/languages/javascript) и поэкспериментируйте.

<details>
<summary>Ответ</summary>

Да, сработает. Будет выведена строка `dragon'smother`.

</details>

Вернемся к нашей валютной программе. Запишем стоимость доллара в юанях как отдельную переменную. Вычислим цену 50 евро в долларах, умножив их на `1.25`. Допустим, что 1 доллар — 6.91 юаней:

```javascript
let yuansPerDollar = 6.91;
let dollarsCount = 50 * 1.25; // 62.5
let yuansCount = dollarsCount * yuansPerDollar; // 431.875

console.log(yuansCount);
```

А теперь давайте добавим к выводу текст с помощью конкатенации:

```javascript
let yuansPerDollar = 6.91;
let dollarsCount = 50 * 1.25; // 62.5
let yuansCount = dollarsCount * yuansPerDollar; // 431.875

console.log('The price is ' + yuansCount + ' yuans');
```

<pre class='hexlet-basics-output'>
The price is 431.875 yuans
</pre>

Любая переменная может быть частью любого выражения. В момент вычисления, вместо имени переменной подставляется её значение.

Интерпретатор вычисляет значение `dollarsCount` до того, как эта  переменная начнет использоваться в других выражениях. Когда подходит момент использования переменной, Javascript «знает» значение, потому что уже вычислил его.
