
Порядок следования инструкций в коде с переменными играет огромное значение. Переменная должна быть определена до того, как будет использована. Ниже пример ошибки, которую очень часто допускают новички:

```javascript
// Uncaught ReferenceError: greeting is not defined
console.log(greeting);
let greeting = 'Father!';
```

Запуск программы с примера выше завершается ошибкой *ReferenceError: greeting is not defined*. *ReferenceError* - это ошибка обращения. Она означает, что в коде используется имя (говорят идентификатор), которое не определено. Причём в самой ошибке об этом говорят прямо: *greeting is not defined*, что переводится как *greeting не определен*. Кроме неправильного порядка определения, в JavaScript встречаются банальные опечатки — как при использовании переменной, так и при её объявлении.

Количество подобных ошибок уменьшается за счет использования правильно настроенного редактора. Такой редактор подсвечивает имена, которые используются без объявления и предупреждает о возможных проблемах.

Еще одна распространенная ошибка — попытаться объявить уже объявленную переменную:

```javascript
let greeting = 'Father!';
let greeting = 'Father!';
```

Так делать нельзя. Придётся создать новую переменную.
