
В веб-разработке программы постоянно оперируют строками. Всё, что мы видим на сайтах, так или иначе представлено в виде текста. Этот текст чаще всего динамический, то есть полученный из разных частей, которые соединяются вместе. Операция соединения строк в программировании называется **конкатенацией**.

```javascript
// Оператор такой же, как и при сложении чисел
// но здесь он имеет другой смысл (семантику)
console.log('Dragon' + 'stone');
// => Dragonstone
```

Склеивание строк всегда происходит в том же порядке, в котором записаны операнды. Левый операнд становится левой частью строки, а правый — правой.

Вот еще несколько примеров:

```javascript
console.log('Kings' + 'wood');     // => Kingswood

// Обратный порядок слов
console.log('road' + 'Kings');     // => roadKings

// Конкатенировать можно абсолютно любые строки
console.log("King's" + 'Landing'); // => King'sLanding
```

Как видите, строки можно склеивать, даже если они записаны с разными кавычками.

В последнем примере название города получилось с ошибкой: *King's Landing* нужно писать через пробел. Но в наших начальных строках не было пробелов, а пробелы в самом коде слева и справа от символа `+` не имеют значения, потому что они не являются частью строк.

Выхода из этой ситуации два:

```javascript
// Оба способа равнозначны

// Ставим пробел в левой части
console.log("King's " + 'Landing'); //  => King's Landing
// Ставим пробел в правой части
console.log("King's" + ' Landing'); //  => King's Landing
```

Пробел — такой же символ, как и другие. Чем больше пробелов, тем шире отступы:

```javascript
console.log("King's " + ' Landing');   // => King's  Landing

console.log("King's  " + '  Landing'); // => King's    Landing
```

https://replit.com/@hexlet/js-basics-strings
