
Мы хотим показать диалог Матери Драконов со своим ребёнком:

```
- Are you hungry?
- Aaaarrrgh!
```

Если вывести на экран строку с таким текстом:

```javascript
console.log('- Are you hungry?- Aaaarrrgh!');
```

то получится так:

```
- Are you hungry?- Aaaarrrgh!
```

Не то, что мы хотели. Строки расположены друг за другом, а не одна ниже другой. Нам нужно как-то сказать интерпретатору «нажать на энтер» — сделать перевод строки после вопросительного знака. Это можно сделать, используя символ перевода строки: `\n`.

```javascript
console.log('- Are you hungry?\n- Aaaarrrgh!');
```

результат:

```
- Are you hungry?
- Aaaarrrgh!
```

`\n` — это специальный символ. В литературе его часто обозначают как *LF* (Line Feed). Возможно вы сейчас подумали, что это опечатка, ведь здесь мы видим два символа `\` и `n`, но это не так. С точки зрения компьютера — это один невидимый символ перевода строки. Доказательство:

```javascript
// Мы это не изучали, но вы должны знать правду
// Ниже код, который возвращает длину строки
'a'.length;    // 1
'\n'.length;   // 1 !!!
'\n\n'.length; // 2 !!!
```

Почему так сделано? `\n` — всего лишь способ записать символ перевода строки, но сам перевод строки по своему смыслу – это один символ, правда, невидимый. Именно поэтому и возникла такая задача. Нужно было как-то представить его на клавиатуре. А поскольку количество знаков на клавиатуре ограничено и отдано под самые важные, то все специальные символы реализуются в виде таких обозначений.

Символ перевода строки не является чем-то специфичным для программирования. Все, кто хоть раз печатал на компьютере, использовал перевод строки, нажимая на Enter. Во многих редакторах есть опция, позволяющая включить отображение невидимых символов. С помощью этой опции можно понять, где находятся невидимые символы (хотя это всего лишь схематичное отображение, у этих символов нет графического представления, они невидимые):

<pre class='hexlet-basics-output'>
- Привет!¶
- О, привет!¶
- Как дела?
</pre>

Устройство, которое выводит соответствующий текст, учитывает этот символ. Например, принтер при встрече с LF протаскивает бумагу вверх на одну строку, а текстовый редактор переносит весь последующий текст ниже, также на одну строку.

`\n` — это пример **экранирующей последовательности** (escape sequence). Их ещё называют управляющими конструкциями.  Хотя таких символов не один десяток, в программировании часто встречаются всего несколько. Кроме перевода строки, к таким символам относятся табуляция (разрыв, получаемый при нажатии на кнопку Tab) и возврат каретки (только в Windows). Нам, программистам, часто нужно использовать перевод строки `\n` для правильного форматирования текста.

```javascript
console.log('Gregor Clegane\nDunsen\nPolliver\nChiswyck');
```

На экран выведется:

```
Gregor Clegane
Dunsen
Polliver
Chiswyck
```

Обратите внимание на следующие моменты:

1. Не имеет значения, что стоит перед или после `\n`: символ или пустая строка. Перевод будет обнаружен и выполнен в любом случае.

2. Помните, что строка может содержать один символ или вообще ноль символов. А еще строка может содержать только `\n`. Проанализируйте следующий пример:

    ```javascript
    console.log('\n');
    console.log('Dunsen');
    ```

    Здесь мы сначала выводим строку «перевод строки», а потом делаем вывод обыкновенной строки. Программа выведет на экран:

    <pre class='hexlet-basics-output'>
    <br>
    Dunsen
    </pre>

    Почему перед строкой *Dunsen* появилось две пустые строки, а не одна? Дело в том, что `console.log()` при выводе значения автоматически добавляет в конец символ перевода строки. Таким образом, один перевод строки мы указали явно, передав этот символ экранирующей последовательности аргументом в функцию, а второй перевод строки добавлен самой функцией автоматически.

    Ещё пример кода:

    ```javascript
    console.log('Polliver');
    console.log('Gregor Clegane');
    console.log();
    console.log('Chiswyck');
    console.log('\n');
    console.log('Dunsen');
    ```

    Вывод будет таким:

    <pre class='hexlet-basics-output'>
    Polliver
    Gregor Clegane<br>
    Chiswyck<br>
    
    Dunsen
    </pre>

    Сейчас у вас достаточно знаний, чтобы самостоятельно разобраться и понять, почему вывод сформировался именно таким образом.

3. Если нам понадобится вывести `\n` именно как текст (два отдельных печатных символа), то можно воспользоваться уже известным нам способом экранирования, добавив еще один `\` в начале. То есть последовательность `\\n` отобразится как символы `\` и `n`, идущие друг за другом.

```javascript
console.log('Joffrey loves using \\n');
```

на экран выйдет:

<pre class='hexlet-basics-output'>
Joffrey loves using \n
</pre>

Небольшое, но важное замечание про Windows. В Windows для перевода строк по умолчанию используется `\r\n`. Такая комбинация хорошо работает только в Windows, но создаёт проблемы при переносе в другие системы (например, когда в команде разработчиков есть пользователи как Windows, так и Linux). Дело в том, что последовательность `\r\n` имеет разную трактовку в зависимости от выбранной кодировки (рассматривается позже). По этой причине, в среде разработчиков принято всегда использовать `\n` без `\r`, так как LF всегда трактуется одинаково и отлично работает в любой системе. Не забудьте настроить ваш редактор на использование `\n`.
