
```javascript
'Hello'
'Goodbye'
'G'
' '
''
```

Which of these five items are strings?

The first two are clearly strings, we've already worked with similar constructions and mentioned that strings are sets of characters.

Any single character between parentheses is a string. The empty string `''` is also a string. So everything inside the quotation marks can be considered a string, even if it is a space, one character, or no characters at all.

In previous lessons, we enclosed strings in single quotes, but you can also use double quotes:

```javascript
// Coding airbnb standard recommends
// using single quotes where possible

console.log("Dracarys!");
```

Imagine you want to print a string: _Dragon's mother_. The apostrophe before the letter **s** and a single quote are the same symbols. Let's print it:

```javascript
console.log('Dragon's mother');
// Uncaught SyntaxError: missing ) after argument list
```

This program won't work. For JavaScript, the string begins with a single quote and ends after the letter **n**. Then comes some characters: `s mother` without quotes, which are not a string. And then there is one quote opening a string which is never closed: `');`. This code is syntactically incorrect (you can see it by the way the code is highlighted).

It's a good idea here is to use double quotes. This version of the program will work correctly:

```javascript
console.log("Dragon's mother");
```

Now the interpreter knows that the string begins with a double quote, so it should end with a double quote too. And the single quote inside has become the part of the string.

It works the other way too. If you want to use double quotes inside a string, you should enclose the string in single quotes. And the number of quotes in a string doesn't matter.

Now, what if we want to create a string like this?

```
Dragon's mother said "No"
```

There are single and double quotes here. What can we do in this case? You need to somehow tell the interpreter to consider each quote as a part of the string, and not as its beginning or an end.

To do this, you have to use **an escape character**. In our case, the character that starts and ends a string is either a single or a double quote, depending on the part of the code. Use a backslash `\` before the character you want to escape.

```javascript
// Only " is escaped, because in this code
// double quotes have a special meaning

console.log("Dragon's mother said \"No\"");
// => Dragon's mother said "No"
```

Look closely: we had to use `\` for double quotes to escape them, and not for the single quote (apostrophe) because the string is written in double quotes. If the string were written in single quotes, the escape character would be used before the apostrophe, not before double quotes.

```javascript
// \ won't be printed if it is followed by a normal character,
// not a special one

console.log("Death is \so terribly final");
// => Death is so terribly final
```

But what if you want to print the backslash? Just like any other special symbol, it escapes using a backslash too.

```javascript
console.log("\\");
// => \
```

Self-test: what will be printed?

```javascript
console.log("\\ \\ \\\\ \\\ \'\"");
```
