Теперь, когда мы уже научились писать простые программы, можно немного поговорить о том, как их писать.

Код программы следует оформлять определенным образом, чтобы он был достаточно понятным и простым в поддержке. Специальные наборы правил — стандарты — описывают различные аспекты написания кода. Конкретно в JavaScript самым распространенным стандартом является стандарт от [AirBnb](https://github.com/airbnb/javascript).

В любом языке программирования существуют утилиты — так называемые **линтеры**. Они проверяют код на соответствие стандартам. В JavaScript это [eslint](https://eslint.org/).

Взгляните на пример из предыдущего урока:

```javascript
console.log(8/2+5 - -3 / 2); // => 10.5
```

Линтер будет «ругаться» на нарушение сразу нескольких правил:

  * [space-infix-ops](https://eslint.org/docs/rules/space-infix-ops) – Отсутствие пробелов между оператором и операндами.
  * [no-mixed-operators](https://eslint.org/docs/rules/no-mixed-operators) – По стандарту нельзя писать код, в котором разные операции используются в одном выражении без явного разделения скобками.

В прошлом уроке мы сами признали, что такое обилие цифр и символов запутывает, и решили добавить скобки исключительно для удобства чтения:

```javascript
console.log(((8 / 2) + 5) - (-3 / 2)); // => 10.5
```

Этот вариант уже не нарушает правил, и линтер будет «молчать».

В упражнении прошлого урока у вас скорее всего получилось так:

```javascript
console.log(70 * (3 + 4) / (8 + 2));
```

Есть ли здесь нарушение стандарта?

К сожалению, да. На этот раз операции `*` и `/` находятся в одном выражении без разделения скобками. Вы можете решить эту проблему, добавив дополнительные скобки. Но в какой-то момент количество скобок может быть уже настолько большим, что код снова станет неудобным и непонятным. В этот момент разумнее будет разделить выражение на отдельные части. Мы научимся это делать в следующих уроках.

[no-mixed-operators](https://eslint.org/docs/rules/no-mixed-operators) — лишь одно из большого количества правил. Другие правила описывают отступы, названия создаваемых сущностей, скобки, математические операции, длину строк и множество иных аспектов. Каждое отдельное правило кажется довольно мелким, не очень важным. Но вместе они составляют основу хорошего кода.

Сейчас сайт не будет проверять ваш код линтером, но в ваших будущих практиках на [Хекслете](https://ru.hexlet.io) и в реальной разработке линтер будет работать и сообщать вам о нарушениях.
