
JavaScript не делает различий между рациональными (0.5) и натуральными числами (10), для него и то, и другое - числа (в других языках это не так). Благодаря этому их можно использовать совместно в любых операциях:

```javascript
3 * 0.5; // 1.5
```

Но как бы от нас ни скрывали, рациональные числа, в силу своих особенностей, устроены совсем по-другому. Нам, как прикладным программистам, это было бы не особенно важно, если бы не одна деталь. Посмотрите на этот пример:

```javascript
0.2 * 0.2 // 0.04000000000000001
```

Операция умножения двух рациональных чисел внезапно привела к неточному вычислению результата. Тот же самый результат выдадут и другие языки программирования. Такое поведение обуславливается ограничениями вычислительных мощностей. Объем памяти, в отличие от чисел, конечен (бесконечное количество чисел требует бесконечного количества памяти для своего хранения). И если с натуральными числами эта проблема решается простым ограничением по верхней границе (есть некоторое максимальное число, которое можно ввести), то с рациональными такой финт не пройдет.

```javascript
// Максимальное возможное целое число
console.log(Number.MAX_SAFE_INTEGER);
9007199254740991
```

Рациональные числа не выстроены в непрерывную цепочку, между _0.1_ и _0.2_ бесконечное множество чисел. Соответственно возникает серьезная проблема, а как хранить рациональные числа? Это интересный вопрос сам по себе. В интернете множество статей, посвященных организации памяти в таких случаях. Более того, существует стандарт, в котором описано, как это делать правильно, и подавляющее число языков на него опирается.

Для нас, как для разработчиков, важно понимать, что операции с плавающими числами неточны (эту точность можно регулировать), а значит при решении задач, связанных с подобными числами, необходимо прибегать к специальным трюкам, которые позволяют добиться необходимой точности.
