А что, если понадобится вычислить такое выражение: `3 * 5 - 2`? Именно так мы и запишем:

```javascript
console.log(3 * 5 - 2); // => 13
```

Обратите внимание, что интерпретатор производит арифметические вычисления в правильном порядке: сначала деление и умножение, потом сложение и вычитание. Иногда этот порядок нужно изменить — об этом следующий урок.

Или другой пример:

```javascript
console.log(2 * 4 * 5 * 10);
```

https://replit.com/@hexlet/js-basics-arithmetics-composition

Как видно, операции можно соединять друг с другом, получая возможность вычислять все более сложные составные выражения. Чтобы представить себе то, как происходят вычисления внутри интерпретатора, давайте разберем пример: `2 * 4 * 5 * 10`.

1. Сначала вычисляется `2 * 4` и получается выражение `8 * 5 * 10`.
1. Затем `8 * 5`. В итоге имеем `40 * 10`.
3. В конце концов происходит последнее умножение, и получается результат `400`.

Таким образом, интерпретатор соединяет сложные составные выражения, последовательно выполняя заложенные в них арифметические действия, по умолчанию соблюдая правильный порядок: сначала умножение и деление, затем - сложение и вычитание.
