
Перед тем как двигаться дальше, разберем базовую терминологию. Знак операции, такой как `+`, называют **оператором**. Операторы выполняют операции над определенными значениями, которые называются **операндами**. Сами операторы, обычно, представлены одним или несколькими символами. Реже словом. Подавляющее большинство операторов соответствуют математическим операциям.

```javascript
console.log(8 + 2);
```

https://replit.com/@hexlet/js-basics-arithmetics-operator

В этом примере `+` — это **оператор**, а числа `8` и `2` — это **операнды**.

В случае сложения у нас есть два операнда: один слева, другой справа от знака `+`. Операции, которые требуют наличия двух операндов, называются **бинарными**. Если пропустить хотя бы один операнд, например, `3 + ;`, то программа завершится с синтаксической ошибкой.

Операции (не операторы) бывают не только бинарными, но и унарными (с одним операндом), и даже тернарными (с тремя операндами)! Причем операторы могут выглядеть одинаково, но обозначать разные операции.

  ```javascript
  console.log(-3); // => -3
  ```

Выше пример применения унарной операции к числу `3`. Оператор минус перед тройкой говорит интерпретатору взять число `3` и найти противоположное, то есть `-3`.

Это немного может сбить с толку, потому что `-3` — это одновременно и число само по себе, и оператор с операндом, но у языков программирования такая структура.
