
Если программа на JavaScript написана синтаксически некорректно, то интерпретатор выводит на экран соответствующее сообщение, а также указание на файл и строчку в нём, где, по его мнению, произошла ошибка. *Синтаксическая ошибка* возникает в том случае, когда код был записан с нарушением грамматических правил. В человеческих языках грамматика важна, но текст с ошибками чаще всего можно понять и прочитать. В программировании всё строго. Любое мельчайшее нарушение, и программа даже не запустится. Примером может быть забытая `;`, неправильно расставленные скобки и другие детали.

Вот пример кода с синтаксической ошибкой:

```javascript
console.log('Hodor'
```

Если запустить код выше, то мы увидим следующее сообщение: `SyntaxError: missing ) after argument list`, а также указание на строку и файл, где возникла эта ошибка. Подобные синтаксические ошибки в JavaScript относятся к разряду SyntaxError.

*По техническим причинам, такой код, запущенный на https://code-basics.com не укажет на строку и файл. Проверить этот вывод можно на https://repl.it*

https://replit.com/@hexlet/js-basics-syntax-errors

С одной стороны, ошибки SyntaxError — самые простые, потому что они связаны исключительно с грамматическими правилами написания кода, а не с самим смыслом кода. Их легко исправить: нужно лишь найти нарушение в записи.

С другой стороны, интерпретатор не всегда может чётко указать на это нарушение. Поэтому бывает, что забытую скобку нужно поставить не туда, куда указывает сообщение об ошибке.
