Инструкция — это команда для компьютера выполнить что-то. Код на JavaScript — это набор инструкций, которые, как правило, отделяются друг от друга символом `;`.

Вот пример кода с двумя инструкциями.

```javascript
console.log('Mother of Dragons.');
console.log('Dracarys!');
```

https://replit.com/@hexlet/js-basics-instructions

При запуске этого кода, на экран последовательно выводятся два предложения:

<pre class='hexlet-basics-output'>
Mother of Dragons.
Dracarys!
</pre>

Теоретически, инструкции можно написать друг за другом без переноса на новую строчку:

```javascript
console.log('Mother of Dragons.'); console.log('Drakarys!');
```

Результат на экране будет таким же, но такой код неудобен для чтения, поэтому инструкции располагают друг под другом.

Почему это важно знать? Инструкция — это единица исполнения. Интерпретатор, программа которая запускает код на JavaScript, выполняет инструкции строго по очереди. И мы, как разработчики, должны понимать этот порядок и уметь мысленно разделять программу на независимые части, удобные для анализа.
