#include "lang.h"

static void outputTreeDefCtype(const struct lang &lang)
{
    FILE *f = fopen("ctypes.def", "w");

    fputs("/*\n"
          " * ctypes.def - C type definition for the `tree' structure.\n"
          " *\n"
          " * Automatically generated by genctypes. DO NOT EDIT.\n"
          " */\n\n", f);

    for (auto const &ctype : lang.treeCTypes)
        fprintf(f, "DEFCTYPE(%s, \"%s\", %s, %s, %s)\n", ctype.name.c_str(),
                ctype.friendly_name.c_str(),
                ctype.ctype.c_str(), ctype.format_string.c_str(),
                ctype.ff_union_member_name.c_str());

    fclose(f);
}

static void usage(char *progname)
{
    fprintf(stderr, "%s - Generate the `ctypes.def' file from a language description\n",
            progname);
    fprintf(stderr, "Usage: %s LANG_DESC_FILE\n", progname);
    fprintf(stderr, "\n");
    fprintf(stderr, "Where LANG_DESC_FILE is a language description file.\n");
}

int main(int argc, char *argv[])
{
    struct lang lang;
    FILE *f;

    if (argc != 2) {
        fprintf(stderr, "Error: %s expects exactly one argument\n", argv[0]);
        usage(argv[0]);
        return 1;
    }

    f = fopen(argv[1], "r");

    if (!f) {
        perror("Could not open lang file");
        usage(argv[0]);
        exit(2);
    }

    lang_read(f, lang);

    outputTreeDefCtype(lang);

    return 0;
}
