-- Code generated by codegen/generate-rest.go. DO NOT EDIT.

--[[--
The Nakama client SDK for Defold.

@module nakama
]]


local log = require "nakama.util.log"
local retries = require "nakama.util.retries"
local async = require "nakama.util.async"
local api_session = require "nakama.session"
local socket = require "nakama.socket"
local json = require "nakama.util.json"
local uri = require "nakama.util.uri"
local uri_encode = uri.encode

local M = {}

-- cancellation tokens associated with a coroutine
local cancellation_tokens = {}

-- cancel a cancellation token
function M.cancel(token)
	assert(token)
	token.cancelled = true
end

-- create a cancellation token
-- use this to cancel an ongoing API call or a sequence of API calls
-- @return token Pass the token to a call to nakama.sync() or to any of the API calls
function M.cancellation_token()
	local token = {
		cancelled = false
	}
	function token.cancel()
		token.cancelled = true
	end
	return token
end

-- Private
-- Run code within a coroutine
-- @param fn The code to run
-- @param cancellation_token Optional cancellation token to cancel the running code
function M.sync(fn, cancellation_token)
	assert(fn)
	local co = nil
	co = coroutine.create(function()
		cancellation_tokens[co] = cancellation_token
		fn()
		cancellation_tokens[co] = nil
	end)
	local ok, err = coroutine.resume(co)
	if not ok then
		log(err)
		cancellation_tokens[co] = nil
	end
end

-- http request helper used to reduce code duplication in all API functions below
local function http(client, callback, url_path, query_params, method, post_data, retry_policy, cancellation_token, handler_fn)
	if callback then
		log(url_path, "with callback")
		client.engine.http(client.config, url_path, query_params, method, post_data, retry_policy, cancellation_token, function(result)
			if not cancellation_token or not cancellation_token.cancelled then
				callback(handler_fn(result))
			end
		end)
	else
		log(url_path, "with coroutine")
		local co = coroutine.running()
		assert(co, "You must be running this from withing a coroutine")

		-- get cancellation token associated with this coroutine
		cancellation_token = cancellation_tokens[co]
		if cancellation_token and cancellation_token.cancelled then
			cancellation_tokens[co] = nil
			return
		end

		return async(function(done)
			client.engine.http(client.config, url_path, query_params, method, post_data, retry_policy, cancellation_token, function(result)
				if cancellation_token and cancellation_token.cancelled then
					cancellation_tokens[co] = nil
					return
				end
				done(handler_fn(result))
			end)
		end)
	end
end

--
-- Enums
--

--- api_operator
-- Operator that can be used to override the one set in the leaderboard.
--
-- - NO_OVERRIDE: Do not override the leaderboard operator.
-- - BEST: Override the leaderboard operator with BEST.
-- - SET: Override the leaderboard operator with SET.
-- - INCREMENT: Override the leaderboard operator with INCREMENT.
-- - DECREMENT: Override the leaderboard operator with DECREMENT.
M.APIOPERATOR_NO_OVERRIDE = "NO_OVERRIDE"
M.APIOPERATOR_BEST = "BEST"
M.APIOPERATOR_SET = "SET"
M.APIOPERATOR_INCREMENT = "INCREMENT"
M.APIOPERATOR_DECREMENT = "DECREMENT"

--- api_store_environment
-- - UNKNOWN: Unknown environment.
-- - SANDBOX: Sandbox/test environment.
-- - PRODUCTION: Production environment.
M.APISTOREENVIRONMENT_UNKNOWN = "UNKNOWN"
M.APISTOREENVIRONMENT_SANDBOX = "SANDBOX"
M.APISTOREENVIRONMENT_PRODUCTION = "PRODUCTION"

--- api_store_provider
-- - APPLE_APP_STORE: Apple App Store
-- - GOOGLE_PLAY_STORE: Google Play Store
-- - HUAWEI_APP_GALLERY: Huawei App Gallery
-- - FACEBOOK_INSTANT_STORE: Facebook Instant Store
M.APISTOREPROVIDER_APPLE_APP_STORE = "APPLE_APP_STORE"
M.APISTOREPROVIDER_GOOGLE_PLAY_STORE = "GOOGLE_PLAY_STORE"
M.APISTOREPROVIDER_HUAWEI_APP_GALLERY = "HUAWEI_APP_GALLERY"
M.APISTOREPROVIDER_FACEBOOK_INSTANT_STORE = "FACEBOOK_INSTANT_STORE"


--
-- Objects
--

--- create_group_user_list_group_user
-- A single user-role pair.
-- @param state_int (number) Their relationship to the group.
-- @param user_api_user (table) User.
function M.create_group_user_list_group_user(state_int,user_api_user,_)
	assert(not state_int or type(state_int) == "number", "Argument 'state_int' must be 'nil' or of type 'number'")
	assert(not user_api_user or type(user_api_user) == "table", "Argument 'user_api_user' must be 'nil' or of type 'table'")
	return {
		["state"] = state_int,
		["user"] = user_api_user,
	}
end

--- create_user_group_list_user_group
-- A single group-role pair.
-- @param group_api_group (table) Group.
-- @param state_int (number) The user's relationship to the group.
function M.create_user_group_list_user_group(group_api_group,state_int,_)
	assert(not group_api_group or type(group_api_group) == "table", "Argument 'group_api_group' must be 'nil' or of type 'table'")
	assert(not state_int or type(state_int) == "number", "Argument 'state_int' must be 'nil' or of type 'number'")
	return {
		["group"] = group_api_group,
		["state"] = state_int,
	}
end

--- create_write_leaderboard_record_request_leaderboard_record_write
-- Record values to write.
-- @param metadata_str (string) Optional record metadata.
-- @param operator_api_operator (string) Operator override.
-- @param score_str (string) The score value to submit.
-- @param subscore_str (string) An optional secondary value.
function M.create_write_leaderboard_record_request_leaderboard_record_write(metadata_str,operator_api_operator,score_str,subscore_str,_)
	assert(not metadata_str or type(metadata_str) == "string", "Argument 'metadata_str' must be 'nil' or of type 'string'")
	assert(not operator_api_operator or type(operator_api_operator) == "string", "Argument 'operator_api_operator' must be 'nil' or of type 'string'")
	assert(not score_str or type(score_str) == "string", "Argument 'score_str' must be 'nil' or of type 'string'")
	assert(not subscore_str or type(subscore_str) == "string", "Argument 'subscore_str' must be 'nil' or of type 'string'")
	return {
		["metadata"] = metadata_str,
		["operator"] = operator_api_operator,
		["score"] = score_str,
		["subscore"] = subscore_str,
	}
end

--- create_write_tournament_record_request_tournament_record_write
-- Record values to write.
-- @param metadata_str (string) A JSON object of additional properties (optional).
-- @param operator_api_operator (string) Operator override.
-- @param score_str (string) The score value to submit.
-- @param subscore_str (string) An optional secondary value.
function M.create_write_tournament_record_request_tournament_record_write(metadata_str,operator_api_operator,score_str,subscore_str,_)
	assert(not metadata_str or type(metadata_str) == "string", "Argument 'metadata_str' must be 'nil' or of type 'string'")
	assert(not operator_api_operator or type(operator_api_operator) == "string", "Argument 'operator_api_operator' must be 'nil' or of type 'string'")
	assert(not score_str or type(score_str) == "string", "Argument 'score_str' must be 'nil' or of type 'string'")
	assert(not subscore_str or type(subscore_str) == "string", "Argument 'subscore_str' must be 'nil' or of type 'string'")
	return {
		["metadata"] = metadata_str,
		["operator"] = operator_api_operator,
		["score"] = score_str,
		["subscore"] = subscore_str,
	}
end

--- create_api_account
-- A user with additional account details. Always the current user.
-- @param custom_id_str (string) The custom id in the user's account.
-- @param devices_arr (table) The devices which belong to the user's account.
-- @param disable_time_str (string) The UNIX time (for gRPC clients) or ISO string (for REST clients) when the user's account was disabled/banned.
-- @param email_str (string) The email address of the user.
-- @param user_api_user (table) The user object.
-- @param verify_time_str (string) The UNIX time (for gRPC clients) or ISO string (for REST clients) when the user's email was verified.
-- @param wallet_str (string) The user's wallet data.
function M.create_api_account(custom_id_str,devices_arr,disable_time_str,email_str,user_api_user,verify_time_str,wallet_str,_)
	assert(not custom_id_str or type(custom_id_str) == "string", "Argument 'custom_id_str' must be 'nil' or of type 'string'")
	assert(not devices_arr or type(devices_arr) == "table", "Argument 'devices_arr' must be 'nil' or of type 'table'")
	assert(not disable_time_str or type(disable_time_str) == "string", "Argument 'disable_time_str' must be 'nil' or of type 'string'")
	assert(not email_str or type(email_str) == "string", "Argument 'email_str' must be 'nil' or of type 'string'")
	assert(not user_api_user or type(user_api_user) == "table", "Argument 'user_api_user' must be 'nil' or of type 'table'")
	assert(not verify_time_str or type(verify_time_str) == "string", "Argument 'verify_time_str' must be 'nil' or of type 'string'")
	assert(not wallet_str or type(wallet_str) == "string", "Argument 'wallet_str' must be 'nil' or of type 'string'")
	return {
		["custom_id"] = custom_id_str,
		["devices"] = devices_arr,
		["disable_time"] = disable_time_str,
		["email"] = email_str,
		["user"] = user_api_user,
		["verify_time"] = verify_time_str,
		["wallet"] = wallet_str,
	}
end

--- create_api_account_apple
-- Send a Apple Sign In token to the server. Used with authenticate/link/unlink.
-- @param token_str (string) The ID token received from Apple to validate.
-- @param vars_obj (table) Extra information that will be bundled in the session token.
function M.create_api_account_apple(token_str,vars_obj,_)
	assert(not token_str or type(token_str) == "string", "Argument 'token_str' must be 'nil' or of type 'string'")
	assert(not vars_obj or type(vars_obj) == "table", "Argument 'vars_obj' must be 'nil' or of type 'table'")
	return {
		["token"] = token_str,
		["vars"] = vars_obj,
	}
end

--- create_api_account_custom
-- Send a custom ID to the server. Used with authenticate/link/unlink.
-- @param id_str (string) A custom identifier.
-- @param vars_obj (table) Extra information that will be bundled in the session token.
function M.create_api_account_custom(id_str,vars_obj,_)
	assert(not id_str or type(id_str) == "string", "Argument 'id_str' must be 'nil' or of type 'string'")
	assert(not vars_obj or type(vars_obj) == "table", "Argument 'vars_obj' must be 'nil' or of type 'table'")
	return {
		["id"] = id_str,
		["vars"] = vars_obj,
	}
end

--- create_api_account_device
-- Send a device to the server. Used with authenticate/link/unlink and user.
-- @param id_str (string) A device identifier. Should be obtained by a platform-specific device API.
-- @param vars_obj (table) Extra information that will be bundled in the session token.
function M.create_api_account_device(id_str,vars_obj,_)
	assert(not id_str or type(id_str) == "string", "Argument 'id_str' must be 'nil' or of type 'string'")
	assert(not vars_obj or type(vars_obj) == "table", "Argument 'vars_obj' must be 'nil' or of type 'table'")
	return {
		["id"] = id_str,
		["vars"] = vars_obj,
	}
end

--- create_api_account_email
-- Send an email with password to the server. Used with authenticate/link/unlink.
-- @param email_str (string) A valid RFC-5322 email address.
-- @param password_str (string) A password for the user account.
--
--Ignored with unlink operations.
-- @param vars_obj (table) Extra information that will be bundled in the session token.
function M.create_api_account_email(email_str,password_str,vars_obj,_)
	assert(not email_str or type(email_str) == "string", "Argument 'email_str' must be 'nil' or of type 'string'")
	assert(not password_str or type(password_str) == "string", "Argument 'password_str' must be 'nil' or of type 'string'")
	assert(not vars_obj or type(vars_obj) == "table", "Argument 'vars_obj' must be 'nil' or of type 'table'")
	return {
		["email"] = email_str,
		["password"] = password_str,
		["vars"] = vars_obj,
	}
end

--- create_api_account_facebook
-- Send a Facebook token to the server. Used with authenticate/link/unlink.
-- @param token_str (string) The OAuth token received from Facebook to access their profile API.
-- @param vars_obj (table) Extra information that will be bundled in the session token.
function M.create_api_account_facebook(token_str,vars_obj,_)
	assert(not token_str or type(token_str) == "string", "Argument 'token_str' must be 'nil' or of type 'string'")
	assert(not vars_obj or type(vars_obj) == "table", "Argument 'vars_obj' must be 'nil' or of type 'table'")
	return {
		["token"] = token_str,
		["vars"] = vars_obj,
	}
end

--- create_api_account_facebook_instant_game
-- Send a Facebook Instant Game token to the server. Used with authenticate/link/unlink.
-- @param signed_player_info_str (string) 
-- @param vars_obj (table) Extra information that will be bundled in the session token.
function M.create_api_account_facebook_instant_game(signed_player_info_str,vars_obj,_)
	assert(not signed_player_info_str or type(signed_player_info_str) == "string", "Argument 'signed_player_info_str' must be 'nil' or of type 'string'")
	assert(not vars_obj or type(vars_obj) == "table", "Argument 'vars_obj' must be 'nil' or of type 'table'")
	return {
		["signed_player_info"] = signed_player_info_str,
		["vars"] = vars_obj,
	}
end

--- create_api_account_game_center
-- Send Apple's Game Center account credentials to the server. Used with authenticate/link/unlink.
--
--https://developer.apple.com/documentation/gamekit/gklocalplayer/1515407-generateidentityverificationsign
-- @param bundle_id_str (string) Bundle ID (generated by GameCenter).
-- @param player_id_str (string) Player ID (generated by GameCenter).
-- @param public_key_url_str (string) The URL for the public encryption key.
-- @param salt_str (string) A random "NSString" used to compute the hash and keep it randomized.
-- @param signature_str (string) The verification signature data generated.
-- @param timestamp_seconds_str (string) Time since UNIX epoch when the signature was created.
-- @param vars_obj (table) Extra information that will be bundled in the session token.
function M.create_api_account_game_center(bundle_id_str,player_id_str,public_key_url_str,salt_str,signature_str,timestamp_seconds_str,vars_obj,_)
	assert(not bundle_id_str or type(bundle_id_str) == "string", "Argument 'bundle_id_str' must be 'nil' or of type 'string'")
	assert(not player_id_str or type(player_id_str) == "string", "Argument 'player_id_str' must be 'nil' or of type 'string'")
	assert(not public_key_url_str or type(public_key_url_str) == "string", "Argument 'public_key_url_str' must be 'nil' or of type 'string'")
	assert(not salt_str or type(salt_str) == "string", "Argument 'salt_str' must be 'nil' or of type 'string'")
	assert(not signature_str or type(signature_str) == "string", "Argument 'signature_str' must be 'nil' or of type 'string'")
	assert(not timestamp_seconds_str or type(timestamp_seconds_str) == "string", "Argument 'timestamp_seconds_str' must be 'nil' or of type 'string'")
	assert(not vars_obj or type(vars_obj) == "table", "Argument 'vars_obj' must be 'nil' or of type 'table'")
	return {
		["bundle_id"] = bundle_id_str,
		["player_id"] = player_id_str,
		["public_key_url"] = public_key_url_str,
		["salt"] = salt_str,
		["signature"] = signature_str,
		["timestamp_seconds"] = timestamp_seconds_str,
		["vars"] = vars_obj,
	}
end

--- create_api_account_google
-- Send a Google token to the server. Used with authenticate/link/unlink.
-- @param token_str (string) The OAuth token received from Google to access their profile API.
-- @param vars_obj (table) Extra information that will be bundled in the session token.
function M.create_api_account_google(token_str,vars_obj,_)
	assert(not token_str or type(token_str) == "string", "Argument 'token_str' must be 'nil' or of type 'string'")
	assert(not vars_obj or type(vars_obj) == "table", "Argument 'vars_obj' must be 'nil' or of type 'table'")
	return {
		["token"] = token_str,
		["vars"] = vars_obj,
	}
end

--- create_api_account_steam
-- Send a Steam token to the server. Used with authenticate/link/unlink.
-- @param token_str (string) The account token received from Steam to access their profile API.
-- @param vars_obj (table) Extra information that will be bundled in the session token.
function M.create_api_account_steam(token_str,vars_obj,_)
	assert(not token_str or type(token_str) == "string", "Argument 'token_str' must be 'nil' or of type 'string'")
	assert(not vars_obj or type(vars_obj) == "table", "Argument 'vars_obj' must be 'nil' or of type 'table'")
	return {
		["token"] = token_str,
		["vars"] = vars_obj,
	}
end

--- create_api_channel_message
-- A message sent on a channel.
-- @param channel_id_str (string) The channel this message belongs to.
-- @param code_int (number) The code representing a message type or category.
-- @param content_str (string) The content payload.
-- @param create_time_str (string) The UNIX time (for gRPC clients) or ISO string (for REST clients) when the message was created.
-- @param group_id_str (string) The ID of the group, or an empty string if this message was not sent through a group channel.
-- @param message_id_str (string) The unique ID of this message.
-- @param persistent_bool (boolean) True if the message was persisted to the channel's history, false otherwise.
-- @param room_name_str (string) The name of the chat room, or an empty string if this message was not sent through a chat room.
-- @param sender_id_str (string) Message sender, usually a user ID.
-- @param update_time_str (string) The UNIX time (for gRPC clients) or ISO string (for REST clients) when the message was last updated.
-- @param user_id_one_str (string) The ID of the first DM user, or an empty string if this message was not sent through a DM chat.
-- @param user_id_two_str (string) The ID of the second DM user, or an empty string if this message was not sent through a DM chat.
-- @param username_str (string) The username of the message sender, if any.
function M.create_api_channel_message(channel_id_str,code_int,content_str,create_time_str,group_id_str,message_id_str,persistent_bool,room_name_str,sender_id_str,update_time_str,user_id_one_str,user_id_two_str,username_str,_)
	assert(not channel_id_str or type(channel_id_str) == "string", "Argument 'channel_id_str' must be 'nil' or of type 'string'")
	assert(not code_int or type(code_int) == "number", "Argument 'code_int' must be 'nil' or of type 'number'")
	assert(not content_str or type(content_str) == "string", "Argument 'content_str' must be 'nil' or of type 'string'")
	assert(not create_time_str or type(create_time_str) == "string", "Argument 'create_time_str' must be 'nil' or of type 'string'")
	assert(not group_id_str or type(group_id_str) == "string", "Argument 'group_id_str' must be 'nil' or of type 'string'")
	assert(not message_id_str or type(message_id_str) == "string", "Argument 'message_id_str' must be 'nil' or of type 'string'")
	assert(not persistent_bool or type(persistent_bool) == "boolean", "Argument 'persistent_bool' must be 'nil' or of type 'boolean'")
	assert(not room_name_str or type(room_name_str) == "string", "Argument 'room_name_str' must be 'nil' or of type 'string'")
	assert(not sender_id_str or type(sender_id_str) == "string", "Argument 'sender_id_str' must be 'nil' or of type 'string'")
	assert(not update_time_str or type(update_time_str) == "string", "Argument 'update_time_str' must be 'nil' or of type 'string'")
	assert(not user_id_one_str or type(user_id_one_str) == "string", "Argument 'user_id_one_str' must be 'nil' or of type 'string'")
	assert(not user_id_two_str or type(user_id_two_str) == "string", "Argument 'user_id_two_str' must be 'nil' or of type 'string'")
	assert(not username_str or type(username_str) == "string", "Argument 'username_str' must be 'nil' or of type 'string'")
	return {
		["channel_id"] = channel_id_str,
		["code"] = code_int,
		["content"] = content_str,
		["create_time"] = create_time_str,
		["group_id"] = group_id_str,
		["message_id"] = message_id_str,
		["persistent"] = persistent_bool,
		["room_name"] = room_name_str,
		["sender_id"] = sender_id_str,
		["update_time"] = update_time_str,
		["user_id_one"] = user_id_one_str,
		["user_id_two"] = user_id_two_str,
		["username"] = username_str,
	}
end

--- create_api_channel_message_list
-- A list of channel messages, usually a result of a list operation.
-- @param cacheable_cursor_str (string) Cacheable cursor to list newer messages. Durable and designed to be stored, unlike next/prev cursors.
-- @param messages_arr (table) A list of messages.
-- @param next_cursor_str (string) The cursor to send when retrieving the next page, if any.
-- @param prev_cursor_str (string) The cursor to send when retrieving the previous page, if any.
function M.create_api_channel_message_list(cacheable_cursor_str,messages_arr,next_cursor_str,prev_cursor_str,_)
	assert(not cacheable_cursor_str or type(cacheable_cursor_str) == "string", "Argument 'cacheable_cursor_str' must be 'nil' or of type 'string'")
	assert(not messages_arr or type(messages_arr) == "table", "Argument 'messages_arr' must be 'nil' or of type 'table'")
	assert(not next_cursor_str or type(next_cursor_str) == "string", "Argument 'next_cursor_str' must be 'nil' or of type 'string'")
	assert(not prev_cursor_str or type(prev_cursor_str) == "string", "Argument 'prev_cursor_str' must be 'nil' or of type 'string'")
	return {
		["cacheable_cursor"] = cacheable_cursor_str,
		["messages"] = messages_arr,
		["next_cursor"] = next_cursor_str,
		["prev_cursor"] = prev_cursor_str,
	}
end

--- create_api_create_group_request
-- Create a group with the current user as owner.
-- @param avatar_url_str (string) A URL for an avatar image.
-- @param description_str (string) A description for the group.
-- @param lang_tag_str (string) The language expected to be a tag which follows the BCP-47 spec.
-- @param max_count_int (number) Maximum number of group members.
-- @param name_str (string) A unique name for the group.
-- @param open_bool (boolean) Mark a group as open or not where only admins can accept members.
function M.create_api_create_group_request(avatar_url_str,description_str,lang_tag_str,max_count_int,name_str,open_bool,_)
	assert(not avatar_url_str or type(avatar_url_str) == "string", "Argument 'avatar_url_str' must be 'nil' or of type 'string'")
	assert(not description_str or type(description_str) == "string", "Argument 'description_str' must be 'nil' or of type 'string'")
	assert(not lang_tag_str or type(lang_tag_str) == "string", "Argument 'lang_tag_str' must be 'nil' or of type 'string'")
	assert(not max_count_int or type(max_count_int) == "number", "Argument 'max_count_int' must be 'nil' or of type 'number'")
	assert(not name_str or type(name_str) == "string", "Argument 'name_str' must be 'nil' or of type 'string'")
	assert(not open_bool or type(open_bool) == "boolean", "Argument 'open_bool' must be 'nil' or of type 'boolean'")
	return {
		["avatar_url"] = avatar_url_str,
		["description"] = description_str,
		["lang_tag"] = lang_tag_str,
		["max_count"] = max_count_int,
		["name"] = name_str,
		["open"] = open_bool,
	}
end

--- create_api_delete_storage_object_id
-- Storage objects to delete.
-- @param collection_str (string) The collection which stores the object.
-- @param key_str (string) The key of the object within the collection.
-- @param version_str (string) The version hash of the object.
function M.create_api_delete_storage_object_id(collection_str,key_str,version_str,_)
	assert(not collection_str or type(collection_str) == "string", "Argument 'collection_str' must be 'nil' or of type 'string'")
	assert(not key_str or type(key_str) == "string", "Argument 'key_str' must be 'nil' or of type 'string'")
	assert(not version_str or type(version_str) == "string", "Argument 'version_str' must be 'nil' or of type 'string'")
	return {
		["collection"] = collection_str,
		["key"] = key_str,
		["version"] = version_str,
	}
end

--- create_api_delete_storage_objects_request
-- Batch delete storage objects.
-- @param object_ids_arr (table) Batch of storage objects.
function M.create_api_delete_storage_objects_request(object_ids_arr,_)
	assert(not object_ids_arr or type(object_ids_arr) == "table", "Argument 'object_ids_arr' must be 'nil' or of type 'table'")
	return {
		["object_ids"] = object_ids_arr,
	}
end

--- create_api_event
-- Represents an event to be passed through the server to registered event handlers.
-- @param external_bool (boolean) True if the event came directly from a client call, false otherwise.
-- @param name_str (string) An event name, type, category, or identifier.
-- @param properties_obj (table) Arbitrary event property values.
-- @param timestamp_str (string) The time when the event was triggered.
function M.create_api_event(external_bool,name_str,properties_obj,timestamp_str,_)
	assert(not external_bool or type(external_bool) == "boolean", "Argument 'external_bool' must be 'nil' or of type 'boolean'")
	assert(not name_str or type(name_str) == "string", "Argument 'name_str' must be 'nil' or of type 'string'")
	assert(not properties_obj or type(properties_obj) == "table", "Argument 'properties_obj' must be 'nil' or of type 'table'")
	assert(not timestamp_str or type(timestamp_str) == "string", "Argument 'timestamp_str' must be 'nil' or of type 'string'")
	return {
		["external"] = external_bool,
		["name"] = name_str,
		["properties"] = properties_obj,
		["timestamp"] = timestamp_str,
	}
end

--- create_api_friend
-- A friend of a user.
-- @param state_int (number) The friend status.
--
--one of "Friend.State".
-- @param update_time_str (string) Time of the latest relationship update.
-- @param user_api_user (table) The user object.
function M.create_api_friend(state_int,update_time_str,user_api_user,_)
	assert(not state_int or type(state_int) == "number", "Argument 'state_int' must be 'nil' or of type 'number'")
	assert(not update_time_str or type(update_time_str) == "string", "Argument 'update_time_str' must be 'nil' or of type 'string'")
	assert(not user_api_user or type(user_api_user) == "table", "Argument 'user_api_user' must be 'nil' or of type 'table'")
	return {
		["state"] = state_int,
		["update_time"] = update_time_str,
		["user"] = user_api_user,
	}
end

--- create_api_friend_list
-- A collection of zero or more friends of the user.
-- @param cursor_str (string) Cursor for the next page of results, if any.
-- @param friends_arr (table) The Friend objects.
function M.create_api_friend_list(cursor_str,friends_arr,_)
	assert(not cursor_str or type(cursor_str) == "string", "Argument 'cursor_str' must be 'nil' or of type 'string'")
	assert(not friends_arr or type(friends_arr) == "table", "Argument 'friends_arr' must be 'nil' or of type 'table'")
	return {
		["cursor"] = cursor_str,
		["friends"] = friends_arr,
	}
end

--- create_api_group
-- A group in the server.
-- @param avatar_url_str (string) A URL for an avatar image.
-- @param create_time_str (string) The UNIX time (for gRPC clients) or ISO string (for REST clients) when the group was created.
-- @param creator_id_str (string) The id of the user who created the group.
-- @param description_str (string) A description for the group.
-- @param edge_count_int (number) The current count of all members in the group.
-- @param id_str (string) The id of a group.
-- @param lang_tag_str (string) The language expected to be a tag which follows the BCP-47 spec.
-- @param max_count_int (number) The maximum number of members allowed.
-- @param metadata_str (string) Additional information stored as a JSON object.
-- @param name_str (string) The unique name of the group.
-- @param open_bool (boolean) Anyone can join open groups, otherwise only admins can accept members.
-- @param update_time_str (string) The UNIX time (for gRPC clients) or ISO string (for REST clients) when the group was last updated.
function M.create_api_group(avatar_url_str,create_time_str,creator_id_str,description_str,edge_count_int,id_str,lang_tag_str,max_count_int,metadata_str,name_str,open_bool,update_time_str,_)
	assert(not avatar_url_str or type(avatar_url_str) == "string", "Argument 'avatar_url_str' must be 'nil' or of type 'string'")
	assert(not create_time_str or type(create_time_str) == "string", "Argument 'create_time_str' must be 'nil' or of type 'string'")
	assert(not creator_id_str or type(creator_id_str) == "string", "Argument 'creator_id_str' must be 'nil' or of type 'string'")
	assert(not description_str or type(description_str) == "string", "Argument 'description_str' must be 'nil' or of type 'string'")
	assert(not edge_count_int or type(edge_count_int) == "number", "Argument 'edge_count_int' must be 'nil' or of type 'number'")
	assert(not id_str or type(id_str) == "string", "Argument 'id_str' must be 'nil' or of type 'string'")
	assert(not lang_tag_str or type(lang_tag_str) == "string", "Argument 'lang_tag_str' must be 'nil' or of type 'string'")
	assert(not max_count_int or type(max_count_int) == "number", "Argument 'max_count_int' must be 'nil' or of type 'number'")
	assert(not metadata_str or type(metadata_str) == "string", "Argument 'metadata_str' must be 'nil' or of type 'string'")
	assert(not name_str or type(name_str) == "string", "Argument 'name_str' must be 'nil' or of type 'string'")
	assert(not open_bool or type(open_bool) == "boolean", "Argument 'open_bool' must be 'nil' or of type 'boolean'")
	assert(not update_time_str or type(update_time_str) == "string", "Argument 'update_time_str' must be 'nil' or of type 'string'")
	return {
		["avatar_url"] = avatar_url_str,
		["create_time"] = create_time_str,
		["creator_id"] = creator_id_str,
		["description"] = description_str,
		["edge_count"] = edge_count_int,
		["id"] = id_str,
		["lang_tag"] = lang_tag_str,
		["max_count"] = max_count_int,
		["metadata"] = metadata_str,
		["name"] = name_str,
		["open"] = open_bool,
		["update_time"] = update_time_str,
	}
end

--- create_api_group_list
-- One or more groups returned from a listing operation.
-- @param cursor_str (string) A cursor used to get the next page.
-- @param groups_arr (table) One or more groups.
function M.create_api_group_list(cursor_str,groups_arr,_)
	assert(not cursor_str or type(cursor_str) == "string", "Argument 'cursor_str' must be 'nil' or of type 'string'")
	assert(not groups_arr or type(groups_arr) == "table", "Argument 'groups_arr' must be 'nil' or of type 'table'")
	return {
		["cursor"] = cursor_str,
		["groups"] = groups_arr,
	}
end

--- create_api_group_user_list
-- A list of users belonging to a group, along with their role.
-- @param cursor_str (string) Cursor for the next page of results, if any.
-- @param group_users_arr (table) User-role pairs for a group.
function M.create_api_group_user_list(cursor_str,group_users_arr,_)
	assert(not cursor_str or type(cursor_str) == "string", "Argument 'cursor_str' must be 'nil' or of type 'string'")
	assert(not group_users_arr or type(group_users_arr) == "table", "Argument 'group_users_arr' must be 'nil' or of type 'table'")
	return {
		["cursor"] = cursor_str,
		["group_users"] = group_users_arr,
	}
end

--- create_api_leaderboard_record
-- Represents a complete leaderboard record with all scores and associated metadata.
-- @param create_time_str (string) The UNIX time (for gRPC clients) or ISO string (for REST clients) when the leaderboard record was created.
-- @param expiry_time_str (string) The UNIX time (for gRPC clients) or ISO string (for REST clients) when the leaderboard record expires.
-- @param leaderboard_id_str (string) The ID of the leaderboard this score belongs to.
-- @param max_num_score_int (number) The maximum number of score updates allowed by the owner.
-- @param metadata_str (string) Metadata.
-- @param num_score_int (number) The number of submissions to this score record.
-- @param owner_id_str (string) The ID of the score owner, usually a user or group.
-- @param rank_str (string) The rank of this record.
-- @param score_str (string) The score value.
-- @param subscore_str (string) An optional subscore value.
-- @param update_time_str (string) The UNIX time (for gRPC clients) or ISO string (for REST clients) when the leaderboard record was updated.
-- @param username_str (string) The username of the score owner, if the owner is a user.
function M.create_api_leaderboard_record(create_time_str,expiry_time_str,leaderboard_id_str,max_num_score_int,metadata_str,num_score_int,owner_id_str,rank_str,score_str,subscore_str,update_time_str,username_str,_)
	assert(not create_time_str or type(create_time_str) == "string", "Argument 'create_time_str' must be 'nil' or of type 'string'")
	assert(not expiry_time_str or type(expiry_time_str) == "string", "Argument 'expiry_time_str' must be 'nil' or of type 'string'")
	assert(not leaderboard_id_str or type(leaderboard_id_str) == "string", "Argument 'leaderboard_id_str' must be 'nil' or of type 'string'")
	assert(not max_num_score_int or type(max_num_score_int) == "number", "Argument 'max_num_score_int' must be 'nil' or of type 'number'")
	assert(not metadata_str or type(metadata_str) == "string", "Argument 'metadata_str' must be 'nil' or of type 'string'")
	assert(not num_score_int or type(num_score_int) == "number", "Argument 'num_score_int' must be 'nil' or of type 'number'")
	assert(not owner_id_str or type(owner_id_str) == "string", "Argument 'owner_id_str' must be 'nil' or of type 'string'")
	assert(not rank_str or type(rank_str) == "string", "Argument 'rank_str' must be 'nil' or of type 'string'")
	assert(not score_str or type(score_str) == "string", "Argument 'score_str' must be 'nil' or of type 'string'")
	assert(not subscore_str or type(subscore_str) == "string", "Argument 'subscore_str' must be 'nil' or of type 'string'")
	assert(not update_time_str or type(update_time_str) == "string", "Argument 'update_time_str' must be 'nil' or of type 'string'")
	assert(not username_str or type(username_str) == "string", "Argument 'username_str' must be 'nil' or of type 'string'")
	return {
		["create_time"] = create_time_str,
		["expiry_time"] = expiry_time_str,
		["leaderboard_id"] = leaderboard_id_str,
		["max_num_score"] = max_num_score_int,
		["metadata"] = metadata_str,
		["num_score"] = num_score_int,
		["owner_id"] = owner_id_str,
		["rank"] = rank_str,
		["score"] = score_str,
		["subscore"] = subscore_str,
		["update_time"] = update_time_str,
		["username"] = username_str,
	}
end

--- create_api_leaderboard_record_list
-- A set of leaderboard records, may be part of a leaderboard records page or a batch of individual records.
-- @param next_cursor_str (string) The cursor to send when retrieving the next page, if any.
-- @param owner_records_arr (table) A batched set of leaderboard records belonging to specified owners.
-- @param prev_cursor_str (string) The cursor to send when retrieving the previous page, if any.
-- @param rank_count_str (string) The total number of ranks available.
-- @param records_arr (table) A list of leaderboard records.
function M.create_api_leaderboard_record_list(next_cursor_str,owner_records_arr,prev_cursor_str,rank_count_str,records_arr,_)
	assert(not next_cursor_str or type(next_cursor_str) == "string", "Argument 'next_cursor_str' must be 'nil' or of type 'string'")
	assert(not owner_records_arr or type(owner_records_arr) == "table", "Argument 'owner_records_arr' must be 'nil' or of type 'table'")
	assert(not prev_cursor_str or type(prev_cursor_str) == "string", "Argument 'prev_cursor_str' must be 'nil' or of type 'string'")
	assert(not rank_count_str or type(rank_count_str) == "string", "Argument 'rank_count_str' must be 'nil' or of type 'string'")
	assert(not records_arr or type(records_arr) == "table", "Argument 'records_arr' must be 'nil' or of type 'table'")
	return {
		["next_cursor"] = next_cursor_str,
		["owner_records"] = owner_records_arr,
		["prev_cursor"] = prev_cursor_str,
		["rank_count"] = rank_count_str,
		["records"] = records_arr,
	}
end

--- create_api_link_steam_request
-- Link Steam to the current user's account.
-- @param account_api_account_steam (table) The Facebook account details.
-- @param sync_bool (boolean) Import Steam friends for the user.
function M.create_api_link_steam_request(account_api_account_steam,sync_bool,_)
	assert(not account_api_account_steam or type(account_api_account_steam) == "table", "Argument 'account_api_account_steam' must be 'nil' or of type 'table'")
	assert(not sync_bool or type(sync_bool) == "boolean", "Argument 'sync_bool' must be 'nil' or of type 'boolean'")
	return {
		["account"] = account_api_account_steam,
		["sync"] = sync_bool,
	}
end

--- create_api_list_subscriptions_request
-- List user subscriptions.
-- @param cursor_str (string) 
-- @param limit_int (number) 
function M.create_api_list_subscriptions_request(cursor_str,limit_int,_)
	assert(not cursor_str or type(cursor_str) == "string", "Argument 'cursor_str' must be 'nil' or of type 'string'")
	assert(not limit_int or type(limit_int) == "number", "Argument 'limit_int' must be 'nil' or of type 'number'")
	return {
		["cursor"] = cursor_str,
		["limit"] = limit_int,
	}
end

--- create_api_match
-- Represents a realtime match.
-- @param authoritative_bool (boolean) True if it's an server-managed authoritative match, false otherwise.
-- @param handler_name_str (string) 
-- @param label_str (string) Match label, if any.
-- @param match_id_str (string) The ID of the match, can be used to join.
-- @param size_int (number) Current number of users in the match.
-- @param tick_rate_int (number) 
function M.create_api_match(authoritative_bool,handler_name_str,label_str,match_id_str,size_int,tick_rate_int,_)
	assert(not authoritative_bool or type(authoritative_bool) == "boolean", "Argument 'authoritative_bool' must be 'nil' or of type 'boolean'")
	assert(not handler_name_str or type(handler_name_str) == "string", "Argument 'handler_name_str' must be 'nil' or of type 'string'")
	assert(not label_str or type(label_str) == "string", "Argument 'label_str' must be 'nil' or of type 'string'")
	assert(not match_id_str or type(match_id_str) == "string", "Argument 'match_id_str' must be 'nil' or of type 'string'")
	assert(not size_int or type(size_int) == "number", "Argument 'size_int' must be 'nil' or of type 'number'")
	assert(not tick_rate_int or type(tick_rate_int) == "number", "Argument 'tick_rate_int' must be 'nil' or of type 'number'")
	return {
		["authoritative"] = authoritative_bool,
		["handler_name"] = handler_name_str,
		["label"] = label_str,
		["match_id"] = match_id_str,
		["size"] = size_int,
		["tick_rate"] = tick_rate_int,
	}
end

--- create_api_match_list
-- A list of realtime matches.
-- @param matches_arr (table) A number of matches corresponding to a list operation.
function M.create_api_match_list(matches_arr,_)
	assert(not matches_arr or type(matches_arr) == "table", "Argument 'matches_arr' must be 'nil' or of type 'table'")
	return {
		["matches"] = matches_arr,
	}
end

--- create_api_notification
-- A notification in the server.
-- @param code_int (number) Category code for this notification.
-- @param content_str (string) Content of the notification in JSON.
-- @param create_time_str (string) The UNIX time (for gRPC clients) or ISO string (for REST clients) when the notification was created.
-- @param id_str (string) ID of the Notification.
-- @param persistent_bool (boolean) True if this notification was persisted to the database.
-- @param sender_id_str (string) ID of the sender, if a user. Otherwise 'null'.
-- @param subject_str (string) Subject of the notification.
function M.create_api_notification(code_int,content_str,create_time_str,id_str,persistent_bool,sender_id_str,subject_str,_)
	assert(not code_int or type(code_int) == "number", "Argument 'code_int' must be 'nil' or of type 'number'")
	assert(not content_str or type(content_str) == "string", "Argument 'content_str' must be 'nil' or of type 'string'")
	assert(not create_time_str or type(create_time_str) == "string", "Argument 'create_time_str' must be 'nil' or of type 'string'")
	assert(not id_str or type(id_str) == "string", "Argument 'id_str' must be 'nil' or of type 'string'")
	assert(not persistent_bool or type(persistent_bool) == "boolean", "Argument 'persistent_bool' must be 'nil' or of type 'boolean'")
	assert(not sender_id_str or type(sender_id_str) == "string", "Argument 'sender_id_str' must be 'nil' or of type 'string'")
	assert(not subject_str or type(subject_str) == "string", "Argument 'subject_str' must be 'nil' or of type 'string'")
	return {
		["code"] = code_int,
		["content"] = content_str,
		["create_time"] = create_time_str,
		["id"] = id_str,
		["persistent"] = persistent_bool,
		["sender_id"] = sender_id_str,
		["subject"] = subject_str,
	}
end

--- create_api_notification_list
-- A collection of zero or more notifications.
-- @param cacheable_cursor_str (string) Use this cursor to paginate notifications. Cache this to catch up to new notifications.
-- @param notifications_arr (table) Collection of notifications.
function M.create_api_notification_list(cacheable_cursor_str,notifications_arr,_)
	assert(not cacheable_cursor_str or type(cacheable_cursor_str) == "string", "Argument 'cacheable_cursor_str' must be 'nil' or of type 'string'")
	assert(not notifications_arr or type(notifications_arr) == "table", "Argument 'notifications_arr' must be 'nil' or of type 'table'")
	return {
		["cacheable_cursor"] = cacheable_cursor_str,
		["notifications"] = notifications_arr,
	}
end

--- create_api_read_storage_object_id
-- Storage objects to get.
-- @param collection_str (string) The collection which stores the object.
-- @param key_str (string) The key of the object within the collection.
-- @param user_id_str (string) The user owner of the object.
function M.create_api_read_storage_object_id(collection_str,key_str,user_id_str,_)
	assert(not collection_str or type(collection_str) == "string", "Argument 'collection_str' must be 'nil' or of type 'string'")
	assert(not key_str or type(key_str) == "string", "Argument 'key_str' must be 'nil' or of type 'string'")
	assert(not user_id_str or type(user_id_str) == "string", "Argument 'user_id_str' must be 'nil' or of type 'string'")
	return {
		["collection"] = collection_str,
		["key"] = key_str,
		["user_id"] = user_id_str,
	}
end

--- create_api_read_storage_objects_request
-- Batch get storage objects.
-- @param object_ids_arr (table) Batch of storage objects.
function M.create_api_read_storage_objects_request(object_ids_arr,_)
	assert(not object_ids_arr or type(object_ids_arr) == "table", "Argument 'object_ids_arr' must be 'nil' or of type 'table'")
	return {
		["object_ids"] = object_ids_arr,
	}
end

--- create_api_rpc
-- Execute an Lua function on the server.
-- @param http_key_str (string) The authentication key used when executed as a non-client HTTP request.
-- @param id_str (string) The identifier of the function.
-- @param payload_str (string) The payload of the function which must be a JSON object.
function M.create_api_rpc(http_key_str,id_str,payload_str,_)
	assert(not http_key_str or type(http_key_str) == "string", "Argument 'http_key_str' must be 'nil' or of type 'string'")
	assert(not id_str or type(id_str) == "string", "Argument 'id_str' must be 'nil' or of type 'string'")
	assert(not payload_str or type(payload_str) == "string", "Argument 'payload_str' must be 'nil' or of type 'string'")
	return {
		["http_key"] = http_key_str,
		["id"] = id_str,
		["payload"] = payload_str,
	}
end

--- create_api_session
-- A user's session used to authenticate messages.
-- @param created_bool (boolean) True if the corresponding account was just created, false otherwise.
-- @param refresh_token_str (string) Refresh token that can be used for session token renewal.
-- @param token_str (string) Authentication credentials.
function M.create_api_session(created_bool,refresh_token_str,token_str,_)
	assert(not created_bool or type(created_bool) == "boolean", "Argument 'created_bool' must be 'nil' or of type 'boolean'")
	assert(not refresh_token_str or type(refresh_token_str) == "string", "Argument 'refresh_token_str' must be 'nil' or of type 'string'")
	assert(not token_str or type(token_str) == "string", "Argument 'token_str' must be 'nil' or of type 'string'")
	return {
		["created"] = created_bool,
		["refresh_token"] = refresh_token_str,
		["token"] = token_str,
	}
end

--- create_api_session_logout_request
-- Log out a session, invalidate a refresh token, or log out all sessions/refresh tokens for a user.
-- @param refresh_token_str (string) Refresh token to invalidate.
-- @param token_str (string) Session token to log out.
function M.create_api_session_logout_request(refresh_token_str,token_str,_)
	assert(not refresh_token_str or type(refresh_token_str) == "string", "Argument 'refresh_token_str' must be 'nil' or of type 'string'")
	assert(not token_str or type(token_str) == "string", "Argument 'token_str' must be 'nil' or of type 'string'")
	return {
		["refresh_token"] = refresh_token_str,
		["token"] = token_str,
	}
end

--- create_api_session_refresh_request
-- Authenticate against the server with a refresh token.
-- @param token_str (string) Refresh token.
-- @param vars_obj (table) Extra information that will be bundled in the session token.
function M.create_api_session_refresh_request(token_str,vars_obj,_)
	assert(not token_str or type(token_str) == "string", "Argument 'token_str' must be 'nil' or of type 'string'")
	assert(not vars_obj or type(vars_obj) == "table", "Argument 'vars_obj' must be 'nil' or of type 'table'")
	return {
		["token"] = token_str,
		["vars"] = vars_obj,
	}
end

--- create_api_storage_object
-- An object within the storage engine.
-- @param collection_str (string) The collection which stores the object.
-- @param create_time_str (string) The UNIX time (for gRPC clients) or ISO string (for REST clients) when the object was created.
-- @param key_str (string) The key of the object within the collection.
-- @param permission_read_int (number) The read access permissions for the object.
-- @param permission_write_int (number) The write access permissions for the object.
-- @param update_time_str (string) The UNIX time (for gRPC clients) or ISO string (for REST clients) when the object was last updated.
-- @param user_id_str (string) The user owner of the object.
-- @param value_str (string) The value of the object.
-- @param version_str (string) The version hash of the object.
function M.create_api_storage_object(collection_str,create_time_str,key_str,permission_read_int,permission_write_int,update_time_str,user_id_str,value_str,version_str,_)
	assert(not collection_str or type(collection_str) == "string", "Argument 'collection_str' must be 'nil' or of type 'string'")
	assert(not create_time_str or type(create_time_str) == "string", "Argument 'create_time_str' must be 'nil' or of type 'string'")
	assert(not key_str or type(key_str) == "string", "Argument 'key_str' must be 'nil' or of type 'string'")
	assert(not permission_read_int or type(permission_read_int) == "number", "Argument 'permission_read_int' must be 'nil' or of type 'number'")
	assert(not permission_write_int or type(permission_write_int) == "number", "Argument 'permission_write_int' must be 'nil' or of type 'number'")
	assert(not update_time_str or type(update_time_str) == "string", "Argument 'update_time_str' must be 'nil' or of type 'string'")
	assert(not user_id_str or type(user_id_str) == "string", "Argument 'user_id_str' must be 'nil' or of type 'string'")
	assert(not value_str or type(value_str) == "string", "Argument 'value_str' must be 'nil' or of type 'string'")
	assert(not version_str or type(version_str) == "string", "Argument 'version_str' must be 'nil' or of type 'string'")
	return {
		["collection"] = collection_str,
		["create_time"] = create_time_str,
		["key"] = key_str,
		["permission_read"] = permission_read_int,
		["permission_write"] = permission_write_int,
		["update_time"] = update_time_str,
		["user_id"] = user_id_str,
		["value"] = value_str,
		["version"] = version_str,
	}
end

--- create_api_storage_object_ack
-- A storage acknowledgement.
-- @param collection_str (string) The collection which stores the object.
-- @param create_time_str (string) The UNIX time (for gRPC clients) or ISO string (for REST clients) when the object was created.
-- @param key_str (string) The key of the object within the collection.
-- @param update_time_str (string) The UNIX time (for gRPC clients) or ISO string (for REST clients) when the object was last updated.
-- @param user_id_str (string) The owner of the object.
-- @param version_str (string) The version hash of the object.
function M.create_api_storage_object_ack(collection_str,create_time_str,key_str,update_time_str,user_id_str,version_str,_)
	assert(not collection_str or type(collection_str) == "string", "Argument 'collection_str' must be 'nil' or of type 'string'")
	assert(not create_time_str or type(create_time_str) == "string", "Argument 'create_time_str' must be 'nil' or of type 'string'")
	assert(not key_str or type(key_str) == "string", "Argument 'key_str' must be 'nil' or of type 'string'")
	assert(not update_time_str or type(update_time_str) == "string", "Argument 'update_time_str' must be 'nil' or of type 'string'")
	assert(not user_id_str or type(user_id_str) == "string", "Argument 'user_id_str' must be 'nil' or of type 'string'")
	assert(not version_str or type(version_str) == "string", "Argument 'version_str' must be 'nil' or of type 'string'")
	return {
		["collection"] = collection_str,
		["create_time"] = create_time_str,
		["key"] = key_str,
		["update_time"] = update_time_str,
		["user_id"] = user_id_str,
		["version"] = version_str,
	}
end

--- create_api_storage_object_acks
-- Batch of acknowledgements for the storage object write.
-- @param acks_arr (table) Batch of storage write acknowledgements.
function M.create_api_storage_object_acks(acks_arr,_)
	assert(not acks_arr or type(acks_arr) == "table", "Argument 'acks_arr' must be 'nil' or of type 'table'")
	return {
		["acks"] = acks_arr,
	}
end

--- create_api_storage_object_list
-- List of storage objects.
-- @param cursor_str (string) The cursor for the next page of results, if any.
-- @param objects_arr (table) The list of storage objects.
function M.create_api_storage_object_list(cursor_str,objects_arr,_)
	assert(not cursor_str or type(cursor_str) == "string", "Argument 'cursor_str' must be 'nil' or of type 'string'")
	assert(not objects_arr or type(objects_arr) == "table", "Argument 'objects_arr' must be 'nil' or of type 'table'")
	return {
		["cursor"] = cursor_str,
		["objects"] = objects_arr,
	}
end

--- create_api_storage_objects
-- Batch of storage objects.
-- @param objects_arr (table) The batch of storage objects.
function M.create_api_storage_objects(objects_arr,_)
	assert(not objects_arr or type(objects_arr) == "table", "Argument 'objects_arr' must be 'nil' or of type 'table'")
	return {
		["objects"] = objects_arr,
	}
end

--- create_api_subscription_list
-- A list of validated subscriptions stored by Nakama.
-- @param cursor_str (string) The cursor to send when retrieving the next page, if any.
-- @param prev_cursor_str (string) The cursor to send when retrieving the previous page, if any.
-- @param validated_subscriptions_arr (table) Stored validated subscriptions.
function M.create_api_subscription_list(cursor_str,prev_cursor_str,validated_subscriptions_arr,_)
	assert(not cursor_str or type(cursor_str) == "string", "Argument 'cursor_str' must be 'nil' or of type 'string'")
	assert(not prev_cursor_str or type(prev_cursor_str) == "string", "Argument 'prev_cursor_str' must be 'nil' or of type 'string'")
	assert(not validated_subscriptions_arr or type(validated_subscriptions_arr) == "table", "Argument 'validated_subscriptions_arr' must be 'nil' or of type 'table'")
	return {
		["cursor"] = cursor_str,
		["prev_cursor"] = prev_cursor_str,
		["validated_subscriptions"] = validated_subscriptions_arr,
	}
end

--- create_api_tournament
-- A tournament on the server.
-- @param authoritative_bool (boolean) Whether the leaderboard was created authoritatively or not.
-- @param can_enter_bool (boolean) True if the tournament is active and can enter. A computed value.
-- @param category_int (number) The category of the tournament. e.g. "vip" could be category 1.
-- @param create_time_str (string) The UNIX time (for gRPC clients) or ISO string (for REST clients) when the tournament was created.
-- @param description_str (string) The description of the tournament. May be blank.
-- @param duration_int (number) Duration of the tournament in seconds.
-- @param end_active_int (number) The UNIX time when the tournament stops being active until next reset. A computed value.
-- @param end_time_str (string) The UNIX time (for gRPC clients) or ISO string (for REST clients) when the tournament will be stopped.
-- @param id_str (string) The ID of the tournament.
-- @param max_num_score_int (number) The maximum score updates allowed per player for the current tournament.
-- @param max_size_int (number) The maximum number of players for the tournament.
-- @param metadata_str (string) Additional information stored as a JSON object.
-- @param next_reset_int (number) The UNIX time when the tournament is next playable. A computed value.
-- @param operator_api_operator (string) Operator.
-- @param prev_reset_int (number) The UNIX time when the tournament was last reset. A computed value.
-- @param size_int (number) The current number of players in the tournament.
-- @param sort_order_int (number) ASC (0) or DESC (1) sort mode of scores in the tournament.
-- @param start_active_int (number) The UNIX time when the tournament start being active. A computed value.
-- @param start_time_str (string) The UNIX time (for gRPC clients) or ISO string (for REST clients) when the tournament will start.
-- @param title_str (string) The title for the tournament.
function M.create_api_tournament(authoritative_bool,can_enter_bool,category_int,create_time_str,description_str,duration_int,end_active_int,end_time_str,id_str,max_num_score_int,max_size_int,metadata_str,next_reset_int,operator_api_operator,prev_reset_int,size_int,sort_order_int,start_active_int,start_time_str,title_str,_)
	assert(not authoritative_bool or type(authoritative_bool) == "boolean", "Argument 'authoritative_bool' must be 'nil' or of type 'boolean'")
	assert(not can_enter_bool or type(can_enter_bool) == "boolean", "Argument 'can_enter_bool' must be 'nil' or of type 'boolean'")
	assert(not category_int or type(category_int) == "number", "Argument 'category_int' must be 'nil' or of type 'number'")
	assert(not create_time_str or type(create_time_str) == "string", "Argument 'create_time_str' must be 'nil' or of type 'string'")
	assert(not description_str or type(description_str) == "string", "Argument 'description_str' must be 'nil' or of type 'string'")
	assert(not duration_int or type(duration_int) == "number", "Argument 'duration_int' must be 'nil' or of type 'number'")
	assert(not end_active_int or type(end_active_int) == "number", "Argument 'end_active_int' must be 'nil' or of type 'number'")
	assert(not end_time_str or type(end_time_str) == "string", "Argument 'end_time_str' must be 'nil' or of type 'string'")
	assert(not id_str or type(id_str) == "string", "Argument 'id_str' must be 'nil' or of type 'string'")
	assert(not max_num_score_int or type(max_num_score_int) == "number", "Argument 'max_num_score_int' must be 'nil' or of type 'number'")
	assert(not max_size_int or type(max_size_int) == "number", "Argument 'max_size_int' must be 'nil' or of type 'number'")
	assert(not metadata_str or type(metadata_str) == "string", "Argument 'metadata_str' must be 'nil' or of type 'string'")
	assert(not next_reset_int or type(next_reset_int) == "number", "Argument 'next_reset_int' must be 'nil' or of type 'number'")
	assert(not operator_api_operator or type(operator_api_operator) == "string", "Argument 'operator_api_operator' must be 'nil' or of type 'string'")
	assert(not prev_reset_int or type(prev_reset_int) == "number", "Argument 'prev_reset_int' must be 'nil' or of type 'number'")
	assert(not size_int or type(size_int) == "number", "Argument 'size_int' must be 'nil' or of type 'number'")
	assert(not sort_order_int or type(sort_order_int) == "number", "Argument 'sort_order_int' must be 'nil' or of type 'number'")
	assert(not start_active_int or type(start_active_int) == "number", "Argument 'start_active_int' must be 'nil' or of type 'number'")
	assert(not start_time_str or type(start_time_str) == "string", "Argument 'start_time_str' must be 'nil' or of type 'string'")
	assert(not title_str or type(title_str) == "string", "Argument 'title_str' must be 'nil' or of type 'string'")
	return {
		["authoritative"] = authoritative_bool,
		["can_enter"] = can_enter_bool,
		["category"] = category_int,
		["create_time"] = create_time_str,
		["description"] = description_str,
		["duration"] = duration_int,
		["end_active"] = end_active_int,
		["end_time"] = end_time_str,
		["id"] = id_str,
		["max_num_score"] = max_num_score_int,
		["max_size"] = max_size_int,
		["metadata"] = metadata_str,
		["next_reset"] = next_reset_int,
		["operator"] = operator_api_operator,
		["prev_reset"] = prev_reset_int,
		["size"] = size_int,
		["sort_order"] = sort_order_int,
		["start_active"] = start_active_int,
		["start_time"] = start_time_str,
		["title"] = title_str,
	}
end

--- create_api_tournament_list
-- A list of tournaments.
-- @param cursor_str (string) A pagination cursor (optional).
-- @param tournaments_arr (table) The list of tournaments returned.
function M.create_api_tournament_list(cursor_str,tournaments_arr,_)
	assert(not cursor_str or type(cursor_str) == "string", "Argument 'cursor_str' must be 'nil' or of type 'string'")
	assert(not tournaments_arr or type(tournaments_arr) == "table", "Argument 'tournaments_arr' must be 'nil' or of type 'table'")
	return {
		["cursor"] = cursor_str,
		["tournaments"] = tournaments_arr,
	}
end

--- create_api_tournament_record_list
-- A set of tournament records which may be part of a tournament records page or a batch of individual records.
-- @param next_cursor_str (string) The cursor to send when retireving the next page (optional).
-- @param owner_records_arr (table) A batched set of tournament records belonging to specified owners.
-- @param prev_cursor_str (string) The cursor to send when retrieving the previous page (optional).
-- @param rank_count_str (string) The total number of ranks available.
-- @param records_arr (table) A list of tournament records.
function M.create_api_tournament_record_list(next_cursor_str,owner_records_arr,prev_cursor_str,rank_count_str,records_arr,_)
	assert(not next_cursor_str or type(next_cursor_str) == "string", "Argument 'next_cursor_str' must be 'nil' or of type 'string'")
	assert(not owner_records_arr or type(owner_records_arr) == "table", "Argument 'owner_records_arr' must be 'nil' or of type 'table'")
	assert(not prev_cursor_str or type(prev_cursor_str) == "string", "Argument 'prev_cursor_str' must be 'nil' or of type 'string'")
	assert(not rank_count_str or type(rank_count_str) == "string", "Argument 'rank_count_str' must be 'nil' or of type 'string'")
	assert(not records_arr or type(records_arr) == "table", "Argument 'records_arr' must be 'nil' or of type 'table'")
	return {
		["next_cursor"] = next_cursor_str,
		["owner_records"] = owner_records_arr,
		["prev_cursor"] = prev_cursor_str,
		["rank_count"] = rank_count_str,
		["records"] = records_arr,
	}
end

--- create_api_update_account_request
-- Update a user's account details.
-- @param avatar_url_str (string) A URL for an avatar image.
-- @param display_name_str (string) The display name of the user.
-- @param lang_tag_str (string) The language expected to be a tag which follows the BCP-47 spec.
-- @param location_str (string) The location set by the user.
-- @param timezone_str (string) The timezone set by the user.
-- @param username_str (string) The username of the user's account.
function M.create_api_update_account_request(avatar_url_str,display_name_str,lang_tag_str,location_str,timezone_str,username_str,_)
	assert(not avatar_url_str or type(avatar_url_str) == "string", "Argument 'avatar_url_str' must be 'nil' or of type 'string'")
	assert(not display_name_str or type(display_name_str) == "string", "Argument 'display_name_str' must be 'nil' or of type 'string'")
	assert(not lang_tag_str or type(lang_tag_str) == "string", "Argument 'lang_tag_str' must be 'nil' or of type 'string'")
	assert(not location_str or type(location_str) == "string", "Argument 'location_str' must be 'nil' or of type 'string'")
	assert(not timezone_str or type(timezone_str) == "string", "Argument 'timezone_str' must be 'nil' or of type 'string'")
	assert(not username_str or type(username_str) == "string", "Argument 'username_str' must be 'nil' or of type 'string'")
	return {
		["avatar_url"] = avatar_url_str,
		["display_name"] = display_name_str,
		["lang_tag"] = lang_tag_str,
		["location"] = location_str,
		["timezone"] = timezone_str,
		["username"] = username_str,
	}
end

--- create_api_user
-- A user in the server.
-- @param apple_id_str (string) The Apple Sign In ID in the user's account.
-- @param avatar_url_str (string) A URL for an avatar image.
-- @param create_time_str (string) The UNIX time (for gRPC clients) or ISO string (for REST clients) when the user was created.
-- @param display_name_str (string) The display name of the user.
-- @param edge_count_int (number) Number of related edges to this user.
-- @param facebook_id_str (string) The Facebook id in the user's account.
-- @param facebook_instant_game_id_str (string) The Facebook Instant Game ID in the user's account.
-- @param gamecenter_id_str (string) The Apple Game Center in of the user's account.
-- @param google_id_str (string) The Google id in the user's account.
-- @param id_str (string) The id of the user's account.
-- @param lang_tag_str (string) The language expected to be a tag which follows the BCP-47 spec.
-- @param location_str (string) The location set by the user.
-- @param metadata_str (string) Additional information stored as a JSON object.
-- @param online_bool (boolean) Indicates whether the user is currently online.
-- @param steam_id_str (string) The Steam id in the user's account.
-- @param timezone_str (string) The timezone set by the user.
-- @param update_time_str (string) The UNIX time (for gRPC clients) or ISO string (for REST clients) when the user was last updated.
-- @param username_str (string) The username of the user's account.
function M.create_api_user(apple_id_str,avatar_url_str,create_time_str,display_name_str,edge_count_int,facebook_id_str,facebook_instant_game_id_str,gamecenter_id_str,google_id_str,id_str,lang_tag_str,location_str,metadata_str,online_bool,steam_id_str,timezone_str,update_time_str,username_str,_)
	assert(not apple_id_str or type(apple_id_str) == "string", "Argument 'apple_id_str' must be 'nil' or of type 'string'")
	assert(not avatar_url_str or type(avatar_url_str) == "string", "Argument 'avatar_url_str' must be 'nil' or of type 'string'")
	assert(not create_time_str or type(create_time_str) == "string", "Argument 'create_time_str' must be 'nil' or of type 'string'")
	assert(not display_name_str or type(display_name_str) == "string", "Argument 'display_name_str' must be 'nil' or of type 'string'")
	assert(not edge_count_int or type(edge_count_int) == "number", "Argument 'edge_count_int' must be 'nil' or of type 'number'")
	assert(not facebook_id_str or type(facebook_id_str) == "string", "Argument 'facebook_id_str' must be 'nil' or of type 'string'")
	assert(not facebook_instant_game_id_str or type(facebook_instant_game_id_str) == "string", "Argument 'facebook_instant_game_id_str' must be 'nil' or of type 'string'")
	assert(not gamecenter_id_str or type(gamecenter_id_str) == "string", "Argument 'gamecenter_id_str' must be 'nil' or of type 'string'")
	assert(not google_id_str or type(google_id_str) == "string", "Argument 'google_id_str' must be 'nil' or of type 'string'")
	assert(not id_str or type(id_str) == "string", "Argument 'id_str' must be 'nil' or of type 'string'")
	assert(not lang_tag_str or type(lang_tag_str) == "string", "Argument 'lang_tag_str' must be 'nil' or of type 'string'")
	assert(not location_str or type(location_str) == "string", "Argument 'location_str' must be 'nil' or of type 'string'")
	assert(not metadata_str or type(metadata_str) == "string", "Argument 'metadata_str' must be 'nil' or of type 'string'")
	assert(not online_bool or type(online_bool) == "boolean", "Argument 'online_bool' must be 'nil' or of type 'boolean'")
	assert(not steam_id_str or type(steam_id_str) == "string", "Argument 'steam_id_str' must be 'nil' or of type 'string'")
	assert(not timezone_str or type(timezone_str) == "string", "Argument 'timezone_str' must be 'nil' or of type 'string'")
	assert(not update_time_str or type(update_time_str) == "string", "Argument 'update_time_str' must be 'nil' or of type 'string'")
	assert(not username_str or type(username_str) == "string", "Argument 'username_str' must be 'nil' or of type 'string'")
	return {
		["apple_id"] = apple_id_str,
		["avatar_url"] = avatar_url_str,
		["create_time"] = create_time_str,
		["display_name"] = display_name_str,
		["edge_count"] = edge_count_int,
		["facebook_id"] = facebook_id_str,
		["facebook_instant_game_id"] = facebook_instant_game_id_str,
		["gamecenter_id"] = gamecenter_id_str,
		["google_id"] = google_id_str,
		["id"] = id_str,
		["lang_tag"] = lang_tag_str,
		["location"] = location_str,
		["metadata"] = metadata_str,
		["online"] = online_bool,
		["steam_id"] = steam_id_str,
		["timezone"] = timezone_str,
		["update_time"] = update_time_str,
		["username"] = username_str,
	}
end

--- create_api_user_group_list
-- A list of groups belonging to a user, along with the user's role in each group.
-- @param cursor_str (string) Cursor for the next page of results, if any.
-- @param user_groups_arr (table) Group-role pairs for a user.
function M.create_api_user_group_list(cursor_str,user_groups_arr,_)
	assert(not cursor_str or type(cursor_str) == "string", "Argument 'cursor_str' must be 'nil' or of type 'string'")
	assert(not user_groups_arr or type(user_groups_arr) == "table", "Argument 'user_groups_arr' must be 'nil' or of type 'table'")
	return {
		["cursor"] = cursor_str,
		["user_groups"] = user_groups_arr,
	}
end

--- create_api_users
-- A collection of zero or more users.
-- @param users_arr (table) The User objects.
function M.create_api_users(users_arr,_)
	assert(not users_arr or type(users_arr) == "table", "Argument 'users_arr' must be 'nil' or of type 'table'")
	return {
		["users"] = users_arr,
	}
end

--- create_api_validate_purchase_apple_request
-- 
-- @param persist_bool (boolean) 
-- @param receipt_str (string) Base64 encoded Apple receipt data payload.
function M.create_api_validate_purchase_apple_request(persist_bool,receipt_str,_)
	assert(not persist_bool or type(persist_bool) == "boolean", "Argument 'persist_bool' must be 'nil' or of type 'boolean'")
	assert(not receipt_str or type(receipt_str) == "string", "Argument 'receipt_str' must be 'nil' or of type 'string'")
	return {
		["persist"] = persist_bool,
		["receipt"] = receipt_str,
	}
end

--- create_api_validate_purchase_facebook_instant_request
-- 
-- @param persist_bool (boolean) 
-- @param signed_request_str (string) Base64 encoded Facebook Instant signedRequest receipt data payload.
function M.create_api_validate_purchase_facebook_instant_request(persist_bool,signed_request_str,_)
	assert(not persist_bool or type(persist_bool) == "boolean", "Argument 'persist_bool' must be 'nil' or of type 'boolean'")
	assert(not signed_request_str or type(signed_request_str) == "string", "Argument 'signed_request_str' must be 'nil' or of type 'string'")
	return {
		["persist"] = persist_bool,
		["signed_request"] = signed_request_str,
	}
end

--- create_api_validate_purchase_google_request
-- 
-- @param persist_bool (boolean) 
-- @param purchase_str (string) JSON encoded Google purchase payload.
function M.create_api_validate_purchase_google_request(persist_bool,purchase_str,_)
	assert(not persist_bool or type(persist_bool) == "boolean", "Argument 'persist_bool' must be 'nil' or of type 'boolean'")
	assert(not purchase_str or type(purchase_str) == "string", "Argument 'purchase_str' must be 'nil' or of type 'string'")
	return {
		["persist"] = persist_bool,
		["purchase"] = purchase_str,
	}
end

--- create_api_validate_purchase_huawei_request
-- 
-- @param persist_bool (boolean) 
-- @param purchase_str (string) JSON encoded Huawei InAppPurchaseData.
-- @param signature_str (string) InAppPurchaseData signature.
function M.create_api_validate_purchase_huawei_request(persist_bool,purchase_str,signature_str,_)
	assert(not persist_bool or type(persist_bool) == "boolean", "Argument 'persist_bool' must be 'nil' or of type 'boolean'")
	assert(not purchase_str or type(purchase_str) == "string", "Argument 'purchase_str' must be 'nil' or of type 'string'")
	assert(not signature_str or type(signature_str) == "string", "Argument 'signature_str' must be 'nil' or of type 'string'")
	return {
		["persist"] = persist_bool,
		["purchase"] = purchase_str,
		["signature"] = signature_str,
	}
end

--- create_api_validate_purchase_response
-- Validate IAP response.
-- @param validated_purchases_arr (table) Newly seen validated purchases.
function M.create_api_validate_purchase_response(validated_purchases_arr,_)
	assert(not validated_purchases_arr or type(validated_purchases_arr) == "table", "Argument 'validated_purchases_arr' must be 'nil' or of type 'table'")
	return {
		["validated_purchases"] = validated_purchases_arr,
	}
end

--- create_api_validate_subscription_apple_request
-- 
-- @param persist_bool (boolean) Persist the subscription.
-- @param receipt_str (string) Base64 encoded Apple receipt data payload.
function M.create_api_validate_subscription_apple_request(persist_bool,receipt_str,_)
	assert(not persist_bool or type(persist_bool) == "boolean", "Argument 'persist_bool' must be 'nil' or of type 'boolean'")
	assert(not receipt_str or type(receipt_str) == "string", "Argument 'receipt_str' must be 'nil' or of type 'string'")
	return {
		["persist"] = persist_bool,
		["receipt"] = receipt_str,
	}
end

--- create_api_validate_subscription_google_request
-- 
-- @param persist_bool (boolean) Persist the subscription.
-- @param receipt_str (string) JSON encoded Google purchase payload.
function M.create_api_validate_subscription_google_request(persist_bool,receipt_str,_)
	assert(not persist_bool or type(persist_bool) == "boolean", "Argument 'persist_bool' must be 'nil' or of type 'boolean'")
	assert(not receipt_str or type(receipt_str) == "string", "Argument 'receipt_str' must be 'nil' or of type 'string'")
	return {
		["persist"] = persist_bool,
		["receipt"] = receipt_str,
	}
end

--- create_api_validate_subscription_response
-- Validate Subscription response.
-- @param validated_subscription_api_validated_subscription (table) 
function M.create_api_validate_subscription_response(validated_subscription_api_validated_subscription,_)
	assert(not validated_subscription_api_validated_subscription or type(validated_subscription_api_validated_subscription) == "table", "Argument 'validated_subscription_api_validated_subscription' must be 'nil' or of type 'table'")
	return {
		["validated_subscription"] = validated_subscription_api_validated_subscription,
	}
end

--- create_api_validated_purchase
-- Validated Purchase stored by Nakama.
-- @param create_time_str (string) Timestamp when the receipt validation was stored in DB.
-- @param environment_api_store_environment (string) Whether the purchase was done in production or sandbox environment.
-- @param product_id_str (string) Purchase Product ID.
-- @param provider_response_str (string) Raw provider validation response.
-- @param purchase_time_str (string) Timestamp when the purchase was done.
-- @param refund_time_str (string) 
-- @param seen_before_bool (boolean) Whether the purchase had already been validated by Nakama before.
-- @param store_api_store_provider (string) 
-- @param transaction_id_str (string) Purchase Transaction ID.
-- @param update_time_str (string) Timestamp when the receipt validation was updated in DB.
-- @param user_id_str (string) Purchase User ID.
function M.create_api_validated_purchase(create_time_str,environment_api_store_environment,product_id_str,provider_response_str,purchase_time_str,refund_time_str,seen_before_bool,store_api_store_provider,transaction_id_str,update_time_str,user_id_str,_)
	assert(not create_time_str or type(create_time_str) == "string", "Argument 'create_time_str' must be 'nil' or of type 'string'")
	assert(not environment_api_store_environment or type(environment_api_store_environment) == "string", "Argument 'environment_api_store_environment' must be 'nil' or of type 'string'")
	assert(not product_id_str or type(product_id_str) == "string", "Argument 'product_id_str' must be 'nil' or of type 'string'")
	assert(not provider_response_str or type(provider_response_str) == "string", "Argument 'provider_response_str' must be 'nil' or of type 'string'")
	assert(not purchase_time_str or type(purchase_time_str) == "string", "Argument 'purchase_time_str' must be 'nil' or of type 'string'")
	assert(not refund_time_str or type(refund_time_str) == "string", "Argument 'refund_time_str' must be 'nil' or of type 'string'")
	assert(not seen_before_bool or type(seen_before_bool) == "boolean", "Argument 'seen_before_bool' must be 'nil' or of type 'boolean'")
	assert(not store_api_store_provider or type(store_api_store_provider) == "string", "Argument 'store_api_store_provider' must be 'nil' or of type 'string'")
	assert(not transaction_id_str or type(transaction_id_str) == "string", "Argument 'transaction_id_str' must be 'nil' or of type 'string'")
	assert(not update_time_str or type(update_time_str) == "string", "Argument 'update_time_str' must be 'nil' or of type 'string'")
	assert(not user_id_str or type(user_id_str) == "string", "Argument 'user_id_str' must be 'nil' or of type 'string'")
	return {
		["create_time"] = create_time_str,
		["environment"] = environment_api_store_environment,
		["product_id"] = product_id_str,
		["provider_response"] = provider_response_str,
		["purchase_time"] = purchase_time_str,
		["refund_time"] = refund_time_str,
		["seen_before"] = seen_before_bool,
		["store"] = store_api_store_provider,
		["transaction_id"] = transaction_id_str,
		["update_time"] = update_time_str,
		["user_id"] = user_id_str,
	}
end

--- create_api_validated_subscription
-- 
-- @param active_bool (boolean) Whether the subscription is currently active or not.
-- @param create_time_str (string) UNIX Timestamp when the receipt validation was stored in DB.
-- @param environment_api_store_environment (string) Whether the purchase was done in production or sandbox environment.
-- @param expiry_time_str (string) Subscription expiration time. The subscription can still be auto-renewed to extend the expiration time further.
-- @param original_transaction_id_str (string) Purchase Original transaction ID (we only keep track of the original subscription, not subsequent renewals).
-- @param product_id_str (string) Purchase Product ID.
-- @param provider_notification_str (string) Raw provider notification body.
-- @param provider_response_str (string) Raw provider validation response body.
-- @param purchase_time_str (string) UNIX Timestamp when the purchase was done.
-- @param refund_time_str (string) Subscription refund time. If this time is set, the subscription was refunded.
-- @param store_api_store_provider (string) 
-- @param update_time_str (string) UNIX Timestamp when the receipt validation was updated in DB.
-- @param user_id_str (string) Subscription User ID.
function M.create_api_validated_subscription(active_bool,create_time_str,environment_api_store_environment,expiry_time_str,original_transaction_id_str,product_id_str,provider_notification_str,provider_response_str,purchase_time_str,refund_time_str,store_api_store_provider,update_time_str,user_id_str,_)
	assert(not active_bool or type(active_bool) == "boolean", "Argument 'active_bool' must be 'nil' or of type 'boolean'")
	assert(not create_time_str or type(create_time_str) == "string", "Argument 'create_time_str' must be 'nil' or of type 'string'")
	assert(not environment_api_store_environment or type(environment_api_store_environment) == "string", "Argument 'environment_api_store_environment' must be 'nil' or of type 'string'")
	assert(not expiry_time_str or type(expiry_time_str) == "string", "Argument 'expiry_time_str' must be 'nil' or of type 'string'")
	assert(not original_transaction_id_str or type(original_transaction_id_str) == "string", "Argument 'original_transaction_id_str' must be 'nil' or of type 'string'")
	assert(not product_id_str or type(product_id_str) == "string", "Argument 'product_id_str' must be 'nil' or of type 'string'")
	assert(not provider_notification_str or type(provider_notification_str) == "string", "Argument 'provider_notification_str' must be 'nil' or of type 'string'")
	assert(not provider_response_str or type(provider_response_str) == "string", "Argument 'provider_response_str' must be 'nil' or of type 'string'")
	assert(not purchase_time_str or type(purchase_time_str) == "string", "Argument 'purchase_time_str' must be 'nil' or of type 'string'")
	assert(not refund_time_str or type(refund_time_str) == "string", "Argument 'refund_time_str' must be 'nil' or of type 'string'")
	assert(not store_api_store_provider or type(store_api_store_provider) == "string", "Argument 'store_api_store_provider' must be 'nil' or of type 'string'")
	assert(not update_time_str or type(update_time_str) == "string", "Argument 'update_time_str' must be 'nil' or of type 'string'")
	assert(not user_id_str or type(user_id_str) == "string", "Argument 'user_id_str' must be 'nil' or of type 'string'")
	return {
		["active"] = active_bool,
		["create_time"] = create_time_str,
		["environment"] = environment_api_store_environment,
		["expiry_time"] = expiry_time_str,
		["original_transaction_id"] = original_transaction_id_str,
		["product_id"] = product_id_str,
		["provider_notification"] = provider_notification_str,
		["provider_response"] = provider_response_str,
		["purchase_time"] = purchase_time_str,
		["refund_time"] = refund_time_str,
		["store"] = store_api_store_provider,
		["update_time"] = update_time_str,
		["user_id"] = user_id_str,
	}
end

--- create_api_write_storage_object
-- The object to store.
-- @param collection_str (string) The collection to store the object.
-- @param key_str (string) The key for the object within the collection.
-- @param permission_read_int (number) The read access permissions for the object.
-- @param permission_write_int (number) The write access permissions for the object.
-- @param value_str (string) The value of the object.
-- @param version_str (string) The version hash of the object to check. Possible values are: ["", "*", "#hash#"].
--
--if-match and if-none-match
function M.create_api_write_storage_object(collection_str,key_str,permission_read_int,permission_write_int,value_str,version_str,_)
	assert(not collection_str or type(collection_str) == "string", "Argument 'collection_str' must be 'nil' or of type 'string'")
	assert(not key_str or type(key_str) == "string", "Argument 'key_str' must be 'nil' or of type 'string'")
	assert(not permission_read_int or type(permission_read_int) == "number", "Argument 'permission_read_int' must be 'nil' or of type 'number'")
	assert(not permission_write_int or type(permission_write_int) == "number", "Argument 'permission_write_int' must be 'nil' or of type 'number'")
	assert(not value_str or type(value_str) == "string", "Argument 'value_str' must be 'nil' or of type 'string'")
	assert(not version_str or type(version_str) == "string", "Argument 'version_str' must be 'nil' or of type 'string'")
	return {
		["collection"] = collection_str,
		["key"] = key_str,
		["permission_read"] = permission_read_int,
		["permission_write"] = permission_write_int,
		["value"] = value_str,
		["version"] = version_str,
	}
end

--- create_api_write_storage_objects_request
-- Write objects to the storage engine.
-- @param objects_arr (table) The objects to store on the server.
function M.create_api_write_storage_objects_request(objects_arr,_)
	assert(not objects_arr or type(objects_arr) == "table", "Argument 'objects_arr' must be 'nil' or of type 'table'")
	return {
		["objects"] = objects_arr,
	}
end

--- create_protobuf_any
-- 
-- @param type_str (string) 
function M.create_protobuf_any(type_str,_)
	assert(not type_str or type(type_str) == "string", "Argument 'type_str' must be 'nil' or of type 'string'")
	return {
		["@type"] = type_str,
	}
end

--- create_rpc_status
-- 
-- @param code_int (number) 
-- @param details_arr (table) 
-- @param message_str (string) 
function M.create_rpc_status(code_int,details_arr,message_str,_)
	assert(not code_int or type(code_int) == "number", "Argument 'code_int' must be 'nil' or of type 'number'")
	assert(not details_arr or type(details_arr) == "table", "Argument 'details_arr' must be 'nil' or of type 'table'")
	assert(not message_str or type(message_str) == "string", "Argument 'message_str' must be 'nil' or of type 'string'")
	return {
		["code"] = code_int,
		["details"] = details_arr,
		["message"] = message_str,
	}
end

--- healthcheck
-- A healthcheck which load balancers can use to check the service.
-- @param client Client.
-- @param callback (function) Optional callback function
-- A coroutine is used and the result is returned if no callback function is provided.
-- @param retry_policy (function) Optional retry policy used specifically for this call or nil
-- @param cancellation_token (table) Optional cancellation token for this call
-- @return The result.
function M.healthcheck(client, callback, retry_policy, cancellation_token)
	assert(client, "You must provide a client")

	local url_path = "/healthcheck"

	local query_params = {}

	local post_data = nil

	return http(client, callback, url_path, query_params, "GET", post_data, retry_policy, cancellation_token, function(result)
		return result
	end)
end

--- delete_account
-- Delete the current user's account.
-- @param client Client.
-- @param callback (function) Optional callback function
-- A coroutine is used and the result is returned if no callback function is provided.
-- @param retry_policy (function) Optional retry policy used specifically for this call or nil
-- @param cancellation_token (table) Optional cancellation token for this call
-- @return The result.
function M.delete_account(client, callback, retry_policy, cancellation_token)
	assert(client, "You must provide a client")

	local url_path = "/v2/account"

	local query_params = {}

	local post_data = nil

	return http(client, callback, url_path, query_params, "DELETE", post_data, retry_policy, cancellation_token, function(result)
		return result
	end)
end

--- get_account
-- Fetch the current user's account.
-- @param client Client.
-- @param callback (function) Optional callback function
-- A coroutine is used and the result is returned if no callback function is provided.
-- @param retry_policy (function) Optional retry policy used specifically for this call or nil
-- @param cancellation_token (table) Optional cancellation token for this call
-- @return The result.
function M.get_account(client, callback, retry_policy, cancellation_token)
	assert(client, "You must provide a client")

	local url_path = "/v2/account"

	local query_params = {}

	local post_data = nil

	return http(client, callback, url_path, query_params, "GET", post_data, retry_policy, cancellation_token, function(result)
		if not result.error and api_account then
			result = api_account.create(result)
		end
		return result
	end)
end

--- update_account
-- Update fields in the current user's account.
-- @param client Client.
-- @param avatarUrl (string) A URL for an avatar image.
-- @param displayName (string) The display name of the user.
-- @param langTag (string) The language expected to be a tag which follows the BCP-47 spec.
-- @param location (string) The location set by the user.
-- @param timezone (string) The timezone set by the user.
-- @param username (string) The username of the user's account.

-- @param callback (function) Optional callback function
-- A coroutine is used and the result is returned if no callback function is provided.
-- @param retry_policy (function) Optional retry policy used specifically for this call or nil
-- @param cancellation_token (table) Optional cancellation token for this call
-- @return The result.
function M.update_account(client, avatarUrl, displayName, langTag, location, timezone, username, callback, retry_policy, cancellation_token)
	assert(client, "You must provide a client")
	assert(not avatarUrl or type(avatarUrl) == "string", "Argument 'avatarUrl' must be 'nil' or of type 'string'")
	assert(not displayName or type(displayName) == "string", "Argument 'displayName' must be 'nil' or of type 'string'")
	assert(not langTag or type(langTag) == "string", "Argument 'langTag' must be 'nil' or of type 'string'")
	assert(not location or type(location) == "string", "Argument 'location' must be 'nil' or of type 'string'")
	assert(not timezone or type(timezone) == "string", "Argument 'timezone' must be 'nil' or of type 'string'")
	assert(not username or type(username) == "string", "Argument 'username' must be 'nil' or of type 'string'")


	local url_path = "/v2/account"

	local query_params = {}

	local post_data = nil
	post_data = json.encode({
	avatarUrl = avatarUrl,
	displayName = displayName,
	langTag = langTag,
	location = location,
	timezone = timezone,
	username = username,
	})

	return http(client, callback, url_path, query_params, "PUT", post_data, retry_policy, cancellation_token, function(result)
		return result
	end)
end

--- authenticate_apple
-- Authenticate a user with an Apple ID against the server.
-- @param client Client.
-- @param token (string) The ID token received from Apple to validate.
-- @param vars (object) Extra information that will be bundled in the session token.

-- @param create_bool () Register the account if the user does not already exist.
-- @param username_str () Set the username on the account at register. Must be unique.
-- @param callback (function) Optional callback function
-- A coroutine is used and the result is returned if no callback function is provided.
-- @param retry_policy (function) Optional retry policy used specifically for this call or nil
-- @param cancellation_token (table) Optional cancellation token for this call
-- @return The result.
function M.authenticate_apple(client, token, vars, create_bool, username_str, callback, retry_policy, cancellation_token)
	assert(client, "You must provide a client")
	assert(not token or type(token) == "string", "Argument 'token' must be 'nil' or of type 'string'")
	assert(not vars or type(vars) == "table", "Argument 'vars' must be 'nil' or of type 'table'")

	-- unset the token so username+password credentials will be used
	client.config.bearer_token = nil

	local url_path = "/v2/account/authenticate/apple"

	local query_params = {}
	query_params["create"] = create_bool
	query_params["username"] = username_str

	local post_data = nil
	post_data = json.encode({
	token = token,
	vars = vars,
	})

	return http(client, callback, url_path, query_params, "POST", post_data, retry_policy, cancellation_token, function(result)
		if not result.error and api_session then
			result = api_session.create(result)
		end
		return result
	end)
end

--- authenticate_custom
-- Authenticate a user with a custom id against the server.
-- @param client Client.
-- @param id (string) A custom identifier.
-- @param vars (object) Extra information that will be bundled in the session token.

-- @param create_bool () Register the account if the user does not already exist.
-- @param username_str () Set the username on the account at register. Must be unique.
-- @param callback (function) Optional callback function
-- A coroutine is used and the result is returned if no callback function is provided.
-- @param retry_policy (function) Optional retry policy used specifically for this call or nil
-- @param cancellation_token (table) Optional cancellation token for this call
-- @return The result.
function M.authenticate_custom(client, id, vars, create_bool, username_str, callback, retry_policy, cancellation_token)
	assert(client, "You must provide a client")
	assert(not id or type(id) == "string", "Argument 'id' must be 'nil' or of type 'string'")
	assert(not vars or type(vars) == "table", "Argument 'vars' must be 'nil' or of type 'table'")

	-- unset the token so username+password credentials will be used
	client.config.bearer_token = nil

	local url_path = "/v2/account/authenticate/custom"

	local query_params = {}
	query_params["create"] = create_bool
	query_params["username"] = username_str

	local post_data = nil
	post_data = json.encode({
	id = id,
	vars = vars,
	})

	return http(client, callback, url_path, query_params, "POST", post_data, retry_policy, cancellation_token, function(result)
		if not result.error and api_session then
			result = api_session.create(result)
		end
		return result
	end)
end

--- authenticate_device
-- Authenticate a user with a device id against the server.
-- @param client Client.
-- @param id (string) A device identifier. Should be obtained by a platform-specific device API.
-- @param vars (object) Extra information that will be bundled in the session token.

-- @param create_bool () Register the account if the user does not already exist.
-- @param username_str () Set the username on the account at register. Must be unique.
-- @param callback (function) Optional callback function
-- A coroutine is used and the result is returned if no callback function is provided.
-- @param retry_policy (function) Optional retry policy used specifically for this call or nil
-- @param cancellation_token (table) Optional cancellation token for this call
-- @return The result.
function M.authenticate_device(client, id, vars, create_bool, username_str, callback, retry_policy, cancellation_token)
	assert(client, "You must provide a client")
	assert(not id or type(id) == "string", "Argument 'id' must be 'nil' or of type 'string'")
	assert(not vars or type(vars) == "table", "Argument 'vars' must be 'nil' or of type 'table'")

	-- unset the token so username+password credentials will be used
	client.config.bearer_token = nil

	local url_path = "/v2/account/authenticate/device"

	local query_params = {}
	query_params["create"] = create_bool
	query_params["username"] = username_str

	local post_data = nil
	post_data = json.encode({
	id = id,
	vars = vars,
	})

	return http(client, callback, url_path, query_params, "POST", post_data, retry_policy, cancellation_token, function(result)
		if not result.error and api_session then
			result = api_session.create(result)
		end
		return result
	end)
end

--- authenticate_email
-- Authenticate a user with an email+password against the server.
-- @param client Client.
-- @param email (string) A valid RFC-5322 email address.
-- @param password (string) A password for the user account.
--
--Ignored with unlink operations.
-- @param vars (object) Extra information that will be bundled in the session token.

-- @param create_bool () Register the account if the user does not already exist.
-- @param username_str () Set the username on the account at register. Must be unique.
-- @param callback (function) Optional callback function
-- A coroutine is used and the result is returned if no callback function is provided.
-- @param retry_policy (function) Optional retry policy used specifically for this call or nil
-- @param cancellation_token (table) Optional cancellation token for this call
-- @return The result.
function M.authenticate_email(client, email, password, vars, create_bool, username_str, callback, retry_policy, cancellation_token)
	assert(client, "You must provide a client")
	assert(not email or type(email) == "string", "Argument 'email' must be 'nil' or of type 'string'")
	assert(not password or type(password) == "string", "Argument 'password' must be 'nil' or of type 'string'")
	assert(not vars or type(vars) == "table", "Argument 'vars' must be 'nil' or of type 'table'")

	-- unset the token so username+password credentials will be used
	client.config.bearer_token = nil

	local url_path = "/v2/account/authenticate/email"

	local query_params = {}
	query_params["create"] = create_bool
	query_params["username"] = username_str

	local post_data = nil
	post_data = json.encode({
	email = email,
	password = password,
	vars = vars,
	})

	return http(client, callback, url_path, query_params, "POST", post_data, retry_policy, cancellation_token, function(result)
		if not result.error and api_session then
			result = api_session.create(result)
		end
		return result
	end)
end

--- authenticate_facebook
-- Authenticate a user with a Facebook OAuth token against the server.
-- @param client Client.
-- @param token (string) The OAuth token received from Facebook to access their profile API.
-- @param vars (object) Extra information that will be bundled in the session token.

-- @param create_bool () Register the account if the user does not already exist.
-- @param username_str () Set the username on the account at register. Must be unique.
-- @param sync_bool () Import Facebook friends for the user.
-- @param callback (function) Optional callback function
-- A coroutine is used and the result is returned if no callback function is provided.
-- @param retry_policy (function) Optional retry policy used specifically for this call or nil
-- @param cancellation_token (table) Optional cancellation token for this call
-- @return The result.
function M.authenticate_facebook(client, token, vars, create_bool, username_str, sync_bool, callback, retry_policy, cancellation_token)
	assert(client, "You must provide a client")
	assert(not token or type(token) == "string", "Argument 'token' must be 'nil' or of type 'string'")
	assert(not vars or type(vars) == "table", "Argument 'vars' must be 'nil' or of type 'table'")

	-- unset the token so username+password credentials will be used
	client.config.bearer_token = nil

	local url_path = "/v2/account/authenticate/facebook"

	local query_params = {}
	query_params["create"] = create_bool
	query_params["username"] = username_str
	query_params["sync"] = sync_bool

	local post_data = nil
	post_data = json.encode({
	token = token,
	vars = vars,
	})

	return http(client, callback, url_path, query_params, "POST", post_data, retry_policy, cancellation_token, function(result)
		if not result.error and api_session then
			result = api_session.create(result)
		end
		return result
	end)
end

--- authenticate_facebook_instant_game
-- Authenticate a user with a Facebook Instant Game token against the server.
-- @param client Client.
-- @param signedPlayerInfo (string) 
-- @param vars (object) Extra information that will be bundled in the session token.

-- @param create_bool () Register the account if the user does not already exist.
-- @param username_str () Set the username on the account at register. Must be unique.
-- @param callback (function) Optional callback function
-- A coroutine is used and the result is returned if no callback function is provided.
-- @param retry_policy (function) Optional retry policy used specifically for this call or nil
-- @param cancellation_token (table) Optional cancellation token for this call
-- @return The result.
function M.authenticate_facebook_instant_game(client, signedPlayerInfo, vars, create_bool, username_str, callback, retry_policy, cancellation_token)
	assert(client, "You must provide a client")
	assert(not signedPlayerInfo or type(signedPlayerInfo) == "string", "Argument 'signedPlayerInfo' must be 'nil' or of type 'string'")
	assert(not vars or type(vars) == "table", "Argument 'vars' must be 'nil' or of type 'table'")

	-- unset the token so username+password credentials will be used
	client.config.bearer_token = nil

	local url_path = "/v2/account/authenticate/facebookinstantgame"

	local query_params = {}
	query_params["create"] = create_bool
	query_params["username"] = username_str

	local post_data = nil
	post_data = json.encode({
	signedPlayerInfo = signedPlayerInfo,
	vars = vars,
	})

	return http(client, callback, url_path, query_params, "POST", post_data, retry_policy, cancellation_token, function(result)
		if not result.error and api_session then
			result = api_session.create(result)
		end
		return result
	end)
end

--- authenticate_game_center
-- Authenticate a user with Apple's GameCenter against the server.
-- @param client Client.
-- @param bundleId (string) Bundle ID (generated by GameCenter).
-- @param playerId (string) Player ID (generated by GameCenter).
-- @param publicKeyUrl (string) The URL for the public encryption key.
-- @param salt (string) A random "NSString" used to compute the hash and keep it randomized.
-- @param signature (string) The verification signature data generated.
-- @param timestampSeconds (string) Time since UNIX epoch when the signature was created.
-- @param vars (object) Extra information that will be bundled in the session token.

-- @param create_bool () Register the account if the user does not already exist.
-- @param username_str () Set the username on the account at register. Must be unique.
-- @param callback (function) Optional callback function
-- A coroutine is used and the result is returned if no callback function is provided.
-- @param retry_policy (function) Optional retry policy used specifically for this call or nil
-- @param cancellation_token (table) Optional cancellation token for this call
-- @return The result.
function M.authenticate_game_center(client, bundleId, playerId, publicKeyUrl, salt, signature, timestampSeconds, vars, create_bool, username_str, callback, retry_policy, cancellation_token)
	assert(client, "You must provide a client")
	assert(not bundleId or type(bundleId) == "string", "Argument 'bundleId' must be 'nil' or of type 'string'")
	assert(not playerId or type(playerId) == "string", "Argument 'playerId' must be 'nil' or of type 'string'")
	assert(not publicKeyUrl or type(publicKeyUrl) == "string", "Argument 'publicKeyUrl' must be 'nil' or of type 'string'")
	assert(not salt or type(salt) == "string", "Argument 'salt' must be 'nil' or of type 'string'")
	assert(not signature or type(signature) == "string", "Argument 'signature' must be 'nil' or of type 'string'")
	assert(not timestampSeconds or type(timestampSeconds) == "string", "Argument 'timestampSeconds' must be 'nil' or of type 'string'")
	assert(not vars or type(vars) == "table", "Argument 'vars' must be 'nil' or of type 'table'")

	-- unset the token so username+password credentials will be used
	client.config.bearer_token = nil

	local url_path = "/v2/account/authenticate/gamecenter"

	local query_params = {}
	query_params["create"] = create_bool
	query_params["username"] = username_str

	local post_data = nil
	post_data = json.encode({
	bundleId = bundleId,
	playerId = playerId,
	publicKeyUrl = publicKeyUrl,
	salt = salt,
	signature = signature,
	timestampSeconds = timestampSeconds,
	vars = vars,
	})

	return http(client, callback, url_path, query_params, "POST", post_data, retry_policy, cancellation_token, function(result)
		if not result.error and api_session then
			result = api_session.create(result)
		end
		return result
	end)
end

--- authenticate_google
-- Authenticate a user with Google against the server.
-- @param client Client.
-- @param token (string) The OAuth token received from Google to access their profile API.
-- @param vars (object) Extra information that will be bundled in the session token.

-- @param create_bool () Register the account if the user does not already exist.
-- @param username_str () Set the username on the account at register. Must be unique.
-- @param callback (function) Optional callback function
-- A coroutine is used and the result is returned if no callback function is provided.
-- @param retry_policy (function) Optional retry policy used specifically for this call or nil
-- @param cancellation_token (table) Optional cancellation token for this call
-- @return The result.
function M.authenticate_google(client, token, vars, create_bool, username_str, callback, retry_policy, cancellation_token)
	assert(client, "You must provide a client")
	assert(not token or type(token) == "string", "Argument 'token' must be 'nil' or of type 'string'")
	assert(not vars or type(vars) == "table", "Argument 'vars' must be 'nil' or of type 'table'")

	-- unset the token so username+password credentials will be used
	client.config.bearer_token = nil

	local url_path = "/v2/account/authenticate/google"

	local query_params = {}
	query_params["create"] = create_bool
	query_params["username"] = username_str

	local post_data = nil
	post_data = json.encode({
	token = token,
	vars = vars,
	})

	return http(client, callback, url_path, query_params, "POST", post_data, retry_policy, cancellation_token, function(result)
		if not result.error and api_session then
			result = api_session.create(result)
		end
		return result
	end)
end

--- authenticate_steam
-- Authenticate a user with Steam against the server.
-- @param client Client.
-- @param token (string) The account token received from Steam to access their profile API.
-- @param vars (object) Extra information that will be bundled in the session token.

-- @param create_bool () Register the account if the user does not already exist.
-- @param username_str () Set the username on the account at register. Must be unique.
-- @param sync_bool () Import Steam friends for the user.
-- @param callback (function) Optional callback function
-- A coroutine is used and the result is returned if no callback function is provided.
-- @param retry_policy (function) Optional retry policy used specifically for this call or nil
-- @param cancellation_token (table) Optional cancellation token for this call
-- @return The result.
function M.authenticate_steam(client, token, vars, create_bool, username_str, sync_bool, callback, retry_policy, cancellation_token)
	assert(client, "You must provide a client")
	assert(not token or type(token) == "string", "Argument 'token' must be 'nil' or of type 'string'")
	assert(not vars or type(vars) == "table", "Argument 'vars' must be 'nil' or of type 'table'")

	-- unset the token so username+password credentials will be used
	client.config.bearer_token = nil

	local url_path = "/v2/account/authenticate/steam"

	local query_params = {}
	query_params["create"] = create_bool
	query_params["username"] = username_str
	query_params["sync"] = sync_bool

	local post_data = nil
	post_data = json.encode({
	token = token,
	vars = vars,
	})

	return http(client, callback, url_path, query_params, "POST", post_data, retry_policy, cancellation_token, function(result)
		if not result.error and api_session then
			result = api_session.create(result)
		end
		return result
	end)
end

--- link_apple
-- Add an Apple ID to the social profiles on the current user's account.
-- @param client Client.
-- @param token (string) The ID token received from Apple to validate.
-- @param vars (object) Extra information that will be bundled in the session token.

-- @param callback (function) Optional callback function
-- A coroutine is used and the result is returned if no callback function is provided.
-- @param retry_policy (function) Optional retry policy used specifically for this call or nil
-- @param cancellation_token (table) Optional cancellation token for this call
-- @return The result.
function M.link_apple(client, token, vars, callback, retry_policy, cancellation_token)
	assert(client, "You must provide a client")
	assert(not token or type(token) == "string", "Argument 'token' must be 'nil' or of type 'string'")
	assert(not vars or type(vars) == "table", "Argument 'vars' must be 'nil' or of type 'table'")


	local url_path = "/v2/account/link/apple"

	local query_params = {}

	local post_data = nil
	post_data = json.encode({
	token = token,
	vars = vars,
	})

	return http(client, callback, url_path, query_params, "POST", post_data, retry_policy, cancellation_token, function(result)
		return result
	end)
end

--- link_custom
-- Add a custom ID to the social profiles on the current user's account.
-- @param client Client.
-- @param id (string) A custom identifier.
-- @param vars (object) Extra information that will be bundled in the session token.

-- @param callback (function) Optional callback function
-- A coroutine is used and the result is returned if no callback function is provided.
-- @param retry_policy (function) Optional retry policy used specifically for this call or nil
-- @param cancellation_token (table) Optional cancellation token for this call
-- @return The result.
function M.link_custom(client, id, vars, callback, retry_policy, cancellation_token)
	assert(client, "You must provide a client")
	assert(not id or type(id) == "string", "Argument 'id' must be 'nil' or of type 'string'")
	assert(not vars or type(vars) == "table", "Argument 'vars' must be 'nil' or of type 'table'")


	local url_path = "/v2/account/link/custom"

	local query_params = {}

	local post_data = nil
	post_data = json.encode({
	id = id,
	vars = vars,
	})

	return http(client, callback, url_path, query_params, "POST", post_data, retry_policy, cancellation_token, function(result)
		return result
	end)
end

--- link_device
-- Add a device ID to the social profiles on the current user's account.
-- @param client Client.
-- @param id (string) A device identifier. Should be obtained by a platform-specific device API.
-- @param vars (object) Extra information that will be bundled in the session token.

-- @param callback (function) Optional callback function
-- A coroutine is used and the result is returned if no callback function is provided.
-- @param retry_policy (function) Optional retry policy used specifically for this call or nil
-- @param cancellation_token (table) Optional cancellation token for this call
-- @return The result.
function M.link_device(client, id, vars, callback, retry_policy, cancellation_token)
	assert(client, "You must provide a client")
	assert(not id or type(id) == "string", "Argument 'id' must be 'nil' or of type 'string'")
	assert(not vars or type(vars) == "table", "Argument 'vars' must be 'nil' or of type 'table'")


	local url_path = "/v2/account/link/device"

	local query_params = {}

	local post_data = nil
	post_data = json.encode({
	id = id,
	vars = vars,
	})

	return http(client, callback, url_path, query_params, "POST", post_data, retry_policy, cancellation_token, function(result)
		return result
	end)
end

--- link_email
-- Add an email+password to the social profiles on the current user's account.
-- @param client Client.
-- @param email (string) A valid RFC-5322 email address.
-- @param password (string) A password for the user account.
--
--Ignored with unlink operations.
-- @param vars (object) Extra information that will be bundled in the session token.

-- @param callback (function) Optional callback function
-- A coroutine is used and the result is returned if no callback function is provided.
-- @param retry_policy (function) Optional retry policy used specifically for this call or nil
-- @param cancellation_token (table) Optional cancellation token for this call
-- @return The result.
function M.link_email(client, email, password, vars, callback, retry_policy, cancellation_token)
	assert(client, "You must provide a client")
	assert(not email or type(email) == "string", "Argument 'email' must be 'nil' or of type 'string'")
	assert(not password or type(password) == "string", "Argument 'password' must be 'nil' or of type 'string'")
	assert(not vars or type(vars) == "table", "Argument 'vars' must be 'nil' or of type 'table'")


	local url_path = "/v2/account/link/email"

	local query_params = {}

	local post_data = nil
	post_data = json.encode({
	email = email,
	password = password,
	vars = vars,
	})

	return http(client, callback, url_path, query_params, "POST", post_data, retry_policy, cancellation_token, function(result)
		return result
	end)
end

--- link_facebook
-- Add Facebook to the social profiles on the current user's account.
-- @param client Client.
-- @param token (string) The OAuth token received from Facebook to access their profile API.
-- @param vars (object) Extra information that will be bundled in the session token.

-- @param sync_bool () Import Facebook friends for the user.
-- @param callback (function) Optional callback function
-- A coroutine is used and the result is returned if no callback function is provided.
-- @param retry_policy (function) Optional retry policy used specifically for this call or nil
-- @param cancellation_token (table) Optional cancellation token for this call
-- @return The result.
function M.link_facebook(client, token, vars, sync_bool, callback, retry_policy, cancellation_token)
	assert(client, "You must provide a client")
	assert(not token or type(token) == "string", "Argument 'token' must be 'nil' or of type 'string'")
	assert(not vars or type(vars) == "table", "Argument 'vars' must be 'nil' or of type 'table'")


	local url_path = "/v2/account/link/facebook"

	local query_params = {}
	query_params["sync"] = sync_bool

	local post_data = nil
	post_data = json.encode({
	token = token,
	vars = vars,
	})

	return http(client, callback, url_path, query_params, "POST", post_data, retry_policy, cancellation_token, function(result)
		return result
	end)
end

--- link_facebook_instant_game
-- Add Facebook Instant Game to the social profiles on the current user's account.
-- @param client Client.
-- @param signedPlayerInfo (string) 
-- @param vars (object) Extra information that will be bundled in the session token.

-- @param callback (function) Optional callback function
-- A coroutine is used and the result is returned if no callback function is provided.
-- @param retry_policy (function) Optional retry policy used specifically for this call or nil
-- @param cancellation_token (table) Optional cancellation token for this call
-- @return The result.
function M.link_facebook_instant_game(client, signedPlayerInfo, vars, callback, retry_policy, cancellation_token)
	assert(client, "You must provide a client")
	assert(not signedPlayerInfo or type(signedPlayerInfo) == "string", "Argument 'signedPlayerInfo' must be 'nil' or of type 'string'")
	assert(not vars or type(vars) == "table", "Argument 'vars' must be 'nil' or of type 'table'")


	local url_path = "/v2/account/link/facebookinstantgame"

	local query_params = {}

	local post_data = nil
	post_data = json.encode({
	signedPlayerInfo = signedPlayerInfo,
	vars = vars,
	})

	return http(client, callback, url_path, query_params, "POST", post_data, retry_policy, cancellation_token, function(result)
		return result
	end)
end

--- link_game_center
-- Add Apple's GameCenter to the social profiles on the current user's account.
-- @param client Client.
-- @param bundleId (string) Bundle ID (generated by GameCenter).
-- @param playerId (string) Player ID (generated by GameCenter).
-- @param publicKeyUrl (string) The URL for the public encryption key.
-- @param salt (string) A random "NSString" used to compute the hash and keep it randomized.
-- @param signature (string) The verification signature data generated.
-- @param timestampSeconds (string) Time since UNIX epoch when the signature was created.
-- @param vars (object) Extra information that will be bundled in the session token.

-- @param callback (function) Optional callback function
-- A coroutine is used and the result is returned if no callback function is provided.
-- @param retry_policy (function) Optional retry policy used specifically for this call or nil
-- @param cancellation_token (table) Optional cancellation token for this call
-- @return The result.
function M.link_game_center(client, bundleId, playerId, publicKeyUrl, salt, signature, timestampSeconds, vars, callback, retry_policy, cancellation_token)
	assert(client, "You must provide a client")
	assert(not bundleId or type(bundleId) == "string", "Argument 'bundleId' must be 'nil' or of type 'string'")
	assert(not playerId or type(playerId) == "string", "Argument 'playerId' must be 'nil' or of type 'string'")
	assert(not publicKeyUrl or type(publicKeyUrl) == "string", "Argument 'publicKeyUrl' must be 'nil' or of type 'string'")
	assert(not salt or type(salt) == "string", "Argument 'salt' must be 'nil' or of type 'string'")
	assert(not signature or type(signature) == "string", "Argument 'signature' must be 'nil' or of type 'string'")
	assert(not timestampSeconds or type(timestampSeconds) == "string", "Argument 'timestampSeconds' must be 'nil' or of type 'string'")
	assert(not vars or type(vars) == "table", "Argument 'vars' must be 'nil' or of type 'table'")


	local url_path = "/v2/account/link/gamecenter"

	local query_params = {}

	local post_data = nil
	post_data = json.encode({
	bundleId = bundleId,
	playerId = playerId,
	publicKeyUrl = publicKeyUrl,
	salt = salt,
	signature = signature,
	timestampSeconds = timestampSeconds,
	vars = vars,
	})

	return http(client, callback, url_path, query_params, "POST", post_data, retry_policy, cancellation_token, function(result)
		return result
	end)
end

--- link_google
-- Add Google to the social profiles on the current user's account.
-- @param client Client.
-- @param token (string) The OAuth token received from Google to access their profile API.
-- @param vars (object) Extra information that will be bundled in the session token.

-- @param callback (function) Optional callback function
-- A coroutine is used and the result is returned if no callback function is provided.
-- @param retry_policy (function) Optional retry policy used specifically for this call or nil
-- @param cancellation_token (table) Optional cancellation token for this call
-- @return The result.
function M.link_google(client, token, vars, callback, retry_policy, cancellation_token)
	assert(client, "You must provide a client")
	assert(not token or type(token) == "string", "Argument 'token' must be 'nil' or of type 'string'")
	assert(not vars or type(vars) == "table", "Argument 'vars' must be 'nil' or of type 'table'")


	local url_path = "/v2/account/link/google"

	local query_params = {}

	local post_data = nil
	post_data = json.encode({
	token = token,
	vars = vars,
	})

	return http(client, callback, url_path, query_params, "POST", post_data, retry_policy, cancellation_token, function(result)
		return result
	end)
end

--- link_steam
-- Add Steam to the social profiles on the current user's account.
-- @param client Client.
-- @param account () The Facebook account details.
-- @param sync (boolean) Import Steam friends for the user.

-- @param callback (function) Optional callback function
-- A coroutine is used and the result is returned if no callback function is provided.
-- @param retry_policy (function) Optional retry policy used specifically for this call or nil
-- @param cancellation_token (table) Optional cancellation token for this call
-- @return The result.
function M.link_steam(client, account, sync, callback, retry_policy, cancellation_token)
	assert(client, "You must provide a client")
	assert(not account or type(account) == "table", "Argument 'account' must be 'nil' or of type 'table'")
	assert(not sync or type(sync) == "boolean", "Argument 'sync' must be 'nil' or of type 'boolean'")


	local url_path = "/v2/account/link/steam"

	local query_params = {}

	local post_data = nil
	post_data = json.encode({
	account = account,
	sync = sync,
	})

	return http(client, callback, url_path, query_params, "POST", post_data, retry_policy, cancellation_token, function(result)
		return result
	end)
end

--- session_refresh
-- Refresh a user's session using a refresh token retrieved from a previous authentication request.
-- @param client Client.
-- @param token (string) Refresh token.
-- @param vars (object) Extra information that will be bundled in the session token.

-- @param callback (function) Optional callback function
-- A coroutine is used and the result is returned if no callback function is provided.
-- @param retry_policy (function) Optional retry policy used specifically for this call or nil
-- @param cancellation_token (table) Optional cancellation token for this call
-- @return The result.
function M.session_refresh(client, token, vars, callback, retry_policy, cancellation_token)
	assert(client, "You must provide a client")
	assert(not token or type(token) == "string", "Argument 'token' must be 'nil' or of type 'string'")
	assert(not vars or type(vars) == "table", "Argument 'vars' must be 'nil' or of type 'table'")


	local url_path = "/v2/account/session/refresh"

	local query_params = {}

	local post_data = nil
	post_data = json.encode({
	token = token,
	vars = vars,
	})

	return http(client, callback, url_path, query_params, "POST", post_data, retry_policy, cancellation_token, function(result)
		if not result.error and api_session then
			result = api_session.create(result)
		end
		return result
	end)
end

--- unlink_apple
-- Remove the Apple ID from the social profiles on the current user's account.
-- @param client Client.
-- @param token (string) The ID token received from Apple to validate.
-- @param vars (object) Extra information that will be bundled in the session token.

-- @param callback (function) Optional callback function
-- A coroutine is used and the result is returned if no callback function is provided.
-- @param retry_policy (function) Optional retry policy used specifically for this call or nil
-- @param cancellation_token (table) Optional cancellation token for this call
-- @return The result.
function M.unlink_apple(client, token, vars, callback, retry_policy, cancellation_token)
	assert(client, "You must provide a client")
	assert(not token or type(token) == "string", "Argument 'token' must be 'nil' or of type 'string'")
	assert(not vars or type(vars) == "table", "Argument 'vars' must be 'nil' or of type 'table'")


	local url_path = "/v2/account/unlink/apple"

	local query_params = {}

	local post_data = nil
	post_data = json.encode({
	token = token,
	vars = vars,
	})

	return http(client, callback, url_path, query_params, "POST", post_data, retry_policy, cancellation_token, function(result)
		return result
	end)
end

--- unlink_custom
-- Remove the custom ID from the social profiles on the current user's account.
-- @param client Client.
-- @param id (string) A custom identifier.
-- @param vars (object) Extra information that will be bundled in the session token.

-- @param callback (function) Optional callback function
-- A coroutine is used and the result is returned if no callback function is provided.
-- @param retry_policy (function) Optional retry policy used specifically for this call or nil
-- @param cancellation_token (table) Optional cancellation token for this call
-- @return The result.
function M.unlink_custom(client, id, vars, callback, retry_policy, cancellation_token)
	assert(client, "You must provide a client")
	assert(not id or type(id) == "string", "Argument 'id' must be 'nil' or of type 'string'")
	assert(not vars or type(vars) == "table", "Argument 'vars' must be 'nil' or of type 'table'")


	local url_path = "/v2/account/unlink/custom"

	local query_params = {}

	local post_data = nil
	post_data = json.encode({
	id = id,
	vars = vars,
	})

	return http(client, callback, url_path, query_params, "POST", post_data, retry_policy, cancellation_token, function(result)
		return result
	end)
end

--- unlink_device
-- Remove the device ID from the social profiles on the current user's account.
-- @param client Client.
-- @param id (string) A device identifier. Should be obtained by a platform-specific device API.
-- @param vars (object) Extra information that will be bundled in the session token.

-- @param callback (function) Optional callback function
-- A coroutine is used and the result is returned if no callback function is provided.
-- @param retry_policy (function) Optional retry policy used specifically for this call or nil
-- @param cancellation_token (table) Optional cancellation token for this call
-- @return The result.
function M.unlink_device(client, id, vars, callback, retry_policy, cancellation_token)
	assert(client, "You must provide a client")
	assert(not id or type(id) == "string", "Argument 'id' must be 'nil' or of type 'string'")
	assert(not vars or type(vars) == "table", "Argument 'vars' must be 'nil' or of type 'table'")


	local url_path = "/v2/account/unlink/device"

	local query_params = {}

	local post_data = nil
	post_data = json.encode({
	id = id,
	vars = vars,
	})

	return http(client, callback, url_path, query_params, "POST", post_data, retry_policy, cancellation_token, function(result)
		return result
	end)
end

--- unlink_email
-- Remove the email+password from the social profiles on the current user's account.
-- @param client Client.
-- @param email (string) A valid RFC-5322 email address.
-- @param password (string) A password for the user account.
--
--Ignored with unlink operations.
-- @param vars (object) Extra information that will be bundled in the session token.

-- @param callback (function) Optional callback function
-- A coroutine is used and the result is returned if no callback function is provided.
-- @param retry_policy (function) Optional retry policy used specifically for this call or nil
-- @param cancellation_token (table) Optional cancellation token for this call
-- @return The result.
function M.unlink_email(client, email, password, vars, callback, retry_policy, cancellation_token)
	assert(client, "You must provide a client")
	assert(not email or type(email) == "string", "Argument 'email' must be 'nil' or of type 'string'")
	assert(not password or type(password) == "string", "Argument 'password' must be 'nil' or of type 'string'")
	assert(not vars or type(vars) == "table", "Argument 'vars' must be 'nil' or of type 'table'")


	local url_path = "/v2/account/unlink/email"

	local query_params = {}

	local post_data = nil
	post_data = json.encode({
	email = email,
	password = password,
	vars = vars,
	})

	return http(client, callback, url_path, query_params, "POST", post_data, retry_policy, cancellation_token, function(result)
		return result
	end)
end

--- unlink_facebook
-- Remove Facebook from the social profiles on the current user's account.
-- @param client Client.
-- @param token (string) The OAuth token received from Facebook to access their profile API.
-- @param vars (object) Extra information that will be bundled in the session token.

-- @param callback (function) Optional callback function
-- A coroutine is used and the result is returned if no callback function is provided.
-- @param retry_policy (function) Optional retry policy used specifically for this call or nil
-- @param cancellation_token (table) Optional cancellation token for this call
-- @return The result.
function M.unlink_facebook(client, token, vars, callback, retry_policy, cancellation_token)
	assert(client, "You must provide a client")
	assert(not token or type(token) == "string", "Argument 'token' must be 'nil' or of type 'string'")
	assert(not vars or type(vars) == "table", "Argument 'vars' must be 'nil' or of type 'table'")


	local url_path = "/v2/account/unlink/facebook"

	local query_params = {}

	local post_data = nil
	post_data = json.encode({
	token = token,
	vars = vars,
	})

	return http(client, callback, url_path, query_params, "POST", post_data, retry_policy, cancellation_token, function(result)
		return result
	end)
end

--- unlink_facebook_instant_game
-- Remove Facebook Instant Game profile from the social profiles on the current user's account.
-- @param client Client.
-- @param signedPlayerInfo (string) 
-- @param vars (object) Extra information that will be bundled in the session token.

-- @param callback (function) Optional callback function
-- A coroutine is used and the result is returned if no callback function is provided.
-- @param retry_policy (function) Optional retry policy used specifically for this call or nil
-- @param cancellation_token (table) Optional cancellation token for this call
-- @return The result.
function M.unlink_facebook_instant_game(client, signedPlayerInfo, vars, callback, retry_policy, cancellation_token)
	assert(client, "You must provide a client")
	assert(not signedPlayerInfo or type(signedPlayerInfo) == "string", "Argument 'signedPlayerInfo' must be 'nil' or of type 'string'")
	assert(not vars or type(vars) == "table", "Argument 'vars' must be 'nil' or of type 'table'")


	local url_path = "/v2/account/unlink/facebookinstantgame"

	local query_params = {}

	local post_data = nil
	post_data = json.encode({
	signedPlayerInfo = signedPlayerInfo,
	vars = vars,
	})

	return http(client, callback, url_path, query_params, "POST", post_data, retry_policy, cancellation_token, function(result)
		return result
	end)
end

--- unlink_game_center
-- Remove Apple's GameCenter from the social profiles on the current user's account.
-- @param client Client.
-- @param bundleId (string) Bundle ID (generated by GameCenter).
-- @param playerId (string) Player ID (generated by GameCenter).
-- @param publicKeyUrl (string) The URL for the public encryption key.
-- @param salt (string) A random "NSString" used to compute the hash and keep it randomized.
-- @param signature (string) The verification signature data generated.
-- @param timestampSeconds (string) Time since UNIX epoch when the signature was created.
-- @param vars (object) Extra information that will be bundled in the session token.

-- @param callback (function) Optional callback function
-- A coroutine is used and the result is returned if no callback function is provided.
-- @param retry_policy (function) Optional retry policy used specifically for this call or nil
-- @param cancellation_token (table) Optional cancellation token for this call
-- @return The result.
function M.unlink_game_center(client, bundleId, playerId, publicKeyUrl, salt, signature, timestampSeconds, vars, callback, retry_policy, cancellation_token)
	assert(client, "You must provide a client")
	assert(not bundleId or type(bundleId) == "string", "Argument 'bundleId' must be 'nil' or of type 'string'")
	assert(not playerId or type(playerId) == "string", "Argument 'playerId' must be 'nil' or of type 'string'")
	assert(not publicKeyUrl or type(publicKeyUrl) == "string", "Argument 'publicKeyUrl' must be 'nil' or of type 'string'")
	assert(not salt or type(salt) == "string", "Argument 'salt' must be 'nil' or of type 'string'")
	assert(not signature or type(signature) == "string", "Argument 'signature' must be 'nil' or of type 'string'")
	assert(not timestampSeconds or type(timestampSeconds) == "string", "Argument 'timestampSeconds' must be 'nil' or of type 'string'")
	assert(not vars or type(vars) == "table", "Argument 'vars' must be 'nil' or of type 'table'")


	local url_path = "/v2/account/unlink/gamecenter"

	local query_params = {}

	local post_data = nil
	post_data = json.encode({
	bundleId = bundleId,
	playerId = playerId,
	publicKeyUrl = publicKeyUrl,
	salt = salt,
	signature = signature,
	timestampSeconds = timestampSeconds,
	vars = vars,
	})

	return http(client, callback, url_path, query_params, "POST", post_data, retry_policy, cancellation_token, function(result)
		return result
	end)
end

--- unlink_google
-- Remove Google from the social profiles on the current user's account.
-- @param client Client.
-- @param token (string) The OAuth token received from Google to access their profile API.
-- @param vars (object) Extra information that will be bundled in the session token.

-- @param callback (function) Optional callback function
-- A coroutine is used and the result is returned if no callback function is provided.
-- @param retry_policy (function) Optional retry policy used specifically for this call or nil
-- @param cancellation_token (table) Optional cancellation token for this call
-- @return The result.
function M.unlink_google(client, token, vars, callback, retry_policy, cancellation_token)
	assert(client, "You must provide a client")
	assert(not token or type(token) == "string", "Argument 'token' must be 'nil' or of type 'string'")
	assert(not vars or type(vars) == "table", "Argument 'vars' must be 'nil' or of type 'table'")


	local url_path = "/v2/account/unlink/google"

	local query_params = {}

	local post_data = nil
	post_data = json.encode({
	token = token,
	vars = vars,
	})

	return http(client, callback, url_path, query_params, "POST", post_data, retry_policy, cancellation_token, function(result)
		return result
	end)
end

--- unlink_steam
-- Remove Steam from the social profiles on the current user's account.
-- @param client Client.
-- @param token (string) The account token received from Steam to access their profile API.
-- @param vars (object) Extra information that will be bundled in the session token.

-- @param callback (function) Optional callback function
-- A coroutine is used and the result is returned if no callback function is provided.
-- @param retry_policy (function) Optional retry policy used specifically for this call or nil
-- @param cancellation_token (table) Optional cancellation token for this call
-- @return The result.
function M.unlink_steam(client, token, vars, callback, retry_policy, cancellation_token)
	assert(client, "You must provide a client")
	assert(not token or type(token) == "string", "Argument 'token' must be 'nil' or of type 'string'")
	assert(not vars or type(vars) == "table", "Argument 'vars' must be 'nil' or of type 'table'")


	local url_path = "/v2/account/unlink/steam"

	local query_params = {}

	local post_data = nil
	post_data = json.encode({
	token = token,
	vars = vars,
	})

	return http(client, callback, url_path, query_params, "POST", post_data, retry_policy, cancellation_token, function(result)
		return result
	end)
end

--- list_channel_messages
-- List a channel's message history.
-- @param client Client.
-- @param channel_id_str () The channel ID to list from.
-- @param limit_int () Max number of records to return. Between 1 and 100.
-- @param forward_bool () True if listing should be older messages to newer, false if reverse.
-- @param cursor_str () A pagination cursor, if any.
-- @param callback (function) Optional callback function
-- A coroutine is used and the result is returned if no callback function is provided.
-- @param retry_policy (function) Optional retry policy used specifically for this call or nil
-- @param cancellation_token (table) Optional cancellation token for this call
-- @return The result.
function M.list_channel_messages(client, channel_id_str, limit_int, forward_bool, cursor_str, callback, retry_policy, cancellation_token)
	assert(client, "You must provide a client")

	local url_path = "/v2/channel/{channelId}"
	url_path = url_path:gsub("{channelId}", uri_encode(channel_id_str))

	local query_params = {}
	query_params["limit"] = limit_int
	query_params["forward"] = forward_bool
	query_params["cursor"] = cursor_str

	local post_data = nil

	return http(client, callback, url_path, query_params, "GET", post_data, retry_policy, cancellation_token, function(result)
		if not result.error and api_channel_message_list then
			result = api_channel_message_list.create(result)
		end
		return result
	end)
end

--- event
-- Submit an event for processing in the server's registered runtime custom events handler.
-- @param client Client.
-- @param external (boolean) True if the event came directly from a client call, false otherwise.
-- @param name (string) An event name, type, category, or identifier.
-- @param properties (object) Arbitrary event property values.
-- @param timestamp (string) The time when the event was triggered.

-- @param callback (function) Optional callback function
-- A coroutine is used and the result is returned if no callback function is provided.
-- @param retry_policy (function) Optional retry policy used specifically for this call or nil
-- @param cancellation_token (table) Optional cancellation token for this call
-- @return The result.
function M.event(client, external, name, properties, timestamp, callback, retry_policy, cancellation_token)
	assert(client, "You must provide a client")
	assert(not external or type(external) == "boolean", "Argument 'external' must be 'nil' or of type 'boolean'")
	assert(not name or type(name) == "string", "Argument 'name' must be 'nil' or of type 'string'")
	assert(not properties or type(properties) == "table", "Argument 'properties' must be 'nil' or of type 'table'")
	assert(not timestamp or type(timestamp) == "string", "Argument 'timestamp' must be 'nil' or of type 'string'")


	local url_path = "/v2/event"

	local query_params = {}

	local post_data = nil
	post_data = json.encode({
	external = external,
	name = name,
	properties = properties,
	timestamp = timestamp,
	})

	return http(client, callback, url_path, query_params, "POST", post_data, retry_policy, cancellation_token, function(result)
		return result
	end)
end

--- delete_friends
-- Delete one or more users by ID or username.
-- @param client Client.
-- @param ids_arr () The account id of a user.
-- @param usernames_arr () The account username of a user.
-- @param callback (function) Optional callback function
-- A coroutine is used and the result is returned if no callback function is provided.
-- @param retry_policy (function) Optional retry policy used specifically for this call or nil
-- @param cancellation_token (table) Optional cancellation token for this call
-- @return The result.
function M.delete_friends(client, ids_arr, usernames_arr, callback, retry_policy, cancellation_token)
	assert(client, "You must provide a client")

	local url_path = "/v2/friend"

	local query_params = {}
	query_params["ids"] = ids_arr
	query_params["usernames"] = usernames_arr

	local post_data = nil

	return http(client, callback, url_path, query_params, "DELETE", post_data, retry_policy, cancellation_token, function(result)
		return result
	end)
end

--- list_friends
-- List all friends for the current user.
-- @param client Client.
-- @param limit_int () Max number of records to return. Between 1 and 100.
-- @param state_int () The friend state to list.
-- @param cursor_str () An optional next page cursor.
-- @param callback (function) Optional callback function
-- A coroutine is used and the result is returned if no callback function is provided.
-- @param retry_policy (function) Optional retry policy used specifically for this call or nil
-- @param cancellation_token (table) Optional cancellation token for this call
-- @return The result.
function M.list_friends(client, limit_int, state_int, cursor_str, callback, retry_policy, cancellation_token)
	assert(client, "You must provide a client")

	local url_path = "/v2/friend"

	local query_params = {}
	query_params["limit"] = limit_int
	query_params["state"] = state_int
	query_params["cursor"] = cursor_str

	local post_data = nil

	return http(client, callback, url_path, query_params, "GET", post_data, retry_policy, cancellation_token, function(result)
		if not result.error and api_friend_list then
			result = api_friend_list.create(result)
		end
		return result
	end)
end

--- add_friends
-- Add friends by ID or username to a user's account.
-- @param client Client.
-- @param ids_arr () The account id of a user.
-- @param usernames_arr () The account username of a user.
-- @param callback (function) Optional callback function
-- A coroutine is used and the result is returned if no callback function is provided.
-- @param retry_policy (function) Optional retry policy used specifically for this call or nil
-- @param cancellation_token (table) Optional cancellation token for this call
-- @return The result.
function M.add_friends(client, ids_arr, usernames_arr, callback, retry_policy, cancellation_token)
	assert(client, "You must provide a client")

	local url_path = "/v2/friend"

	local query_params = {}
	query_params["ids"] = ids_arr
	query_params["usernames"] = usernames_arr

	local post_data = nil

	return http(client, callback, url_path, query_params, "POST", post_data, retry_policy, cancellation_token, function(result)
		return result
	end)
end

--- block_friends
-- Block one or more users by ID or username.
-- @param client Client.
-- @param ids_arr () The account id of a user.
-- @param usernames_arr () The account username of a user.
-- @param callback (function) Optional callback function
-- A coroutine is used and the result is returned if no callback function is provided.
-- @param retry_policy (function) Optional retry policy used specifically for this call or nil
-- @param cancellation_token (table) Optional cancellation token for this call
-- @return The result.
function M.block_friends(client, ids_arr, usernames_arr, callback, retry_policy, cancellation_token)
	assert(client, "You must provide a client")

	local url_path = "/v2/friend/block"

	local query_params = {}
	query_params["ids"] = ids_arr
	query_params["usernames"] = usernames_arr

	local post_data = nil

	return http(client, callback, url_path, query_params, "POST", post_data, retry_policy, cancellation_token, function(result)
		return result
	end)
end

--- import_facebook_friends
-- Import Facebook friends and add them to a user's account.
-- @param client Client.
-- @param token (string) The OAuth token received from Facebook to access their profile API.
-- @param vars (object) Extra information that will be bundled in the session token.

-- @param reset_bool () Reset the current user's friends list.
-- @param callback (function) Optional callback function
-- A coroutine is used and the result is returned if no callback function is provided.
-- @param retry_policy (function) Optional retry policy used specifically for this call or nil
-- @param cancellation_token (table) Optional cancellation token for this call
-- @return The result.
function M.import_facebook_friends(client, token, vars, reset_bool, callback, retry_policy, cancellation_token)
	assert(client, "You must provide a client")
	assert(not token or type(token) == "string", "Argument 'token' must be 'nil' or of type 'string'")
	assert(not vars or type(vars) == "table", "Argument 'vars' must be 'nil' or of type 'table'")


	local url_path = "/v2/friend/facebook"

	local query_params = {}
	query_params["reset"] = reset_bool

	local post_data = nil
	post_data = json.encode({
	token = token,
	vars = vars,
	})

	return http(client, callback, url_path, query_params, "POST", post_data, retry_policy, cancellation_token, function(result)
		return result
	end)
end

--- import_steam_friends
-- Import Steam friends and add them to a user's account.
-- @param client Client.
-- @param token (string) The account token received from Steam to access their profile API.
-- @param vars (object) Extra information that will be bundled in the session token.

-- @param reset_bool () Reset the current user's friends list.
-- @param callback (function) Optional callback function
-- A coroutine is used and the result is returned if no callback function is provided.
-- @param retry_policy (function) Optional retry policy used specifically for this call or nil
-- @param cancellation_token (table) Optional cancellation token for this call
-- @return The result.
function M.import_steam_friends(client, token, vars, reset_bool, callback, retry_policy, cancellation_token)
	assert(client, "You must provide a client")
	assert(not token or type(token) == "string", "Argument 'token' must be 'nil' or of type 'string'")
	assert(not vars or type(vars) == "table", "Argument 'vars' must be 'nil' or of type 'table'")


	local url_path = "/v2/friend/steam"

	local query_params = {}
	query_params["reset"] = reset_bool

	local post_data = nil
	post_data = json.encode({
	token = token,
	vars = vars,
	})

	return http(client, callback, url_path, query_params, "POST", post_data, retry_policy, cancellation_token, function(result)
		return result
	end)
end

--- list_groups
-- List groups based on given filters.
-- @param client Client.
-- @param name_str () List groups that contain this value in their names.
-- @param cursor_str () Optional pagination cursor.
-- @param limit_int () Max number of groups to return. Between 1 and 100.
-- @param lang_tag_str () Language tag filter
-- @param members_int () Number of group members
-- @param open_bool () Optional Open/Closed filter.
-- @param callback (function) Optional callback function
-- A coroutine is used and the result is returned if no callback function is provided.
-- @param retry_policy (function) Optional retry policy used specifically for this call or nil
-- @param cancellation_token (table) Optional cancellation token for this call
-- @return The result.
function M.list_groups(client, name_str, cursor_str, limit_int, lang_tag_str, members_int, open_bool, callback, retry_policy, cancellation_token)
	assert(client, "You must provide a client")

	local url_path = "/v2/group"

	local query_params = {}
	query_params["name"] = name_str
	query_params["cursor"] = cursor_str
	query_params["limit"] = limit_int
	query_params["langTag"] = lang_tag_str
	query_params["members"] = members_int
	query_params["open"] = open_bool

	local post_data = nil

	return http(client, callback, url_path, query_params, "GET", post_data, retry_policy, cancellation_token, function(result)
		if not result.error and api_group_list then
			result = api_group_list.create(result)
		end
		return result
	end)
end

--- create_group
-- Create a new group with the current user as the owner.
-- @param client Client.
-- @param avatarUrl (string) A URL for an avatar image.
-- @param description (string) A description for the group.
-- @param langTag (string) The language expected to be a tag which follows the BCP-47 spec.
-- @param maxCount (integer) Maximum number of group members.
-- @param name (string) A unique name for the group.
-- @param open (boolean) Mark a group as open or not where only admins can accept members.

-- @param callback (function) Optional callback function
-- A coroutine is used and the result is returned if no callback function is provided.
-- @param retry_policy (function) Optional retry policy used specifically for this call or nil
-- @param cancellation_token (table) Optional cancellation token for this call
-- @return The result.
function M.create_group(client, avatarUrl, description, langTag, maxCount, name, open, callback, retry_policy, cancellation_token)
	assert(client, "You must provide a client")
	assert(not avatarUrl or type(avatarUrl) == "string", "Argument 'avatarUrl' must be 'nil' or of type 'string'")
	assert(not description or type(description) == "string", "Argument 'description' must be 'nil' or of type 'string'")
	assert(not langTag or type(langTag) == "string", "Argument 'langTag' must be 'nil' or of type 'string'")
	assert(not maxCount or type(maxCount) == "number", "Argument 'maxCount' must be 'nil' or of type 'number'")
	assert(not name or type(name) == "string", "Argument 'name' must be 'nil' or of type 'string'")
	assert(not open or type(open) == "boolean", "Argument 'open' must be 'nil' or of type 'boolean'")


	local url_path = "/v2/group"

	local query_params = {}

	local post_data = nil
	post_data = json.encode({
	avatarUrl = avatarUrl,
	description = description,
	langTag = langTag,
	maxCount = maxCount,
	name = name,
	open = open,
	})

	return http(client, callback, url_path, query_params, "POST", post_data, retry_policy, cancellation_token, function(result)
		if not result.error and api_group then
			result = api_group.create(result)
		end
		return result
	end)
end

--- delete_group
-- Delete a group by ID.
-- @param client Client.
-- @param group_id_str () The id of a group.
-- @param callback (function) Optional callback function
-- A coroutine is used and the result is returned if no callback function is provided.
-- @param retry_policy (function) Optional retry policy used specifically for this call or nil
-- @param cancellation_token (table) Optional cancellation token for this call
-- @return The result.
function M.delete_group(client, group_id_str, callback, retry_policy, cancellation_token)
	assert(client, "You must provide a client")

	local url_path = "/v2/group/{groupId}"
	url_path = url_path:gsub("{groupId}", uri_encode(group_id_str))

	local query_params = {}

	local post_data = nil

	return http(client, callback, url_path, query_params, "DELETE", post_data, retry_policy, cancellation_token, function(result)
		return result
	end)
end

--- update_group
-- Update fields in a given group.
-- @param client Client.
-- @param group_id_str () The ID of the group to update.
-- @param body (object) 
-- @param callback (function) Optional callback function
-- A coroutine is used and the result is returned if no callback function is provided.
-- @param retry_policy (function) Optional retry policy used specifically for this call or nil
-- @param cancellation_token (table) Optional cancellation token for this call
-- @return The result.
function M.update_group(client, group_id_str, body, callback, retry_policy, cancellation_token)
	assert(client, "You must provide a client")

	assert(body and type(body) == "object", "Argument 'body' must be of type 'object'")

	local url_path = "/v2/group/{groupId}"
	url_path = url_path:gsub("{groupId}", uri_encode(group_id_str))

	local query_params = {}

	local post_data = nil
	post_data = json.encode(body)

	return http(client, callback, url_path, query_params, "PUT", post_data, retry_policy, cancellation_token, function(result)
		return result
	end)
end

--- add_group_users
-- Add users to a group.
-- @param client Client.
-- @param group_id_str () The group to add users to.
-- @param user_ids_arr () The users to add.
-- @param callback (function) Optional callback function
-- A coroutine is used and the result is returned if no callback function is provided.
-- @param retry_policy (function) Optional retry policy used specifically for this call or nil
-- @param cancellation_token (table) Optional cancellation token for this call
-- @return The result.
function M.add_group_users(client, group_id_str, user_ids_arr, callback, retry_policy, cancellation_token)
	assert(client, "You must provide a client")

	local url_path = "/v2/group/{groupId}/add"
	url_path = url_path:gsub("{groupId}", uri_encode(group_id_str))

	local query_params = {}
	query_params["userIds"] = user_ids_arr

	local post_data = nil

	return http(client, callback, url_path, query_params, "POST", post_data, retry_policy, cancellation_token, function(result)
		return result
	end)
end

--- ban_group_users
-- Ban a set of users from a group.
-- @param client Client.
-- @param group_id_str () The group to ban users from.
-- @param user_ids_arr () The users to ban.
-- @param callback (function) Optional callback function
-- A coroutine is used and the result is returned if no callback function is provided.
-- @param retry_policy (function) Optional retry policy used specifically for this call or nil
-- @param cancellation_token (table) Optional cancellation token for this call
-- @return The result.
function M.ban_group_users(client, group_id_str, user_ids_arr, callback, retry_policy, cancellation_token)
	assert(client, "You must provide a client")

	local url_path = "/v2/group/{groupId}/ban"
	url_path = url_path:gsub("{groupId}", uri_encode(group_id_str))

	local query_params = {}
	query_params["userIds"] = user_ids_arr

	local post_data = nil

	return http(client, callback, url_path, query_params, "POST", post_data, retry_policy, cancellation_token, function(result)
		return result
	end)
end

--- demote_group_users
-- Demote a set of users in a group to the next role down.
-- @param client Client.
-- @param group_id_str () The group ID to demote in.
-- @param user_ids_arr () The users to demote.
-- @param callback (function) Optional callback function
-- A coroutine is used and the result is returned if no callback function is provided.
-- @param retry_policy (function) Optional retry policy used specifically for this call or nil
-- @param cancellation_token (table) Optional cancellation token for this call
-- @return The result.
function M.demote_group_users(client, group_id_str, user_ids_arr, callback, retry_policy, cancellation_token)
	assert(client, "You must provide a client")

	local url_path = "/v2/group/{groupId}/demote"
	url_path = url_path:gsub("{groupId}", uri_encode(group_id_str))

	local query_params = {}
	query_params["userIds"] = user_ids_arr

	local post_data = nil

	return http(client, callback, url_path, query_params, "POST", post_data, retry_policy, cancellation_token, function(result)
		return result
	end)
end

--- join_group
-- Immediately join an open group, or request to join a closed one.
-- @param client Client.
-- @param group_id_str () The group ID to join. The group must already exist.
-- @param callback (function) Optional callback function
-- A coroutine is used and the result is returned if no callback function is provided.
-- @param retry_policy (function) Optional retry policy used specifically for this call or nil
-- @param cancellation_token (table) Optional cancellation token for this call
-- @return The result.
function M.join_group(client, group_id_str, callback, retry_policy, cancellation_token)
	assert(client, "You must provide a client")

	local url_path = "/v2/group/{groupId}/join"
	url_path = url_path:gsub("{groupId}", uri_encode(group_id_str))

	local query_params = {}

	local post_data = nil

	return http(client, callback, url_path, query_params, "POST", post_data, retry_policy, cancellation_token, function(result)
		return result
	end)
end

--- kick_group_users
-- Kick a set of users from a group.
-- @param client Client.
-- @param group_id_str () The group ID to kick from.
-- @param user_ids_arr () The users to kick.
-- @param callback (function) Optional callback function
-- A coroutine is used and the result is returned if no callback function is provided.
-- @param retry_policy (function) Optional retry policy used specifically for this call or nil
-- @param cancellation_token (table) Optional cancellation token for this call
-- @return The result.
function M.kick_group_users(client, group_id_str, user_ids_arr, callback, retry_policy, cancellation_token)
	assert(client, "You must provide a client")

	local url_path = "/v2/group/{groupId}/kick"
	url_path = url_path:gsub("{groupId}", uri_encode(group_id_str))

	local query_params = {}
	query_params["userIds"] = user_ids_arr

	local post_data = nil

	return http(client, callback, url_path, query_params, "POST", post_data, retry_policy, cancellation_token, function(result)
		return result
	end)
end

--- leave_group
-- Leave a group the user is a member of.
-- @param client Client.
-- @param group_id_str () The group ID to leave.
-- @param callback (function) Optional callback function
-- A coroutine is used and the result is returned if no callback function is provided.
-- @param retry_policy (function) Optional retry policy used specifically for this call or nil
-- @param cancellation_token (table) Optional cancellation token for this call
-- @return The result.
function M.leave_group(client, group_id_str, callback, retry_policy, cancellation_token)
	assert(client, "You must provide a client")

	local url_path = "/v2/group/{groupId}/leave"
	url_path = url_path:gsub("{groupId}", uri_encode(group_id_str))

	local query_params = {}

	local post_data = nil

	return http(client, callback, url_path, query_params, "POST", post_data, retry_policy, cancellation_token, function(result)
		return result
	end)
end

--- promote_group_users
-- Promote a set of users in a group to the next role up.
-- @param client Client.
-- @param group_id_str () The group ID to promote in.
-- @param user_ids_arr () The users to promote.
-- @param callback (function) Optional callback function
-- A coroutine is used and the result is returned if no callback function is provided.
-- @param retry_policy (function) Optional retry policy used specifically for this call or nil
-- @param cancellation_token (table) Optional cancellation token for this call
-- @return The result.
function M.promote_group_users(client, group_id_str, user_ids_arr, callback, retry_policy, cancellation_token)
	assert(client, "You must provide a client")

	local url_path = "/v2/group/{groupId}/promote"
	url_path = url_path:gsub("{groupId}", uri_encode(group_id_str))

	local query_params = {}
	query_params["userIds"] = user_ids_arr

	local post_data = nil

	return http(client, callback, url_path, query_params, "POST", post_data, retry_policy, cancellation_token, function(result)
		return result
	end)
end

--- list_group_users
-- List all users that are part of a group.
-- @param client Client.
-- @param group_id_str () The group ID to list from.
-- @param limit_int () Max number of records to return. Between 1 and 100.
-- @param state_int () The group user state to list.
-- @param cursor_str () An optional next page cursor.
-- @param callback (function) Optional callback function
-- A coroutine is used and the result is returned if no callback function is provided.
-- @param retry_policy (function) Optional retry policy used specifically for this call or nil
-- @param cancellation_token (table) Optional cancellation token for this call
-- @return The result.
function M.list_group_users(client, group_id_str, limit_int, state_int, cursor_str, callback, retry_policy, cancellation_token)
	assert(client, "You must provide a client")

	local url_path = "/v2/group/{groupId}/user"
	url_path = url_path:gsub("{groupId}", uri_encode(group_id_str))

	local query_params = {}
	query_params["limit"] = limit_int
	query_params["state"] = state_int
	query_params["cursor"] = cursor_str

	local post_data = nil

	return http(client, callback, url_path, query_params, "GET", post_data, retry_policy, cancellation_token, function(result)
		if not result.error and api_group_user_list then
			result = api_group_user_list.create(result)
		end
		return result
	end)
end

--- validate_purchase_apple
-- Validate Apple IAP Receipt
-- @param client Client.
-- @param persist (boolean) 
-- @param receipt (string) Base64 encoded Apple receipt data payload.

-- @param callback (function) Optional callback function
-- A coroutine is used and the result is returned if no callback function is provided.
-- @param retry_policy (function) Optional retry policy used specifically for this call or nil
-- @param cancellation_token (table) Optional cancellation token for this call
-- @return The result.
function M.validate_purchase_apple(client, persist, receipt, callback, retry_policy, cancellation_token)
	assert(client, "You must provide a client")
	assert(not persist or type(persist) == "boolean", "Argument 'persist' must be 'nil' or of type 'boolean'")
	assert(not receipt or type(receipt) == "string", "Argument 'receipt' must be 'nil' or of type 'string'")


	local url_path = "/v2/iap/purchase/apple"

	local query_params = {}

	local post_data = nil
	post_data = json.encode({
	persist = persist,
	receipt = receipt,
	})

	return http(client, callback, url_path, query_params, "POST", post_data, retry_policy, cancellation_token, function(result)
		if not result.error and api_validate_purchase_response then
			result = api_validate_purchase_response.create(result)
		end
		return result
	end)
end

--- validate_purchase_facebook_instant
-- Validate FB Instant IAP Receipt
-- @param client Client.
-- @param persist (boolean) 
-- @param signedRequest (string) Base64 encoded Facebook Instant signedRequest receipt data payload.

-- @param callback (function) Optional callback function
-- A coroutine is used and the result is returned if no callback function is provided.
-- @param retry_policy (function) Optional retry policy used specifically for this call or nil
-- @param cancellation_token (table) Optional cancellation token for this call
-- @return The result.
function M.validate_purchase_facebook_instant(client, persist, signedRequest, callback, retry_policy, cancellation_token)
	assert(client, "You must provide a client")
	assert(not persist or type(persist) == "boolean", "Argument 'persist' must be 'nil' or of type 'boolean'")
	assert(not signedRequest or type(signedRequest) == "string", "Argument 'signedRequest' must be 'nil' or of type 'string'")


	local url_path = "/v2/iap/purchase/facebookinstant"

	local query_params = {}

	local post_data = nil
	post_data = json.encode({
	persist = persist,
	signedRequest = signedRequest,
	})

	return http(client, callback, url_path, query_params, "POST", post_data, retry_policy, cancellation_token, function(result)
		if not result.error and api_validate_purchase_response then
			result = api_validate_purchase_response.create(result)
		end
		return result
	end)
end

--- validate_purchase_google
-- Validate Google IAP Receipt
-- @param client Client.
-- @param persist (boolean) 
-- @param purchase (string) JSON encoded Google purchase payload.

-- @param callback (function) Optional callback function
-- A coroutine is used and the result is returned if no callback function is provided.
-- @param retry_policy (function) Optional retry policy used specifically for this call or nil
-- @param cancellation_token (table) Optional cancellation token for this call
-- @return The result.
function M.validate_purchase_google(client, persist, purchase, callback, retry_policy, cancellation_token)
	assert(client, "You must provide a client")
	assert(not persist or type(persist) == "boolean", "Argument 'persist' must be 'nil' or of type 'boolean'")
	assert(not purchase or type(purchase) == "string", "Argument 'purchase' must be 'nil' or of type 'string'")


	local url_path = "/v2/iap/purchase/google"

	local query_params = {}

	local post_data = nil
	post_data = json.encode({
	persist = persist,
	purchase = purchase,
	})

	return http(client, callback, url_path, query_params, "POST", post_data, retry_policy, cancellation_token, function(result)
		if not result.error and api_validate_purchase_response then
			result = api_validate_purchase_response.create(result)
		end
		return result
	end)
end

--- validate_purchase_huawei
-- Validate Huawei IAP Receipt
-- @param client Client.
-- @param persist (boolean) 
-- @param purchase (string) JSON encoded Huawei InAppPurchaseData.
-- @param signature (string) InAppPurchaseData signature.

-- @param callback (function) Optional callback function
-- A coroutine is used and the result is returned if no callback function is provided.
-- @param retry_policy (function) Optional retry policy used specifically for this call or nil
-- @param cancellation_token (table) Optional cancellation token for this call
-- @return The result.
function M.validate_purchase_huawei(client, persist, purchase, signature, callback, retry_policy, cancellation_token)
	assert(client, "You must provide a client")
	assert(not persist or type(persist) == "boolean", "Argument 'persist' must be 'nil' or of type 'boolean'")
	assert(not purchase or type(purchase) == "string", "Argument 'purchase' must be 'nil' or of type 'string'")
	assert(not signature or type(signature) == "string", "Argument 'signature' must be 'nil' or of type 'string'")


	local url_path = "/v2/iap/purchase/huawei"

	local query_params = {}

	local post_data = nil
	post_data = json.encode({
	persist = persist,
	purchase = purchase,
	signature = signature,
	})

	return http(client, callback, url_path, query_params, "POST", post_data, retry_policy, cancellation_token, function(result)
		if not result.error and api_validate_purchase_response then
			result = api_validate_purchase_response.create(result)
		end
		return result
	end)
end

--- list_subscriptions
-- List user's subscriptions.
-- @param client Client.
-- @param cursor (string) 
-- @param limit (integer) 

-- @param callback (function) Optional callback function
-- A coroutine is used and the result is returned if no callback function is provided.
-- @param retry_policy (function) Optional retry policy used specifically for this call or nil
-- @param cancellation_token (table) Optional cancellation token for this call
-- @return The result.
function M.list_subscriptions(client, cursor, limit, callback, retry_policy, cancellation_token)
	assert(client, "You must provide a client")
	assert(not cursor or type(cursor) == "string", "Argument 'cursor' must be 'nil' or of type 'string'")
	assert(not limit or type(limit) == "number", "Argument 'limit' must be 'nil' or of type 'number'")


	local url_path = "/v2/iap/subscription"

	local query_params = {}

	local post_data = nil
	post_data = json.encode({
	cursor = cursor,
	limit = limit,
	})

	return http(client, callback, url_path, query_params, "POST", post_data, retry_policy, cancellation_token, function(result)
		if not result.error and api_subscription_list then
			result = api_subscription_list.create(result)
		end
		return result
	end)
end

--- validate_subscription_apple
-- Validate Apple Subscription Receipt
-- @param client Client.
-- @param persist (boolean) Persist the subscription.
-- @param receipt (string) Base64 encoded Apple receipt data payload.

-- @param callback (function) Optional callback function
-- A coroutine is used and the result is returned if no callback function is provided.
-- @param retry_policy (function) Optional retry policy used specifically for this call or nil
-- @param cancellation_token (table) Optional cancellation token for this call
-- @return The result.
function M.validate_subscription_apple(client, persist, receipt, callback, retry_policy, cancellation_token)
	assert(client, "You must provide a client")
	assert(not persist or type(persist) == "boolean", "Argument 'persist' must be 'nil' or of type 'boolean'")
	assert(not receipt or type(receipt) == "string", "Argument 'receipt' must be 'nil' or of type 'string'")


	local url_path = "/v2/iap/subscription/apple"

	local query_params = {}

	local post_data = nil
	post_data = json.encode({
	persist = persist,
	receipt = receipt,
	})

	return http(client, callback, url_path, query_params, "POST", post_data, retry_policy, cancellation_token, function(result)
		if not result.error and api_validate_subscription_response then
			result = api_validate_subscription_response.create(result)
		end
		return result
	end)
end

--- validate_subscription_google
-- Validate Google Subscription Receipt
-- @param client Client.
-- @param persist (boolean) Persist the subscription.
-- @param receipt (string) JSON encoded Google purchase payload.

-- @param callback (function) Optional callback function
-- A coroutine is used and the result is returned if no callback function is provided.
-- @param retry_policy (function) Optional retry policy used specifically for this call or nil
-- @param cancellation_token (table) Optional cancellation token for this call
-- @return The result.
function M.validate_subscription_google(client, persist, receipt, callback, retry_policy, cancellation_token)
	assert(client, "You must provide a client")
	assert(not persist or type(persist) == "boolean", "Argument 'persist' must be 'nil' or of type 'boolean'")
	assert(not receipt or type(receipt) == "string", "Argument 'receipt' must be 'nil' or of type 'string'")


	local url_path = "/v2/iap/subscription/google"

	local query_params = {}

	local post_data = nil
	post_data = json.encode({
	persist = persist,
	receipt = receipt,
	})

	return http(client, callback, url_path, query_params, "POST", post_data, retry_policy, cancellation_token, function(result)
		if not result.error and api_validate_subscription_response then
			result = api_validate_subscription_response.create(result)
		end
		return result
	end)
end

--- get_subscription
-- Get subscription by product id.
-- @param client Client.
-- @param product_id_str () Product id of the subscription
-- @param callback (function) Optional callback function
-- A coroutine is used and the result is returned if no callback function is provided.
-- @param retry_policy (function) Optional retry policy used specifically for this call or nil
-- @param cancellation_token (table) Optional cancellation token for this call
-- @return The result.
function M.get_subscription(client, product_id_str, callback, retry_policy, cancellation_token)
	assert(client, "You must provide a client")

	local url_path = "/v2/iap/subscription/{productId}"
	url_path = url_path:gsub("{productId}", uri_encode(product_id_str))

	local query_params = {}

	local post_data = nil

	return http(client, callback, url_path, query_params, "GET", post_data, retry_policy, cancellation_token, function(result)
		if not result.error and api_validated_subscription then
			result = api_validated_subscription.create(result)
		end
		return result
	end)
end

--- delete_leaderboard_record
-- Delete a leaderboard record.
-- @param client Client.
-- @param leaderboard_id_str () The leaderboard ID to delete from.
-- @param callback (function) Optional callback function
-- A coroutine is used and the result is returned if no callback function is provided.
-- @param retry_policy (function) Optional retry policy used specifically for this call or nil
-- @param cancellation_token (table) Optional cancellation token for this call
-- @return The result.
function M.delete_leaderboard_record(client, leaderboard_id_str, callback, retry_policy, cancellation_token)
	assert(client, "You must provide a client")

	local url_path = "/v2/leaderboard/{leaderboardId}"
	url_path = url_path:gsub("{leaderboardId}", uri_encode(leaderboard_id_str))

	local query_params = {}

	local post_data = nil

	return http(client, callback, url_path, query_params, "DELETE", post_data, retry_policy, cancellation_token, function(result)
		return result
	end)
end

--- list_leaderboard_records
-- List leaderboard records.
-- @param client Client.
-- @param leaderboard_id_str () The ID of the leaderboard to list for.
-- @param owner_ids_arr () One or more owners to retrieve records for.
-- @param limit_int () Max number of records to return. Between 1 and 100.
-- @param cursor_str () A next or previous page cursor.
-- @param expiry_str () Expiry in seconds (since epoch) to begin fetching records from. Optional. 0 means from current time.
-- @param callback (function) Optional callback function
-- A coroutine is used and the result is returned if no callback function is provided.
-- @param retry_policy (function) Optional retry policy used specifically for this call or nil
-- @param cancellation_token (table) Optional cancellation token for this call
-- @return The result.
function M.list_leaderboard_records(client, leaderboard_id_str, owner_ids_arr, limit_int, cursor_str, expiry_str, callback, retry_policy, cancellation_token)
	assert(client, "You must provide a client")

	local url_path = "/v2/leaderboard/{leaderboardId}"
	url_path = url_path:gsub("{leaderboardId}", uri_encode(leaderboard_id_str))

	local query_params = {}
	query_params["ownerIds"] = owner_ids_arr
	query_params["limit"] = limit_int
	query_params["cursor"] = cursor_str
	query_params["expiry"] = expiry_str

	local post_data = nil

	return http(client, callback, url_path, query_params, "GET", post_data, retry_policy, cancellation_token, function(result)
		if not result.error and api_leaderboard_record_list then
			result = api_leaderboard_record_list.create(result)
		end
		return result
	end)
end

--- write_leaderboard_record
-- Write a record to a leaderboard.
-- @param client Client.
-- @param leaderboard_id_str () The ID of the leaderboard to write to.
-- @param metadata (string) Optional record metadata.
-- @param operator () Operator override.
-- @param score (string) The score value to submit.
-- @param subscore (string) An optional secondary value.

-- @param callback (function) Optional callback function
-- A coroutine is used and the result is returned if no callback function is provided.
-- @param retry_policy (function) Optional retry policy used specifically for this call or nil
-- @param cancellation_token (table) Optional cancellation token for this call
-- @return The result.
function M.write_leaderboard_record(client, leaderboard_id_str, metadata, operator, score, subscore, callback, retry_policy, cancellation_token)
	assert(client, "You must provide a client")
	assert(not metadata or type(metadata) == "string", "Argument 'metadata' must be 'nil' or of type 'string'")
	assert(not operator or type(operator) == "string", "Argument 'operator' must be 'nil' or of type 'string'")
	assert(not score or type(score) == "string", "Argument 'score' must be 'nil' or of type 'string'")
	assert(not subscore or type(subscore) == "string", "Argument 'subscore' must be 'nil' or of type 'string'")


	local url_path = "/v2/leaderboard/{leaderboardId}"
	url_path = url_path:gsub("{leaderboardId}", uri_encode(leaderboard_id_str))

	local query_params = {}

	local post_data = nil
	post_data = json.encode({
	metadata = metadata,
	operator = operator,
	score = score,
	subscore = subscore,
	})

	return http(client, callback, url_path, query_params, "POST", post_data, retry_policy, cancellation_token, function(result)
		if not result.error and api_leaderboard_record then
			result = api_leaderboard_record.create(result)
		end
		return result
	end)
end

--- list_leaderboard_records_around_owner
-- List leaderboard records that belong to a user.
-- @param client Client.
-- @param leaderboard_id_str () The ID of the tournament to list for.
-- @param owner_id_str () The owner to retrieve records around.
-- @param limit_int () Max number of records to return. Between 1 and 100.
-- @param expiry_str () Expiry in seconds (since epoch) to begin fetching records from.
-- @param cursor_str () A next or previous page cursor.
-- @param callback (function) Optional callback function
-- A coroutine is used and the result is returned if no callback function is provided.
-- @param retry_policy (function) Optional retry policy used specifically for this call or nil
-- @param cancellation_token (table) Optional cancellation token for this call
-- @return The result.
function M.list_leaderboard_records_around_owner(client, leaderboard_id_str, owner_id_str, limit_int, expiry_str, cursor_str, callback, retry_policy, cancellation_token)
	assert(client, "You must provide a client")

	local url_path = "/v2/leaderboard/{leaderboardId}/owner/{ownerId}"
	url_path = url_path:gsub("{leaderboardId}", uri_encode(leaderboard_id_str))
	url_path = url_path:gsub("{ownerId}", uri_encode(owner_id_str))

	local query_params = {}
	query_params["limit"] = limit_int
	query_params["expiry"] = expiry_str
	query_params["cursor"] = cursor_str

	local post_data = nil

	return http(client, callback, url_path, query_params, "GET", post_data, retry_policy, cancellation_token, function(result)
		if not result.error and api_leaderboard_record_list then
			result = api_leaderboard_record_list.create(result)
		end
		return result
	end)
end

--- list_matches
-- Fetch list of running matches.
-- @param client Client.
-- @param limit_int () Limit the number of returned matches.
-- @param authoritative_bool () Authoritative or relayed matches.
-- @param label_str () Label filter.
-- @param min_size_int () Minimum user count.
-- @param max_size_int () Maximum user count.
-- @param query_str () Arbitrary label query.
-- @param callback (function) Optional callback function
-- A coroutine is used and the result is returned if no callback function is provided.
-- @param retry_policy (function) Optional retry policy used specifically for this call or nil
-- @param cancellation_token (table) Optional cancellation token for this call
-- @return The result.
function M.list_matches(client, limit_int, authoritative_bool, label_str, min_size_int, max_size_int, query_str, callback, retry_policy, cancellation_token)
	assert(client, "You must provide a client")

	local url_path = "/v2/match"

	local query_params = {}
	query_params["limit"] = limit_int
	query_params["authoritative"] = authoritative_bool
	query_params["label"] = label_str
	query_params["minSize"] = min_size_int
	query_params["maxSize"] = max_size_int
	query_params["query"] = query_str

	local post_data = nil

	return http(client, callback, url_path, query_params, "GET", post_data, retry_policy, cancellation_token, function(result)
		if not result.error and api_match_list then
			result = api_match_list.create(result)
		end
		return result
	end)
end

--- delete_notifications
-- Delete one or more notifications for the current user.
-- @param client Client.
-- @param ids_arr () The id of notifications.
-- @param callback (function) Optional callback function
-- A coroutine is used and the result is returned if no callback function is provided.
-- @param retry_policy (function) Optional retry policy used specifically for this call or nil
-- @param cancellation_token (table) Optional cancellation token for this call
-- @return The result.
function M.delete_notifications(client, ids_arr, callback, retry_policy, cancellation_token)
	assert(client, "You must provide a client")

	local url_path = "/v2/notification"

	local query_params = {}
	query_params["ids"] = ids_arr

	local post_data = nil

	return http(client, callback, url_path, query_params, "DELETE", post_data, retry_policy, cancellation_token, function(result)
		return result
	end)
end

--- list_notifications
-- Fetch list of notifications.
-- @param client Client.
-- @param limit_int () The number of notifications to get. Between 1 and 100.
-- @param cacheable_cursor_str () A cursor to page through notifications. May be cached by clients to get from point in time forwards.
--
--value from NotificationList.cacheable_cursor.
-- @param callback (function) Optional callback function
-- A coroutine is used and the result is returned if no callback function is provided.
-- @param retry_policy (function) Optional retry policy used specifically for this call or nil
-- @param cancellation_token (table) Optional cancellation token for this call
-- @return The result.
function M.list_notifications(client, limit_int, cacheable_cursor_str, callback, retry_policy, cancellation_token)
	assert(client, "You must provide a client")

	local url_path = "/v2/notification"

	local query_params = {}
	query_params["limit"] = limit_int
	query_params["cacheableCursor"] = cacheable_cursor_str

	local post_data = nil

	return http(client, callback, url_path, query_params, "GET", post_data, retry_policy, cancellation_token, function(result)
		if not result.error and api_notification_list then
			result = api_notification_list.create(result)
		end
		return result
	end)
end

--- rpc_func2
-- Execute a Lua function on the server.
-- @param client Client.
-- @param id_str () The identifier of the function.
-- @param payload_str () The payload of the function which must be a JSON object.
-- @param http_key_str () The authentication key used when executed as a non-client HTTP request.
-- @param callback (function) Optional callback function
-- A coroutine is used and the result is returned if no callback function is provided.
-- @param retry_policy (function) Optional retry policy used specifically for this call or nil
-- @param cancellation_token (table) Optional cancellation token for this call
-- @return The result.
function M.rpc_func2(client, id_str, payload_str, http_key_str, callback, retry_policy, cancellation_token)
	assert(client, "You must provide a client")

	local url_path = "/v2/rpc/{id}"
	url_path = url_path:gsub("{id}", uri_encode(id_str))

	local query_params = {}
	query_params["payload"] = payload_str
	query_params["httpKey"] = http_key_str

	local post_data = nil

	return http(client, callback, url_path, query_params, "GET", post_data, retry_policy, cancellation_token, function(result)
		if not result.error and api_rpc then
			result = api_rpc.create(result)
		end
		return result
	end)
end

--- rpc_func
-- Execute a Lua function on the server.
-- @param client Client.
-- @param id_str () The identifier of the function.
-- @param payload (string) The payload of the function which must be a JSON object.
-- @param http_key_str () The authentication key used when executed as a non-client HTTP request.
-- @param callback (function) Optional callback function
-- A coroutine is used and the result is returned if no callback function is provided.
-- @param retry_policy (function) Optional retry policy used specifically for this call or nil
-- @param cancellation_token (table) Optional cancellation token for this call
-- @return The result.
function M.rpc_func(client, id_str, payload, http_key_str, callback, retry_policy, cancellation_token)
	assert(client, "You must provide a client")

	assert(payload and type(payload) == "string", "Argument 'payload' must be of type 'string'")

	local url_path = "/v2/rpc/{id}"
	url_path = url_path:gsub("{id}", uri_encode(id_str))

	local query_params = {}
	query_params["httpKey"] = http_key_str

	local post_data = nil
	post_data = json.encode(payload)

	return http(client, callback, url_path, query_params, "POST", post_data, retry_policy, cancellation_token, function(result)
		if not result.error and api_rpc then
			result = api_rpc.create(result)
		end
		return result
	end)
end

--- session_logout
-- Log out a session, invalidate a refresh token, or log out all sessions/refresh tokens for a user.
-- @param client Client.
-- @param refreshToken (string) Refresh token to invalidate.
-- @param token (string) Session token to log out.

-- @param callback (function) Optional callback function
-- A coroutine is used and the result is returned if no callback function is provided.
-- @param retry_policy (function) Optional retry policy used specifically for this call or nil
-- @param cancellation_token (table) Optional cancellation token for this call
-- @return The result.
function M.session_logout(client, refreshToken, token, callback, retry_policy, cancellation_token)
	assert(client, "You must provide a client")
	assert(not refreshToken or type(refreshToken) == "string", "Argument 'refreshToken' must be 'nil' or of type 'string'")
	assert(not token or type(token) == "string", "Argument 'token' must be 'nil' or of type 'string'")


	local url_path = "/v2/session/logout"

	local query_params = {}

	local post_data = nil
	post_data = json.encode({
	refreshToken = refreshToken,
	token = token,
	})

	return http(client, callback, url_path, query_params, "POST", post_data, retry_policy, cancellation_token, function(result)
		return result
	end)
end

--- read_storage_objects
-- Get storage objects.
-- @param client Client.
-- @param objectIds (array) Batch of storage objects.

-- @param callback (function) Optional callback function
-- A coroutine is used and the result is returned if no callback function is provided.
-- @param retry_policy (function) Optional retry policy used specifically for this call or nil
-- @param cancellation_token (table) Optional cancellation token for this call
-- @return The result.
function M.read_storage_objects(client, objectIds, callback, retry_policy, cancellation_token)
	assert(client, "You must provide a client")
	assert(not objectIds or type(objectIds) == "table", "Argument 'objectIds' must be 'nil' or of type 'table'")


	local url_path = "/v2/storage"

	local query_params = {}

	local post_data = nil
	post_data = json.encode({
	objectIds = objectIds,
	})

	return http(client, callback, url_path, query_params, "POST", post_data, retry_policy, cancellation_token, function(result)
		if not result.error and api_storage_objects then
			result = api_storage_objects.create(result)
		end
		return result
	end)
end

--- write_storage_objects
-- Write objects into the storage engine.
-- @param client Client.
-- @param objects (array) The objects to store on the server.

-- @param callback (function) Optional callback function
-- A coroutine is used and the result is returned if no callback function is provided.
-- @param retry_policy (function) Optional retry policy used specifically for this call or nil
-- @param cancellation_token (table) Optional cancellation token for this call
-- @return The result.
function M.write_storage_objects(client, objects, callback, retry_policy, cancellation_token)
	assert(client, "You must provide a client")
	assert(not objects or type(objects) == "table", "Argument 'objects' must be 'nil' or of type 'table'")


	local url_path = "/v2/storage"

	local query_params = {}

	local post_data = nil
	post_data = json.encode({
	objects = objects,
	})

	return http(client, callback, url_path, query_params, "PUT", post_data, retry_policy, cancellation_token, function(result)
		if not result.error and api_storage_object_acks then
			result = api_storage_object_acks.create(result)
		end
		return result
	end)
end

--- delete_storage_objects
-- Delete one or more objects by ID or username.
-- @param client Client.
-- @param objectIds (array) Batch of storage objects.

-- @param callback (function) Optional callback function
-- A coroutine is used and the result is returned if no callback function is provided.
-- @param retry_policy (function) Optional retry policy used specifically for this call or nil
-- @param cancellation_token (table) Optional cancellation token for this call
-- @return The result.
function M.delete_storage_objects(client, objectIds, callback, retry_policy, cancellation_token)
	assert(client, "You must provide a client")
	assert(not objectIds or type(objectIds) == "table", "Argument 'objectIds' must be 'nil' or of type 'table'")


	local url_path = "/v2/storage/delete"

	local query_params = {}

	local post_data = nil
	post_data = json.encode({
	objectIds = objectIds,
	})

	return http(client, callback, url_path, query_params, "PUT", post_data, retry_policy, cancellation_token, function(result)
		return result
	end)
end

--- list_storage_objects
-- List publicly readable storage objects in a given collection.
-- @param client Client.
-- @param collection_str () The collection which stores the object.
-- @param user_id_str () ID of the user.
-- @param limit_int () The number of storage objects to list. Between 1 and 100.
-- @param cursor_str () The cursor to page through results from.
--
--value from StorageObjectList.cursor.
-- @param callback (function) Optional callback function
-- A coroutine is used and the result is returned if no callback function is provided.
-- @param retry_policy (function) Optional retry policy used specifically for this call or nil
-- @param cancellation_token (table) Optional cancellation token for this call
-- @return The result.
function M.list_storage_objects(client, collection_str, user_id_str, limit_int, cursor_str, callback, retry_policy, cancellation_token)
	assert(client, "You must provide a client")

	local url_path = "/v2/storage/{collection}"
	url_path = url_path:gsub("{collection}", uri_encode(collection_str))

	local query_params = {}
	query_params["userId"] = user_id_str
	query_params["limit"] = limit_int
	query_params["cursor"] = cursor_str

	local post_data = nil

	return http(client, callback, url_path, query_params, "GET", post_data, retry_policy, cancellation_token, function(result)
		if not result.error and api_storage_object_list then
			result = api_storage_object_list.create(result)
		end
		return result
	end)
end

--- list_storage_objects2
-- List publicly readable storage objects in a given collection.
-- @param client Client.
-- @param collection_str () The collection which stores the object.
-- @param user_id_str () ID of the user.
-- @param limit_int () The number of storage objects to list. Between 1 and 100.
-- @param cursor_str () The cursor to page through results from.
--
--value from StorageObjectList.cursor.
-- @param callback (function) Optional callback function
-- A coroutine is used and the result is returned if no callback function is provided.
-- @param retry_policy (function) Optional retry policy used specifically for this call or nil
-- @param cancellation_token (table) Optional cancellation token for this call
-- @return The result.
function M.list_storage_objects2(client, collection_str, user_id_str, limit_int, cursor_str, callback, retry_policy, cancellation_token)
	assert(client, "You must provide a client")

	local url_path = "/v2/storage/{collection}/{userId}"
	url_path = url_path:gsub("{collection}", uri_encode(collection_str))
	url_path = url_path:gsub("{userId}", uri_encode(user_id_str))

	local query_params = {}
	query_params["limit"] = limit_int
	query_params["cursor"] = cursor_str

	local post_data = nil

	return http(client, callback, url_path, query_params, "GET", post_data, retry_policy, cancellation_token, function(result)
		if not result.error and api_storage_object_list then
			result = api_storage_object_list.create(result)
		end
		return result
	end)
end

--- list_tournaments
-- List current or upcoming tournaments.
-- @param client Client.
-- @param category_start_int () The start of the categories to include. Defaults to 0.
-- @param category_end_int () The end of the categories to include. Defaults to 128.
-- @param start_time_int () The start time for tournaments. Defaults to epoch.
-- @param end_time_int () The end time for tournaments. Defaults to +1 year from current Unix time.
-- @param limit_int () Max number of records to return. Between 1 and 100.
-- @param cursor_str () A next page cursor for listings (optional).
-- @param callback (function) Optional callback function
-- A coroutine is used and the result is returned if no callback function is provided.
-- @param retry_policy (function) Optional retry policy used specifically for this call or nil
-- @param cancellation_token (table) Optional cancellation token for this call
-- @return The result.
function M.list_tournaments(client, category_start_int, category_end_int, start_time_int, end_time_int, limit_int, cursor_str, callback, retry_policy, cancellation_token)
	assert(client, "You must provide a client")

	local url_path = "/v2/tournament"

	local query_params = {}
	query_params["categoryStart"] = category_start_int
	query_params["categoryEnd"] = category_end_int
	query_params["startTime"] = start_time_int
	query_params["endTime"] = end_time_int
	query_params["limit"] = limit_int
	query_params["cursor"] = cursor_str

	local post_data = nil

	return http(client, callback, url_path, query_params, "GET", post_data, retry_policy, cancellation_token, function(result)
		if not result.error and api_tournament_list then
			result = api_tournament_list.create(result)
		end
		return result
	end)
end

--- delete_tournament_record
-- Delete a tournament record.
-- @param client Client.
-- @param tournament_id_str () The tournament ID to delete from.
-- @param callback (function) Optional callback function
-- A coroutine is used and the result is returned if no callback function is provided.
-- @param retry_policy (function) Optional retry policy used specifically for this call or nil
-- @param cancellation_token (table) Optional cancellation token for this call
-- @return The result.
function M.delete_tournament_record(client, tournament_id_str, callback, retry_policy, cancellation_token)
	assert(client, "You must provide a client")

	local url_path = "/v2/tournament/{tournamentId}"
	url_path = url_path:gsub("{tournamentId}", uri_encode(tournament_id_str))

	local query_params = {}

	local post_data = nil

	return http(client, callback, url_path, query_params, "DELETE", post_data, retry_policy, cancellation_token, function(result)
		return result
	end)
end

--- list_tournament_records
-- List tournament records.
-- @param client Client.
-- @param tournament_id_str () The ID of the tournament to list for.
-- @param owner_ids_arr () One or more owners to retrieve records for.
-- @param limit_int () Max number of records to return. Between 1 and 100.
-- @param cursor_str () A next or previous page cursor.
-- @param expiry_str () Expiry in seconds (since epoch) to begin fetching records from.
-- @param callback (function) Optional callback function
-- A coroutine is used and the result is returned if no callback function is provided.
-- @param retry_policy (function) Optional retry policy used specifically for this call or nil
-- @param cancellation_token (table) Optional cancellation token for this call
-- @return The result.
function M.list_tournament_records(client, tournament_id_str, owner_ids_arr, limit_int, cursor_str, expiry_str, callback, retry_policy, cancellation_token)
	assert(client, "You must provide a client")

	local url_path = "/v2/tournament/{tournamentId}"
	url_path = url_path:gsub("{tournamentId}", uri_encode(tournament_id_str))

	local query_params = {}
	query_params["ownerIds"] = owner_ids_arr
	query_params["limit"] = limit_int
	query_params["cursor"] = cursor_str
	query_params["expiry"] = expiry_str

	local post_data = nil

	return http(client, callback, url_path, query_params, "GET", post_data, retry_policy, cancellation_token, function(result)
		if not result.error and api_tournament_record_list then
			result = api_tournament_record_list.create(result)
		end
		return result
	end)
end

--- write_tournament_record2
-- Write a record to a tournament.
-- @param client Client.
-- @param tournament_id_str () The tournament ID to write the record for.
-- @param metadata (string) A JSON object of additional properties (optional).
-- @param operator () Operator override.
-- @param score (string) The score value to submit.
-- @param subscore (string) An optional secondary value.

-- @param callback (function) Optional callback function
-- A coroutine is used and the result is returned if no callback function is provided.
-- @param retry_policy (function) Optional retry policy used specifically for this call or nil
-- @param cancellation_token (table) Optional cancellation token for this call
-- @return The result.
function M.write_tournament_record2(client, tournament_id_str, metadata, operator, score, subscore, callback, retry_policy, cancellation_token)
	assert(client, "You must provide a client")
	assert(not metadata or type(metadata) == "string", "Argument 'metadata' must be 'nil' or of type 'string'")
	assert(not operator or type(operator) == "string", "Argument 'operator' must be 'nil' or of type 'string'")
	assert(not score or type(score) == "string", "Argument 'score' must be 'nil' or of type 'string'")
	assert(not subscore or type(subscore) == "string", "Argument 'subscore' must be 'nil' or of type 'string'")


	local url_path = "/v2/tournament/{tournamentId}"
	url_path = url_path:gsub("{tournamentId}", uri_encode(tournament_id_str))

	local query_params = {}

	local post_data = nil
	post_data = json.encode({
	metadata = metadata,
	operator = operator,
	score = score,
	subscore = subscore,
	})

	return http(client, callback, url_path, query_params, "POST", post_data, retry_policy, cancellation_token, function(result)
		if not result.error and api_leaderboard_record then
			result = api_leaderboard_record.create(result)
		end
		return result
	end)
end

--- write_tournament_record
-- Write a record to a tournament.
-- @param client Client.
-- @param tournament_id_str () The tournament ID to write the record for.
-- @param metadata (string) A JSON object of additional properties (optional).
-- @param operator () Operator override.
-- @param score (string) The score value to submit.
-- @param subscore (string) An optional secondary value.

-- @param callback (function) Optional callback function
-- A coroutine is used and the result is returned if no callback function is provided.
-- @param retry_policy (function) Optional retry policy used specifically for this call or nil
-- @param cancellation_token (table) Optional cancellation token for this call
-- @return The result.
function M.write_tournament_record(client, tournament_id_str, metadata, operator, score, subscore, callback, retry_policy, cancellation_token)
	assert(client, "You must provide a client")
	assert(not metadata or type(metadata) == "string", "Argument 'metadata' must be 'nil' or of type 'string'")
	assert(not operator or type(operator) == "string", "Argument 'operator' must be 'nil' or of type 'string'")
	assert(not score or type(score) == "string", "Argument 'score' must be 'nil' or of type 'string'")
	assert(not subscore or type(subscore) == "string", "Argument 'subscore' must be 'nil' or of type 'string'")


	local url_path = "/v2/tournament/{tournamentId}"
	url_path = url_path:gsub("{tournamentId}", uri_encode(tournament_id_str))

	local query_params = {}

	local post_data = nil
	post_data = json.encode({
	metadata = metadata,
	operator = operator,
	score = score,
	subscore = subscore,
	})

	return http(client, callback, url_path, query_params, "PUT", post_data, retry_policy, cancellation_token, function(result)
		if not result.error and api_leaderboard_record then
			result = api_leaderboard_record.create(result)
		end
		return result
	end)
end

--- join_tournament
-- Attempt to join an open and running tournament.
-- @param client Client.
-- @param tournament_id_str () The ID of the tournament to join. The tournament must already exist.
-- @param callback (function) Optional callback function
-- A coroutine is used and the result is returned if no callback function is provided.
-- @param retry_policy (function) Optional retry policy used specifically for this call or nil
-- @param cancellation_token (table) Optional cancellation token for this call
-- @return The result.
function M.join_tournament(client, tournament_id_str, callback, retry_policy, cancellation_token)
	assert(client, "You must provide a client")

	local url_path = "/v2/tournament/{tournamentId}/join"
	url_path = url_path:gsub("{tournamentId}", uri_encode(tournament_id_str))

	local query_params = {}

	local post_data = nil

	return http(client, callback, url_path, query_params, "POST", post_data, retry_policy, cancellation_token, function(result)
		return result
	end)
end

--- list_tournament_records_around_owner
-- List tournament records for a given owner.
-- @param client Client.
-- @param tournament_id_str () The ID of the tournament to list for.
-- @param owner_id_str () The owner to retrieve records around.
-- @param limit_int () Max number of records to return. Between 1 and 100.
-- @param expiry_str () Expiry in seconds (since epoch) to begin fetching records from.
-- @param cursor_str () A next or previous page cursor.
-- @param callback (function) Optional callback function
-- A coroutine is used and the result is returned if no callback function is provided.
-- @param retry_policy (function) Optional retry policy used specifically for this call or nil
-- @param cancellation_token (table) Optional cancellation token for this call
-- @return The result.
function M.list_tournament_records_around_owner(client, tournament_id_str, owner_id_str, limit_int, expiry_str, cursor_str, callback, retry_policy, cancellation_token)
	assert(client, "You must provide a client")

	local url_path = "/v2/tournament/{tournamentId}/owner/{ownerId}"
	url_path = url_path:gsub("{tournamentId}", uri_encode(tournament_id_str))
	url_path = url_path:gsub("{ownerId}", uri_encode(owner_id_str))

	local query_params = {}
	query_params["limit"] = limit_int
	query_params["expiry"] = expiry_str
	query_params["cursor"] = cursor_str

	local post_data = nil

	return http(client, callback, url_path, query_params, "GET", post_data, retry_policy, cancellation_token, function(result)
		if not result.error and api_tournament_record_list then
			result = api_tournament_record_list.create(result)
		end
		return result
	end)
end

--- get_users
-- Fetch zero or more users by ID and/or username.
-- @param client Client.
-- @param ids_arr () The account id of a user.
-- @param usernames_arr () The account username of a user.
-- @param facebook_ids_arr () The Facebook ID of a user.
-- @param callback (function) Optional callback function
-- A coroutine is used and the result is returned if no callback function is provided.
-- @param retry_policy (function) Optional retry policy used specifically for this call or nil
-- @param cancellation_token (table) Optional cancellation token for this call
-- @return The result.
function M.get_users(client, ids_arr, usernames_arr, facebook_ids_arr, callback, retry_policy, cancellation_token)
	assert(client, "You must provide a client")

	local url_path = "/v2/user"

	local query_params = {}
	query_params["ids"] = ids_arr
	query_params["usernames"] = usernames_arr
	query_params["facebookIds"] = facebook_ids_arr

	local post_data = nil

	return http(client, callback, url_path, query_params, "GET", post_data, retry_policy, cancellation_token, function(result)
		if not result.error and api_users then
			result = api_users.create(result)
		end
		return result
	end)
end

--- list_user_groups
-- List groups the current user belongs to.
-- @param client Client.
-- @param user_id_str () ID of the user.
-- @param limit_int () Max number of records to return. Between 1 and 100.
-- @param state_int () The user group state to list.
-- @param cursor_str () An optional next page cursor.
-- @param callback (function) Optional callback function
-- A coroutine is used and the result is returned if no callback function is provided.
-- @param retry_policy (function) Optional retry policy used specifically for this call or nil
-- @param cancellation_token (table) Optional cancellation token for this call
-- @return The result.
function M.list_user_groups(client, user_id_str, limit_int, state_int, cursor_str, callback, retry_policy, cancellation_token)
	assert(client, "You must provide a client")

	local url_path = "/v2/user/{userId}/group"
	url_path = url_path:gsub("{userId}", uri_encode(user_id_str))

	local query_params = {}
	query_params["limit"] = limit_int
	query_params["state"] = state_int
	query_params["cursor"] = cursor_str

	local post_data = nil

	return http(client, callback, url_path, query_params, "GET", post_data, retry_policy, cancellation_token, function(result)
		if not result.error and api_user_group_list then
			result = api_user_group_list.create(result)
		end
		return result
	end)
end


local _config = {}

--- Create a Nakama client instance.
-- @param config A table of configuration options.
-- config.engine - Engine specific implementations.
-- config.host
-- config.port
-- config.timeout
-- config.use_ssl - Use secure or non-secure sockets.
-- config.bearer_token
-- config.username
-- config.password
-- @return Nakama Client instance.
function M.create_client(config)
	assert(config, "You must provide a configuration")
	assert(config.host, "You must provide a host")
	assert(config.port, "You must provide a port")
	assert(config.engine, "You must provide an engine")
	assert(type(config.engine.http) == "function", "The engine must provide the 'http' function")
	assert(type(config.engine.socket_create) == "function", "The engine must provide the 'socket_create' function")
	assert(type(config.engine.socket_connect) == "function", "The engine must provide the 'socket_connect' function")
	assert(type(config.engine.socket_send) == "function", "The engine must provide the 'socket_send' function")
	log("init()")

	local client = {}
	local scheme = config.use_ssl and "https" or "http"
	client.engine = config.engine
	client.config = {}
	client.config.host = config.host
	client.config.port = config.port
	client.config.http_uri = ("%s://%s:%d"):format(scheme, config.host, config.port)
	client.config.bearer_token = config.bearer_token
	client.config.username = config.username
	client.config.password = config.password
	client.config.timeout = config.timeout or 10
	client.config.use_ssl = config.use_ssl
	client.config.retry_policy = config.retry_policy or retries.none()

	local ignored_fns = { create_client = true, sync = true }
	for name,fn in pairs(M) do
		if not ignored_fns[name] and type(fn) == "function" then
			--log("setting " .. name)
			client[name] = function(...) return fn(client, ...) end
		end
	end

	return client
end


--- Create a Nakama socket.
-- @param client The client to create the socket for.
-- @return Socket instance.
function M.create_socket(client)
	assert(client, "You must provide a client")
	return socket.create(client)
end

--- Set Nakama client bearer token.
-- @param client Nakama client.
-- @param bearer_token Authorization bearer token.
function M.set_bearer_token(client, bearer_token)
	assert(client, "You must provide a client")
	client.config.bearer_token = bearer_token
end



return M
