package main

const MAIN_TEMPLATE string = `-- Code generated by codegen/generate-rest.go. DO NOT EDIT.

--[[--
The Nakama client SDK for Defold.

@module nakama
]]

%%COMMON_TEMPLATE%%

local _config = {}

--- Create a Nakama client instance.
-- @param config A table of configuration options.
-- config.engine - Engine specific implementations.
-- config.host
-- config.port
-- config.timeout
-- config.use_ssl - Use secure or non-secure sockets.
-- config.bearer_token
-- config.username
-- config.password
-- @return Nakama Client instance.
function M.create_client(config)
	assert(config, "You must provide a configuration")
	assert(config.host, "You must provide a host")
	assert(config.port, "You must provide a port")
	assert(config.engine, "You must provide an engine")
	assert(type(config.engine.http) == "function", "The engine must provide the 'http' function")
	assert(type(config.engine.socket_create) == "function", "The engine must provide the 'socket_create' function")
	assert(type(config.engine.socket_connect) == "function", "The engine must provide the 'socket_connect' function")
	assert(type(config.engine.socket_send) == "function", "The engine must provide the 'socket_send' function")
	log("init()")

	local client = {}
	local scheme = config.use_ssl and "https" or "http"
	client.engine = config.engine
	client.config = {}
	client.config.host = config.host
	client.config.port = config.port
	client.config.http_uri = ("%s://%s:%d"):format(scheme, config.host, config.port)
	client.config.bearer_token = config.bearer_token
	client.config.username = config.username
	client.config.password = config.password
	client.config.timeout = config.timeout or 10
	client.config.use_ssl = config.use_ssl
	client.config.retry_policy = config.retry_policy or retries.none()

	local ignored_fns = { create_client = true, sync = true }
	for name,fn in pairs(M) do
		if not ignored_fns[name] and type(fn) == "function" then
			--log("setting " .. name)
			client[name] = function(...) return fn(client, ...) end
		end
	end

	return client
end


--- Create a Nakama socket.
-- @param client The client to create the socket for.
-- @return Socket instance.
function M.create_socket(client)
	assert(client, "You must provide a client")
	return socket.create(client)
end

--- Set Nakama client bearer token.
-- @param client Nakama client.
-- @param bearer_token Authorization bearer token.
function M.set_bearer_token(client, bearer_token)
	assert(client, "You must provide a client")
	client.config.bearer_token = bearer_token
end



return M
`
