<p align="center">
   <img src="https://raw.githubusercontent.com/hellzerg/optimizer/master/banner.png">
</p>

<p align="center">
	<a href="https://github.com/hellzerg/optimizer/releases/download/16.7/Optimizer-16.7.exe" target="_blank">
		<img src="https://raw.githubusercontent.com/hellzerg/optimizer/master/download-button.png">
		<br>
		<img src="https://raw.githubusercontent.com/hellzerg/optimizer/master/flags.png">
	</a>
</p>

<center>
<h2>ℹ️ Advanced Privacy and Security Configuration Utility</h2> 
</center>

Welcome to Optimizer, an advanced configuration utility designed to enhance your privacy and security on Windows. This tool is highly recommended for use after a fresh installation of Windows to achieve maximum privacy and security benefits. Depending on your Windows version, Optimizer can also help you apply specific system tweaks.

<center>
<h2> 🏗️ Key Features:</h2> 
</center>

- Full multilingual support (24 languages available)
- Enhance system and network performance
- Disable unnecessary Windows services
- Turn off Windows telemetry, Cortana, and more
- Disable Office telemetry (works with Office 2016 or newer)
- Stop automatic Windows 10/11 updates
- Download multiple useful apps quickly
- Disable CoPilot AI in Windows 11 & Edge
- Enable UTC time globally
- Advanced tweaks like disabling HPET, OneDrive, etc.
- Uninstall UWP apps
- Clean system drive and browser profiles
- Fix common registry issues
- Ping IPs and assess latency
- Search IPs on SHODAN.io
- Quickly change DNS server (from a pre-made list)
- Flush DNS cache
- Remove unwanted startup programs
- Edit your HOSTS file
- Edit your System Variables paths
- Identify and terminate file lock handles
- Hardware inspection tool
- Add items to the desktop right-click menu
- Define custom commands for the run dialog
- Support silent runs using a template file

<center>
<h2> ⬇️ Downloads</h2> 
</center>

Find the latest release of Optimizer on the [Releases](https://github.com/hellzerg/optimizer/releases) page.

<center>
<h2>🖼️ Screenshots</h2> 
</center>

View Optimizer in action through our [Screenshots](https://github.com/hellzerg/optimizer/blob/master/IMAGES.md) collection.

<center>
<h2> 🆘 How to Disable Defender in Windows 10 1903 and Later</h2> 
</center>

- Restart in SAFE-MODE and run Optimizer with `/disabledefender` switch
- OR -
- Execute Optimizer with `/restart=disabledefender` switch for automated disabling

<center>
<h2>🔨 Automation using Templating</h2> 
</center>

Explore the possibilities of automation with Optimizer through our [Automation Guide](https://github.com/hellzerg/optimizer/blob/master/AUTOMATION.md).

<center>
<h2> 🔨 Command-line Options</h2> 
</center>

Check out the [Command-line Options](https://github.com/hellzerg/optimizer/blob/master/CONFS.md) available for Optimizer.

<center>
<h2> ❓ Frequently Asked Questions</h2> 
</center>

Find answers to common queries in the [FAQ Section](https://github.com/hellzerg/optimizer/blob/master/FAQ.md).

<center>
<h2> 📰 Changelog</h2> 
</center>

Stay updated with the latest changes through the [Changelog](https://github.com/hellzerg/optimizer/blob/master/CHANGELOG.md).

<center>
<h2>🛡️ Security Policy</h2> 
</center>

Learn about our security measures in the [Security Policy](https://github.com/hellzerg/optimizer/blob/master/SECURITY.md).

<center>
<h2> 💻 Compatibility</h2> 
</center>

- Requires .NET Framework 4.8.1
- Compatible with Windows 7, 8, 8.1, 10, 11
- Can run on Windows Server 2008, 2012, 2016, 2019, 2022 using `/unsafe` switch

<center>
<h2> 📊 Details</h2> 
</center>

- Latest version: 16.7 (Released: August 18, 2024)
- SHA256: 03A234060541B686AC4265754AFF43DF9325C21383F90E17F831E67965D717F8

<center>
<h2> ☕ Buy me a delicious espresso</h2>
</center>

If you find this tool useful, consider showing your support by [donating through PayPal](https://www.paypal.com/paypalme/supportoptimizer).

<center>
<h2> 🌐 Join our Community</h2>
</center>

Be a part of our [Discord](https://discord.gg/RmHYWMxWfJ) community.

<center>
<h2> ❤️ Credits and Acknowledgments</h2>
</center>

- [ByteSize](https://github.com/omar/ByteSize) - A useful library by Omar Rahman
- ColorPicker - Theme engine, courtesy of cat ([GitHub Profile](https://github.com/vadiscode))

<center>
<h2> ❤️ Translations</h2>
</center>

We'd like to extend our gratitude to the following contributors for their translations:

- Russian: mrkaban
- German: theflamehd
- Turkish: Kheasyque
- Spanish: danielcshn
- Portuguese: Cassio
- French: RAFF47
- Italian: Ziocash
- Chinese: btwise
- Czech: Tom Longhorn
- Taiwanese: H3XDaemon
- Korean: VenusGirl
- Polish: Wilamaxin
- Arabic: MesterPerfect
- Romanian: BeamingNG, DefaultUser9148
- Dutch: svanlaere
- Ukrainian: Kirill Ermakov
- Japanese: Yamada Hayao, creeper-0910
- Kurdish: Parwar Andam
- Hungarian: Zan
- Farsi: MjavadH
- Nepali: chapagetti
- Hellenic
- Bulgarian
- Indonesian: ftrsndrya
- Croatian: zZan54

<center>
<h2> ❤️ Contribute with a translation</h2>
</center>

If you would like to translate the app into your language, you can do so, by translating the EN.json and making a PR.
Don't forget to mention your language's official name, as well as its national flag.
- [EN.json](https://github.com/hellzerg/optimizer/blob/master/Optimizer/Resources/i18n/EN.json)