# Food Order Management JSP Project

This repository contains a Food Order Management project implemented using JSP (JavaServer Pages) technology. The project focuses on creating a web-based platform that allows users to browse a menu, select food items, and place orders. The project is designed to demonstrate the use of JSP, HTML, CSS, and Java for building a simple food ordering system.

## Table of Contents

- [Introduction](#introduction)
- [Features](#features)
- [Technologies Used](#technologies-used)
- [Setup](#setup)
- [Usage](#usage)
- [Contributing](#contributing)
- [License](#license)

## Introduction

The Food Order Management JSP Project is a web application that aims to provide users with a convenient way to order food online. Users can browse through the available menu items, add items to their cart, and place orders for home delivery or pickup. The project showcases the implementation of fundamental web development concepts using JSP and Java.

## Features

- User Registration and Login: Users can create accounts and log in to the system to access personalized features.
- Browse Menu: Users can view the list of available food items along with their descriptions and prices.
- Add to Cart: Users can add items to their cart while browsing the menu.
- Cart Management: Users can view their cart, modify quantities, and remove items.
- Place Order: Users can place orders based on the items in their cart.
- Order History: Users can view their order history and track the status of their orders.
- Admin Panel: Admin users can manage menu items, view orders, and update order status.

## Technologies Used

- JavaServer Pages (JSP): For dynamic content generation and interaction with Java backend.
- Java Servlets: Handle requests, manage sessions, and interact with the database.
- HTML and CSS: Structure and style the web pages.
- MySQL: Database management and storage of user accounts, menu items, and orders.

## Setup

1. Clone the repository: `git clone https://github.com/your-username/food-order-management-jsp.git`
2. Set up a MySQL database using the provided SQL scripts.
3. Configure the database connection settings in the `WEB-INF/web.xml` file.
4. Deploy the project on a servlet container (e.g., Apache Tomcat).
5. Access the application through a web browser.

## Usage

1. Register a new account or log in with existing credentials.
2. Browse the menu and add items to your cart.
3. Go to the cart page to review your order and make any modifications.
4. Proceed to the checkout page, provide delivery details, and place your order.
5. Admin users can log in to the admin panel to manage menu items and view orders.

## Contributing

Contributions are welcome! If you find any issues or want to enhance the project, feel free to submit a pull request.

## License

This project is licensed under the [MIT License](LICENSE).

---
## Insttruction to setup Project
### 1.install apache tomcat (the latest version) on your system.
### 2.create a folder name as tomcat and put installed apache in this folder which should be like(apache-tomcat-10.0.5)
### 3.then open tomcat folder like this tomcat->apache-tomcat-10.0.5->webapps
### 4.create a folder name as jsp under webapps folder after it open jsp folder 
### 5.create a folder name as restaurent(this is your project name you can change it)
### 6.open restaurent folder and put all jsp codes under it (exension should be .jsp)

### then start tomcat(to start double click windows user)
### mac user open terminal and write following commands cd tomcat/cd apache-tomcat-10.0.5/cd bin then type ./startup.sh tomcat has beebn started

### then go to the your browser and type in search bar localhost//8080:restaturent/jsp/home.jsp( it is your homepage name with extension it may be different)

## output 


![Screenshot 2021-06-04 at 4 18 17 PM](https://user-images.githubusercontent.com/78723011/120791567-fea23c00-c551-11eb-9db2-91a9308f6b83.png)
![Screenshot 2021-06-04 at 4 18 26 PM](https://user-images.githubusercontent.com/78723011/120791617-0cf05800-c552-11eb-90a9-d7223c4de77b.png)
![Screenshot 2021-06-04 at 4 18 38 PM](https://user-images.githubusercontent.com/78723011/120791714-2b565380-c552-11eb-9f22-f35894d60527.png)
![Screenshot 2021-06-04 at 4 18 46 PM](https://user-images.githubusercontent.com/78723011/120791798-43c66e00-c552-11eb-8c24-224835983a7c.png)
![Screenshot 2021-06-04 at 4 18 52 PM](https://user-images.githubusercontent.com/78723011/120791836-517bf380-c552-11eb-9b22-51a987915698.png)
![Screenshot 2021-06-04 at 4 19 02 PM](https://user-images.githubusercontent.com/78723011/120791883-5f317900-c552-11eb-9891-0b79d74c9483.png)
