// Copyright (c) HashiCorp, Inc.
// SPDX-License-Identifier: MPL-2.0

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.3.0
// - protoc             (unknown)
// source: plugin/v1/storage_plugin_service.proto

package plugin

import (
	context "context"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

const (
	StoragePluginService_OnCreateStorageBucket_FullMethodName = "/plugin.v1.StoragePluginService/OnCreateStorageBucket"
	StoragePluginService_OnUpdateStorageBucket_FullMethodName = "/plugin.v1.StoragePluginService/OnUpdateStorageBucket"
	StoragePluginService_OnDeleteStorageBucket_FullMethodName = "/plugin.v1.StoragePluginService/OnDeleteStorageBucket"
	StoragePluginService_ValidatePermissions_FullMethodName   = "/plugin.v1.StoragePluginService/ValidatePermissions"
	StoragePluginService_HeadObject_FullMethodName            = "/plugin.v1.StoragePluginService/HeadObject"
	StoragePluginService_GetObject_FullMethodName             = "/plugin.v1.StoragePluginService/GetObject"
	StoragePluginService_PutObject_FullMethodName             = "/plugin.v1.StoragePluginService/PutObject"
	StoragePluginService_DeleteObjects_FullMethodName         = "/plugin.v1.StoragePluginService/DeleteObjects"
)

// StoragePluginServiceClient is the client API for StoragePluginService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type StoragePluginServiceClient interface {
	// OnCreateStorageBucket is a hook that runs when a
	// storage bucket is created.
	OnCreateStorageBucket(ctx context.Context, in *OnCreateStorageBucketRequest, opts ...grpc.CallOption) (*OnCreateStorageBucketResponse, error)
	// OnUpdateStorageBucket is a hook that runs when a storage bucket is
	// updated.
	OnUpdateStorageBucket(ctx context.Context, in *OnUpdateStorageBucketRequest, opts ...grpc.CallOption) (*OnUpdateStorageBucketResponse, error)
	// OnDeleteStorageBucket is a hook that runs when a storage bucket is
	// deleted.
	OnDeleteStorageBucket(ctx context.Context, in *OnDeleteStorageBucketRequest, opts ...grpc.CallOption) (*OnDeleteStorageBucketResponse, error)
	// ValidatePermissions is a hook that checks if the secrets associated with
	// the storage bucket meet the requirements of the plugin.
	ValidatePermissions(ctx context.Context, in *ValidatePermissionsRequest, opts ...grpc.CallOption) (*ValidatePermissionsResponse, error)
	// HeadObject is a hook that retrieves metadata about an object.
	HeadObject(ctx context.Context, in *HeadObjectRequest, opts ...grpc.CallOption) (*HeadObjectResponse, error)
	// GetObject is a hook that retrieves objects.
	GetObject(ctx context.Context, in *GetObjectRequest, opts ...grpc.CallOption) (StoragePluginService_GetObjectClient, error)
	// PutObject is a hook that reads a file stored on local disk and
	// stores it to an external object store.
	PutObject(ctx context.Context, in *PutObjectRequest, opts ...grpc.CallOption) (*PutObjectResponse, error)
	// DeleteObjects deletes one or many files in an external object store
	// via a provided key prefix.
	DeleteObjects(ctx context.Context, in *DeleteObjectsRequest, opts ...grpc.CallOption) (*DeleteObjectsResponse, error)
}

type storagePluginServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewStoragePluginServiceClient(cc grpc.ClientConnInterface) StoragePluginServiceClient {
	return &storagePluginServiceClient{cc}
}

func (c *storagePluginServiceClient) OnCreateStorageBucket(ctx context.Context, in *OnCreateStorageBucketRequest, opts ...grpc.CallOption) (*OnCreateStorageBucketResponse, error) {
	out := new(OnCreateStorageBucketResponse)
	err := c.cc.Invoke(ctx, StoragePluginService_OnCreateStorageBucket_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *storagePluginServiceClient) OnUpdateStorageBucket(ctx context.Context, in *OnUpdateStorageBucketRequest, opts ...grpc.CallOption) (*OnUpdateStorageBucketResponse, error) {
	out := new(OnUpdateStorageBucketResponse)
	err := c.cc.Invoke(ctx, StoragePluginService_OnUpdateStorageBucket_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *storagePluginServiceClient) OnDeleteStorageBucket(ctx context.Context, in *OnDeleteStorageBucketRequest, opts ...grpc.CallOption) (*OnDeleteStorageBucketResponse, error) {
	out := new(OnDeleteStorageBucketResponse)
	err := c.cc.Invoke(ctx, StoragePluginService_OnDeleteStorageBucket_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *storagePluginServiceClient) ValidatePermissions(ctx context.Context, in *ValidatePermissionsRequest, opts ...grpc.CallOption) (*ValidatePermissionsResponse, error) {
	out := new(ValidatePermissionsResponse)
	err := c.cc.Invoke(ctx, StoragePluginService_ValidatePermissions_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *storagePluginServiceClient) HeadObject(ctx context.Context, in *HeadObjectRequest, opts ...grpc.CallOption) (*HeadObjectResponse, error) {
	out := new(HeadObjectResponse)
	err := c.cc.Invoke(ctx, StoragePluginService_HeadObject_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *storagePluginServiceClient) GetObject(ctx context.Context, in *GetObjectRequest, opts ...grpc.CallOption) (StoragePluginService_GetObjectClient, error) {
	stream, err := c.cc.NewStream(ctx, &StoragePluginService_ServiceDesc.Streams[0], StoragePluginService_GetObject_FullMethodName, opts...)
	if err != nil {
		return nil, err
	}
	x := &storagePluginServiceGetObjectClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type StoragePluginService_GetObjectClient interface {
	Recv() (*GetObjectResponse, error)
	grpc.ClientStream
}

type storagePluginServiceGetObjectClient struct {
	grpc.ClientStream
}

func (x *storagePluginServiceGetObjectClient) Recv() (*GetObjectResponse, error) {
	m := new(GetObjectResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *storagePluginServiceClient) PutObject(ctx context.Context, in *PutObjectRequest, opts ...grpc.CallOption) (*PutObjectResponse, error) {
	out := new(PutObjectResponse)
	err := c.cc.Invoke(ctx, StoragePluginService_PutObject_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *storagePluginServiceClient) DeleteObjects(ctx context.Context, in *DeleteObjectsRequest, opts ...grpc.CallOption) (*DeleteObjectsResponse, error) {
	out := new(DeleteObjectsResponse)
	err := c.cc.Invoke(ctx, StoragePluginService_DeleteObjects_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// StoragePluginServiceServer is the server API for StoragePluginService service.
// All implementations must embed UnimplementedStoragePluginServiceServer
// for forward compatibility
type StoragePluginServiceServer interface {
	// OnCreateStorageBucket is a hook that runs when a
	// storage bucket is created.
	OnCreateStorageBucket(context.Context, *OnCreateStorageBucketRequest) (*OnCreateStorageBucketResponse, error)
	// OnUpdateStorageBucket is a hook that runs when a storage bucket is
	// updated.
	OnUpdateStorageBucket(context.Context, *OnUpdateStorageBucketRequest) (*OnUpdateStorageBucketResponse, error)
	// OnDeleteStorageBucket is a hook that runs when a storage bucket is
	// deleted.
	OnDeleteStorageBucket(context.Context, *OnDeleteStorageBucketRequest) (*OnDeleteStorageBucketResponse, error)
	// ValidatePermissions is a hook that checks if the secrets associated with
	// the storage bucket meet the requirements of the plugin.
	ValidatePermissions(context.Context, *ValidatePermissionsRequest) (*ValidatePermissionsResponse, error)
	// HeadObject is a hook that retrieves metadata about an object.
	HeadObject(context.Context, *HeadObjectRequest) (*HeadObjectResponse, error)
	// GetObject is a hook that retrieves objects.
	GetObject(*GetObjectRequest, StoragePluginService_GetObjectServer) error
	// PutObject is a hook that reads a file stored on local disk and
	// stores it to an external object store.
	PutObject(context.Context, *PutObjectRequest) (*PutObjectResponse, error)
	// DeleteObjects deletes one or many files in an external object store
	// via a provided key prefix.
	DeleteObjects(context.Context, *DeleteObjectsRequest) (*DeleteObjectsResponse, error)
	mustEmbedUnimplementedStoragePluginServiceServer()
}

// UnimplementedStoragePluginServiceServer must be embedded to have forward compatible implementations.
type UnimplementedStoragePluginServiceServer struct {
}

func (UnimplementedStoragePluginServiceServer) OnCreateStorageBucket(context.Context, *OnCreateStorageBucketRequest) (*OnCreateStorageBucketResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method OnCreateStorageBucket not implemented")
}
func (UnimplementedStoragePluginServiceServer) OnUpdateStorageBucket(context.Context, *OnUpdateStorageBucketRequest) (*OnUpdateStorageBucketResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method OnUpdateStorageBucket not implemented")
}
func (UnimplementedStoragePluginServiceServer) OnDeleteStorageBucket(context.Context, *OnDeleteStorageBucketRequest) (*OnDeleteStorageBucketResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method OnDeleteStorageBucket not implemented")
}
func (UnimplementedStoragePluginServiceServer) ValidatePermissions(context.Context, *ValidatePermissionsRequest) (*ValidatePermissionsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ValidatePermissions not implemented")
}
func (UnimplementedStoragePluginServiceServer) HeadObject(context.Context, *HeadObjectRequest) (*HeadObjectResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method HeadObject not implemented")
}
func (UnimplementedStoragePluginServiceServer) GetObject(*GetObjectRequest, StoragePluginService_GetObjectServer) error {
	return status.Errorf(codes.Unimplemented, "method GetObject not implemented")
}
func (UnimplementedStoragePluginServiceServer) PutObject(context.Context, *PutObjectRequest) (*PutObjectResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method PutObject not implemented")
}
func (UnimplementedStoragePluginServiceServer) DeleteObjects(context.Context, *DeleteObjectsRequest) (*DeleteObjectsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteObjects not implemented")
}
func (UnimplementedStoragePluginServiceServer) mustEmbedUnimplementedStoragePluginServiceServer() {}

// UnsafeStoragePluginServiceServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to StoragePluginServiceServer will
// result in compilation errors.
type UnsafeStoragePluginServiceServer interface {
	mustEmbedUnimplementedStoragePluginServiceServer()
}

func RegisterStoragePluginServiceServer(s grpc.ServiceRegistrar, srv StoragePluginServiceServer) {
	s.RegisterService(&StoragePluginService_ServiceDesc, srv)
}

func _StoragePluginService_OnCreateStorageBucket_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(OnCreateStorageBucketRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StoragePluginServiceServer).OnCreateStorageBucket(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: StoragePluginService_OnCreateStorageBucket_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StoragePluginServiceServer).OnCreateStorageBucket(ctx, req.(*OnCreateStorageBucketRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _StoragePluginService_OnUpdateStorageBucket_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(OnUpdateStorageBucketRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StoragePluginServiceServer).OnUpdateStorageBucket(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: StoragePluginService_OnUpdateStorageBucket_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StoragePluginServiceServer).OnUpdateStorageBucket(ctx, req.(*OnUpdateStorageBucketRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _StoragePluginService_OnDeleteStorageBucket_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(OnDeleteStorageBucketRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StoragePluginServiceServer).OnDeleteStorageBucket(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: StoragePluginService_OnDeleteStorageBucket_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StoragePluginServiceServer).OnDeleteStorageBucket(ctx, req.(*OnDeleteStorageBucketRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _StoragePluginService_ValidatePermissions_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ValidatePermissionsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StoragePluginServiceServer).ValidatePermissions(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: StoragePluginService_ValidatePermissions_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StoragePluginServiceServer).ValidatePermissions(ctx, req.(*ValidatePermissionsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _StoragePluginService_HeadObject_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(HeadObjectRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StoragePluginServiceServer).HeadObject(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: StoragePluginService_HeadObject_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StoragePluginServiceServer).HeadObject(ctx, req.(*HeadObjectRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _StoragePluginService_GetObject_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(GetObjectRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(StoragePluginServiceServer).GetObject(m, &storagePluginServiceGetObjectServer{stream})
}

type StoragePluginService_GetObjectServer interface {
	Send(*GetObjectResponse) error
	grpc.ServerStream
}

type storagePluginServiceGetObjectServer struct {
	grpc.ServerStream
}

func (x *storagePluginServiceGetObjectServer) Send(m *GetObjectResponse) error {
	return x.ServerStream.SendMsg(m)
}

func _StoragePluginService_PutObject_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(PutObjectRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StoragePluginServiceServer).PutObject(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: StoragePluginService_PutObject_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StoragePluginServiceServer).PutObject(ctx, req.(*PutObjectRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _StoragePluginService_DeleteObjects_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteObjectsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StoragePluginServiceServer).DeleteObjects(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: StoragePluginService_DeleteObjects_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StoragePluginServiceServer).DeleteObjects(ctx, req.(*DeleteObjectsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// StoragePluginService_ServiceDesc is the grpc.ServiceDesc for StoragePluginService service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var StoragePluginService_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "plugin.v1.StoragePluginService",
	HandlerType: (*StoragePluginServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "OnCreateStorageBucket",
			Handler:    _StoragePluginService_OnCreateStorageBucket_Handler,
		},
		{
			MethodName: "OnUpdateStorageBucket",
			Handler:    _StoragePluginService_OnUpdateStorageBucket_Handler,
		},
		{
			MethodName: "OnDeleteStorageBucket",
			Handler:    _StoragePluginService_OnDeleteStorageBucket_Handler,
		},
		{
			MethodName: "ValidatePermissions",
			Handler:    _StoragePluginService_ValidatePermissions_Handler,
		},
		{
			MethodName: "HeadObject",
			Handler:    _StoragePluginService_HeadObject_Handler,
		},
		{
			MethodName: "PutObject",
			Handler:    _StoragePluginService_PutObject_Handler,
		},
		{
			MethodName: "DeleteObjects",
			Handler:    _StoragePluginService_DeleteObjects_Handler,
		},
	},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "GetObject",
			Handler:       _StoragePluginService_GetObject_Handler,
			ServerStreams: true,
		},
	},
	Metadata: "plugin/v1/storage_plugin_service.proto",
}
