// Copyright (c) HashiCorp, Inc.
// SPDX-License-Identifier: MPL-2.0

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.34.2
// 	protoc        (unknown)
// source: plugin/v1/storage_plugin_service.proto

package plugin

import (
	storagebuckets "github.com/hashicorp/boundary/sdk/pbs/controller/api/resources/storagebuckets"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

type StateType int32

const (
	StateType_STATE_TYPE_UNSPECIFIED StateType = 0
	StateType_STATE_TYPE_OK          StateType = 1
	StateType_STATE_TYPE_ERROR       StateType = 2
	StateType_STATE_TYPE_UNKNOWN     StateType = 3
)

// Enum value maps for StateType.
var (
	StateType_name = map[int32]string{
		0: "STATE_TYPE_UNSPECIFIED",
		1: "STATE_TYPE_OK",
		2: "STATE_TYPE_ERROR",
		3: "STATE_TYPE_UNKNOWN",
	}
	StateType_value = map[string]int32{
		"STATE_TYPE_UNSPECIFIED": 0,
		"STATE_TYPE_OK":          1,
		"STATE_TYPE_ERROR":       2,
		"STATE_TYPE_UNKNOWN":     3,
	}
)

func (x StateType) Enum() *StateType {
	p := new(StateType)
	*p = x
	return p
}

func (x StateType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (StateType) Descriptor() protoreflect.EnumDescriptor {
	return file_plugin_v1_storage_plugin_service_proto_enumTypes[0].Descriptor()
}

func (StateType) Type() protoreflect.EnumType {
	return &file_plugin_v1_storage_plugin_service_proto_enumTypes[0]
}

func (x StateType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use StateType.Descriptor instead.
func (StateType) EnumDescriptor() ([]byte, []int) {
	return file_plugin_v1_storage_plugin_service_proto_rawDescGZIP(), []int{0}
}

type OnCreateStorageBucketRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The storage bucket to create. The request may contain optional
	// secret data to help authenticate the request against a cloud
	// API.
	Bucket *storagebuckets.StorageBucket `protobuf:"bytes,10,opt,name=bucket,proto3" json:"bucket,omitempty"`
}

func (x *OnCreateStorageBucketRequest) Reset() {
	*x = OnCreateStorageBucketRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_plugin_v1_storage_plugin_service_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *OnCreateStorageBucketRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OnCreateStorageBucketRequest) ProtoMessage() {}

func (x *OnCreateStorageBucketRequest) ProtoReflect() protoreflect.Message {
	mi := &file_plugin_v1_storage_plugin_service_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OnCreateStorageBucketRequest.ProtoReflect.Descriptor instead.
func (*OnCreateStorageBucketRequest) Descriptor() ([]byte, []int) {
	return file_plugin_v1_storage_plugin_service_proto_rawDescGZIP(), []int{0}
}

func (x *OnCreateStorageBucketRequest) GetBucket() *storagebuckets.StorageBucket {
	if x != nil {
		return x.Bucket
	}
	return nil
}

type OnCreateStorageBucketResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The persisted data represents state persisted between storage bucket calls.
	Persisted *storagebuckets.StorageBucketPersisted `protobuf:"bytes,10,opt,name=persisted,proto3" json:"persisted,omitempty"`
}

func (x *OnCreateStorageBucketResponse) Reset() {
	*x = OnCreateStorageBucketResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_plugin_v1_storage_plugin_service_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *OnCreateStorageBucketResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OnCreateStorageBucketResponse) ProtoMessage() {}

func (x *OnCreateStorageBucketResponse) ProtoReflect() protoreflect.Message {
	mi := &file_plugin_v1_storage_plugin_service_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OnCreateStorageBucketResponse.ProtoReflect.Descriptor instead.
func (*OnCreateStorageBucketResponse) Descriptor() ([]byte, []int) {
	return file_plugin_v1_storage_plugin_service_proto_rawDescGZIP(), []int{1}
}

func (x *OnCreateStorageBucketResponse) GetPersisted() *storagebuckets.StorageBucketPersisted {
	if x != nil {
		return x.Persisted
	}
	return nil
}

type OnUpdateStorageBucketRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The existing state of the storage bucket.
	CurrentBucket *storagebuckets.StorageBucket `protobuf:"bytes,10,opt,name=current_bucket,json=currentBucket,proto3" json:"current_bucket,omitempty"`
	// Required. The requested new state of the storage bucket.
	// This field may contain optional secret data that has been
	// updated from the last returned persisted state.
	NewBucket *storagebuckets.StorageBucket `protobuf:"bytes,20,opt,name=new_bucket,json=newBucket,proto3" json:"new_bucket,omitempty"`
	// Required. The existing persisted secret data.
	Persisted *storagebuckets.StorageBucketPersisted `protobuf:"bytes,30,opt,name=persisted,proto3" json:"persisted,omitempty"`
}

func (x *OnUpdateStorageBucketRequest) Reset() {
	*x = OnUpdateStorageBucketRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_plugin_v1_storage_plugin_service_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *OnUpdateStorageBucketRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OnUpdateStorageBucketRequest) ProtoMessage() {}

func (x *OnUpdateStorageBucketRequest) ProtoReflect() protoreflect.Message {
	mi := &file_plugin_v1_storage_plugin_service_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OnUpdateStorageBucketRequest.ProtoReflect.Descriptor instead.
func (*OnUpdateStorageBucketRequest) Descriptor() ([]byte, []int) {
	return file_plugin_v1_storage_plugin_service_proto_rawDescGZIP(), []int{2}
}

func (x *OnUpdateStorageBucketRequest) GetCurrentBucket() *storagebuckets.StorageBucket {
	if x != nil {
		return x.CurrentBucket
	}
	return nil
}

func (x *OnUpdateStorageBucketRequest) GetNewBucket() *storagebuckets.StorageBucket {
	if x != nil {
		return x.NewBucket
	}
	return nil
}

func (x *OnUpdateStorageBucketRequest) GetPersisted() *storagebuckets.StorageBucketPersisted {
	if x != nil {
		return x.Persisted
	}
	return nil
}

type OnUpdateStorageBucketResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The persisted data represents state persisted between storage bucket calls.
	Persisted *storagebuckets.StorageBucketPersisted `protobuf:"bytes,10,opt,name=persisted,proto3" json:"persisted,omitempty"`
}

func (x *OnUpdateStorageBucketResponse) Reset() {
	*x = OnUpdateStorageBucketResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_plugin_v1_storage_plugin_service_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *OnUpdateStorageBucketResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OnUpdateStorageBucketResponse) ProtoMessage() {}

func (x *OnUpdateStorageBucketResponse) ProtoReflect() protoreflect.Message {
	mi := &file_plugin_v1_storage_plugin_service_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OnUpdateStorageBucketResponse.ProtoReflect.Descriptor instead.
func (*OnUpdateStorageBucketResponse) Descriptor() ([]byte, []int) {
	return file_plugin_v1_storage_plugin_service_proto_rawDescGZIP(), []int{3}
}

func (x *OnUpdateStorageBucketResponse) GetPersisted() *storagebuckets.StorageBucketPersisted {
	if x != nil {
		return x.Persisted
	}
	return nil
}

type OnDeleteStorageBucketRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The existing state of the storage bucket to delete.
	Bucket *storagebuckets.StorageBucket `protobuf:"bytes,10,opt,name=bucket,proto3" json:"bucket,omitempty"`
	// Required. The existing persisted secret data.
	Persisted *storagebuckets.StorageBucketPersisted `protobuf:"bytes,20,opt,name=persisted,proto3" json:"persisted,omitempty"`
}

func (x *OnDeleteStorageBucketRequest) Reset() {
	*x = OnDeleteStorageBucketRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_plugin_v1_storage_plugin_service_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *OnDeleteStorageBucketRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OnDeleteStorageBucketRequest) ProtoMessage() {}

func (x *OnDeleteStorageBucketRequest) ProtoReflect() protoreflect.Message {
	mi := &file_plugin_v1_storage_plugin_service_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OnDeleteStorageBucketRequest.ProtoReflect.Descriptor instead.
func (*OnDeleteStorageBucketRequest) Descriptor() ([]byte, []int) {
	return file_plugin_v1_storage_plugin_service_proto_rawDescGZIP(), []int{4}
}

func (x *OnDeleteStorageBucketRequest) GetBucket() *storagebuckets.StorageBucket {
	if x != nil {
		return x.Bucket
	}
	return nil
}

func (x *OnDeleteStorageBucketRequest) GetPersisted() *storagebuckets.StorageBucketPersisted {
	if x != nil {
		return x.Persisted
	}
	return nil
}

type OnDeleteStorageBucketResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *OnDeleteStorageBucketResponse) Reset() {
	*x = OnDeleteStorageBucketResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_plugin_v1_storage_plugin_service_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *OnDeleteStorageBucketResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OnDeleteStorageBucketResponse) ProtoMessage() {}

func (x *OnDeleteStorageBucketResponse) ProtoReflect() protoreflect.Message {
	mi := &file_plugin_v1_storage_plugin_service_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OnDeleteStorageBucketResponse.ProtoReflect.Descriptor instead.
func (*OnDeleteStorageBucketResponse) Descriptor() ([]byte, []int) {
	return file_plugin_v1_storage_plugin_service_proto_rawDescGZIP(), []int{5}
}

type ValidatePermissionsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The existing state of the storage bucket.
	Bucket *storagebuckets.StorageBucket `protobuf:"bytes,10,opt,name=bucket,proto3" json:"bucket,omitempty"`
}

func (x *ValidatePermissionsRequest) Reset() {
	*x = ValidatePermissionsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_plugin_v1_storage_plugin_service_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ValidatePermissionsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ValidatePermissionsRequest) ProtoMessage() {}

func (x *ValidatePermissionsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_plugin_v1_storage_plugin_service_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ValidatePermissionsRequest.ProtoReflect.Descriptor instead.
func (*ValidatePermissionsRequest) Descriptor() ([]byte, []int) {
	return file_plugin_v1_storage_plugin_service_proto_rawDescGZIP(), []int{6}
}

func (x *ValidatePermissionsRequest) GetBucket() *storagebuckets.StorageBucket {
	if x != nil {
		return x.Bucket
	}
	return nil
}

type ValidatePermissionsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *ValidatePermissionsResponse) Reset() {
	*x = ValidatePermissionsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_plugin_v1_storage_plugin_service_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ValidatePermissionsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ValidatePermissionsResponse) ProtoMessage() {}

func (x *ValidatePermissionsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_plugin_v1_storage_plugin_service_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ValidatePermissionsResponse.ProtoReflect.Descriptor instead.
func (*ValidatePermissionsResponse) Descriptor() ([]byte, []int) {
	return file_plugin_v1_storage_plugin_service_proto_rawDescGZIP(), []int{7}
}

type HeadObjectRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The existing state of the storage bucket.
	Bucket *storagebuckets.StorageBucket `protobuf:"bytes,10,opt,name=bucket,proto3" json:"bucket,omitempty"`
	// Required. The path of the object.
	Key string `protobuf:"bytes,20,opt,name=key,proto3" json:"key,omitempty"`
}

func (x *HeadObjectRequest) Reset() {
	*x = HeadObjectRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_plugin_v1_storage_plugin_service_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *HeadObjectRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*HeadObjectRequest) ProtoMessage() {}

func (x *HeadObjectRequest) ProtoReflect() protoreflect.Message {
	mi := &file_plugin_v1_storage_plugin_service_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use HeadObjectRequest.ProtoReflect.Descriptor instead.
func (*HeadObjectRequest) Descriptor() ([]byte, []int) {
	return file_plugin_v1_storage_plugin_service_proto_rawDescGZIP(), []int{8}
}

func (x *HeadObjectRequest) GetBucket() *storagebuckets.StorageBucket {
	if x != nil {
		return x.Bucket
	}
	return nil
}

func (x *HeadObjectRequest) GetKey() string {
	if x != nil {
		return x.Key
	}
	return ""
}

type HeadObjectResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The size of the object in bytes.
	ContentLength int64 `protobuf:"varint,10,opt,name=content_length,json=contentLength,proto3" json:"content_length,omitempty"`
	// Creation date of the object.
	LastModified *timestamppb.Timestamp `protobuf:"bytes,20,opt,name=last_modified,json=lastModified,proto3" json:"last_modified,omitempty"`
}

func (x *HeadObjectResponse) Reset() {
	*x = HeadObjectResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_plugin_v1_storage_plugin_service_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *HeadObjectResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*HeadObjectResponse) ProtoMessage() {}

func (x *HeadObjectResponse) ProtoReflect() protoreflect.Message {
	mi := &file_plugin_v1_storage_plugin_service_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use HeadObjectResponse.ProtoReflect.Descriptor instead.
func (*HeadObjectResponse) Descriptor() ([]byte, []int) {
	return file_plugin_v1_storage_plugin_service_proto_rawDescGZIP(), []int{9}
}

func (x *HeadObjectResponse) GetContentLength() int64 {
	if x != nil {
		return x.ContentLength
	}
	return 0
}

func (x *HeadObjectResponse) GetLastModified() *timestamppb.Timestamp {
	if x != nil {
		return x.LastModified
	}
	return nil
}

type GetObjectRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The existing state of the storage bucket.
	Bucket *storagebuckets.StorageBucket `protobuf:"bytes,10,opt,name=bucket,proto3" json:"bucket,omitempty"`
	// Required. The path of the object.
	Key string `protobuf:"bytes,20,opt,name=key,proto3" json:"key,omitempty"`
	// Optional. The maximum size of the stream response message. Defaults to 64KiB.
	ChunkSize uint32 `protobuf:"varint,30,opt,name=chunk_size,json=chunkSize,proto3" json:"chunk_size,omitempty"`
}

func (x *GetObjectRequest) Reset() {
	*x = GetObjectRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_plugin_v1_storage_plugin_service_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetObjectRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetObjectRequest) ProtoMessage() {}

func (x *GetObjectRequest) ProtoReflect() protoreflect.Message {
	mi := &file_plugin_v1_storage_plugin_service_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetObjectRequest.ProtoReflect.Descriptor instead.
func (*GetObjectRequest) Descriptor() ([]byte, []int) {
	return file_plugin_v1_storage_plugin_service_proto_rawDescGZIP(), []int{10}
}

func (x *GetObjectRequest) GetBucket() *storagebuckets.StorageBucket {
	if x != nil {
		return x.Bucket
	}
	return nil
}

func (x *GetObjectRequest) GetKey() string {
	if x != nil {
		return x.Key
	}
	return ""
}

func (x *GetObjectRequest) GetChunkSize() uint32 {
	if x != nil {
		return x.ChunkSize
	}
	return 0
}

type GetObjectResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Object data.
	FileChunk []byte `protobuf:"bytes,10,opt,name=file_chunk,json=fileChunk,proto3" json:"file_chunk,omitempty"`
}

func (x *GetObjectResponse) Reset() {
	*x = GetObjectResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_plugin_v1_storage_plugin_service_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetObjectResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetObjectResponse) ProtoMessage() {}

func (x *GetObjectResponse) ProtoReflect() protoreflect.Message {
	mi := &file_plugin_v1_storage_plugin_service_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetObjectResponse.ProtoReflect.Descriptor instead.
func (*GetObjectResponse) Descriptor() ([]byte, []int) {
	return file_plugin_v1_storage_plugin_service_proto_rawDescGZIP(), []int{11}
}

func (x *GetObjectResponse) GetFileChunk() []byte {
	if x != nil {
		return x.FileChunk
	}
	return nil
}

type PutObjectRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The existing state of the storage bucket.
	Bucket *storagebuckets.StorageBucket `protobuf:"bytes,10,opt,name=bucket,proto3" json:"bucket,omitempty"`
	// Required. The path of the object.
	Key string `protobuf:"bytes,20,opt,name=key,proto3" json:"key,omitempty"`
	// Required. The path of the object on local disk.
	Path string `protobuf:"bytes,30,opt,name=path,proto3" json:"path,omitempty"`
}

func (x *PutObjectRequest) Reset() {
	*x = PutObjectRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_plugin_v1_storage_plugin_service_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PutObjectRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PutObjectRequest) ProtoMessage() {}

func (x *PutObjectRequest) ProtoReflect() protoreflect.Message {
	mi := &file_plugin_v1_storage_plugin_service_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PutObjectRequest.ProtoReflect.Descriptor instead.
func (*PutObjectRequest) Descriptor() ([]byte, []int) {
	return file_plugin_v1_storage_plugin_service_proto_rawDescGZIP(), []int{12}
}

func (x *PutObjectRequest) GetBucket() *storagebuckets.StorageBucket {
	if x != nil {
		return x.Bucket
	}
	return nil
}

func (x *PutObjectRequest) GetKey() string {
	if x != nil {
		return x.Key
	}
	return ""
}

func (x *PutObjectRequest) GetPath() string {
	if x != nil {
		return x.Path
	}
	return ""
}

type PutObjectResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// 256-bit SHA-256 digest of the object.
	ChecksumSha_256 []byte `protobuf:"bytes,10,opt,name=checksum_sha_256,json=checksumSha256,proto3" json:"checksum_sha_256,omitempty"`
}

func (x *PutObjectResponse) Reset() {
	*x = PutObjectResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_plugin_v1_storage_plugin_service_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PutObjectResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PutObjectResponse) ProtoMessage() {}

func (x *PutObjectResponse) ProtoReflect() protoreflect.Message {
	mi := &file_plugin_v1_storage_plugin_service_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PutObjectResponse.ProtoReflect.Descriptor instead.
func (*PutObjectResponse) Descriptor() ([]byte, []int) {
	return file_plugin_v1_storage_plugin_service_proto_rawDescGZIP(), []int{13}
}

func (x *PutObjectResponse) GetChecksumSha_256() []byte {
	if x != nil {
		return x.ChecksumSha_256
	}
	return nil
}

type DeleteObjectsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The existing state of the storage bucket.
	Bucket *storagebuckets.StorageBucket `protobuf:"bytes,10,opt,name=bucket,proto3" json:"bucket,omitempty"`
	// Required. The prefix of object keys to be deleted.
	//
	// Deletes all objects whose keys start with this field. Note that object storage keys
	// use fully qualified names, including the full directory path in the object key. This
	// allows you to delete entire "folders" stored on remote by passing the directory path
	// and setting recursive to true, or only a single object by passing the object's full
	// key and setting recursive to false.
	KeyPrefix string `protobuf:"bytes,20,opt,name=key_prefix,json=keyPrefix,proto3" json:"key_prefix,omitempty"`
	// Required. Determines whether or not to delete all objects beginning with the prefix
	// or only a single key that matches the prefix in its entirety.
	//
	// Note that this means when recursive = false, key_prefix is not treated as a prefix
	// but as a fully qualified key.
	Recursive bool `protobuf:"varint,30,opt,name=recursive,proto3" json:"recursive,omitempty"`
}

func (x *DeleteObjectsRequest) Reset() {
	*x = DeleteObjectsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_plugin_v1_storage_plugin_service_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteObjectsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteObjectsRequest) ProtoMessage() {}

func (x *DeleteObjectsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_plugin_v1_storage_plugin_service_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteObjectsRequest.ProtoReflect.Descriptor instead.
func (*DeleteObjectsRequest) Descriptor() ([]byte, []int) {
	return file_plugin_v1_storage_plugin_service_proto_rawDescGZIP(), []int{14}
}

func (x *DeleteObjectsRequest) GetBucket() *storagebuckets.StorageBucket {
	if x != nil {
		return x.Bucket
	}
	return nil
}

func (x *DeleteObjectsRequest) GetKeyPrefix() string {
	if x != nil {
		return x.KeyPrefix
	}
	return ""
}

func (x *DeleteObjectsRequest) GetRecursive() bool {
	if x != nil {
		return x.Recursive
	}
	return false
}

type DeleteObjectsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The number of objects successfully deleted.
	//
	// Note that when receiving a successful response, the plugin guarantees that all
	// objects beginning with the prefix have been deleted. This response is purely
	// informational and not meant to be used for validation.
	ObjectsDeleted uint32 `protobuf:"varint,10,opt,name=objects_deleted,json=objectsDeleted,proto3" json:"objects_deleted,omitempty"`
}

func (x *DeleteObjectsResponse) Reset() {
	*x = DeleteObjectsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_plugin_v1_storage_plugin_service_proto_msgTypes[15]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteObjectsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteObjectsResponse) ProtoMessage() {}

func (x *DeleteObjectsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_plugin_v1_storage_plugin_service_proto_msgTypes[15]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteObjectsResponse.ProtoReflect.Descriptor instead.
func (*DeleteObjectsResponse) Descriptor() ([]byte, []int) {
	return file_plugin_v1_storage_plugin_service_proto_rawDescGZIP(), []int{15}
}

func (x *DeleteObjectsResponse) GetObjectsDeleted() uint32 {
	if x != nil {
		return x.ObjectsDeleted
	}
	return 0
}

type Permission struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The state of the permission.
	State StateType `protobuf:"varint,10,opt,name=state,proto3,enum=plugin.v1.StateType" json:"state,omitempty"`
	// Optional. The error details returned from the external object store service.
	ErrorDetails string `protobuf:"bytes,20,opt,name=error_details,json=errorDetails,proto3" json:"error_details,omitempty"`
	// Required. The utc timestamp of when the permission was tested.
	CheckedAt *timestamppb.Timestamp `protobuf:"bytes,30,opt,name=checked_at,json=checkedAt,proto3" json:"checked_at,omitempty"`
}

func (x *Permission) Reset() {
	*x = Permission{}
	if protoimpl.UnsafeEnabled {
		mi := &file_plugin_v1_storage_plugin_service_proto_msgTypes[16]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Permission) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Permission) ProtoMessage() {}

func (x *Permission) ProtoReflect() protoreflect.Message {
	mi := &file_plugin_v1_storage_plugin_service_proto_msgTypes[16]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Permission.ProtoReflect.Descriptor instead.
func (*Permission) Descriptor() ([]byte, []int) {
	return file_plugin_v1_storage_plugin_service_proto_rawDescGZIP(), []int{16}
}

func (x *Permission) GetState() StateType {
	if x != nil {
		return x.State
	}
	return StateType_STATE_TYPE_UNSPECIFIED
}

func (x *Permission) GetErrorDetails() string {
	if x != nil {
		return x.ErrorDetails
	}
	return ""
}

func (x *Permission) GetCheckedAt() *timestamppb.Timestamp {
	if x != nil {
		return x.CheckedAt
	}
	return nil
}

type Permissions struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. The write permission state.
	Write *Permission `protobuf:"bytes,10,opt,name=write,proto3" json:"write,omitempty"`
	// Optional. The read permission state.
	Read *Permission `protobuf:"bytes,20,opt,name=read,proto3" json:"read,omitempty"`
	// Optional. The delete permission state.
	Delete *Permission `protobuf:"bytes,30,opt,name=delete,proto3" json:"delete,omitempty"`
}

func (x *Permissions) Reset() {
	*x = Permissions{}
	if protoimpl.UnsafeEnabled {
		mi := &file_plugin_v1_storage_plugin_service_proto_msgTypes[17]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Permissions) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Permissions) ProtoMessage() {}

func (x *Permissions) ProtoReflect() protoreflect.Message {
	mi := &file_plugin_v1_storage_plugin_service_proto_msgTypes[17]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Permissions.ProtoReflect.Descriptor instead.
func (*Permissions) Descriptor() ([]byte, []int) {
	return file_plugin_v1_storage_plugin_service_proto_rawDescGZIP(), []int{17}
}

func (x *Permissions) GetWrite() *Permission {
	if x != nil {
		return x.Write
	}
	return nil
}

func (x *Permissions) GetRead() *Permission {
	if x != nil {
		return x.Read
	}
	return nil
}

func (x *Permissions) GetDelete() *Permission {
	if x != nil {
		return x.Delete
	}
	return nil
}

type StorageBucketCredentialState struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The permission states.
	State *Permissions `protobuf:"bytes,10,opt,name=state,proto3" json:"state,omitempty"`
	// Required. The version of the storage bucket.
	Version uint32 `protobuf:"varint,20,opt,name=version,proto3" json:"version,omitempty"`
}

func (x *StorageBucketCredentialState) Reset() {
	*x = StorageBucketCredentialState{}
	if protoimpl.UnsafeEnabled {
		mi := &file_plugin_v1_storage_plugin_service_proto_msgTypes[18]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *StorageBucketCredentialState) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StorageBucketCredentialState) ProtoMessage() {}

func (x *StorageBucketCredentialState) ProtoReflect() protoreflect.Message {
	mi := &file_plugin_v1_storage_plugin_service_proto_msgTypes[18]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StorageBucketCredentialState.ProtoReflect.Descriptor instead.
func (*StorageBucketCredentialState) Descriptor() ([]byte, []int) {
	return file_plugin_v1_storage_plugin_service_proto_rawDescGZIP(), []int{18}
}

func (x *StorageBucketCredentialState) GetState() *Permissions {
	if x != nil {
		return x.State
	}
	return nil
}

func (x *StorageBucketCredentialState) GetVersion() uint32 {
	if x != nil {
		return x.Version
	}
	return 0
}

var File_plugin_v1_storage_plugin_service_proto protoreflect.FileDescriptor

var file_plugin_v1_storage_plugin_service_proto_rawDesc = []byte{
	0x0a, 0x26, 0x70, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x2f, 0x76, 0x31, 0x2f, 0x73, 0x74, 0x6f, 0x72,
	0x61, 0x67, 0x65, 0x5f, 0x70, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x5f, 0x73, 0x65, 0x72, 0x76, 0x69,
	0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x09, 0x70, 0x6c, 0x75, 0x67, 0x69, 0x6e,
	0x2e, 0x76, 0x31, 0x1a, 0x3f, 0x63, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x6c, 0x65, 0x72, 0x2f,
	0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2f, 0x73, 0x74,
	0x6f, 0x72, 0x61, 0x67, 0x65, 0x62, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x73, 0x2f, 0x76, 0x31, 0x2f,
	0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x5f, 0x62, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0x71, 0x0a, 0x1c, 0x4f, 0x6e, 0x43, 0x72, 0x65, 0x61, 0x74,
	0x65, 0x53, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x42, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x51, 0x0a, 0x06, 0x62, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x18,
	0x0a, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x39, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x6c,
	0x65, 0x72, 0x2e, 0x61, 0x70, 0x69, 0x2e, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73,
	0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x62, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x73, 0x2e,
	0x76, 0x31, 0x2e, 0x53, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x42, 0x75, 0x63, 0x6b, 0x65, 0x74,
	0x52, 0x06, 0x62, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x22, 0x81, 0x01, 0x0a, 0x1d, 0x4f, 0x6e, 0x43,
	0x72, 0x65, 0x61, 0x74, 0x65, 0x53, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x42, 0x75, 0x63, 0x6b,
	0x65, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x60, 0x0a, 0x09, 0x70, 0x65,
	0x72, 0x73, 0x69, 0x73, 0x74, 0x65, 0x64, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x42, 0x2e,
	0x63, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x6c, 0x65, 0x72, 0x2e, 0x61, 0x70, 0x69, 0x2e, 0x72,
	0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65,
	0x62, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x74, 0x6f, 0x72, 0x61,
	0x67, 0x65, 0x42, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x50, 0x65, 0x72, 0x73, 0x69, 0x73, 0x74, 0x65,
	0x64, 0x52, 0x09, 0x70, 0x65, 0x72, 0x73, 0x69, 0x73, 0x74, 0x65, 0x64, 0x22, 0xbc, 0x02, 0x0a,
	0x1c, 0x4f, 0x6e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x53, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65,
	0x42, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x60, 0x0a,
	0x0e, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x74, 0x5f, 0x62, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x18,
	0x0a, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x39, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x6c,
	0x65, 0x72, 0x2e, 0x61, 0x70, 0x69, 0x2e, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73,
	0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x62, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x73, 0x2e,
	0x76, 0x31, 0x2e, 0x53, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x42, 0x75, 0x63, 0x6b, 0x65, 0x74,
	0x52, 0x0d, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x74, 0x42, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x12,
	0x58, 0x0a, 0x0a, 0x6e, 0x65, 0x77, 0x5f, 0x62, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x18, 0x14, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x39, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x6c, 0x65, 0x72,
	0x2e, 0x61, 0x70, 0x69, 0x2e, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2e, 0x73,
	0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x62, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x73, 0x2e, 0x76, 0x31,
	0x2e, 0x53, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x42, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x52, 0x09,
	0x6e, 0x65, 0x77, 0x42, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x12, 0x60, 0x0a, 0x09, 0x70, 0x65, 0x72,
	0x73, 0x69, 0x73, 0x74, 0x65, 0x64, 0x18, 0x1e, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x42, 0x2e, 0x63,
	0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x6c, 0x65, 0x72, 0x2e, 0x61, 0x70, 0x69, 0x2e, 0x72, 0x65,
	0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x62,
	0x75, 0x63, 0x6b, 0x65, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x74, 0x6f, 0x72, 0x61, 0x67,
	0x65, 0x42, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x50, 0x65, 0x72, 0x73, 0x69, 0x73, 0x74, 0x65, 0x64,
	0x52, 0x09, 0x70, 0x65, 0x72, 0x73, 0x69, 0x73, 0x74, 0x65, 0x64, 0x22, 0x81, 0x01, 0x0a, 0x1d,
	0x4f, 0x6e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x53, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x42,
	0x75, 0x63, 0x6b, 0x65, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x60, 0x0a,
	0x09, 0x70, 0x65, 0x72, 0x73, 0x69, 0x73, 0x74, 0x65, 0x64, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x42, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x6c, 0x65, 0x72, 0x2e, 0x61, 0x70,
	0x69, 0x2e, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2e, 0x73, 0x74, 0x6f, 0x72,
	0x61, 0x67, 0x65, 0x62, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x74,
	0x6f, 0x72, 0x61, 0x67, 0x65, 0x42, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x50, 0x65, 0x72, 0x73, 0x69,
	0x73, 0x74, 0x65, 0x64, 0x52, 0x09, 0x70, 0x65, 0x72, 0x73, 0x69, 0x73, 0x74, 0x65, 0x64, 0x22,
	0xd3, 0x01, 0x0a, 0x1c, 0x4f, 0x6e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x53, 0x74, 0x6f, 0x72,
	0x61, 0x67, 0x65, 0x42, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x51, 0x0a, 0x06, 0x62, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x39, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x6c, 0x65, 0x72, 0x2e, 0x61, 0x70,
	0x69, 0x2e, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2e, 0x73, 0x74, 0x6f, 0x72,
	0x61, 0x67, 0x65, 0x62, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x74,
	0x6f, 0x72, 0x61, 0x67, 0x65, 0x42, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x52, 0x06, 0x62, 0x75, 0x63,
	0x6b, 0x65, 0x74, 0x12, 0x60, 0x0a, 0x09, 0x70, 0x65, 0x72, 0x73, 0x69, 0x73, 0x74, 0x65, 0x64,
	0x18, 0x14, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x42, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c,
	0x6c, 0x65, 0x72, 0x2e, 0x61, 0x70, 0x69, 0x2e, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x73, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x62, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x73,
	0x2e, 0x76, 0x31, 0x2e, 0x53, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x42, 0x75, 0x63, 0x6b, 0x65,
	0x74, 0x50, 0x65, 0x72, 0x73, 0x69, 0x73, 0x74, 0x65, 0x64, 0x52, 0x09, 0x70, 0x65, 0x72, 0x73,
	0x69, 0x73, 0x74, 0x65, 0x64, 0x22, 0x1f, 0x0a, 0x1d, 0x4f, 0x6e, 0x44, 0x65, 0x6c, 0x65, 0x74,
	0x65, 0x53, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x42, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x6f, 0x0a, 0x1a, 0x56, 0x61, 0x6c, 0x69, 0x64, 0x61,
	0x74, 0x65, 0x50, 0x65, 0x72, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x51, 0x0a, 0x06, 0x62, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x18, 0x0a,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x39, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x6c, 0x65,
	0x72, 0x2e, 0x61, 0x70, 0x69, 0x2e, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2e,
	0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x62, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x73, 0x2e, 0x76,
	0x31, 0x2e, 0x53, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x42, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x52,
	0x06, 0x62, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x22, 0x1d, 0x0a, 0x1b, 0x56, 0x61, 0x6c, 0x69, 0x64,
	0x61, 0x74, 0x65, 0x50, 0x65, 0x72, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x78, 0x0a, 0x11, 0x48, 0x65, 0x61, 0x64, 0x4f, 0x62,
	0x6a, 0x65, 0x63, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x51, 0x0a, 0x06, 0x62,
	0x75, 0x63, 0x6b, 0x65, 0x74, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x39, 0x2e, 0x63, 0x6f,
	0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x6c, 0x65, 0x72, 0x2e, 0x61, 0x70, 0x69, 0x2e, 0x72, 0x65, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x62, 0x75,
	0x63, 0x6b, 0x65, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65,
	0x42, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x52, 0x06, 0x62, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x12, 0x10,
	0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x14, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79,
	0x22, 0x7c, 0x0a, 0x12, 0x48, 0x65, 0x61, 0x64, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x25, 0x0a, 0x0e, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e,
	0x74, 0x5f, 0x6c, 0x65, 0x6e, 0x67, 0x74, 0x68, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x03, 0x52, 0x0d,
	0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x4c, 0x65, 0x6e, 0x67, 0x74, 0x68, 0x12, 0x3f, 0x0a,
	0x0d, 0x6c, 0x61, 0x73, 0x74, 0x5f, 0x6d, 0x6f, 0x64, 0x69, 0x66, 0x69, 0x65, 0x64, 0x18, 0x14,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70,
	0x52, 0x0c, 0x6c, 0x61, 0x73, 0x74, 0x4d, 0x6f, 0x64, 0x69, 0x66, 0x69, 0x65, 0x64, 0x22, 0x96,
	0x01, 0x0a, 0x10, 0x47, 0x65, 0x74, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x51, 0x0a, 0x06, 0x62, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x18, 0x0a, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x39, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x6c, 0x65, 0x72,
	0x2e, 0x61, 0x70, 0x69, 0x2e, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2e, 0x73,
	0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x62, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x73, 0x2e, 0x76, 0x31,
	0x2e, 0x53, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x42, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x52, 0x06,
	0x62, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x14, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x1d, 0x0a, 0x0a, 0x63, 0x68, 0x75, 0x6e,
	0x6b, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x1e, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x09, 0x63, 0x68,
	0x75, 0x6e, 0x6b, 0x53, 0x69, 0x7a, 0x65, 0x22, 0x32, 0x0a, 0x11, 0x47, 0x65, 0x74, 0x4f, 0x62,
	0x6a, 0x65, 0x63, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x1d, 0x0a, 0x0a,
	0x66, 0x69, 0x6c, 0x65, 0x5f, 0x63, 0x68, 0x75, 0x6e, 0x6b, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0c,
	0x52, 0x09, 0x66, 0x69, 0x6c, 0x65, 0x43, 0x68, 0x75, 0x6e, 0x6b, 0x22, 0x8b, 0x01, 0x0a, 0x10,
	0x50, 0x75, 0x74, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x51, 0x0a, 0x06, 0x62, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x39, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x6c, 0x65, 0x72, 0x2e, 0x61, 0x70,
	0x69, 0x2e, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2e, 0x73, 0x74, 0x6f, 0x72,
	0x61, 0x67, 0x65, 0x62, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x74,
	0x6f, 0x72, 0x61, 0x67, 0x65, 0x42, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x52, 0x06, 0x62, 0x75, 0x63,
	0x6b, 0x65, 0x74, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x14, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x12, 0x0a, 0x04, 0x70, 0x61, 0x74, 0x68, 0x18, 0x1e, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x04, 0x70, 0x61, 0x74, 0x68, 0x22, 0x3d, 0x0a, 0x11, 0x50, 0x75, 0x74,
	0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x28,
	0x0a, 0x10, 0x63, 0x68, 0x65, 0x63, 0x6b, 0x73, 0x75, 0x6d, 0x5f, 0x73, 0x68, 0x61, 0x5f, 0x32,
	0x35, 0x36, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x0e, 0x63, 0x68, 0x65, 0x63, 0x6b, 0x73,
	0x75, 0x6d, 0x53, 0x68, 0x61, 0x32, 0x35, 0x36, 0x22, 0xa6, 0x01, 0x0a, 0x14, 0x44, 0x65, 0x6c,
	0x65, 0x74, 0x65, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x51, 0x0a, 0x06, 0x62, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x18, 0x0a, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x39, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x6c, 0x65, 0x72, 0x2e, 0x61,
	0x70, 0x69, 0x2e, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2e, 0x73, 0x74, 0x6f,
	0x72, 0x61, 0x67, 0x65, 0x62, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x53,
	0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x42, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x52, 0x06, 0x62, 0x75,
	0x63, 0x6b, 0x65, 0x74, 0x12, 0x1d, 0x0a, 0x0a, 0x6b, 0x65, 0x79, 0x5f, 0x70, 0x72, 0x65, 0x66,
	0x69, 0x78, 0x18, 0x14, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x6b, 0x65, 0x79, 0x50, 0x72, 0x65,
	0x66, 0x69, 0x78, 0x12, 0x1c, 0x0a, 0x09, 0x72, 0x65, 0x63, 0x75, 0x72, 0x73, 0x69, 0x76, 0x65,
	0x18, 0x1e, 0x20, 0x01, 0x28, 0x08, 0x52, 0x09, 0x72, 0x65, 0x63, 0x75, 0x72, 0x73, 0x69, 0x76,
	0x65, 0x22, 0x40, 0x0a, 0x15, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x4f, 0x62, 0x6a, 0x65, 0x63,
	0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x27, 0x0a, 0x0f, 0x6f, 0x62,
	0x6a, 0x65, 0x63, 0x74, 0x73, 0x5f, 0x64, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x64, 0x18, 0x0a, 0x20,
	0x01, 0x28, 0x0d, 0x52, 0x0e, 0x6f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x44, 0x65, 0x6c, 0x65,
	0x74, 0x65, 0x64, 0x22, 0x98, 0x01, 0x0a, 0x0a, 0x50, 0x65, 0x72, 0x6d, 0x69, 0x73, 0x73, 0x69,
	0x6f, 0x6e, 0x12, 0x2a, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x0a, 0x20, 0x01, 0x28,
	0x0e, 0x32, 0x14, 0x2e, 0x70, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x74,
	0x61, 0x74, 0x65, 0x54, 0x79, 0x70, 0x65, 0x52, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x12, 0x23,
	0x0a, 0x0d, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x5f, 0x64, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x18,
	0x14, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x44, 0x65, 0x74, 0x61,
	0x69, 0x6c, 0x73, 0x12, 0x39, 0x0a, 0x0a, 0x63, 0x68, 0x65, 0x63, 0x6b, 0x65, 0x64, 0x5f, 0x61,
	0x74, 0x18, 0x1e, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74,
	0x61, 0x6d, 0x70, 0x52, 0x09, 0x63, 0x68, 0x65, 0x63, 0x6b, 0x65, 0x64, 0x41, 0x74, 0x22, 0x94,
	0x01, 0x0a, 0x0b, 0x50, 0x65, 0x72, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x2b,
	0x0a, 0x05, 0x77, 0x72, 0x69, 0x74, 0x65, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x15, 0x2e,
	0x70, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x65, 0x72, 0x6d, 0x69, 0x73,
	0x73, 0x69, 0x6f, 0x6e, 0x52, 0x05, 0x77, 0x72, 0x69, 0x74, 0x65, 0x12, 0x29, 0x0a, 0x04, 0x72,
	0x65, 0x61, 0x64, 0x18, 0x14, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x15, 0x2e, 0x70, 0x6c, 0x75, 0x67,
	0x69, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x65, 0x72, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e,
	0x52, 0x04, 0x72, 0x65, 0x61, 0x64, 0x12, 0x2d, 0x0a, 0x06, 0x64, 0x65, 0x6c, 0x65, 0x74, 0x65,
	0x18, 0x1e, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x15, 0x2e, 0x70, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x2e,
	0x76, 0x31, 0x2e, 0x50, 0x65, 0x72, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x06, 0x64,
	0x65, 0x6c, 0x65, 0x74, 0x65, 0x22, 0x66, 0x0a, 0x1c, 0x53, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65,
	0x42, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x43, 0x72, 0x65, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x61, 0x6c,
	0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x2c, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x0a,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x16, 0x2e, 0x70, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x2e, 0x76, 0x31,
	0x2e, 0x50, 0x65, 0x72, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x05, 0x73, 0x74,
	0x61, 0x74, 0x65, 0x12, 0x18, 0x0a, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x14,
	0x20, 0x01, 0x28, 0x0d, 0x52, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x2a, 0x68, 0x0a,
	0x09, 0x53, 0x74, 0x61, 0x74, 0x65, 0x54, 0x79, 0x70, 0x65, 0x12, 0x1a, 0x0a, 0x16, 0x53, 0x54,
	0x41, 0x54, 0x45, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49,
	0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x11, 0x0a, 0x0d, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f,
	0x54, 0x59, 0x50, 0x45, 0x5f, 0x4f, 0x4b, 0x10, 0x01, 0x12, 0x14, 0x0a, 0x10, 0x53, 0x54, 0x41,
	0x54, 0x45, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x45, 0x52, 0x52, 0x4f, 0x52, 0x10, 0x02, 0x12,
	0x16, 0x0a, 0x12, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e,
	0x4b, 0x4e, 0x4f, 0x57, 0x4e, 0x10, 0x03, 0x32, 0xf1, 0x05, 0x0a, 0x14, 0x53, 0x74, 0x6f, 0x72,
	0x61, 0x67, 0x65, 0x50, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65,
	0x12, 0x6a, 0x0a, 0x15, 0x4f, 0x6e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x53, 0x74, 0x6f, 0x72,
	0x61, 0x67, 0x65, 0x42, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x12, 0x27, 0x2e, 0x70, 0x6c, 0x75, 0x67,
	0x69, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x4f, 0x6e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x53, 0x74,
	0x6f, 0x72, 0x61, 0x67, 0x65, 0x42, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x1a, 0x28, 0x2e, 0x70, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x4f,
	0x6e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x53, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x42, 0x75,
	0x63, 0x6b, 0x65, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x6a, 0x0a, 0x15,
	0x4f, 0x6e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x53, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x42,
	0x75, 0x63, 0x6b, 0x65, 0x74, 0x12, 0x27, 0x2e, 0x70, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x2e, 0x76,
	0x31, 0x2e, 0x4f, 0x6e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x53, 0x74, 0x6f, 0x72, 0x61, 0x67,
	0x65, 0x42, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x28,
	0x2e, 0x70, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x4f, 0x6e, 0x55, 0x70, 0x64,
	0x61, 0x74, 0x65, 0x53, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x42, 0x75, 0x63, 0x6b, 0x65, 0x74,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x6a, 0x0a, 0x15, 0x4f, 0x6e, 0x44, 0x65,
	0x6c, 0x65, 0x74, 0x65, 0x53, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x42, 0x75, 0x63, 0x6b, 0x65,
	0x74, 0x12, 0x27, 0x2e, 0x70, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x4f, 0x6e,
	0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x53, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x42, 0x75, 0x63,
	0x6b, 0x65, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x28, 0x2e, 0x70, 0x6c, 0x75,
	0x67, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x4f, 0x6e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x53,
	0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x42, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x12, 0x64, 0x0a, 0x13, 0x56, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65,
	0x50, 0x65, 0x72, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x25, 0x2e, 0x70, 0x6c,
	0x75, 0x67, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x56, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65,
	0x50, 0x65, 0x72, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x1a, 0x26, 0x2e, 0x70, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x56,
	0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x50, 0x65, 0x72, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f,
	0x6e, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x49, 0x0a, 0x0a, 0x48, 0x65,
	0x61, 0x64, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x12, 0x1c, 0x2e, 0x70, 0x6c, 0x75, 0x67, 0x69,
	0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x48, 0x65, 0x61, 0x64, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x70, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x2e,
	0x76, 0x31, 0x2e, 0x48, 0x65, 0x61, 0x64, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x48, 0x0a, 0x09, 0x47, 0x65, 0x74, 0x4f, 0x62, 0x6a, 0x65,
	0x63, 0x74, 0x12, 0x1b, 0x2e, 0x70, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x47,
	0x65, 0x74, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x1c, 0x2e, 0x70, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x4f,
	0x62, 0x6a, 0x65, 0x63, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x30, 0x01, 0x12,
	0x46, 0x0a, 0x09, 0x50, 0x75, 0x74, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x12, 0x1b, 0x2e, 0x70,
	0x6c, 0x75, 0x67, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x75, 0x74, 0x4f, 0x62, 0x6a, 0x65,
	0x63, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1c, 0x2e, 0x70, 0x6c, 0x75, 0x67,
	0x69, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x75, 0x74, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x52, 0x0a, 0x0d, 0x44, 0x65, 0x6c, 0x65, 0x74,
	0x65, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x12, 0x1f, 0x2e, 0x70, 0x6c, 0x75, 0x67, 0x69,
	0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x4f, 0x62, 0x6a, 0x65, 0x63,
	0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x20, 0x2e, 0x70, 0x6c, 0x75, 0x67,
	0x69, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x4f, 0x62, 0x6a, 0x65,
	0x63, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x42, 0x35, 0x5a, 0x33, 0x67,
	0x69, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x68, 0x61, 0x73, 0x68, 0x69, 0x63,
	0x6f, 0x72, 0x70, 0x2f, 0x62, 0x6f, 0x75, 0x6e, 0x64, 0x61, 0x72, 0x79, 0x2f, 0x73, 0x64, 0x6b,
	0x2f, 0x70, 0x62, 0x73, 0x2f, 0x70, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x3b, 0x70, 0x6c, 0x75, 0x67,
	0x69, 0x6e, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_plugin_v1_storage_plugin_service_proto_rawDescOnce sync.Once
	file_plugin_v1_storage_plugin_service_proto_rawDescData = file_plugin_v1_storage_plugin_service_proto_rawDesc
)

func file_plugin_v1_storage_plugin_service_proto_rawDescGZIP() []byte {
	file_plugin_v1_storage_plugin_service_proto_rawDescOnce.Do(func() {
		file_plugin_v1_storage_plugin_service_proto_rawDescData = protoimpl.X.CompressGZIP(file_plugin_v1_storage_plugin_service_proto_rawDescData)
	})
	return file_plugin_v1_storage_plugin_service_proto_rawDescData
}

var file_plugin_v1_storage_plugin_service_proto_enumTypes = make([]protoimpl.EnumInfo, 1)
var file_plugin_v1_storage_plugin_service_proto_msgTypes = make([]protoimpl.MessageInfo, 19)
var file_plugin_v1_storage_plugin_service_proto_goTypes = []any{
	(StateType)(0),                                // 0: plugin.v1.StateType
	(*OnCreateStorageBucketRequest)(nil),          // 1: plugin.v1.OnCreateStorageBucketRequest
	(*OnCreateStorageBucketResponse)(nil),         // 2: plugin.v1.OnCreateStorageBucketResponse
	(*OnUpdateStorageBucketRequest)(nil),          // 3: plugin.v1.OnUpdateStorageBucketRequest
	(*OnUpdateStorageBucketResponse)(nil),         // 4: plugin.v1.OnUpdateStorageBucketResponse
	(*OnDeleteStorageBucketRequest)(nil),          // 5: plugin.v1.OnDeleteStorageBucketRequest
	(*OnDeleteStorageBucketResponse)(nil),         // 6: plugin.v1.OnDeleteStorageBucketResponse
	(*ValidatePermissionsRequest)(nil),            // 7: plugin.v1.ValidatePermissionsRequest
	(*ValidatePermissionsResponse)(nil),           // 8: plugin.v1.ValidatePermissionsResponse
	(*HeadObjectRequest)(nil),                     // 9: plugin.v1.HeadObjectRequest
	(*HeadObjectResponse)(nil),                    // 10: plugin.v1.HeadObjectResponse
	(*GetObjectRequest)(nil),                      // 11: plugin.v1.GetObjectRequest
	(*GetObjectResponse)(nil),                     // 12: plugin.v1.GetObjectResponse
	(*PutObjectRequest)(nil),                      // 13: plugin.v1.PutObjectRequest
	(*PutObjectResponse)(nil),                     // 14: plugin.v1.PutObjectResponse
	(*DeleteObjectsRequest)(nil),                  // 15: plugin.v1.DeleteObjectsRequest
	(*DeleteObjectsResponse)(nil),                 // 16: plugin.v1.DeleteObjectsResponse
	(*Permission)(nil),                            // 17: plugin.v1.Permission
	(*Permissions)(nil),                           // 18: plugin.v1.Permissions
	(*StorageBucketCredentialState)(nil),          // 19: plugin.v1.StorageBucketCredentialState
	(*storagebuckets.StorageBucket)(nil),          // 20: controller.api.resources.storagebuckets.v1.StorageBucket
	(*storagebuckets.StorageBucketPersisted)(nil), // 21: controller.api.resources.storagebuckets.v1.StorageBucketPersisted
	(*timestamppb.Timestamp)(nil),                 // 22: google.protobuf.Timestamp
}
var file_plugin_v1_storage_plugin_service_proto_depIdxs = []int32{
	20, // 0: plugin.v1.OnCreateStorageBucketRequest.bucket:type_name -> controller.api.resources.storagebuckets.v1.StorageBucket
	21, // 1: plugin.v1.OnCreateStorageBucketResponse.persisted:type_name -> controller.api.resources.storagebuckets.v1.StorageBucketPersisted
	20, // 2: plugin.v1.OnUpdateStorageBucketRequest.current_bucket:type_name -> controller.api.resources.storagebuckets.v1.StorageBucket
	20, // 3: plugin.v1.OnUpdateStorageBucketRequest.new_bucket:type_name -> controller.api.resources.storagebuckets.v1.StorageBucket
	21, // 4: plugin.v1.OnUpdateStorageBucketRequest.persisted:type_name -> controller.api.resources.storagebuckets.v1.StorageBucketPersisted
	21, // 5: plugin.v1.OnUpdateStorageBucketResponse.persisted:type_name -> controller.api.resources.storagebuckets.v1.StorageBucketPersisted
	20, // 6: plugin.v1.OnDeleteStorageBucketRequest.bucket:type_name -> controller.api.resources.storagebuckets.v1.StorageBucket
	21, // 7: plugin.v1.OnDeleteStorageBucketRequest.persisted:type_name -> controller.api.resources.storagebuckets.v1.StorageBucketPersisted
	20, // 8: plugin.v1.ValidatePermissionsRequest.bucket:type_name -> controller.api.resources.storagebuckets.v1.StorageBucket
	20, // 9: plugin.v1.HeadObjectRequest.bucket:type_name -> controller.api.resources.storagebuckets.v1.StorageBucket
	22, // 10: plugin.v1.HeadObjectResponse.last_modified:type_name -> google.protobuf.Timestamp
	20, // 11: plugin.v1.GetObjectRequest.bucket:type_name -> controller.api.resources.storagebuckets.v1.StorageBucket
	20, // 12: plugin.v1.PutObjectRequest.bucket:type_name -> controller.api.resources.storagebuckets.v1.StorageBucket
	20, // 13: plugin.v1.DeleteObjectsRequest.bucket:type_name -> controller.api.resources.storagebuckets.v1.StorageBucket
	0,  // 14: plugin.v1.Permission.state:type_name -> plugin.v1.StateType
	22, // 15: plugin.v1.Permission.checked_at:type_name -> google.protobuf.Timestamp
	17, // 16: plugin.v1.Permissions.write:type_name -> plugin.v1.Permission
	17, // 17: plugin.v1.Permissions.read:type_name -> plugin.v1.Permission
	17, // 18: plugin.v1.Permissions.delete:type_name -> plugin.v1.Permission
	18, // 19: plugin.v1.StorageBucketCredentialState.state:type_name -> plugin.v1.Permissions
	1,  // 20: plugin.v1.StoragePluginService.OnCreateStorageBucket:input_type -> plugin.v1.OnCreateStorageBucketRequest
	3,  // 21: plugin.v1.StoragePluginService.OnUpdateStorageBucket:input_type -> plugin.v1.OnUpdateStorageBucketRequest
	5,  // 22: plugin.v1.StoragePluginService.OnDeleteStorageBucket:input_type -> plugin.v1.OnDeleteStorageBucketRequest
	7,  // 23: plugin.v1.StoragePluginService.ValidatePermissions:input_type -> plugin.v1.ValidatePermissionsRequest
	9,  // 24: plugin.v1.StoragePluginService.HeadObject:input_type -> plugin.v1.HeadObjectRequest
	11, // 25: plugin.v1.StoragePluginService.GetObject:input_type -> plugin.v1.GetObjectRequest
	13, // 26: plugin.v1.StoragePluginService.PutObject:input_type -> plugin.v1.PutObjectRequest
	15, // 27: plugin.v1.StoragePluginService.DeleteObjects:input_type -> plugin.v1.DeleteObjectsRequest
	2,  // 28: plugin.v1.StoragePluginService.OnCreateStorageBucket:output_type -> plugin.v1.OnCreateStorageBucketResponse
	4,  // 29: plugin.v1.StoragePluginService.OnUpdateStorageBucket:output_type -> plugin.v1.OnUpdateStorageBucketResponse
	6,  // 30: plugin.v1.StoragePluginService.OnDeleteStorageBucket:output_type -> plugin.v1.OnDeleteStorageBucketResponse
	8,  // 31: plugin.v1.StoragePluginService.ValidatePermissions:output_type -> plugin.v1.ValidatePermissionsResponse
	10, // 32: plugin.v1.StoragePluginService.HeadObject:output_type -> plugin.v1.HeadObjectResponse
	12, // 33: plugin.v1.StoragePluginService.GetObject:output_type -> plugin.v1.GetObjectResponse
	14, // 34: plugin.v1.StoragePluginService.PutObject:output_type -> plugin.v1.PutObjectResponse
	16, // 35: plugin.v1.StoragePluginService.DeleteObjects:output_type -> plugin.v1.DeleteObjectsResponse
	28, // [28:36] is the sub-list for method output_type
	20, // [20:28] is the sub-list for method input_type
	20, // [20:20] is the sub-list for extension type_name
	20, // [20:20] is the sub-list for extension extendee
	0,  // [0:20] is the sub-list for field type_name
}

func init() { file_plugin_v1_storage_plugin_service_proto_init() }
func file_plugin_v1_storage_plugin_service_proto_init() {
	if File_plugin_v1_storage_plugin_service_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_plugin_v1_storage_plugin_service_proto_msgTypes[0].Exporter = func(v any, i int) any {
			switch v := v.(*OnCreateStorageBucketRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_plugin_v1_storage_plugin_service_proto_msgTypes[1].Exporter = func(v any, i int) any {
			switch v := v.(*OnCreateStorageBucketResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_plugin_v1_storage_plugin_service_proto_msgTypes[2].Exporter = func(v any, i int) any {
			switch v := v.(*OnUpdateStorageBucketRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_plugin_v1_storage_plugin_service_proto_msgTypes[3].Exporter = func(v any, i int) any {
			switch v := v.(*OnUpdateStorageBucketResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_plugin_v1_storage_plugin_service_proto_msgTypes[4].Exporter = func(v any, i int) any {
			switch v := v.(*OnDeleteStorageBucketRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_plugin_v1_storage_plugin_service_proto_msgTypes[5].Exporter = func(v any, i int) any {
			switch v := v.(*OnDeleteStorageBucketResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_plugin_v1_storage_plugin_service_proto_msgTypes[6].Exporter = func(v any, i int) any {
			switch v := v.(*ValidatePermissionsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_plugin_v1_storage_plugin_service_proto_msgTypes[7].Exporter = func(v any, i int) any {
			switch v := v.(*ValidatePermissionsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_plugin_v1_storage_plugin_service_proto_msgTypes[8].Exporter = func(v any, i int) any {
			switch v := v.(*HeadObjectRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_plugin_v1_storage_plugin_service_proto_msgTypes[9].Exporter = func(v any, i int) any {
			switch v := v.(*HeadObjectResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_plugin_v1_storage_plugin_service_proto_msgTypes[10].Exporter = func(v any, i int) any {
			switch v := v.(*GetObjectRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_plugin_v1_storage_plugin_service_proto_msgTypes[11].Exporter = func(v any, i int) any {
			switch v := v.(*GetObjectResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_plugin_v1_storage_plugin_service_proto_msgTypes[12].Exporter = func(v any, i int) any {
			switch v := v.(*PutObjectRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_plugin_v1_storage_plugin_service_proto_msgTypes[13].Exporter = func(v any, i int) any {
			switch v := v.(*PutObjectResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_plugin_v1_storage_plugin_service_proto_msgTypes[14].Exporter = func(v any, i int) any {
			switch v := v.(*DeleteObjectsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_plugin_v1_storage_plugin_service_proto_msgTypes[15].Exporter = func(v any, i int) any {
			switch v := v.(*DeleteObjectsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_plugin_v1_storage_plugin_service_proto_msgTypes[16].Exporter = func(v any, i int) any {
			switch v := v.(*Permission); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_plugin_v1_storage_plugin_service_proto_msgTypes[17].Exporter = func(v any, i int) any {
			switch v := v.(*Permissions); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_plugin_v1_storage_plugin_service_proto_msgTypes[18].Exporter = func(v any, i int) any {
			switch v := v.(*StorageBucketCredentialState); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_plugin_v1_storage_plugin_service_proto_rawDesc,
			NumEnums:      1,
			NumMessages:   19,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_plugin_v1_storage_plugin_service_proto_goTypes,
		DependencyIndexes: file_plugin_v1_storage_plugin_service_proto_depIdxs,
		EnumInfos:         file_plugin_v1_storage_plugin_service_proto_enumTypes,
		MessageInfos:      file_plugin_v1_storage_plugin_service_proto_msgTypes,
	}.Build()
	File_plugin_v1_storage_plugin_service_proto = out.File
	file_plugin_v1_storage_plugin_service_proto_rawDesc = nil
	file_plugin_v1_storage_plugin_service_proto_goTypes = nil
	file_plugin_v1_storage_plugin_service_proto_depIdxs = nil
}
