// Copyright (c) HashiCorp, Inc.
// SPDX-License-Identifier: MPL-2.0

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.34.2
// 	protoc        (unknown)
// source: controller/api/resources/sessionrecordings/v1/session_recording.proto

package session_recordings

import (
	scopes "github.com/hashicorp/boundary/sdk/pbs/controller/api/resources/scopes"
	_ "github.com/hashicorp/boundary/sdk/pbs/controller/protooptions"
	_ "google.golang.org/genproto/googleapis/api/visibility"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	durationpb "google.golang.org/protobuf/types/known/durationpb"
	structpb "google.golang.org/protobuf/types/known/structpb"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// ChannelRecording contains recorded information about a single Channel within a Connection.
// Channels are only present in multiplexed protocols, such as SSH.
type ChannelRecording struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The ID of the Channel recording.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty" class:"public" eventstream:"observation"` // @gotags: class:"public" eventstream:"observation"
	// The total number of bytes uploaded from the client in the Channel.
	BytesUp uint64 `protobuf:"varint,2,opt,name=bytes_up,proto3" json:"bytes_up,omitempty" class:"public" eventstream:"observation"` // @gotags: class:"public" eventstream:"observation"
	// The total number of bytes downloaded to the client in the Channel.
	BytesDown uint64 `protobuf:"varint,3,opt,name=bytes_down,proto3" json:"bytes_down,omitempty" class:"public" eventstream:"observation"` // @gotags: class:"public" eventstream:"observation"
	// The time the Channel was created in the controller.
	CreatedTime *timestamppb.Timestamp `protobuf:"bytes,4,opt,name=created_time,proto3" json:"created_time,omitempty" class:"public" eventstream:"observation"` // @gotags: class:"public" eventstream:"observation"
	// The time of the most recent update to the Channel.
	UpdatedTime *timestamppb.Timestamp `protobuf:"bytes,5,opt,name=updated_time,proto3" json:"updated_time,omitempty" class:"public" eventstream:"observation"` // @gotags: class:"public" eventstream:"observation"
	// The time the Channel started.
	StartTime *timestamppb.Timestamp `protobuf:"bytes,6,opt,name=start_time,proto3" json:"start_time,omitempty" class:"public" eventstream:"observation"` // @gotags: class:"public" eventstream:"observation"
	// The time the Channel ended.
	EndTime *timestamppb.Timestamp `protobuf:"bytes,7,opt,name=end_time,proto3" json:"end_time,omitempty" class:"public" eventstream:"observation"` // @gotags: class:"public" eventstream:"observation"
	// The total duration of the Channel.
	Duration *durationpb.Duration `protobuf:"bytes,8,opt,name=duration,proto3" json:"duration,omitempty" class:"public" eventstream:"observation"` // @gotags: class:"public" eventstream:"observation"
	// MimeTypes define the mime types that can
	// be used to consume the recording of this Channel.
	// The only supported mime type is "application/x-asciicast".
	MimeTypes []string `protobuf:"bytes,9,rep,name=mime_types,proto3" json:"mime_types,omitempty" class:"public" eventstream:"observation"` // @gotags: class:"public" eventstream:"observation"
}

func (x *ChannelRecording) Reset() {
	*x = ChannelRecording{}
	if protoimpl.UnsafeEnabled {
		mi := &file_controller_api_resources_sessionrecordings_v1_session_recording_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ChannelRecording) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ChannelRecording) ProtoMessage() {}

func (x *ChannelRecording) ProtoReflect() protoreflect.Message {
	mi := &file_controller_api_resources_sessionrecordings_v1_session_recording_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ChannelRecording.ProtoReflect.Descriptor instead.
func (*ChannelRecording) Descriptor() ([]byte, []int) {
	return file_controller_api_resources_sessionrecordings_v1_session_recording_proto_rawDescGZIP(), []int{0}
}

func (x *ChannelRecording) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

func (x *ChannelRecording) GetBytesUp() uint64 {
	if x != nil {
		return x.BytesUp
	}
	return 0
}

func (x *ChannelRecording) GetBytesDown() uint64 {
	if x != nil {
		return x.BytesDown
	}
	return 0
}

func (x *ChannelRecording) GetCreatedTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreatedTime
	}
	return nil
}

func (x *ChannelRecording) GetUpdatedTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdatedTime
	}
	return nil
}

func (x *ChannelRecording) GetStartTime() *timestamppb.Timestamp {
	if x != nil {
		return x.StartTime
	}
	return nil
}

func (x *ChannelRecording) GetEndTime() *timestamppb.Timestamp {
	if x != nil {
		return x.EndTime
	}
	return nil
}

func (x *ChannelRecording) GetDuration() *durationpb.Duration {
	if x != nil {
		return x.Duration
	}
	return nil
}

func (x *ChannelRecording) GetMimeTypes() []string {
	if x != nil {
		return x.MimeTypes
	}
	return nil
}

// ConnectionRecording contains the recording of a single Connection within a Session.
type ConnectionRecording struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The ID of the Connection recording.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty" class:"public" eventstream:"observation"` // @gotags: class:"public" eventstream:"observation"
	// The total number of bytes uploaded from the client in the Connection.
	// This includes any protocol overhead.
	BytesUp uint64 `protobuf:"varint,2,opt,name=bytes_up,proto3" json:"bytes_up,omitempty" class:"public" eventstream:"observation"` // @gotags: class:"public" eventstream:"observation"
	// The total number of bytes downloaded to the client in the Connection.
	// This includes any protocol overhead.
	BytesDown uint64 `protobuf:"varint,3,opt,name=bytes_down,proto3" json:"bytes_down,omitempty" class:"public" eventstream:"observation"` // @gotags: class:"public" eventstream:"observation"
	// The time the Connection was created in the controller.
	CreatedTime *timestamppb.Timestamp `protobuf:"bytes,4,opt,name=created_time,proto3" json:"created_time,omitempty" class:"public" eventstream:"observation"` // @gotags: class:"public" eventstream:"observation"
	// The time of the most recent update to the Connection.
	UpdatedTime *timestamppb.Timestamp `protobuf:"bytes,5,opt,name=updated_time,proto3" json:"updated_time,omitempty" class:"public" eventstream:"observation"` // @gotags: class:"public" eventstream:"observation"
	// The time the Connection started.
	StartTime *timestamppb.Timestamp `protobuf:"bytes,6,opt,name=start_time,proto3" json:"start_time,omitempty" class:"public" eventstream:"observation"` // @gotags: class:"public" eventstream:"observation"
	// The time the Connection ended.
	EndTime *timestamppb.Timestamp `protobuf:"bytes,7,opt,name=end_time,proto3" json:"end_time,omitempty" class:"public" eventstream:"observation"` // @gotags: class:"public" eventstream:"observation"
	// The total duration of the Connection.
	Duration *durationpb.Duration `protobuf:"bytes,8,opt,name=duration,proto3" json:"duration,omitempty" class:"public" eventstream:"observation"` // @gotags: class:"public" eventstream:"observation"
	// MimeTypes define the mime types that can
	// be used to consume the recording of this Connection.
	// No mime types are currently supported.
	MimeTypes []string `protobuf:"bytes,9,rep,name=mime_types,proto3" json:"mime_types,omitempty" class:"public"` // @gotags: class:"public"
	// Optionally, the channels used in this Connection,
	// if it is using a multiplexed protocol, such as SSH.
	ChannelRecordings []*ChannelRecording `protobuf:"bytes,10,rep,name=channel_recordings,proto3" json:"channel_recordings,omitempty"`
}

func (x *ConnectionRecording) Reset() {
	*x = ConnectionRecording{}
	if protoimpl.UnsafeEnabled {
		mi := &file_controller_api_resources_sessionrecordings_v1_session_recording_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ConnectionRecording) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ConnectionRecording) ProtoMessage() {}

func (x *ConnectionRecording) ProtoReflect() protoreflect.Message {
	mi := &file_controller_api_resources_sessionrecordings_v1_session_recording_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ConnectionRecording.ProtoReflect.Descriptor instead.
func (*ConnectionRecording) Descriptor() ([]byte, []int) {
	return file_controller_api_resources_sessionrecordings_v1_session_recording_proto_rawDescGZIP(), []int{1}
}

func (x *ConnectionRecording) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

func (x *ConnectionRecording) GetBytesUp() uint64 {
	if x != nil {
		return x.BytesUp
	}
	return 0
}

func (x *ConnectionRecording) GetBytesDown() uint64 {
	if x != nil {
		return x.BytesDown
	}
	return 0
}

func (x *ConnectionRecording) GetCreatedTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreatedTime
	}
	return nil
}

func (x *ConnectionRecording) GetUpdatedTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdatedTime
	}
	return nil
}

func (x *ConnectionRecording) GetStartTime() *timestamppb.Timestamp {
	if x != nil {
		return x.StartTime
	}
	return nil
}

func (x *ConnectionRecording) GetEndTime() *timestamppb.Timestamp {
	if x != nil {
		return x.EndTime
	}
	return nil
}

func (x *ConnectionRecording) GetDuration() *durationpb.Duration {
	if x != nil {
		return x.Duration
	}
	return nil
}

func (x *ConnectionRecording) GetMimeTypes() []string {
	if x != nil {
		return x.MimeTypes
	}
	return nil
}

func (x *ConnectionRecording) GetChannelRecordings() []*ChannelRecording {
	if x != nil {
		return x.ChannelRecordings
	}
	return nil
}

// User describes an authenticated user in Boundary.
type User struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The ID of the User.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty" class:"public" eventstream:"observation"` // @gotags: class:"public" eventstream:"observation"
	// The name of the User that created the Session.
	Name string `protobuf:"bytes,2,opt,name=name,proto3" json:"name,omitempty" class:"sensitive"` // @gotags: class:"sensitive"
	// The description of the User that created the Session.
	Description string `protobuf:"bytes,3,opt,name=description,proto3" json:"description,omitempty" class:"sensitive"` // @gotags: class:"sensitive"
	// The scope that the User is in.
	Scope *scopes.ScopeInfo `protobuf:"bytes,7,opt,name=scope,proto3" json:"scope,omitempty"`
}

func (x *User) Reset() {
	*x = User{}
	if protoimpl.UnsafeEnabled {
		mi := &file_controller_api_resources_sessionrecordings_v1_session_recording_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *User) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*User) ProtoMessage() {}

func (x *User) ProtoReflect() protoreflect.Message {
	mi := &file_controller_api_resources_sessionrecordings_v1_session_recording_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use User.ProtoReflect.Descriptor instead.
func (*User) Descriptor() ([]byte, []int) {
	return file_controller_api_resources_sessionrecordings_v1_session_recording_proto_rawDescGZIP(), []int{2}
}

func (x *User) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

func (x *User) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *User) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *User) GetScope() *scopes.ScopeInfo {
	if x != nil {
		return x.Scope
	}
	return nil
}

// HostCatalog describes the HostCatalog that contains the host chosen for the
// recorded session.
type HostCatalog struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The ID of the Host Catalog
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty" class:"public" eventstream:"observation"` // @gotags: class:"public" eventstream:"observation"
	// The scope that the Host Catalog is in
	Scope *scopes.ScopeInfo `protobuf:"bytes,2,opt,name=scope,proto3" json:"scope,omitempty"`
	// The plugin id used by this Host Catalog, if any.
	PluginId string `protobuf:"bytes,3,opt,name=plugin_id,proto3" json:"plugin_id,omitempty" class:"public" eventstream:"observation"` // @gotags: class:"public" eventstream:"observation"
	// The name of the Host Catalog, if set
	Name string `protobuf:"bytes,4,opt,name=name,proto3" json:"name,omitempty" class:"public"` // @gotags: class:"public"
	// The description of the Host Catalog.
	Description string `protobuf:"bytes,5,opt,name=description,proto3" json:"description,omitempty" class:"public"` // @gotags: class:"public"
	// The type of the Host Catalog.  This will be either "static" or "plugin"
	Type string `protobuf:"bytes,6,opt,name=type,proto3" json:"type,omitempty" class:"public" eventstream:"observation"` // @gotags: class:"public" eventstream:"observation"
	// Types that are assignable to Attrs:
	//
	//	*HostCatalog_Attributes
	Attrs isHostCatalog_Attrs `protobuf_oneof:"attrs"`
}

func (x *HostCatalog) Reset() {
	*x = HostCatalog{}
	if protoimpl.UnsafeEnabled {
		mi := &file_controller_api_resources_sessionrecordings_v1_session_recording_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *HostCatalog) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*HostCatalog) ProtoMessage() {}

func (x *HostCatalog) ProtoReflect() protoreflect.Message {
	mi := &file_controller_api_resources_sessionrecordings_v1_session_recording_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use HostCatalog.ProtoReflect.Descriptor instead.
func (*HostCatalog) Descriptor() ([]byte, []int) {
	return file_controller_api_resources_sessionrecordings_v1_session_recording_proto_rawDescGZIP(), []int{3}
}

func (x *HostCatalog) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

func (x *HostCatalog) GetScope() *scopes.ScopeInfo {
	if x != nil {
		return x.Scope
	}
	return nil
}

func (x *HostCatalog) GetPluginId() string {
	if x != nil {
		return x.PluginId
	}
	return ""
}

func (x *HostCatalog) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *HostCatalog) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *HostCatalog) GetType() string {
	if x != nil {
		return x.Type
	}
	return ""
}

func (m *HostCatalog) GetAttrs() isHostCatalog_Attrs {
	if m != nil {
		return m.Attrs
	}
	return nil
}

func (x *HostCatalog) GetAttributes() *structpb.Struct {
	if x, ok := x.GetAttrs().(*HostCatalog_Attributes); ok {
		return x.Attributes
	}
	return nil
}

type isHostCatalog_Attrs interface {
	isHostCatalog_Attrs()
}

type HostCatalog_Attributes struct {
	// The attributes of the Host Catalog.
	Attributes *structpb.Struct `protobuf:"bytes,7,opt,name=attributes,proto3,oneof" class:"public"` // @gotags: class:"public"
}

func (*HostCatalog_Attributes) isHostCatalog_Attrs() {}

// Host describes the Host that was chosen for the recorded session.
type Host struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The ID of the Host
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty" class:"public" eventstream:"observation"` // @gotags: class:"public" eventstream:"observation"
	// The Host Catalog this Host is in
	HostCatalog *HostCatalog `protobuf:"bytes,2,opt,name=host_catalog,proto3" json:"host_catalog,omitempty"`
	// The name of the Host, if set.
	Name string `protobuf:"bytes,3,opt,name=name,proto3" json:"name,omitempty" class:"public"` // @gotags: class:"public"
	// The description of the Host, if set.
	Description string `protobuf:"bytes,4,opt,name=description,proto3" json:"description,omitempty" class:"public"` // @gotags: class:"public"
	// The type of the host. This will be either "static" or "plugin"
	Type string `protobuf:"bytes,5,opt,name=type,proto3" json:"type,omitempty" class:"public" eventstream:"observation"` // @gotags: class:"public" eventstream:"observation"
	// Types that are assignable to Attrs:
	//
	//	*Host_Attributes
	//	*Host_StaticHostAttributes
	Attrs isHost_Attrs `protobuf_oneof:"attrs"`
	// The external id of the Host, if any.
	ExternalId string `protobuf:"bytes,7,opt,name=external_id,proto3" json:"external_id,omitempty" class:"public"` // @gotags: class:"public"
	// The external name of the Host, if any.
	ExternalName string `protobuf:"bytes,8,opt,name=external_name,proto3" json:"external_name,omitempty" class:"public"` // @gotags: class:"public"
}

func (x *Host) Reset() {
	*x = Host{}
	if protoimpl.UnsafeEnabled {
		mi := &file_controller_api_resources_sessionrecordings_v1_session_recording_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Host) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Host) ProtoMessage() {}

func (x *Host) ProtoReflect() protoreflect.Message {
	mi := &file_controller_api_resources_sessionrecordings_v1_session_recording_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Host.ProtoReflect.Descriptor instead.
func (*Host) Descriptor() ([]byte, []int) {
	return file_controller_api_resources_sessionrecordings_v1_session_recording_proto_rawDescGZIP(), []int{4}
}

func (x *Host) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

func (x *Host) GetHostCatalog() *HostCatalog {
	if x != nil {
		return x.HostCatalog
	}
	return nil
}

func (x *Host) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Host) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *Host) GetType() string {
	if x != nil {
		return x.Type
	}
	return ""
}

func (m *Host) GetAttrs() isHost_Attrs {
	if m != nil {
		return m.Attrs
	}
	return nil
}

func (x *Host) GetAttributes() *structpb.Struct {
	if x, ok := x.GetAttrs().(*Host_Attributes); ok {
		return x.Attributes
	}
	return nil
}

func (x *Host) GetStaticHostAttributes() *StaticHostAttributes {
	if x, ok := x.GetAttrs().(*Host_StaticHostAttributes); ok {
		return x.StaticHostAttributes
	}
	return nil
}

func (x *Host) GetExternalId() string {
	if x != nil {
		return x.ExternalId
	}
	return ""
}

func (x *Host) GetExternalName() string {
	if x != nil {
		return x.ExternalName
	}
	return ""
}

type isHost_Attrs interface {
	isHost_Attrs()
}

type Host_Attributes struct {
	// The attributes that are applicable for the specific Host.
	Attributes *structpb.Struct `protobuf:"bytes,6,opt,name=attributes,proto3,oneof"`
}

type Host_StaticHostAttributes struct {
	StaticHostAttributes *StaticHostAttributes `protobuf:"bytes,9,opt,name=static_host_attributes,json=staticHostAttributes,proto3,oneof"`
}

func (*Host_Attributes) isHost_Attrs() {}

func (*Host_StaticHostAttributes) isHost_Attrs() {}

type StaticHostAttributes struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The address specified on a static host
	Address string `protobuf:"bytes,1,opt,name=address,proto3" json:"address,omitempty" class:"public"` // @gotags: class:"public"
}

func (x *StaticHostAttributes) Reset() {
	*x = StaticHostAttributes{}
	if protoimpl.UnsafeEnabled {
		mi := &file_controller_api_resources_sessionrecordings_v1_session_recording_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *StaticHostAttributes) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StaticHostAttributes) ProtoMessage() {}

func (x *StaticHostAttributes) ProtoReflect() protoreflect.Message {
	mi := &file_controller_api_resources_sessionrecordings_v1_session_recording_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StaticHostAttributes.ProtoReflect.Descriptor instead.
func (*StaticHostAttributes) Descriptor() ([]byte, []int) {
	return file_controller_api_resources_sessionrecordings_v1_session_recording_proto_rawDescGZIP(), []int{5}
}

func (x *StaticHostAttributes) GetAddress() string {
	if x != nil {
		return x.Address
	}
	return ""
}

// Target describes a target in Boundary.
type Target struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The ID of the Target.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty" class:"public" eventstream:"observation"` // @gotags: class:"public" eventstream:"observation"
	// The name of the Target, if set.
	Name string `protobuf:"bytes,2,opt,name=name,proto3" json:"name,omitempty" class:"public"` // @gotags: class:"public"
	// The description of the Target, if set.
	Description string `protobuf:"bytes,3,opt,name=description,proto3" json:"description,omitempty" class:"public"` // @gotags: class:"public"
	// The scope that the Target is in.
	Scope *scopes.ScopeInfo `protobuf:"bytes,4,opt,name=scope,proto3" json:"scope,omitempty"`
	// Maximum total lifetime of a created Session, in seconds.
	SessionMaxSeconds uint32 `protobuf:"varint,5,opt,name=session_max_seconds,proto3" json:"session_max_seconds,omitempty" class:"public" eventstream:"observation"` // @gotags: class:"public" eventstream:"observation"
	// Maximum number of connections allowed in a Session.  Unlimited is indicated by the value -1.
	SessionConnectionLimit int32 `protobuf:"varint,6,opt,name=session_connection_limit,proto3" json:"session_connection_limit,omitempty" class:"public" eventstream:"observation"` // @gotags: class:"public" eventstream:"observation"
	// Optional boolean expression to filter the workers that are allowed to satisfy this request.
	WorkerFilter string `protobuf:"bytes,7,opt,name=worker_filter,proto3" json:"worker_filter,omitempty" class:"public"` // @gotags: class:"public"
	// Optional boolean expressions to filter the egress workers that are allowed to satisfy this request.
	EgressWorkerFilter string `protobuf:"bytes,8,opt,name=egress_worker_filter,proto3" json:"egress_worker_filter,omitempty" class:"public"` // @gotags: class:"public"
	// Optional boolean expressions to filter the ingress workers that are allowed to satisfy this request.
	IngressWorkerFilter string `protobuf:"bytes,9,opt,name=ingress_worker_filter,proto3" json:"ingress_worker_filter,omitempty" class:"public"` // @gotags: class:"public"
	// The type of the Target.
	Type string `protobuf:"bytes,10,opt,name=type,proto3" json:"type,omitempty" class:"public" eventstream:"observation"` // @gotags: class:"public" eventstream:"observation"
	// Types that are assignable to Attrs:
	//
	//	*Target_Attributes
	//	*Target_SshTargetAttributes
	Attrs isTarget_Attrs `protobuf_oneof:"attrs"`
}

func (x *Target) Reset() {
	*x = Target{}
	if protoimpl.UnsafeEnabled {
		mi := &file_controller_api_resources_sessionrecordings_v1_session_recording_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Target) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Target) ProtoMessage() {}

func (x *Target) ProtoReflect() protoreflect.Message {
	mi := &file_controller_api_resources_sessionrecordings_v1_session_recording_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Target.ProtoReflect.Descriptor instead.
func (*Target) Descriptor() ([]byte, []int) {
	return file_controller_api_resources_sessionrecordings_v1_session_recording_proto_rawDescGZIP(), []int{6}
}

func (x *Target) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

func (x *Target) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Target) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *Target) GetScope() *scopes.ScopeInfo {
	if x != nil {
		return x.Scope
	}
	return nil
}

func (x *Target) GetSessionMaxSeconds() uint32 {
	if x != nil {
		return x.SessionMaxSeconds
	}
	return 0
}

func (x *Target) GetSessionConnectionLimit() int32 {
	if x != nil {
		return x.SessionConnectionLimit
	}
	return 0
}

func (x *Target) GetWorkerFilter() string {
	if x != nil {
		return x.WorkerFilter
	}
	return ""
}

func (x *Target) GetEgressWorkerFilter() string {
	if x != nil {
		return x.EgressWorkerFilter
	}
	return ""
}

func (x *Target) GetIngressWorkerFilter() string {
	if x != nil {
		return x.IngressWorkerFilter
	}
	return ""
}

func (x *Target) GetType() string {
	if x != nil {
		return x.Type
	}
	return ""
}

func (m *Target) GetAttrs() isTarget_Attrs {
	if m != nil {
		return m.Attrs
	}
	return nil
}

func (x *Target) GetAttributes() *structpb.Struct {
	if x, ok := x.GetAttrs().(*Target_Attributes); ok {
		return x.Attributes
	}
	return nil
}

func (x *Target) GetSshTargetAttributes() *SshTargetAttributes {
	if x, ok := x.GetAttrs().(*Target_SshTargetAttributes); ok {
		return x.SshTargetAttributes
	}
	return nil
}

type isTarget_Attrs interface {
	isTarget_Attrs()
}

type Target_Attributes struct {
	// The attributes that are applicable for the specific Target.
	Attributes *structpb.Struct `protobuf:"bytes,11,opt,name=attributes,proto3,oneof"`
}

type Target_SshTargetAttributes struct {
	SshTargetAttributes *SshTargetAttributes `protobuf:"bytes,12,opt,name=ssh_target_attributes,json=sshTargetAttributes,proto3,oneof"`
}

func (*Target_Attributes) isTarget_Attrs() {}

func (*Target_SshTargetAttributes) isTarget_Attrs() {}

// SshTargetAttributes contains attributes relevant to Targets of type "ssh"
type SshTargetAttributes struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The default SSH port that is used when connecting to the endpoint.
	DefaultPort uint32 `protobuf:"varint,1,opt,name=default_port,proto3" json:"default_port,omitempty" class:"public"` // @gotags: class:"public"
	// The default TCP port that will be listened on by the client's local proxy.
	DefaultClientPort uint32 `protobuf:"varint,2,opt,name=default_client_port,proto3" json:"default_client_port,omitempty" class:"public"` // @gotags: class:"public"
}

func (x *SshTargetAttributes) Reset() {
	*x = SshTargetAttributes{}
	if protoimpl.UnsafeEnabled {
		mi := &file_controller_api_resources_sessionrecordings_v1_session_recording_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SshTargetAttributes) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SshTargetAttributes) ProtoMessage() {}

func (x *SshTargetAttributes) ProtoReflect() protoreflect.Message {
	mi := &file_controller_api_resources_sessionrecordings_v1_session_recording_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SshTargetAttributes.ProtoReflect.Descriptor instead.
func (*SshTargetAttributes) Descriptor() ([]byte, []int) {
	return file_controller_api_resources_sessionrecordings_v1_session_recording_proto_rawDescGZIP(), []int{7}
}

func (x *SshTargetAttributes) GetDefaultPort() uint32 {
	if x != nil {
		return x.DefaultPort
	}
	return 0
}

func (x *SshTargetAttributes) GetDefaultClientPort() uint32 {
	if x != nil {
		return x.DefaultClientPort
	}
	return 0
}

// CredentialStore contains all fields related to a Credential Store resource
type CredentialStore struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The ID of the Credential Store.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty" class:"public" eventstream:"observation"` // @gotags: class:"public" eventstream:"observation"
	// The ID of the Scope of which this Credential Store is a part.
	ScopeId string `protobuf:"bytes,2,opt,name=scope_id,proto3" json:"scope_id,omitempty" class:"public" eventstream:"observation"` // @gotags: class:"public" eventstream:"observation"
	// The name for identification purposes if set.
	Name string `protobuf:"bytes,3,opt,name=name,proto3" json:"name,omitempty" class:"public"` // @gotags: class:"public"
	// The description for identification purposes if set.
	Description string `protobuf:"bytes,4,opt,name=description,proto3" json:"description,omitempty" class:"public"` // @gotags: class:"public"
	// The Credential Store type.
	Type string `protobuf:"bytes,5,opt,name=type,proto3" json:"type,omitempty" class:"public" eventstream:"observation"` // @gotags: class:"public" eventstream:"observation"
	// Types that are assignable to Attrs:
	//
	//	*CredentialStore_Attributes
	//	*CredentialStore_VaultCredentialStoreAttributes
	Attrs isCredentialStore_Attrs `protobuf_oneof:"attrs"`
}

func (x *CredentialStore) Reset() {
	*x = CredentialStore{}
	if protoimpl.UnsafeEnabled {
		mi := &file_controller_api_resources_sessionrecordings_v1_session_recording_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CredentialStore) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CredentialStore) ProtoMessage() {}

func (x *CredentialStore) ProtoReflect() protoreflect.Message {
	mi := &file_controller_api_resources_sessionrecordings_v1_session_recording_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CredentialStore.ProtoReflect.Descriptor instead.
func (*CredentialStore) Descriptor() ([]byte, []int) {
	return file_controller_api_resources_sessionrecordings_v1_session_recording_proto_rawDescGZIP(), []int{8}
}

func (x *CredentialStore) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

func (x *CredentialStore) GetScopeId() string {
	if x != nil {
		return x.ScopeId
	}
	return ""
}

func (x *CredentialStore) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *CredentialStore) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *CredentialStore) GetType() string {
	if x != nil {
		return x.Type
	}
	return ""
}

func (m *CredentialStore) GetAttrs() isCredentialStore_Attrs {
	if m != nil {
		return m.Attrs
	}
	return nil
}

func (x *CredentialStore) GetAttributes() *structpb.Struct {
	if x, ok := x.GetAttrs().(*CredentialStore_Attributes); ok {
		return x.Attributes
	}
	return nil
}

func (x *CredentialStore) GetVaultCredentialStoreAttributes() *VaultCredentialStoreAttributes {
	if x, ok := x.GetAttrs().(*CredentialStore_VaultCredentialStoreAttributes); ok {
		return x.VaultCredentialStoreAttributes
	}
	return nil
}

type isCredentialStore_Attrs interface {
	isCredentialStore_Attrs()
}

type CredentialStore_Attributes struct {
	// The attributes that are applicable for the specific Credential Store type.
	Attributes *structpb.Struct `protobuf:"bytes,6,opt,name=attributes,proto3,oneof"`
}

type CredentialStore_VaultCredentialStoreAttributes struct {
	VaultCredentialStoreAttributes *VaultCredentialStoreAttributes `protobuf:"bytes,7,opt,name=vault_credential_store_attributes,json=vaultCredentialStoreAttributes,proto3,oneof"`
}

func (*CredentialStore_Attributes) isCredentialStore_Attrs() {}

func (*CredentialStore_VaultCredentialStoreAttributes) isCredentialStore_Attrs() {}

// The attributes of a vault typed Credential Store.
type VaultCredentialStoreAttributes struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The complete url address of vault.
	Address string `protobuf:"bytes,1,opt,name=address,proto3" json:"address,omitempty" class:"public"` // @gotags: class:"public"
	// The namespace of vault used by this store
	Namespace string `protobuf:"bytes,2,opt,name=namespace,proto3" json:"namespace,omitempty" class:"public"` // @gotags: class:"public"
	// The value to use as the SNI host when connecting to vault via TLS.
	TlsServerName string `protobuf:"bytes,3,opt,name=tls_server_name,proto3" json:"tls_server_name,omitempty" class:"public"` // @gotags: class:"public"
	// Indicates if verification of the TLS certificate is disabled.
	TlsSkipVerify bool `protobuf:"varint,4,opt,name=tls_skip_verify,proto3" json:"tls_skip_verify,omitempty" class:"public"` // @gotags: class:"public"
	// Filters to the worker(s) who can handle Vault requests for this cred store if set.
	WorkerFilter string `protobuf:"bytes,5,opt,name=worker_filter,proto3" json:"worker_filter,omitempty" class:"public"` // @gotags: class:"public"
}

func (x *VaultCredentialStoreAttributes) Reset() {
	*x = VaultCredentialStoreAttributes{}
	if protoimpl.UnsafeEnabled {
		mi := &file_controller_api_resources_sessionrecordings_v1_session_recording_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *VaultCredentialStoreAttributes) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*VaultCredentialStoreAttributes) ProtoMessage() {}

func (x *VaultCredentialStoreAttributes) ProtoReflect() protoreflect.Message {
	mi := &file_controller_api_resources_sessionrecordings_v1_session_recording_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use VaultCredentialStoreAttributes.ProtoReflect.Descriptor instead.
func (*VaultCredentialStoreAttributes) Descriptor() ([]byte, []int) {
	return file_controller_api_resources_sessionrecordings_v1_session_recording_proto_rawDescGZIP(), []int{9}
}

func (x *VaultCredentialStoreAttributes) GetAddress() string {
	if x != nil {
		return x.Address
	}
	return ""
}

func (x *VaultCredentialStoreAttributes) GetNamespace() string {
	if x != nil {
		return x.Namespace
	}
	return ""
}

func (x *VaultCredentialStoreAttributes) GetTlsServerName() string {
	if x != nil {
		return x.TlsServerName
	}
	return ""
}

func (x *VaultCredentialStoreAttributes) GetTlsSkipVerify() bool {
	if x != nil {
		return x.TlsSkipVerify
	}
	return false
}

func (x *VaultCredentialStoreAttributes) GetWorkerFilter() string {
	if x != nil {
		return x.WorkerFilter
	}
	return ""
}

// Credential contains fields related to an Credential resource
type Credential struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The ID of the Credential.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty" class:"public" eventstream:"observation"` // @gotags: class:"public" eventstream:"observation"
	// The Credential Store of which this Credential is a part.
	CredentialStore *CredentialStore `protobuf:"bytes,2,opt,name=credential_store,proto3" json:"credential_store,omitempty"`
	// The name of the credential.
	Name string `protobuf:"bytes,3,opt,name=name,proto3" json:"name,omitempty" class:"public"` // @gotags: class:"public"
	// Optional user-set description.
	Description string `protobuf:"bytes,4,opt,name=description,proto3" json:"description,omitempty" class:"public"` // @gotags: class:"public"
	// The purposes for which this Credential was attached to the sesssion.
	Purposes []string `protobuf:"bytes,5,rep,name=purposes,proto3" json:"purposes,omitempty" class:"public"` // @gotags: class:"public"
	// The Credential type.
	Type string `protobuf:"bytes,6,opt,name=type,proto3" json:"type,omitempty" class:"public" eventstream:"observation"` // @gotags: class:"public" eventstream:"observation"
	// Types that are assignable to Attrs:
	//
	//	*Credential_Attributes
	//	*Credential_UsernamePasswordAttributes
	//	*Credential_SshPrivateKeyAttributes
	//	*Credential_JsonAttributes
	Attrs isCredential_Attrs `protobuf_oneof:"attrs"`
}

func (x *Credential) Reset() {
	*x = Credential{}
	if protoimpl.UnsafeEnabled {
		mi := &file_controller_api_resources_sessionrecordings_v1_session_recording_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Credential) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Credential) ProtoMessage() {}

func (x *Credential) ProtoReflect() protoreflect.Message {
	mi := &file_controller_api_resources_sessionrecordings_v1_session_recording_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Credential.ProtoReflect.Descriptor instead.
func (*Credential) Descriptor() ([]byte, []int) {
	return file_controller_api_resources_sessionrecordings_v1_session_recording_proto_rawDescGZIP(), []int{10}
}

func (x *Credential) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

func (x *Credential) GetCredentialStore() *CredentialStore {
	if x != nil {
		return x.CredentialStore
	}
	return nil
}

func (x *Credential) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Credential) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *Credential) GetPurposes() []string {
	if x != nil {
		return x.Purposes
	}
	return nil
}

func (x *Credential) GetType() string {
	if x != nil {
		return x.Type
	}
	return ""
}

func (m *Credential) GetAttrs() isCredential_Attrs {
	if m != nil {
		return m.Attrs
	}
	return nil
}

func (x *Credential) GetAttributes() *structpb.Struct {
	if x, ok := x.GetAttrs().(*Credential_Attributes); ok {
		return x.Attributes
	}
	return nil
}

func (x *Credential) GetUsernamePasswordAttributes() *UsernamePasswordCredentialAttributes {
	if x, ok := x.GetAttrs().(*Credential_UsernamePasswordAttributes); ok {
		return x.UsernamePasswordAttributes
	}
	return nil
}

func (x *Credential) GetSshPrivateKeyAttributes() *SshPrivateKeyCredentialAttributes {
	if x, ok := x.GetAttrs().(*Credential_SshPrivateKeyAttributes); ok {
		return x.SshPrivateKeyAttributes
	}
	return nil
}

func (x *Credential) GetJsonAttributes() *JsonCredentialAttributes {
	if x, ok := x.GetAttrs().(*Credential_JsonAttributes); ok {
		return x.JsonAttributes
	}
	return nil
}

type isCredential_Attrs interface {
	isCredential_Attrs()
}

type Credential_Attributes struct {
	// The attributes that are applicable for the specific Credential type.
	Attributes *structpb.Struct `protobuf:"bytes,7,opt,name=attributes,proto3,oneof"`
}

type Credential_UsernamePasswordAttributes struct {
	UsernamePasswordAttributes *UsernamePasswordCredentialAttributes `protobuf:"bytes,8,opt,name=username_password_attributes,json=usernamePasswordAttributes,proto3,oneof"`
}

type Credential_SshPrivateKeyAttributes struct {
	SshPrivateKeyAttributes *SshPrivateKeyCredentialAttributes `protobuf:"bytes,9,opt,name=ssh_private_key_attributes,json=sshPrivateKeyAttributes,proto3,oneof"`
}

type Credential_JsonAttributes struct {
	JsonAttributes *JsonCredentialAttributes `protobuf:"bytes,10,opt,name=json_attributes,json=jsonAttributes,proto3,oneof"`
}

func (*Credential_Attributes) isCredential_Attrs() {}

func (*Credential_UsernamePasswordAttributes) isCredential_Attrs() {}

func (*Credential_SshPrivateKeyAttributes) isCredential_Attrs() {}

func (*Credential_JsonAttributes) isCredential_Attrs() {}

// The attributes of a UsernamePassword Credential.
type UsernamePasswordCredentialAttributes struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The username associated with the credential.
	Username string `protobuf:"bytes,1,opt,name=username,proto3" json:"username,omitempty" class:"public"` // @gotags: class:"public"
	// The hmac value of the password.
	PasswordHmac string `protobuf:"bytes,2,opt,name=password_hmac,json=passwordHmac,proto3" json:"password_hmac,omitempty" class:"public"` // @gotags: class:"public"
}

func (x *UsernamePasswordCredentialAttributes) Reset() {
	*x = UsernamePasswordCredentialAttributes{}
	if protoimpl.UnsafeEnabled {
		mi := &file_controller_api_resources_sessionrecordings_v1_session_recording_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UsernamePasswordCredentialAttributes) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UsernamePasswordCredentialAttributes) ProtoMessage() {}

func (x *UsernamePasswordCredentialAttributes) ProtoReflect() protoreflect.Message {
	mi := &file_controller_api_resources_sessionrecordings_v1_session_recording_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UsernamePasswordCredentialAttributes.ProtoReflect.Descriptor instead.
func (*UsernamePasswordCredentialAttributes) Descriptor() ([]byte, []int) {
	return file_controller_api_resources_sessionrecordings_v1_session_recording_proto_rawDescGZIP(), []int{11}
}

func (x *UsernamePasswordCredentialAttributes) GetUsername() string {
	if x != nil {
		return x.Username
	}
	return ""
}

func (x *UsernamePasswordCredentialAttributes) GetPasswordHmac() string {
	if x != nil {
		return x.PasswordHmac
	}
	return ""
}

// The attributes of a SshPrivateKey Credential.
type SshPrivateKeyCredentialAttributes struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The username associated with the credential.
	Username string `protobuf:"bytes,1,opt,name=username,proto3" json:"username,omitempty" class:"public"` // @gotags: class:"public"
	// The hmac value of the SSH private key.
	PrivateKeyHmac string `protobuf:"bytes,2,opt,name=private_key_hmac,json=privateKeyHmac,proto3" json:"private_key_hmac,omitempty" class:"public"` // @gotags: class:"public"
	// The hmac value of the SSH private key passphrase.
	PrivateKeyPassphraseHmac string `protobuf:"bytes,3,opt,name=private_key_passphrase_hmac,json=privateKeyPassphraseHmac,proto3" json:"private_key_passphrase_hmac,omitempty" class:"public"` // @gotags: class:"public"
}

func (x *SshPrivateKeyCredentialAttributes) Reset() {
	*x = SshPrivateKeyCredentialAttributes{}
	if protoimpl.UnsafeEnabled {
		mi := &file_controller_api_resources_sessionrecordings_v1_session_recording_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SshPrivateKeyCredentialAttributes) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SshPrivateKeyCredentialAttributes) ProtoMessage() {}

func (x *SshPrivateKeyCredentialAttributes) ProtoReflect() protoreflect.Message {
	mi := &file_controller_api_resources_sessionrecordings_v1_session_recording_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SshPrivateKeyCredentialAttributes.ProtoReflect.Descriptor instead.
func (*SshPrivateKeyCredentialAttributes) Descriptor() ([]byte, []int) {
	return file_controller_api_resources_sessionrecordings_v1_session_recording_proto_rawDescGZIP(), []int{12}
}

func (x *SshPrivateKeyCredentialAttributes) GetUsername() string {
	if x != nil {
		return x.Username
	}
	return ""
}

func (x *SshPrivateKeyCredentialAttributes) GetPrivateKeyHmac() string {
	if x != nil {
		return x.PrivateKeyHmac
	}
	return ""
}

func (x *SshPrivateKeyCredentialAttributes) GetPrivateKeyPassphraseHmac() string {
	if x != nil {
		return x.PrivateKeyPassphraseHmac
	}
	return ""
}

// The attributes of a JSON Credential.
type JsonCredentialAttributes struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The hmac value of the object.
	ObjectHmac string `protobuf:"bytes,1,opt,name=object_hmac,json=objectHmac,proto3" json:"object_hmac,omitempty" class:"public"` // @gotags: class:"public"
}

func (x *JsonCredentialAttributes) Reset() {
	*x = JsonCredentialAttributes{}
	if protoimpl.UnsafeEnabled {
		mi := &file_controller_api_resources_sessionrecordings_v1_session_recording_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *JsonCredentialAttributes) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*JsonCredentialAttributes) ProtoMessage() {}

func (x *JsonCredentialAttributes) ProtoReflect() protoreflect.Message {
	mi := &file_controller_api_resources_sessionrecordings_v1_session_recording_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use JsonCredentialAttributes.ProtoReflect.Descriptor instead.
func (*JsonCredentialAttributes) Descriptor() ([]byte, []int) {
	return file_controller_api_resources_sessionrecordings_v1_session_recording_proto_rawDescGZIP(), []int{13}
}

func (x *JsonCredentialAttributes) GetObjectHmac() string {
	if x != nil {
		return x.ObjectHmac
	}
	return ""
}

// CredentialLibrary contains all fields related to an Credential Library resource
type CredentialLibrary struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The ID of the Credential Library.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty" class:"public" eventstream:"observation"` // @gotags: class:"public" eventstream:"observation"
	// The credential store of which this library is a part.
	CredentialStore *CredentialStore `protobuf:"bytes,2,opt,name=credential_store,proto3" json:"credential_store,omitempty"`
	// Optional name of this Credential Library.
	Name string `protobuf:"bytes,3,opt,name=name,proto3" json:"name,omitempty" class:"public"` // @gotags: class:"public"
	// Optional user-set description of this Credential Library.
	Description string `protobuf:"bytes,4,opt,name=description,proto3" json:"description,omitempty" class:"public"` // @gotags: class:"public"
	// The purposes for which this CredentialLibrary was attached to the sesssion.
	Purposes []string `protobuf:"bytes,5,rep,name=purposes,proto3" json:"purposes,omitempty" class:"public"` // @gotags: class:"public"
	// The Credential Library type.
	Type string `protobuf:"bytes,6,opt,name=type,proto3" json:"type,omitempty" class:"public" eventstream:"observation"` // @gotags: class:"public" eventstream:"observation"
	// Types that are assignable to Attrs:
	//
	//	*CredentialLibrary_Attributes
	//	*CredentialLibrary_VaultCredentialLibraryAttributes
	//	*CredentialLibrary_VaultGenericCredentialLibraryAttributes
	//	*CredentialLibrary_VaultSshCertificateCredentialLibraryAttributes
	Attrs isCredentialLibrary_Attrs `protobuf_oneof:"attrs"`
}

func (x *CredentialLibrary) Reset() {
	*x = CredentialLibrary{}
	if protoimpl.UnsafeEnabled {
		mi := &file_controller_api_resources_sessionrecordings_v1_session_recording_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CredentialLibrary) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CredentialLibrary) ProtoMessage() {}

func (x *CredentialLibrary) ProtoReflect() protoreflect.Message {
	mi := &file_controller_api_resources_sessionrecordings_v1_session_recording_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CredentialLibrary.ProtoReflect.Descriptor instead.
func (*CredentialLibrary) Descriptor() ([]byte, []int) {
	return file_controller_api_resources_sessionrecordings_v1_session_recording_proto_rawDescGZIP(), []int{14}
}

func (x *CredentialLibrary) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

func (x *CredentialLibrary) GetCredentialStore() *CredentialStore {
	if x != nil {
		return x.CredentialStore
	}
	return nil
}

func (x *CredentialLibrary) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *CredentialLibrary) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *CredentialLibrary) GetPurposes() []string {
	if x != nil {
		return x.Purposes
	}
	return nil
}

func (x *CredentialLibrary) GetType() string {
	if x != nil {
		return x.Type
	}
	return ""
}

func (m *CredentialLibrary) GetAttrs() isCredentialLibrary_Attrs {
	if m != nil {
		return m.Attrs
	}
	return nil
}

func (x *CredentialLibrary) GetAttributes() *structpb.Struct {
	if x, ok := x.GetAttrs().(*CredentialLibrary_Attributes); ok {
		return x.Attributes
	}
	return nil
}

func (x *CredentialLibrary) GetVaultCredentialLibraryAttributes() *VaultCredentialLibraryAttributes {
	if x, ok := x.GetAttrs().(*CredentialLibrary_VaultCredentialLibraryAttributes); ok {
		return x.VaultCredentialLibraryAttributes
	}
	return nil
}

func (x *CredentialLibrary) GetVaultGenericCredentialLibraryAttributes() *VaultCredentialLibraryAttributes {
	if x, ok := x.GetAttrs().(*CredentialLibrary_VaultGenericCredentialLibraryAttributes); ok {
		return x.VaultGenericCredentialLibraryAttributes
	}
	return nil
}

func (x *CredentialLibrary) GetVaultSshCertificateCredentialLibraryAttributes() *VaultSSHCertificateCredentialLibraryAttributes {
	if x, ok := x.GetAttrs().(*CredentialLibrary_VaultSshCertificateCredentialLibraryAttributes); ok {
		return x.VaultSshCertificateCredentialLibraryAttributes
	}
	return nil
}

type isCredentialLibrary_Attrs interface {
	isCredentialLibrary_Attrs()
}

type CredentialLibrary_Attributes struct {
	// The attributes that are applicable for the specific Credential Library type.
	Attributes *structpb.Struct `protobuf:"bytes,7,opt,name=attributes,proto3,oneof"`
}

type CredentialLibrary_VaultCredentialLibraryAttributes struct {
	VaultCredentialLibraryAttributes *VaultCredentialLibraryAttributes `protobuf:"bytes,8,opt,name=vault_credential_library_attributes,json=vaultCredentialLibraryAttributes,proto3,oneof"`
}

type CredentialLibrary_VaultGenericCredentialLibraryAttributes struct {
	VaultGenericCredentialLibraryAttributes *VaultCredentialLibraryAttributes `protobuf:"bytes,9,opt,name=vault_generic_credential_library_attributes,json=vaultGenericCredentialLibraryAttributes,proto3,oneof"`
}

type CredentialLibrary_VaultSshCertificateCredentialLibraryAttributes struct {
	VaultSshCertificateCredentialLibraryAttributes *VaultSSHCertificateCredentialLibraryAttributes `protobuf:"bytes,10,opt,name=vault_ssh_certificate_credential_library_attributes,json=vaultSshCertificateCredentialLibraryAttributes,proto3,oneof"`
}

func (*CredentialLibrary_Attributes) isCredentialLibrary_Attrs() {}

func (*CredentialLibrary_VaultCredentialLibraryAttributes) isCredentialLibrary_Attrs() {}

func (*CredentialLibrary_VaultGenericCredentialLibraryAttributes) isCredentialLibrary_Attrs() {}

func (*CredentialLibrary_VaultSshCertificateCredentialLibraryAttributes) isCredentialLibrary_Attrs() {
}

// The attributes of a vault typed Credential Library.
type VaultCredentialLibraryAttributes struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The path in Vault to request credentials from.
	Path string `protobuf:"bytes,1,opt,name=path,proto3" json:"path,omitempty" class:"public"` // @gotags: class:"public"
	// The HTTP method the library uses to communicate with Vault.
	HttpMethod string `protobuf:"bytes,2,opt,name=http_method,json=httpMethod,proto3" json:"http_method,omitempty" class:"public"` // @gotags: class:"public"
	// The body of the HTTP request the library sends to vault.
	HttpRequestBody string `protobuf:"bytes,3,opt,name=http_request_body,json=httpRequestBody,proto3" json:"http_request_body,omitempty" class:"secret"` // @gotags: `class:"secret"`
}

func (x *VaultCredentialLibraryAttributes) Reset() {
	*x = VaultCredentialLibraryAttributes{}
	if protoimpl.UnsafeEnabled {
		mi := &file_controller_api_resources_sessionrecordings_v1_session_recording_proto_msgTypes[15]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *VaultCredentialLibraryAttributes) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*VaultCredentialLibraryAttributes) ProtoMessage() {}

func (x *VaultCredentialLibraryAttributes) ProtoReflect() protoreflect.Message {
	mi := &file_controller_api_resources_sessionrecordings_v1_session_recording_proto_msgTypes[15]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use VaultCredentialLibraryAttributes.ProtoReflect.Descriptor instead.
func (*VaultCredentialLibraryAttributes) Descriptor() ([]byte, []int) {
	return file_controller_api_resources_sessionrecordings_v1_session_recording_proto_rawDescGZIP(), []int{15}
}

func (x *VaultCredentialLibraryAttributes) GetPath() string {
	if x != nil {
		return x.Path
	}
	return ""
}

func (x *VaultCredentialLibraryAttributes) GetHttpMethod() string {
	if x != nil {
		return x.HttpMethod
	}
	return ""
}

func (x *VaultCredentialLibraryAttributes) GetHttpRequestBody() string {
	if x != nil {
		return x.HttpRequestBody
	}
	return ""
}

// The attributes of a vault SSH Certificate Credential Library.
type VaultSSHCertificateCredentialLibraryAttributes struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The path in Vault to request credentials from.
	Path string `protobuf:"bytes,1,opt,name=path,proto3" json:"path,omitempty" class:"public"` // @gotags: class:"public"
	// The username used when making an SSH connection.
	Username string `protobuf:"bytes,2,opt,name=username,proto3" json:"username,omitempty" class:"sensitive"` // @gotags: `class:"sensitive"`
	// The key type to use when generating an SSH private key.
	KeyType string `protobuf:"bytes,3,opt,name=key_type,json=keyType,proto3" json:"key_type,omitempty" class:"public"` // @gotags: class:"public"
	// The number of bits to use to generate an SSH private key.
	KeyBits uint32 `protobuf:"varint,4,opt,name=key_bits,json=keyBits,proto3" json:"key_bits,omitempty" class:"public"` // @gotags: class:"public"
	// The requested time to live for the certificate.
	Ttl string `protobuf:"bytes,5,opt,name=ttl,proto3" json:"ttl,omitempty" class:"public"` // @gotags: class:"public"
	// The critical options that the certificate should be signed for.
	CriticalOptions map[string]string `protobuf:"bytes,6,rep,name=critical_options,json=criticalOptions,proto3" json:"critical_options,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3" class:"public"` // @gotags: class:"public"
	// The extensions that the certificate should be signed for.
	Extensions map[string]string `protobuf:"bytes,7,rep,name=extensions,proto3" json:"extensions,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3" class:"public"` // @gotags: class:"public"
	// Principals to be signed as "valid_principles" in addition to username.
	AdditionalValidPrincipals []string `protobuf:"bytes,8,rep,name=additional_valid_principals,json=additionalValidPrincipals,proto3" json:"additional_valid_principals,omitempty" class:"public"` // @gotags: class:"public"
}

func (x *VaultSSHCertificateCredentialLibraryAttributes) Reset() {
	*x = VaultSSHCertificateCredentialLibraryAttributes{}
	if protoimpl.UnsafeEnabled {
		mi := &file_controller_api_resources_sessionrecordings_v1_session_recording_proto_msgTypes[16]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *VaultSSHCertificateCredentialLibraryAttributes) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*VaultSSHCertificateCredentialLibraryAttributes) ProtoMessage() {}

func (x *VaultSSHCertificateCredentialLibraryAttributes) ProtoReflect() protoreflect.Message {
	mi := &file_controller_api_resources_sessionrecordings_v1_session_recording_proto_msgTypes[16]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use VaultSSHCertificateCredentialLibraryAttributes.ProtoReflect.Descriptor instead.
func (*VaultSSHCertificateCredentialLibraryAttributes) Descriptor() ([]byte, []int) {
	return file_controller_api_resources_sessionrecordings_v1_session_recording_proto_rawDescGZIP(), []int{16}
}

func (x *VaultSSHCertificateCredentialLibraryAttributes) GetPath() string {
	if x != nil {
		return x.Path
	}
	return ""
}

func (x *VaultSSHCertificateCredentialLibraryAttributes) GetUsername() string {
	if x != nil {
		return x.Username
	}
	return ""
}

func (x *VaultSSHCertificateCredentialLibraryAttributes) GetKeyType() string {
	if x != nil {
		return x.KeyType
	}
	return ""
}

func (x *VaultSSHCertificateCredentialLibraryAttributes) GetKeyBits() uint32 {
	if x != nil {
		return x.KeyBits
	}
	return 0
}

func (x *VaultSSHCertificateCredentialLibraryAttributes) GetTtl() string {
	if x != nil {
		return x.Ttl
	}
	return ""
}

func (x *VaultSSHCertificateCredentialLibraryAttributes) GetCriticalOptions() map[string]string {
	if x != nil {
		return x.CriticalOptions
	}
	return nil
}

func (x *VaultSSHCertificateCredentialLibraryAttributes) GetExtensions() map[string]string {
	if x != nil {
		return x.Extensions
	}
	return nil
}

func (x *VaultSSHCertificateCredentialLibraryAttributes) GetAdditionalValidPrincipals() []string {
	if x != nil {
		return x.AdditionalValidPrincipals
	}
	return nil
}

// ValuesAtTime contain information about other Boundary resources as they
// were at a certain time through the lifetime of the Session Recording.
type ValuesAtTime struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Information about the User that created the Session.
	User *User `protobuf:"bytes,1,opt,name=user,proto3" json:"user,omitempty" class:"public"` // @gotags: class:"public"
	// Information about the Target the Session connected to.
	Target *Target `protobuf:"bytes,2,opt,name=target,proto3" json:"target,omitempty" class:"public"` // @gotags: class:"public"
	// Information about the Host chosen for the session.
	Host *Host `protobuf:"bytes,3,opt,name=host,proto3" json:"host,omitempty" class:"public"` // @gotags: class:"public"
	// Information about the Credentials used for this session.
	Credentials []*Credential `protobuf:"bytes,4,rep,name=credentials,proto3" json:"credentials,omitempty"`
	// Information about the Credential Libraries used for this session.
	CredentialLibraries []*CredentialLibrary `protobuf:"bytes,5,rep,name=credential_libraries,proto3" json:"credential_libraries,omitempty"`
}

func (x *ValuesAtTime) Reset() {
	*x = ValuesAtTime{}
	if protoimpl.UnsafeEnabled {
		mi := &file_controller_api_resources_sessionrecordings_v1_session_recording_proto_msgTypes[17]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ValuesAtTime) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ValuesAtTime) ProtoMessage() {}

func (x *ValuesAtTime) ProtoReflect() protoreflect.Message {
	mi := &file_controller_api_resources_sessionrecordings_v1_session_recording_proto_msgTypes[17]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ValuesAtTime.ProtoReflect.Descriptor instead.
func (*ValuesAtTime) Descriptor() ([]byte, []int) {
	return file_controller_api_resources_sessionrecordings_v1_session_recording_proto_rawDescGZIP(), []int{17}
}

func (x *ValuesAtTime) GetUser() *User {
	if x != nil {
		return x.User
	}
	return nil
}

func (x *ValuesAtTime) GetTarget() *Target {
	if x != nil {
		return x.Target
	}
	return nil
}

func (x *ValuesAtTime) GetHost() *Host {
	if x != nil {
		return x.Host
	}
	return nil
}

func (x *ValuesAtTime) GetCredentials() []*Credential {
	if x != nil {
		return x.Credentials
	}
	return nil
}

func (x *ValuesAtTime) GetCredentialLibraries() []*CredentialLibrary {
	if x != nil {
		return x.CredentialLibraries
	}
	return nil
}

// SessionRecording contains information about the recording of a Session.
type SessionRecording struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The ID of the Session recording.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty" class:"public"` // @gotags: class:"public"
	// The scope that the Session Recording is in.
	// This is inferred from the storage bucket associated
	// with the target.
	Scope *scopes.ScopeInfo `protobuf:"bytes,2,opt,name=scope,proto3" json:"scope,omitempty" class:"public"` // @gotags: class:"public"
	// The ID of the Session which this Session Recording recorded.
	SessionId string `protobuf:"bytes,3,opt,name=session_id,proto3" json:"session_id,omitempty" class:"public" eventstream:"observation"` // @gotags: class:"public" eventstream:"observation"
	// The ID of the Storage Bucket for the Target of this Session Recording.
	StorageBucketId string `protobuf:"bytes,4,opt,name=storage_bucket_id,proto3" json:"storage_bucket_id,omitempty" class:"public" eventstream:"observation"` // @gotags: class:"public" eventstream:"observation"
	// The total number of bytes uploaded from the client in the Session.
	// This includes all bytes uploaded over all Connections, including
	// any protocol overhead.
	BytesUp uint64 `protobuf:"varint,5,opt,name=bytes_up,proto3" json:"bytes_up,omitempty" class:"public" eventstream:"observation"` // @gotags: class:"public" eventstream:"observation"
	// The total number of bytes downloaded to the client in the Session.
	// This includes all bytes downloaded over all Connections, including
	// any protocol overhead.
	BytesDown uint64 `protobuf:"varint,6,opt,name=bytes_down,proto3" json:"bytes_down,omitempty" class:"public" eventstream:"observation"` // @gotags: class:"public" eventstream:"observation"
	// The time the Session Recording was created in the controller.
	CreatedTime *timestamppb.Timestamp `protobuf:"bytes,7,opt,name=created_time,proto3" json:"created_time,omitempty" class:"public" eventstream:"observation"` // @gotags: class:"public" eventstream:"observation"
	// The time of the most recent update to the Session Recording.
	UpdatedTime *timestamppb.Timestamp `protobuf:"bytes,8,opt,name=updated_time,proto3" json:"updated_time,omitempty" class:"public" eventstream:"observation"` // @gotags: class:"public" eventstream:"observation"
	// The time the Session started.
	StartTime *timestamppb.Timestamp `protobuf:"bytes,9,opt,name=start_time,proto3" json:"start_time,omitempty" class:"public" eventstream:"observation"` // @gotags: class:"public" eventstream:"observation"
	// The time the Session ended.
	EndTime *timestamppb.Timestamp `protobuf:"bytes,10,opt,name=end_time,proto3" json:"end_time,omitempty" class:"public" eventstream:"observation"` // @gotags: class:"public" eventstream:"observation"
	// The total duration of the Session.
	Duration *durationpb.Duration `protobuf:"bytes,11,opt,name=duration,proto3" json:"duration,omitempty" class:"public" eventstream:"observation"` // @gotags: class:"public" eventstream:"observation"
	// Type of the Session that was recorded (e.g. ssh).
	Type string `protobuf:"bytes,12,opt,name=type,proto3" json:"type,omitempty" class:"public" eventstream:"observation"` // @gotags: class:"public" eventstream:"observation"
	// The current state of the session recording. One of
	// "started", "available" and "unknown".
	State string `protobuf:"bytes,13,opt,name=state,proto3" json:"state,omitempty" class:"public" eventstream:"observation"` // @gotags: class:"public" eventstream:"observation"
	// Any error seen during the closing of the session recording.
	// Currently only set if state is "unknown".
	ErrorDetails string `protobuf:"bytes,14,opt,name=error_details,json=errorDetails,proto3" json:"error_details,omitempty" class:"public"` // @gotags: class:"public"
	// MimeTypes define the mime types that can
	// be used to consume the recording of this Session.
	// No mime types are currently supported.
	MimeTypes []string `protobuf:"bytes,15,rep,name=mime_types,proto3" json:"mime_types,omitempty" class:"public" eventstream:"observation"` // @gotags: class:"public" eventstream:"observation"
	// The endpoint of the Session; that is, the address to which the egress worker connected.
	Endpoint string `protobuf:"bytes,16,opt,name=endpoint,proto3" json:"endpoint,omitempty" class:"public"` // @gotags: class:"public"
	// The recordings of the connections that were created in the Session.
	// This field may be unset when listing Session recordings.
	ConnectionRecordings []*ConnectionRecording `protobuf:"bytes,17,rep,name=connection_recordings,proto3" json:"connection_recordings,omitempty"`
	// create_time_values contains the values of related fields at the time
	// this Session Recording was created. This may be unset when listing.
	CreateTimeValues *ValuesAtTime `protobuf:"bytes,18,opt,name=create_time_values,proto3" json:"create_time_values,omitempty" class:"public"` // @gotags: class:"public"
	// The available actions on this resource for this user.
	AuthorizedActions []string `protobuf:"bytes,19,rep,name=authorized_actions,proto3" json:"authorized_actions,omitempty" class:"public"` // @gotags: class:"public"
	// The time until a session recording is required to be stored.
	RetainUntil *timestamppb.Timestamp `protobuf:"bytes,20,opt,name=retain_until,proto3" json:"retain_until,omitempty" class:"public" eventstream:"observation"` // @gotags: class:"public" eventstream:"observation"
	// The time a session recording is scheduled to be automatically deleted.
	DeleteAfter *timestamppb.Timestamp `protobuf:"bytes,21,opt,name=delete_after,proto3" json:"delete_after,omitempty" class:"public" eventstream:"observation"` // @gotags: class:"public" eventstream:"observation"
}

func (x *SessionRecording) Reset() {
	*x = SessionRecording{}
	if protoimpl.UnsafeEnabled {
		mi := &file_controller_api_resources_sessionrecordings_v1_session_recording_proto_msgTypes[18]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SessionRecording) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SessionRecording) ProtoMessage() {}

func (x *SessionRecording) ProtoReflect() protoreflect.Message {
	mi := &file_controller_api_resources_sessionrecordings_v1_session_recording_proto_msgTypes[18]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SessionRecording.ProtoReflect.Descriptor instead.
func (*SessionRecording) Descriptor() ([]byte, []int) {
	return file_controller_api_resources_sessionrecordings_v1_session_recording_proto_rawDescGZIP(), []int{18}
}

func (x *SessionRecording) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

func (x *SessionRecording) GetScope() *scopes.ScopeInfo {
	if x != nil {
		return x.Scope
	}
	return nil
}

func (x *SessionRecording) GetSessionId() string {
	if x != nil {
		return x.SessionId
	}
	return ""
}

func (x *SessionRecording) GetStorageBucketId() string {
	if x != nil {
		return x.StorageBucketId
	}
	return ""
}

func (x *SessionRecording) GetBytesUp() uint64 {
	if x != nil {
		return x.BytesUp
	}
	return 0
}

func (x *SessionRecording) GetBytesDown() uint64 {
	if x != nil {
		return x.BytesDown
	}
	return 0
}

func (x *SessionRecording) GetCreatedTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreatedTime
	}
	return nil
}

func (x *SessionRecording) GetUpdatedTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdatedTime
	}
	return nil
}

func (x *SessionRecording) GetStartTime() *timestamppb.Timestamp {
	if x != nil {
		return x.StartTime
	}
	return nil
}

func (x *SessionRecording) GetEndTime() *timestamppb.Timestamp {
	if x != nil {
		return x.EndTime
	}
	return nil
}

func (x *SessionRecording) GetDuration() *durationpb.Duration {
	if x != nil {
		return x.Duration
	}
	return nil
}

func (x *SessionRecording) GetType() string {
	if x != nil {
		return x.Type
	}
	return ""
}

func (x *SessionRecording) GetState() string {
	if x != nil {
		return x.State
	}
	return ""
}

func (x *SessionRecording) GetErrorDetails() string {
	if x != nil {
		return x.ErrorDetails
	}
	return ""
}

func (x *SessionRecording) GetMimeTypes() []string {
	if x != nil {
		return x.MimeTypes
	}
	return nil
}

func (x *SessionRecording) GetEndpoint() string {
	if x != nil {
		return x.Endpoint
	}
	return ""
}

func (x *SessionRecording) GetConnectionRecordings() []*ConnectionRecording {
	if x != nil {
		return x.ConnectionRecordings
	}
	return nil
}

func (x *SessionRecording) GetCreateTimeValues() *ValuesAtTime {
	if x != nil {
		return x.CreateTimeValues
	}
	return nil
}

func (x *SessionRecording) GetAuthorizedActions() []string {
	if x != nil {
		return x.AuthorizedActions
	}
	return nil
}

func (x *SessionRecording) GetRetainUntil() *timestamppb.Timestamp {
	if x != nil {
		return x.RetainUntil
	}
	return nil
}

func (x *SessionRecording) GetDeleteAfter() *timestamppb.Timestamp {
	if x != nil {
		return x.DeleteAfter
	}
	return nil
}

var File_controller_api_resources_sessionrecordings_v1_session_recording_proto protoreflect.FileDescriptor

var file_controller_api_resources_sessionrecordings_v1_session_recording_proto_rawDesc = []byte{
	0x0a, 0x45, 0x63, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x6c, 0x65, 0x72, 0x2f, 0x61, 0x70, 0x69,
	0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2f, 0x73, 0x65, 0x73, 0x73, 0x69,
	0x6f, 0x6e, 0x72, 0x65, 0x63, 0x6f, 0x72, 0x64, 0x69, 0x6e, 0x67, 0x73, 0x2f, 0x76, 0x31, 0x2f,
	0x73, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x72, 0x65, 0x63, 0x6f, 0x72, 0x64, 0x69, 0x6e,
	0x67, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x2d, 0x63, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c,
	0x6c, 0x65, 0x72, 0x2e, 0x61, 0x70, 0x69, 0x2e, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x73, 0x2e, 0x73, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x72, 0x65, 0x63, 0x6f, 0x72, 0x64, 0x69,
	0x6e, 0x67, 0x73, 0x2e, 0x76, 0x31, 0x1a, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x6c,
	0x65, 0x72, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73,
	0x2f, 0x73, 0x63, 0x6f, 0x70, 0x65, 0x73, 0x2f, 0x76, 0x31, 0x2f, 0x73, 0x63, 0x6f, 0x70, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x2a, 0x63, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x6c,
	0x65, 0x72, 0x2f, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x5f, 0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2f, 0x76, 0x31, 0x2f, 0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x1a, 0x1b, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x76,
	0x69, 0x73, 0x69, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a,
	0x1e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2f, 0x64, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a,
	0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2f, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74,
	0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xa9,
	0x03, 0x0a, 0x10, 0x43, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x52, 0x65, 0x63, 0x6f, 0x72, 0x64,
	0x69, 0x6e, 0x67, 0x12, 0x0e, 0x0a, 0x02, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x02, 0x69, 0x64, 0x12, 0x1a, 0x0a, 0x08, 0x62, 0x79, 0x74, 0x65, 0x73, 0x5f, 0x75, 0x70, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x04, 0x52, 0x08, 0x62, 0x79, 0x74, 0x65, 0x73, 0x5f, 0x75, 0x70, 0x12,
	0x1e, 0x0a, 0x0a, 0x62, 0x79, 0x74, 0x65, 0x73, 0x5f, 0x64, 0x6f, 0x77, 0x6e, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x04, 0x52, 0x0a, 0x62, 0x79, 0x74, 0x65, 0x73, 0x5f, 0x64, 0x6f, 0x77, 0x6e, 0x12,
	0x3e, 0x0a, 0x0c, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x64, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d,
	0x70, 0x52, 0x0c, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x64, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x12,
	0x3e, 0x0a, 0x0c, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x64, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18,
	0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d,
	0x70, 0x52, 0x0c, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x64, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x12,
	0x3a, 0x0a, 0x0a, 0x73, 0x74, 0x61, 0x72, 0x74, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x06, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52,
	0x0a, 0x73, 0x74, 0x61, 0x72, 0x74, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x12, 0x36, 0x0a, 0x08, 0x65,
	0x6e, 0x64, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x08, 0x65, 0x6e, 0x64, 0x5f, 0x74,
	0x69, 0x6d, 0x65, 0x12, 0x35, 0x0a, 0x08, 0x64, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18,
	0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x52, 0x08, 0x64, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x1e, 0x0a, 0x0a, 0x6d, 0x69,
	0x6d, 0x65, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x73, 0x18, 0x09, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0a,
	0x6d, 0x69, 0x6d, 0x65, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x73, 0x22, 0x9d, 0x04, 0x0a, 0x13, 0x43,
	0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x63, 0x6f, 0x72, 0x64, 0x69,
	0x6e, 0x67, 0x12, 0x0e, 0x0a, 0x02, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x02,
	0x69, 0x64, 0x12, 0x1a, 0x0a, 0x08, 0x62, 0x79, 0x74, 0x65, 0x73, 0x5f, 0x75, 0x70, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x04, 0x52, 0x08, 0x62, 0x79, 0x74, 0x65, 0x73, 0x5f, 0x75, 0x70, 0x12, 0x1e,
	0x0a, 0x0a, 0x62, 0x79, 0x74, 0x65, 0x73, 0x5f, 0x64, 0x6f, 0x77, 0x6e, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x04, 0x52, 0x0a, 0x62, 0x79, 0x74, 0x65, 0x73, 0x5f, 0x64, 0x6f, 0x77, 0x6e, 0x12, 0x3e,
	0x0a, 0x0c, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x64, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70,
	0x52, 0x0c, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x64, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x12, 0x3e,
	0x0a, 0x0c, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x64, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x05,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70,
	0x52, 0x0c, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x64, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x12, 0x3a,
	0x0a, 0x0a, 0x73, 0x74, 0x61, 0x72, 0x74, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x06, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0a,
	0x73, 0x74, 0x61, 0x72, 0x74, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x12, 0x36, 0x0a, 0x08, 0x65, 0x6e,
	0x64, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54,
	0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x08, 0x65, 0x6e, 0x64, 0x5f, 0x74, 0x69,
	0x6d, 0x65, 0x12, 0x35, 0x0a, 0x08, 0x64, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x08,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52,
	0x08, 0x64, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x1e, 0x0a, 0x0a, 0x6d, 0x69, 0x6d,
	0x65, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x73, 0x18, 0x09, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0a, 0x6d,
	0x69, 0x6d, 0x65, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x73, 0x12, 0x6f, 0x0a, 0x12, 0x63, 0x68, 0x61,
	0x6e, 0x6e, 0x65, 0x6c, 0x5f, 0x72, 0x65, 0x63, 0x6f, 0x72, 0x64, 0x69, 0x6e, 0x67, 0x73, 0x18,
	0x0a, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x3f, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x6c,
	0x65, 0x72, 0x2e, 0x61, 0x70, 0x69, 0x2e, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73,
	0x2e, 0x73, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x72, 0x65, 0x63, 0x6f, 0x72, 0x64, 0x69, 0x6e,
	0x67, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x52, 0x65, 0x63,
	0x6f, 0x72, 0x64, 0x69, 0x6e, 0x67, 0x52, 0x12, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x5f,
	0x72, 0x65, 0x63, 0x6f, 0x72, 0x64, 0x69, 0x6e, 0x67, 0x73, 0x22, 0x91, 0x01, 0x0a, 0x04, 0x55,
	0x73, 0x65, 0x72, 0x12, 0x0e, 0x0a, 0x02, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x02, 0x69, 0x64, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x20, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72,
	0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x65,
	0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x43, 0x0a, 0x05, 0x73, 0x63, 0x6f,
	0x70, 0x65, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x72,
	0x6f, 0x6c, 0x6c, 0x65, 0x72, 0x2e, 0x61, 0x70, 0x69, 0x2e, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x73, 0x2e, 0x73, 0x63, 0x6f, 0x70, 0x65, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x63,
	0x6f, 0x70, 0x65, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x05, 0x73, 0x63, 0x6f, 0x70, 0x65, 0x22, 0x8e,
	0x02, 0x0a, 0x0b, 0x48, 0x6f, 0x73, 0x74, 0x43, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x12, 0x0e,
	0x0a, 0x02, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x02, 0x69, 0x64, 0x12, 0x43,
	0x0a, 0x05, 0x73, 0x63, 0x6f, 0x70, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2d, 0x2e,
	0x63, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x6c, 0x65, 0x72, 0x2e, 0x61, 0x70, 0x69, 0x2e, 0x72,
	0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2e, 0x73, 0x63, 0x6f, 0x70, 0x65, 0x73, 0x2e,
	0x76, 0x31, 0x2e, 0x53, 0x63, 0x6f, 0x70, 0x65, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x05, 0x73, 0x63,
	0x6f, 0x70, 0x65, 0x12, 0x1c, 0x0a, 0x09, 0x70, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x5f, 0x69, 0x64,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x5f, 0x69,
	0x64, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x20, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70,
	0x74, 0x69, 0x6f, 0x6e, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x65, 0x73, 0x63,
	0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x12, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18,
	0x06, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x12, 0x39, 0x0a, 0x0a, 0x61,
	0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x17, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x53, 0x74, 0x72, 0x75, 0x63, 0x74, 0x48, 0x00, 0x52, 0x0a, 0x61, 0x74, 0x74, 0x72,
	0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x42, 0x07, 0x0a, 0x05, 0x61, 0x74, 0x74, 0x72, 0x73, 0x22,
	0xf3, 0x03, 0x0a, 0x04, 0x48, 0x6f, 0x73, 0x74, 0x12, 0x0e, 0x0a, 0x02, 0x69, 0x64, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x02, 0x69, 0x64, 0x12, 0x5e, 0x0a, 0x0c, 0x68, 0x6f, 0x73, 0x74,
	0x5f, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3a,
	0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x6c, 0x65, 0x72, 0x2e, 0x61, 0x70, 0x69, 0x2e,
	0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2e, 0x73, 0x65, 0x73, 0x73, 0x69, 0x6f,
	0x6e, 0x72, 0x65, 0x63, 0x6f, 0x72, 0x64, 0x69, 0x6e, 0x67, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x48,
	0x6f, 0x73, 0x74, 0x43, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x52, 0x0c, 0x68, 0x6f, 0x73, 0x74,
	0x5f, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x20, 0x0a, 0x0b,
	0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x12,
	0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x74, 0x79,
	0x70, 0x65, 0x12, 0x46, 0x0a, 0x0a, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73,
	0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x75, 0x63, 0x74, 0x42,
	0x0b, 0x9a, 0xe3, 0x29, 0x07, 0x64, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x48, 0x00, 0x52, 0x0a,
	0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x12, 0x97, 0x01, 0x0a, 0x16, 0x73,
	0x74, 0x61, 0x74, 0x69, 0x63, 0x5f, 0x68, 0x6f, 0x73, 0x74, 0x5f, 0x61, 0x74, 0x74, 0x72, 0x69,
	0x62, 0x75, 0x74, 0x65, 0x73, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x43, 0x2e, 0x63, 0x6f,
	0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x6c, 0x65, 0x72, 0x2e, 0x61, 0x70, 0x69, 0x2e, 0x72, 0x65, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2e, 0x73, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x72, 0x65,
	0x63, 0x6f, 0x72, 0x64, 0x69, 0x6e, 0x67, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x74, 0x61, 0x74,
	0x69, 0x63, 0x48, 0x6f, 0x73, 0x74, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73,
	0x42, 0x1a, 0x9a, 0xe3, 0x29, 0x06, 0x73, 0x74, 0x61, 0x74, 0x69, 0x63, 0xfa, 0xd2, 0xe4, 0x93,
	0x02, 0x0a, 0x12, 0x08, 0x49, 0x4e, 0x54, 0x45, 0x52, 0x4e, 0x41, 0x4c, 0x48, 0x00, 0x52, 0x14,
	0x73, 0x74, 0x61, 0x74, 0x69, 0x63, 0x48, 0x6f, 0x73, 0x74, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62,
	0x75, 0x74, 0x65, 0x73, 0x12, 0x20, 0x0a, 0x0b, 0x65, 0x78, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c,
	0x5f, 0x69, 0x64, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x65, 0x78, 0x74, 0x65, 0x72,
	0x6e, 0x61, 0x6c, 0x5f, 0x69, 0x64, 0x12, 0x24, 0x0a, 0x0d, 0x65, 0x78, 0x74, 0x65, 0x72, 0x6e,
	0x61, 0x6c, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x08, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x65,
	0x78, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x42, 0x07, 0x0a, 0x05,
	0x61, 0x74, 0x74, 0x72, 0x73, 0x22, 0x30, 0x0a, 0x14, 0x53, 0x74, 0x61, 0x74, 0x69, 0x63, 0x48,
	0x6f, 0x73, 0x74, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x12, 0x18, 0x0a,
	0x07, 0x61, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07,
	0x61, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x22, 0x8a, 0x05, 0x0a, 0x06, 0x54, 0x61, 0x72, 0x67,
	0x65, 0x74, 0x12, 0x0e, 0x0a, 0x02, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x02,
	0x69, 0x64, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x20, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69,
	0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x65, 0x73,
	0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x43, 0x0a, 0x05, 0x73, 0x63, 0x6f, 0x70,
	0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x72, 0x6f,
	0x6c, 0x6c, 0x65, 0x72, 0x2e, 0x61, 0x70, 0x69, 0x2e, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x73, 0x2e, 0x73, 0x63, 0x6f, 0x70, 0x65, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x63, 0x6f,
	0x70, 0x65, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x05, 0x73, 0x63, 0x6f, 0x70, 0x65, 0x12, 0x30, 0x0a,
	0x13, 0x73, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x6d, 0x61, 0x78, 0x5f, 0x73, 0x65, 0x63,
	0x6f, 0x6e, 0x64, 0x73, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x13, 0x73, 0x65, 0x73, 0x73,
	0x69, 0x6f, 0x6e, 0x5f, 0x6d, 0x61, 0x78, 0x5f, 0x73, 0x65, 0x63, 0x6f, 0x6e, 0x64, 0x73, 0x12,
	0x3a, 0x0a, 0x18, 0x73, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x6f, 0x6e, 0x6e, 0x65,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6c, 0x69, 0x6d, 0x69, 0x74, 0x18, 0x06, 0x20, 0x01, 0x28,
	0x05, 0x52, 0x18, 0x73, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x6f, 0x6e, 0x6e, 0x65,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6c, 0x69, 0x6d, 0x69, 0x74, 0x12, 0x24, 0x0a, 0x0d, 0x77,
	0x6f, 0x72, 0x6b, 0x65, 0x72, 0x5f, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x07, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x0d, 0x77, 0x6f, 0x72, 0x6b, 0x65, 0x72, 0x5f, 0x66, 0x69, 0x6c, 0x74, 0x65,
	0x72, 0x12, 0x32, 0x0a, 0x14, 0x65, 0x67, 0x72, 0x65, 0x73, 0x73, 0x5f, 0x77, 0x6f, 0x72, 0x6b,
	0x65, 0x72, 0x5f, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x08, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x14, 0x65, 0x67, 0x72, 0x65, 0x73, 0x73, 0x5f, 0x77, 0x6f, 0x72, 0x6b, 0x65, 0x72, 0x5f, 0x66,
	0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x34, 0x0a, 0x15, 0x69, 0x6e, 0x67, 0x72, 0x65, 0x73, 0x73,
	0x5f, 0x77, 0x6f, 0x72, 0x6b, 0x65, 0x72, 0x5f, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x09,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x15, 0x69, 0x6e, 0x67, 0x72, 0x65, 0x73, 0x73, 0x5f, 0x77, 0x6f,
	0x72, 0x6b, 0x65, 0x72, 0x5f, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x12, 0x0a, 0x04, 0x74,
	0x79, 0x70, 0x65, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x12,
	0x46, 0x0a, 0x0a, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x18, 0x0b, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x75, 0x63, 0x74, 0x42, 0x0b, 0x9a, 0xe3,
	0x29, 0x07, 0x64, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x48, 0x00, 0x52, 0x0a, 0x61, 0x74, 0x74,
	0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x12, 0x91, 0x01, 0x0a, 0x15, 0x73, 0x73, 0x68, 0x5f,
	0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x5f, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65,
	0x73, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x42, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x72, 0x6f,
	0x6c, 0x6c, 0x65, 0x72, 0x2e, 0x61, 0x70, 0x69, 0x2e, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x73, 0x2e, 0x73, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x72, 0x65, 0x63, 0x6f, 0x72, 0x64,
	0x69, 0x6e, 0x67, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x73, 0x68, 0x54, 0x61, 0x72, 0x67, 0x65,
	0x74, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x42, 0x17, 0x9a, 0xe3, 0x29,
	0x03, 0x73, 0x73, 0x68, 0xfa, 0xd2, 0xe4, 0x93, 0x02, 0x0a, 0x12, 0x08, 0x49, 0x4e, 0x54, 0x45,
	0x52, 0x4e, 0x41, 0x4c, 0x48, 0x00, 0x52, 0x13, 0x73, 0x73, 0x68, 0x54, 0x61, 0x72, 0x67, 0x65,
	0x74, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x42, 0x07, 0x0a, 0x05, 0x61,
	0x74, 0x74, 0x72, 0x73, 0x22, 0x6b, 0x0a, 0x13, 0x53, 0x73, 0x68, 0x54, 0x61, 0x72, 0x67, 0x65,
	0x74, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x12, 0x22, 0x0a, 0x0c, 0x64,
	0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x5f, 0x70, 0x6f, 0x72, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0d, 0x52, 0x0c, 0x64, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x5f, 0x70, 0x6f, 0x72, 0x74, 0x12,
	0x30, 0x0a, 0x13, 0x64, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x5f, 0x63, 0x6c, 0x69, 0x65, 0x6e,
	0x74, 0x5f, 0x70, 0x6f, 0x72, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x13, 0x64, 0x65,
	0x66, 0x61, 0x75, 0x6c, 0x74, 0x5f, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x5f, 0x70, 0x6f, 0x72,
	0x74, 0x22, 0x90, 0x03, 0x0a, 0x0f, 0x43, 0x72, 0x65, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x61, 0x6c,
	0x53, 0x74, 0x6f, 0x72, 0x65, 0x12, 0x0e, 0x0a, 0x02, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x02, 0x69, 0x64, 0x12, 0x1a, 0x0a, 0x08, 0x73, 0x63, 0x6f, 0x70, 0x65, 0x5f, 0x69,
	0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x73, 0x63, 0x6f, 0x70, 0x65, 0x5f, 0x69,
	0x64, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x20, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70,
	0x74, 0x69, 0x6f, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x65, 0x73, 0x63,
	0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x12, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18,
	0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x12, 0x46, 0x0a, 0x0a, 0x61,
	0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x17, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x53, 0x74, 0x72, 0x75, 0x63, 0x74, 0x42, 0x0b, 0x9a, 0xe3, 0x29, 0x07, 0x64, 0x65,
	0x66, 0x61, 0x75, 0x6c, 0x74, 0x48, 0x00, 0x52, 0x0a, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75,
	0x74, 0x65, 0x73, 0x12, 0xb5, 0x01, 0x0a, 0x21, 0x76, 0x61, 0x75, 0x6c, 0x74, 0x5f, 0x63, 0x72,
	0x65, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x61, 0x6c, 0x5f, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x5f, 0x61,
	0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x4d, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x6c, 0x65, 0x72, 0x2e, 0x61, 0x70, 0x69,
	0x2e, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2e, 0x73, 0x65, 0x73, 0x73, 0x69,
	0x6f, 0x6e, 0x72, 0x65, 0x63, 0x6f, 0x72, 0x64, 0x69, 0x6e, 0x67, 0x73, 0x2e, 0x76, 0x31, 0x2e,
	0x56, 0x61, 0x75, 0x6c, 0x74, 0x43, 0x72, 0x65, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x61, 0x6c, 0x53,
	0x74, 0x6f, 0x72, 0x65, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x42, 0x19,
	0x9a, 0xe3, 0x29, 0x05, 0x76, 0x61, 0x75, 0x6c, 0x74, 0xfa, 0xd2, 0xe4, 0x93, 0x02, 0x0a, 0x12,
	0x08, 0x49, 0x4e, 0x54, 0x45, 0x52, 0x4e, 0x41, 0x4c, 0x48, 0x00, 0x52, 0x1e, 0x76, 0x61, 0x75,
	0x6c, 0x74, 0x43, 0x72, 0x65, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x61, 0x6c, 0x53, 0x74, 0x6f, 0x72,
	0x65, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x42, 0x07, 0x0a, 0x05, 0x61,
	0x74, 0x74, 0x72, 0x73, 0x22, 0xd2, 0x01, 0x0a, 0x1e, 0x56, 0x61, 0x75, 0x6c, 0x74, 0x43, 0x72,
	0x65, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x61, 0x6c, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x41, 0x74, 0x74,
	0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x12, 0x18, 0x0a, 0x07, 0x61, 0x64, 0x64, 0x72, 0x65,
	0x73, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x61, 0x64, 0x64, 0x72, 0x65, 0x73,
	0x73, 0x12, 0x1c, 0x0a, 0x09, 0x6e, 0x61, 0x6d, 0x65, 0x73, 0x70, 0x61, 0x63, 0x65, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x6e, 0x61, 0x6d, 0x65, 0x73, 0x70, 0x61, 0x63, 0x65, 0x12,
	0x28, 0x0a, 0x0f, 0x74, 0x6c, 0x73, 0x5f, 0x73, 0x65, 0x72, 0x76, 0x65, 0x72, 0x5f, 0x6e, 0x61,
	0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0f, 0x74, 0x6c, 0x73, 0x5f, 0x73, 0x65,
	0x72, 0x76, 0x65, 0x72, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x28, 0x0a, 0x0f, 0x74, 0x6c, 0x73,
	0x5f, 0x73, 0x6b, 0x69, 0x70, 0x5f, 0x76, 0x65, 0x72, 0x69, 0x66, 0x79, 0x18, 0x04, 0x20, 0x01,
	0x28, 0x08, 0x52, 0x0f, 0x74, 0x6c, 0x73, 0x5f, 0x73, 0x6b, 0x69, 0x70, 0x5f, 0x76, 0x65, 0x72,
	0x69, 0x66, 0x79, 0x12, 0x24, 0x0a, 0x0d, 0x77, 0x6f, 0x72, 0x6b, 0x65, 0x72, 0x5f, 0x66, 0x69,
	0x6c, 0x74, 0x65, 0x72, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x77, 0x6f, 0x72, 0x6b,
	0x65, 0x72, 0x5f, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x22, 0xc6, 0x06, 0x0a, 0x0a, 0x43, 0x72,
	0x65, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x61, 0x6c, 0x12, 0x0e, 0x0a, 0x02, 0x69, 0x64, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x02, 0x69, 0x64, 0x12, 0x6a, 0x0a, 0x10, 0x63, 0x72, 0x65, 0x64,
	0x65, 0x6e, 0x74, 0x69, 0x61, 0x6c, 0x5f, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x3e, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x6c, 0x65, 0x72, 0x2e,
	0x61, 0x70, 0x69, 0x2e, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2e, 0x73, 0x65,
	0x73, 0x73, 0x69, 0x6f, 0x6e, 0x72, 0x65, 0x63, 0x6f, 0x72, 0x64, 0x69, 0x6e, 0x67, 0x73, 0x2e,
	0x76, 0x31, 0x2e, 0x43, 0x72, 0x65, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x61, 0x6c, 0x53, 0x74, 0x6f,
	0x72, 0x65, 0x52, 0x10, 0x63, 0x72, 0x65, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x61, 0x6c, 0x5f, 0x73,
	0x74, 0x6f, 0x72, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x20, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63,
	0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64,
	0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x1a, 0x0a, 0x08, 0x70, 0x75,
	0x72, 0x70, 0x6f, 0x73, 0x65, 0x73, 0x18, 0x05, 0x20, 0x03, 0x28, 0x09, 0x52, 0x08, 0x70, 0x75,
	0x72, 0x70, 0x6f, 0x73, 0x65, 0x73, 0x12, 0x12, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x06,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x12, 0x46, 0x0a, 0x0a, 0x61, 0x74,
	0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x53, 0x74, 0x72, 0x75, 0x63, 0x74, 0x42, 0x0b, 0x9a, 0xe3, 0x29, 0x07, 0x64, 0x65, 0x66,
	0x61, 0x75, 0x6c, 0x74, 0x48, 0x00, 0x52, 0x0a, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74,
	0x65, 0x73, 0x12, 0xbe, 0x01, 0x0a, 0x1c, 0x75, 0x73, 0x65, 0x72, 0x6e, 0x61, 0x6d, 0x65, 0x5f,
	0x70, 0x61, 0x73, 0x73, 0x77, 0x6f, 0x72, 0x64, 0x5f, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75,
	0x74, 0x65, 0x73, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x53, 0x2e, 0x63, 0x6f, 0x6e, 0x74,
	0x72, 0x6f, 0x6c, 0x6c, 0x65, 0x72, 0x2e, 0x61, 0x70, 0x69, 0x2e, 0x72, 0x65, 0x73, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x73, 0x2e, 0x73, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x72, 0x65, 0x63, 0x6f,
	0x72, 0x64, 0x69, 0x6e, 0x67, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x55, 0x73, 0x65, 0x72, 0x6e, 0x61,
	0x6d, 0x65, 0x50, 0x61, 0x73, 0x73, 0x77, 0x6f, 0x72, 0x64, 0x43, 0x72, 0x65, 0x64, 0x65, 0x6e,
	0x74, 0x69, 0x61, 0x6c, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x42, 0x25,
	0x9a, 0xe3, 0x29, 0x11, 0x75, 0x73, 0x65, 0x72, 0x6e, 0x61, 0x6d, 0x65, 0x5f, 0x70, 0x61, 0x73,
	0x73, 0x77, 0x6f, 0x72, 0x64, 0xfa, 0xd2, 0xe4, 0x93, 0x02, 0x0a, 0x12, 0x08, 0x49, 0x4e, 0x54,
	0x45, 0x52, 0x4e, 0x41, 0x4c, 0x48, 0x00, 0x52, 0x1a, 0x75, 0x73, 0x65, 0x72, 0x6e, 0x61, 0x6d,
	0x65, 0x50, 0x61, 0x73, 0x73, 0x77, 0x6f, 0x72, 0x64, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75,
	0x74, 0x65, 0x73, 0x12, 0xb4, 0x01, 0x0a, 0x1a, 0x73, 0x73, 0x68, 0x5f, 0x70, 0x72, 0x69, 0x76,
	0x61, 0x74, 0x65, 0x5f, 0x6b, 0x65, 0x79, 0x5f, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74,
	0x65, 0x73, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x50, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x72,
	0x6f, 0x6c, 0x6c, 0x65, 0x72, 0x2e, 0x61, 0x70, 0x69, 0x2e, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x73, 0x2e, 0x73, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x72, 0x65, 0x63, 0x6f, 0x72,
	0x64, 0x69, 0x6e, 0x67, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x73, 0x68, 0x50, 0x72, 0x69, 0x76,
	0x61, 0x74, 0x65, 0x4b, 0x65, 0x79, 0x43, 0x72, 0x65, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x61, 0x6c,
	0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x42, 0x23, 0x9a, 0xe3, 0x29, 0x0f,
	0x73, 0x73, 0x68, 0x5f, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x5f, 0x6b, 0x65, 0x79, 0xfa,
	0xd2, 0xe4, 0x93, 0x02, 0x0a, 0x12, 0x08, 0x49, 0x4e, 0x54, 0x45, 0x52, 0x4e, 0x41, 0x4c, 0x48,
	0x00, 0x52, 0x17, 0x73, 0x73, 0x68, 0x50, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x4b, 0x65, 0x79,
	0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x12, 0x8c, 0x01, 0x0a, 0x0f, 0x6a,
	0x73, 0x6f, 0x6e, 0x5f, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x18, 0x0a,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x47, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x6c, 0x65,
	0x72, 0x2e, 0x61, 0x70, 0x69, 0x2e, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2e,
	0x73, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x72, 0x65, 0x63, 0x6f, 0x72, 0x64, 0x69, 0x6e, 0x67,
	0x73, 0x2e, 0x76, 0x31, 0x2e, 0x4a, 0x73, 0x6f, 0x6e, 0x43, 0x72, 0x65, 0x64, 0x65, 0x6e, 0x74,
	0x69, 0x61, 0x6c, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x42, 0x18, 0x9a,
	0xe3, 0x29, 0x04, 0x6a, 0x73, 0x6f, 0x6e, 0xfa, 0xd2, 0xe4, 0x93, 0x02, 0x0a, 0x12, 0x08, 0x49,
	0x4e, 0x54, 0x45, 0x52, 0x4e, 0x41, 0x4c, 0x48, 0x00, 0x52, 0x0e, 0x6a, 0x73, 0x6f, 0x6e, 0x41,
	0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x42, 0x07, 0x0a, 0x05, 0x61, 0x74, 0x74,
	0x72, 0x73, 0x22, 0x67, 0x0a, 0x24, 0x55, 0x73, 0x65, 0x72, 0x6e, 0x61, 0x6d, 0x65, 0x50, 0x61,
	0x73, 0x73, 0x77, 0x6f, 0x72, 0x64, 0x43, 0x72, 0x65, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x61, 0x6c,
	0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x12, 0x1a, 0x0a, 0x08, 0x75, 0x73,
	0x65, 0x72, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x75, 0x73,
	0x65, 0x72, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x23, 0x0a, 0x0d, 0x70, 0x61, 0x73, 0x73, 0x77, 0x6f,
	0x72, 0x64, 0x5f, 0x68, 0x6d, 0x61, 0x63, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x70,
	0x61, 0x73, 0x73, 0x77, 0x6f, 0x72, 0x64, 0x48, 0x6d, 0x61, 0x63, 0x22, 0xa8, 0x01, 0x0a, 0x21,
	0x53, 0x73, 0x68, 0x50, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x4b, 0x65, 0x79, 0x43, 0x72, 0x65,
	0x64, 0x65, 0x6e, 0x74, 0x69, 0x61, 0x6c, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65,
	0x73, 0x12, 0x1a, 0x0a, 0x08, 0x75, 0x73, 0x65, 0x72, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x08, 0x75, 0x73, 0x65, 0x72, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x28, 0x0a,
	0x10, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x5f, 0x6b, 0x65, 0x79, 0x5f, 0x68, 0x6d, 0x61,
	0x63, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65,
	0x4b, 0x65, 0x79, 0x48, 0x6d, 0x61, 0x63, 0x12, 0x3d, 0x0a, 0x1b, 0x70, 0x72, 0x69, 0x76, 0x61,
	0x74, 0x65, 0x5f, 0x6b, 0x65, 0x79, 0x5f, 0x70, 0x61, 0x73, 0x73, 0x70, 0x68, 0x72, 0x61, 0x73,
	0x65, 0x5f, 0x68, 0x6d, 0x61, 0x63, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x18, 0x70, 0x72,
	0x69, 0x76, 0x61, 0x74, 0x65, 0x4b, 0x65, 0x79, 0x50, 0x61, 0x73, 0x73, 0x70, 0x68, 0x72, 0x61,
	0x73, 0x65, 0x48, 0x6d, 0x61, 0x63, 0x22, 0x3b, 0x0a, 0x18, 0x4a, 0x73, 0x6f, 0x6e, 0x43, 0x72,
	0x65, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x61, 0x6c, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74,
	0x65, 0x73, 0x12, 0x1f, 0x0a, 0x0b, 0x6f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x68, 0x6d, 0x61,
	0x63, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x6f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x48,
	0x6d, 0x61, 0x63, 0x22, 0xd3, 0x07, 0x0a, 0x11, 0x43, 0x72, 0x65, 0x64, 0x65, 0x6e, 0x74, 0x69,
	0x61, 0x6c, 0x4c, 0x69, 0x62, 0x72, 0x61, 0x72, 0x79, 0x12, 0x0e, 0x0a, 0x02, 0x69, 0x64, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x02, 0x69, 0x64, 0x12, 0x6a, 0x0a, 0x10, 0x63, 0x72, 0x65,
	0x64, 0x65, 0x6e, 0x74, 0x69, 0x61, 0x6c, 0x5f, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x3e, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x6c, 0x65, 0x72,
	0x2e, 0x61, 0x70, 0x69, 0x2e, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2e, 0x73,
	0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x72, 0x65, 0x63, 0x6f, 0x72, 0x64, 0x69, 0x6e, 0x67, 0x73,
	0x2e, 0x76, 0x31, 0x2e, 0x43, 0x72, 0x65, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x61, 0x6c, 0x53, 0x74,
	0x6f, 0x72, 0x65, 0x52, 0x10, 0x63, 0x72, 0x65, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x61, 0x6c, 0x5f,
	0x73, 0x74, 0x6f, 0x72, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x20, 0x0a, 0x0b, 0x64, 0x65, 0x73,
	0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b,
	0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x1a, 0x0a, 0x08, 0x70,
	0x75, 0x72, 0x70, 0x6f, 0x73, 0x65, 0x73, 0x18, 0x05, 0x20, 0x03, 0x28, 0x09, 0x52, 0x08, 0x70,
	0x75, 0x72, 0x70, 0x6f, 0x73, 0x65, 0x73, 0x12, 0x12, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18,
	0x06, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x12, 0x46, 0x0a, 0x0a, 0x61,
	0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x17, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x53, 0x74, 0x72, 0x75, 0x63, 0x74, 0x42, 0x0b, 0x9a, 0xe3, 0x29, 0x07, 0x64, 0x65,
	0x66, 0x61, 0x75, 0x6c, 0x74, 0x48, 0x00, 0x52, 0x0a, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75,
	0x74, 0x65, 0x73, 0x12, 0xbb, 0x01, 0x0a, 0x23, 0x76, 0x61, 0x75, 0x6c, 0x74, 0x5f, 0x63, 0x72,
	0x65, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x61, 0x6c, 0x5f, 0x6c, 0x69, 0x62, 0x72, 0x61, 0x72, 0x79,
	0x5f, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x18, 0x08, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x4f, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x6c, 0x65, 0x72, 0x2e, 0x61,
	0x70, 0x69, 0x2e, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2e, 0x73, 0x65, 0x73,
	0x73, 0x69, 0x6f, 0x6e, 0x72, 0x65, 0x63, 0x6f, 0x72, 0x64, 0x69, 0x6e, 0x67, 0x73, 0x2e, 0x76,
	0x31, 0x2e, 0x56, 0x61, 0x75, 0x6c, 0x74, 0x43, 0x72, 0x65, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x61,
	0x6c, 0x4c, 0x69, 0x62, 0x72, 0x61, 0x72, 0x79, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74,
	0x65, 0x73, 0x42, 0x19, 0x9a, 0xe3, 0x29, 0x05, 0x76, 0x61, 0x75, 0x6c, 0x74, 0xfa, 0xd2, 0xe4,
	0x93, 0x02, 0x0a, 0x12, 0x08, 0x49, 0x4e, 0x54, 0x45, 0x52, 0x4e, 0x41, 0x4c, 0x48, 0x00, 0x52,
	0x20, 0x76, 0x61, 0x75, 0x6c, 0x74, 0x43, 0x72, 0x65, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x61, 0x6c,
	0x4c, 0x69, 0x62, 0x72, 0x61, 0x72, 0x79, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65,
	0x73, 0x12, 0xd2, 0x01, 0x0a, 0x2b, 0x76, 0x61, 0x75, 0x6c, 0x74, 0x5f, 0x67, 0x65, 0x6e, 0x65,
	0x72, 0x69, 0x63, 0x5f, 0x63, 0x72, 0x65, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x61, 0x6c, 0x5f, 0x6c,
	0x69, 0x62, 0x72, 0x61, 0x72, 0x79, 0x5f, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65,
	0x73, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x4f, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x72, 0x6f,
	0x6c, 0x6c, 0x65, 0x72, 0x2e, 0x61, 0x70, 0x69, 0x2e, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x73, 0x2e, 0x73, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x72, 0x65, 0x63, 0x6f, 0x72, 0x64,
	0x69, 0x6e, 0x67, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x56, 0x61, 0x75, 0x6c, 0x74, 0x43, 0x72, 0x65,
	0x64, 0x65, 0x6e, 0x74, 0x69, 0x61, 0x6c, 0x4c, 0x69, 0x62, 0x72, 0x61, 0x72, 0x79, 0x41, 0x74,
	0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x42, 0x21, 0x9a, 0xe3, 0x29, 0x0d, 0x76, 0x61,
	0x75, 0x6c, 0x74, 0x2d, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x69, 0x63, 0xfa, 0xd2, 0xe4, 0x93, 0x02,
	0x0a, 0x12, 0x08, 0x49, 0x4e, 0x54, 0x45, 0x52, 0x4e, 0x41, 0x4c, 0x48, 0x00, 0x52, 0x27, 0x76,
	0x61, 0x75, 0x6c, 0x74, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x69, 0x63, 0x43, 0x72, 0x65, 0x64, 0x65,
	0x6e, 0x74, 0x69, 0x61, 0x6c, 0x4c, 0x69, 0x62, 0x72, 0x61, 0x72, 0x79, 0x41, 0x74, 0x74, 0x72,
	0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x12, 0xf7, 0x01, 0x0a, 0x33, 0x76, 0x61, 0x75, 0x6c, 0x74,
	0x5f, 0x73, 0x73, 0x68, 0x5f, 0x63, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65,
	0x5f, 0x63, 0x72, 0x65, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x61, 0x6c, 0x5f, 0x6c, 0x69, 0x62, 0x72,
	0x61, 0x72, 0x79, 0x5f, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x18, 0x0a,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x5d, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x6c, 0x65,
	0x72, 0x2e, 0x61, 0x70, 0x69, 0x2e, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2e,
	0x73, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x72, 0x65, 0x63, 0x6f, 0x72, 0x64, 0x69, 0x6e, 0x67,
	0x73, 0x2e, 0x76, 0x31, 0x2e, 0x56, 0x61, 0x75, 0x6c, 0x74, 0x53, 0x53, 0x48, 0x43, 0x65, 0x72,
	0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x43, 0x72, 0x65, 0x64, 0x65, 0x6e, 0x74, 0x69,
	0x61, 0x6c, 0x4c, 0x69, 0x62, 0x72, 0x61, 0x72, 0x79, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75,
	0x74, 0x65, 0x73, 0x42, 0x29, 0x9a, 0xe3, 0x29, 0x15, 0x76, 0x61, 0x75, 0x6c, 0x74, 0x2d, 0x73,
	0x73, 0x68, 0x2d, 0x63, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0xfa, 0xd2,
	0xe4, 0x93, 0x02, 0x0a, 0x12, 0x08, 0x49, 0x4e, 0x54, 0x45, 0x52, 0x4e, 0x41, 0x4c, 0x48, 0x00,
	0x52, 0x2e, 0x76, 0x61, 0x75, 0x6c, 0x74, 0x53, 0x73, 0x68, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66,
	0x69, 0x63, 0x61, 0x74, 0x65, 0x43, 0x72, 0x65, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x61, 0x6c, 0x4c,
	0x69, 0x62, 0x72, 0x61, 0x72, 0x79, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73,
	0x42, 0x07, 0x0a, 0x05, 0x61, 0x74, 0x74, 0x72, 0x73, 0x22, 0x83, 0x01, 0x0a, 0x20, 0x56, 0x61,
	0x75, 0x6c, 0x74, 0x43, 0x72, 0x65, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x61, 0x6c, 0x4c, 0x69, 0x62,
	0x72, 0x61, 0x72, 0x79, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x12, 0x12,
	0x0a, 0x04, 0x70, 0x61, 0x74, 0x68, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x70, 0x61,
	0x74, 0x68, 0x12, 0x1f, 0x0a, 0x0b, 0x68, 0x74, 0x74, 0x70, 0x5f, 0x6d, 0x65, 0x74, 0x68, 0x6f,
	0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x68, 0x74, 0x74, 0x70, 0x4d, 0x65, 0x74,
	0x68, 0x6f, 0x64, 0x12, 0x2a, 0x0a, 0x11, 0x68, 0x74, 0x74, 0x70, 0x5f, 0x72, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x5f, 0x62, 0x6f, 0x64, 0x79, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0f,
	0x68, 0x74, 0x74, 0x70, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x42, 0x6f, 0x64, 0x79, 0x22,
	0x9b, 0x05, 0x0a, 0x2e, 0x56, 0x61, 0x75, 0x6c, 0x74, 0x53, 0x53, 0x48, 0x43, 0x65, 0x72, 0x74,
	0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x43, 0x72, 0x65, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x61,
	0x6c, 0x4c, 0x69, 0x62, 0x72, 0x61, 0x72, 0x79, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74,
	0x65, 0x73, 0x12, 0x12, 0x0a, 0x04, 0x70, 0x61, 0x74, 0x68, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x04, 0x70, 0x61, 0x74, 0x68, 0x12, 0x1a, 0x0a, 0x08, 0x75, 0x73, 0x65, 0x72, 0x6e, 0x61,
	0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x75, 0x73, 0x65, 0x72, 0x6e, 0x61,
	0x6d, 0x65, 0x12, 0x19, 0x0a, 0x08, 0x6b, 0x65, 0x79, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x6b, 0x65, 0x79, 0x54, 0x79, 0x70, 0x65, 0x12, 0x19, 0x0a,
	0x08, 0x6b, 0x65, 0x79, 0x5f, 0x62, 0x69, 0x74, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0d, 0x52,
	0x07, 0x6b, 0x65, 0x79, 0x42, 0x69, 0x74, 0x73, 0x12, 0x10, 0x0a, 0x03, 0x74, 0x74, 0x6c, 0x18,
	0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x74, 0x74, 0x6c, 0x12, 0x9d, 0x01, 0x0a, 0x10, 0x63,
	0x72, 0x69, 0x74, 0x69, 0x63, 0x61, 0x6c, 0x5f, 0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18,
	0x06, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x72, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x6c,
	0x65, 0x72, 0x2e, 0x61, 0x70, 0x69, 0x2e, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73,
	0x2e, 0x73, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x72, 0x65, 0x63, 0x6f, 0x72, 0x64, 0x69, 0x6e,
	0x67, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x56, 0x61, 0x75, 0x6c, 0x74, 0x53, 0x53, 0x48, 0x43, 0x65,
	0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x43, 0x72, 0x65, 0x64, 0x65, 0x6e, 0x74,
	0x69, 0x61, 0x6c, 0x4c, 0x69, 0x62, 0x72, 0x61, 0x72, 0x79, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62,
	0x75, 0x74, 0x65, 0x73, 0x2e, 0x43, 0x72, 0x69, 0x74, 0x69, 0x63, 0x61, 0x6c, 0x4f, 0x70, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x0f, 0x63, 0x72, 0x69, 0x74, 0x69,
	0x63, 0x61, 0x6c, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x8d, 0x01, 0x0a, 0x0a, 0x65,
	0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x07, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x6d, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x6c, 0x65, 0x72, 0x2e, 0x61, 0x70, 0x69,
	0x2e, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2e, 0x73, 0x65, 0x73, 0x73, 0x69,
	0x6f, 0x6e, 0x72, 0x65, 0x63, 0x6f, 0x72, 0x64, 0x69, 0x6e, 0x67, 0x73, 0x2e, 0x76, 0x31, 0x2e,
	0x56, 0x61, 0x75, 0x6c, 0x74, 0x53, 0x53, 0x48, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63,
	0x61, 0x74, 0x65, 0x43, 0x72, 0x65, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x61, 0x6c, 0x4c, 0x69, 0x62,
	0x72, 0x61, 0x72, 0x79, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x2e, 0x45,
	0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x0a,
	0x65, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x3e, 0x0a, 0x1b, 0x61, 0x64,
	0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x5f, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x5f, 0x70,
	0x72, 0x69, 0x6e, 0x63, 0x69, 0x70, 0x61, 0x6c, 0x73, 0x18, 0x08, 0x20, 0x03, 0x28, 0x09, 0x52,
	0x19, 0x61, 0x64, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x56, 0x61, 0x6c, 0x69, 0x64,
	0x50, 0x72, 0x69, 0x6e, 0x63, 0x69, 0x70, 0x61, 0x6c, 0x73, 0x1a, 0x42, 0x0a, 0x14, 0x43, 0x72,
	0x69, 0x74, 0x69, 0x63, 0x61, 0x6c, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x45, 0x6e, 0x74,
	0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x1a, 0x3d,
	0x0a, 0x0f, 0x45, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x45, 0x6e, 0x74, 0x72,
	0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03,
	0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0xc2, 0x03,
	0x0a, 0x0c, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x41, 0x74, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x47,
	0x0a, 0x04, 0x75, 0x73, 0x65, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x33, 0x2e, 0x63,
	0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x6c, 0x65, 0x72, 0x2e, 0x61, 0x70, 0x69, 0x2e, 0x72, 0x65,
	0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2e, 0x73, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x72,
	0x65, 0x63, 0x6f, 0x72, 0x64, 0x69, 0x6e, 0x67, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x55, 0x73, 0x65,
	0x72, 0x52, 0x04, 0x75, 0x73, 0x65, 0x72, 0x12, 0x4d, 0x0a, 0x06, 0x74, 0x61, 0x72, 0x67, 0x65,
	0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x35, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x72, 0x6f,
	0x6c, 0x6c, 0x65, 0x72, 0x2e, 0x61, 0x70, 0x69, 0x2e, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x73, 0x2e, 0x73, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x72, 0x65, 0x63, 0x6f, 0x72, 0x64,
	0x69, 0x6e, 0x67, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x52, 0x06,
	0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x12, 0x47, 0x0a, 0x04, 0x68, 0x6f, 0x73, 0x74, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x33, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x6c, 0x65,
	0x72, 0x2e, 0x61, 0x70, 0x69, 0x2e, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2e,
	0x73, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x72, 0x65, 0x63, 0x6f, 0x72, 0x64, 0x69, 0x6e, 0x67,
	0x73, 0x2e, 0x76, 0x31, 0x2e, 0x48, 0x6f, 0x73, 0x74, 0x52, 0x04, 0x68, 0x6f, 0x73, 0x74, 0x12,
	0x5b, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x61, 0x6c, 0x73, 0x18, 0x04,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x39, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x6c, 0x65,
	0x72, 0x2e, 0x61, 0x70, 0x69, 0x2e, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2e,
	0x73, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x72, 0x65, 0x63, 0x6f, 0x72, 0x64, 0x69, 0x6e, 0x67,
	0x73, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x72, 0x65, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x61, 0x6c, 0x52,
	0x0b, 0x63, 0x72, 0x65, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x61, 0x6c, 0x73, 0x12, 0x74, 0x0a, 0x14,
	0x63, 0x72, 0x65, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x61, 0x6c, 0x5f, 0x6c, 0x69, 0x62, 0x72, 0x61,
	0x72, 0x69, 0x65, 0x73, 0x18, 0x05, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x40, 0x2e, 0x63, 0x6f, 0x6e,
	0x74, 0x72, 0x6f, 0x6c, 0x6c, 0x65, 0x72, 0x2e, 0x61, 0x70, 0x69, 0x2e, 0x72, 0x65, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x73, 0x2e, 0x73, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x72, 0x65, 0x63,
	0x6f, 0x72, 0x64, 0x69, 0x6e, 0x67, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x72, 0x65, 0x64, 0x65,
	0x6e, 0x74, 0x69, 0x61, 0x6c, 0x4c, 0x69, 0x62, 0x72, 0x61, 0x72, 0x79, 0x52, 0x14, 0x63, 0x72,
	0x65, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x61, 0x6c, 0x5f, 0x6c, 0x69, 0x62, 0x72, 0x61, 0x72, 0x69,
	0x65, 0x73, 0x22, 0xbe, 0x08, 0x0a, 0x10, 0x53, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x65,
	0x63, 0x6f, 0x72, 0x64, 0x69, 0x6e, 0x67, 0x12, 0x0e, 0x0a, 0x02, 0x69, 0x64, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x02, 0x69, 0x64, 0x12, 0x43, 0x0a, 0x05, 0x73, 0x63, 0x6f, 0x70, 0x65,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c,
	0x6c, 0x65, 0x72, 0x2e, 0x61, 0x70, 0x69, 0x2e, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x73, 0x2e, 0x73, 0x63, 0x6f, 0x70, 0x65, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x63, 0x6f, 0x70,
	0x65, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x05, 0x73, 0x63, 0x6f, 0x70, 0x65, 0x12, 0x1e, 0x0a, 0x0a,
	0x73, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x0a, 0x73, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x12, 0x2c, 0x0a, 0x11,
	0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x5f, 0x62, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x5f, 0x69,
	0x64, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x11, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65,
	0x5f, 0x62, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x5f, 0x69, 0x64, 0x12, 0x1a, 0x0a, 0x08, 0x62, 0x79,
	0x74, 0x65, 0x73, 0x5f, 0x75, 0x70, 0x18, 0x05, 0x20, 0x01, 0x28, 0x04, 0x52, 0x08, 0x62, 0x79,
	0x74, 0x65, 0x73, 0x5f, 0x75, 0x70, 0x12, 0x1e, 0x0a, 0x0a, 0x62, 0x79, 0x74, 0x65, 0x73, 0x5f,
	0x64, 0x6f, 0x77, 0x6e, 0x18, 0x06, 0x20, 0x01, 0x28, 0x04, 0x52, 0x0a, 0x62, 0x79, 0x74, 0x65,
	0x73, 0x5f, 0x64, 0x6f, 0x77, 0x6e, 0x12, 0x3e, 0x0a, 0x0c, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65,
	0x64, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54,
	0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0c, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65,
	0x64, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x12, 0x3e, 0x0a, 0x0c, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65,
	0x64, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54,
	0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0c, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65,
	0x64, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x12, 0x3a, 0x0a, 0x0a, 0x73, 0x74, 0x61, 0x72, 0x74, 0x5f,
	0x74, 0x69, 0x6d, 0x65, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d,
	0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0a, 0x73, 0x74, 0x61, 0x72, 0x74, 0x5f, 0x74, 0x69,
	0x6d, 0x65, 0x12, 0x36, 0x0a, 0x08, 0x65, 0x6e, 0x64, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x0a,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70,
	0x52, 0x08, 0x65, 0x6e, 0x64, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x12, 0x35, 0x0a, 0x08, 0x64, 0x75,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44,
	0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x08, 0x64, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x12, 0x12, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x04, 0x74, 0x79, 0x70, 0x65, 0x12, 0x14, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x0d,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x12, 0x23, 0x0a, 0x0d, 0x65,
	0x72, 0x72, 0x6f, 0x72, 0x5f, 0x64, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x18, 0x0e, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x0c, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73,
	0x12, 0x1e, 0x0a, 0x0a, 0x6d, 0x69, 0x6d, 0x65, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x73, 0x18, 0x0f,
	0x20, 0x03, 0x28, 0x09, 0x52, 0x0a, 0x6d, 0x69, 0x6d, 0x65, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x73,
	0x12, 0x1a, 0x0a, 0x08, 0x65, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x18, 0x10, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x08, 0x65, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x12, 0x78, 0x0a, 0x15,
	0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x72, 0x65, 0x63, 0x6f, 0x72,
	0x64, 0x69, 0x6e, 0x67, 0x73, 0x18, 0x11, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x42, 0x2e, 0x63, 0x6f,
	0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x6c, 0x65, 0x72, 0x2e, 0x61, 0x70, 0x69, 0x2e, 0x72, 0x65, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2e, 0x73, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x72, 0x65,
	0x63, 0x6f, 0x72, 0x64, 0x69, 0x6e, 0x67, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6e, 0x6e,
	0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x63, 0x6f, 0x72, 0x64, 0x69, 0x6e, 0x67, 0x52,
	0x15, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x72, 0x65, 0x63, 0x6f,
	0x72, 0x64, 0x69, 0x6e, 0x67, 0x73, 0x12, 0x6b, 0x0a, 0x12, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65,
	0x5f, 0x74, 0x69, 0x6d, 0x65, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x18, 0x12, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x3b, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x6c, 0x65, 0x72, 0x2e,
	0x61, 0x70, 0x69, 0x2e, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2e, 0x73, 0x65,
	0x73, 0x73, 0x69, 0x6f, 0x6e, 0x72, 0x65, 0x63, 0x6f, 0x72, 0x64, 0x69, 0x6e, 0x67, 0x73, 0x2e,
	0x76, 0x31, 0x2e, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x41, 0x74, 0x54, 0x69, 0x6d, 0x65, 0x52,
	0x12, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x5f, 0x76, 0x61, 0x6c,
	0x75, 0x65, 0x73, 0x12, 0x2e, 0x0a, 0x12, 0x61, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x65,
	0x64, 0x5f, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x13, 0x20, 0x03, 0x28, 0x09, 0x52,
	0x12, 0x61, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x65, 0x64, 0x5f, 0x61, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x12, 0x3e, 0x0a, 0x0c, 0x72, 0x65, 0x74, 0x61, 0x69, 0x6e, 0x5f, 0x75, 0x6e,
	0x74, 0x69, 0x6c, 0x18, 0x14, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65,
	0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0c, 0x72, 0x65, 0x74, 0x61, 0x69, 0x6e, 0x5f, 0x75, 0x6e,
	0x74, 0x69, 0x6c, 0x12, 0x3e, 0x0a, 0x0c, 0x64, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x5f, 0x61, 0x66,
	0x74, 0x65, 0x72, 0x18, 0x15, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65,
	0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0c, 0x64, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x5f, 0x61, 0x66,
	0x74, 0x65, 0x72, 0x42, 0x66, 0x5a, 0x64, 0x67, 0x69, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x68, 0x61, 0x73, 0x68, 0x69, 0x63, 0x6f, 0x72, 0x70, 0x2f, 0x62, 0x6f, 0x75, 0x6e,
	0x64, 0x61, 0x72, 0x79, 0x2f, 0x73, 0x64, 0x6b, 0x2f, 0x70, 0x62, 0x73, 0x2f, 0x63, 0x6f, 0x6e,
	0x74, 0x72, 0x6f, 0x6c, 0x6c, 0x65, 0x72, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x73, 0x2f, 0x73, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x72, 0x65,
	0x63, 0x6f, 0x72, 0x64, 0x69, 0x6e, 0x67, 0x73, 0x3b, 0x73, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e,
	0x5f, 0x72, 0x65, 0x63, 0x6f, 0x72, 0x64, 0x69, 0x6e, 0x67, 0x73, 0x62, 0x06, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x33,
}

var (
	file_controller_api_resources_sessionrecordings_v1_session_recording_proto_rawDescOnce sync.Once
	file_controller_api_resources_sessionrecordings_v1_session_recording_proto_rawDescData = file_controller_api_resources_sessionrecordings_v1_session_recording_proto_rawDesc
)

func file_controller_api_resources_sessionrecordings_v1_session_recording_proto_rawDescGZIP() []byte {
	file_controller_api_resources_sessionrecordings_v1_session_recording_proto_rawDescOnce.Do(func() {
		file_controller_api_resources_sessionrecordings_v1_session_recording_proto_rawDescData = protoimpl.X.CompressGZIP(file_controller_api_resources_sessionrecordings_v1_session_recording_proto_rawDescData)
	})
	return file_controller_api_resources_sessionrecordings_v1_session_recording_proto_rawDescData
}

var file_controller_api_resources_sessionrecordings_v1_session_recording_proto_msgTypes = make([]protoimpl.MessageInfo, 21)
var file_controller_api_resources_sessionrecordings_v1_session_recording_proto_goTypes = []any{
	(*ChannelRecording)(nil),                               // 0: controller.api.resources.sessionrecordings.v1.ChannelRecording
	(*ConnectionRecording)(nil),                            // 1: controller.api.resources.sessionrecordings.v1.ConnectionRecording
	(*User)(nil),                                           // 2: controller.api.resources.sessionrecordings.v1.User
	(*HostCatalog)(nil),                                    // 3: controller.api.resources.sessionrecordings.v1.HostCatalog
	(*Host)(nil),                                           // 4: controller.api.resources.sessionrecordings.v1.Host
	(*StaticHostAttributes)(nil),                           // 5: controller.api.resources.sessionrecordings.v1.StaticHostAttributes
	(*Target)(nil),                                         // 6: controller.api.resources.sessionrecordings.v1.Target
	(*SshTargetAttributes)(nil),                            // 7: controller.api.resources.sessionrecordings.v1.SshTargetAttributes
	(*CredentialStore)(nil),                                // 8: controller.api.resources.sessionrecordings.v1.CredentialStore
	(*VaultCredentialStoreAttributes)(nil),                 // 9: controller.api.resources.sessionrecordings.v1.VaultCredentialStoreAttributes
	(*Credential)(nil),                                     // 10: controller.api.resources.sessionrecordings.v1.Credential
	(*UsernamePasswordCredentialAttributes)(nil),           // 11: controller.api.resources.sessionrecordings.v1.UsernamePasswordCredentialAttributes
	(*SshPrivateKeyCredentialAttributes)(nil),              // 12: controller.api.resources.sessionrecordings.v1.SshPrivateKeyCredentialAttributes
	(*JsonCredentialAttributes)(nil),                       // 13: controller.api.resources.sessionrecordings.v1.JsonCredentialAttributes
	(*CredentialLibrary)(nil),                              // 14: controller.api.resources.sessionrecordings.v1.CredentialLibrary
	(*VaultCredentialLibraryAttributes)(nil),               // 15: controller.api.resources.sessionrecordings.v1.VaultCredentialLibraryAttributes
	(*VaultSSHCertificateCredentialLibraryAttributes)(nil), // 16: controller.api.resources.sessionrecordings.v1.VaultSSHCertificateCredentialLibraryAttributes
	(*ValuesAtTime)(nil),                                   // 17: controller.api.resources.sessionrecordings.v1.ValuesAtTime
	(*SessionRecording)(nil),                               // 18: controller.api.resources.sessionrecordings.v1.SessionRecording
	nil,                                                    // 19: controller.api.resources.sessionrecordings.v1.VaultSSHCertificateCredentialLibraryAttributes.CriticalOptionsEntry
	nil,                                                    // 20: controller.api.resources.sessionrecordings.v1.VaultSSHCertificateCredentialLibraryAttributes.ExtensionsEntry
	(*timestamppb.Timestamp)(nil),                          // 21: google.protobuf.Timestamp
	(*durationpb.Duration)(nil),                            // 22: google.protobuf.Duration
	(*scopes.ScopeInfo)(nil),                               // 23: controller.api.resources.scopes.v1.ScopeInfo
	(*structpb.Struct)(nil),                                // 24: google.protobuf.Struct
}
var file_controller_api_resources_sessionrecordings_v1_session_recording_proto_depIdxs = []int32{
	21, // 0: controller.api.resources.sessionrecordings.v1.ChannelRecording.created_time:type_name -> google.protobuf.Timestamp
	21, // 1: controller.api.resources.sessionrecordings.v1.ChannelRecording.updated_time:type_name -> google.protobuf.Timestamp
	21, // 2: controller.api.resources.sessionrecordings.v1.ChannelRecording.start_time:type_name -> google.protobuf.Timestamp
	21, // 3: controller.api.resources.sessionrecordings.v1.ChannelRecording.end_time:type_name -> google.protobuf.Timestamp
	22, // 4: controller.api.resources.sessionrecordings.v1.ChannelRecording.duration:type_name -> google.protobuf.Duration
	21, // 5: controller.api.resources.sessionrecordings.v1.ConnectionRecording.created_time:type_name -> google.protobuf.Timestamp
	21, // 6: controller.api.resources.sessionrecordings.v1.ConnectionRecording.updated_time:type_name -> google.protobuf.Timestamp
	21, // 7: controller.api.resources.sessionrecordings.v1.ConnectionRecording.start_time:type_name -> google.protobuf.Timestamp
	21, // 8: controller.api.resources.sessionrecordings.v1.ConnectionRecording.end_time:type_name -> google.protobuf.Timestamp
	22, // 9: controller.api.resources.sessionrecordings.v1.ConnectionRecording.duration:type_name -> google.protobuf.Duration
	0,  // 10: controller.api.resources.sessionrecordings.v1.ConnectionRecording.channel_recordings:type_name -> controller.api.resources.sessionrecordings.v1.ChannelRecording
	23, // 11: controller.api.resources.sessionrecordings.v1.User.scope:type_name -> controller.api.resources.scopes.v1.ScopeInfo
	23, // 12: controller.api.resources.sessionrecordings.v1.HostCatalog.scope:type_name -> controller.api.resources.scopes.v1.ScopeInfo
	24, // 13: controller.api.resources.sessionrecordings.v1.HostCatalog.attributes:type_name -> google.protobuf.Struct
	3,  // 14: controller.api.resources.sessionrecordings.v1.Host.host_catalog:type_name -> controller.api.resources.sessionrecordings.v1.HostCatalog
	24, // 15: controller.api.resources.sessionrecordings.v1.Host.attributes:type_name -> google.protobuf.Struct
	5,  // 16: controller.api.resources.sessionrecordings.v1.Host.static_host_attributes:type_name -> controller.api.resources.sessionrecordings.v1.StaticHostAttributes
	23, // 17: controller.api.resources.sessionrecordings.v1.Target.scope:type_name -> controller.api.resources.scopes.v1.ScopeInfo
	24, // 18: controller.api.resources.sessionrecordings.v1.Target.attributes:type_name -> google.protobuf.Struct
	7,  // 19: controller.api.resources.sessionrecordings.v1.Target.ssh_target_attributes:type_name -> controller.api.resources.sessionrecordings.v1.SshTargetAttributes
	24, // 20: controller.api.resources.sessionrecordings.v1.CredentialStore.attributes:type_name -> google.protobuf.Struct
	9,  // 21: controller.api.resources.sessionrecordings.v1.CredentialStore.vault_credential_store_attributes:type_name -> controller.api.resources.sessionrecordings.v1.VaultCredentialStoreAttributes
	8,  // 22: controller.api.resources.sessionrecordings.v1.Credential.credential_store:type_name -> controller.api.resources.sessionrecordings.v1.CredentialStore
	24, // 23: controller.api.resources.sessionrecordings.v1.Credential.attributes:type_name -> google.protobuf.Struct
	11, // 24: controller.api.resources.sessionrecordings.v1.Credential.username_password_attributes:type_name -> controller.api.resources.sessionrecordings.v1.UsernamePasswordCredentialAttributes
	12, // 25: controller.api.resources.sessionrecordings.v1.Credential.ssh_private_key_attributes:type_name -> controller.api.resources.sessionrecordings.v1.SshPrivateKeyCredentialAttributes
	13, // 26: controller.api.resources.sessionrecordings.v1.Credential.json_attributes:type_name -> controller.api.resources.sessionrecordings.v1.JsonCredentialAttributes
	8,  // 27: controller.api.resources.sessionrecordings.v1.CredentialLibrary.credential_store:type_name -> controller.api.resources.sessionrecordings.v1.CredentialStore
	24, // 28: controller.api.resources.sessionrecordings.v1.CredentialLibrary.attributes:type_name -> google.protobuf.Struct
	15, // 29: controller.api.resources.sessionrecordings.v1.CredentialLibrary.vault_credential_library_attributes:type_name -> controller.api.resources.sessionrecordings.v1.VaultCredentialLibraryAttributes
	15, // 30: controller.api.resources.sessionrecordings.v1.CredentialLibrary.vault_generic_credential_library_attributes:type_name -> controller.api.resources.sessionrecordings.v1.VaultCredentialLibraryAttributes
	16, // 31: controller.api.resources.sessionrecordings.v1.CredentialLibrary.vault_ssh_certificate_credential_library_attributes:type_name -> controller.api.resources.sessionrecordings.v1.VaultSSHCertificateCredentialLibraryAttributes
	19, // 32: controller.api.resources.sessionrecordings.v1.VaultSSHCertificateCredentialLibraryAttributes.critical_options:type_name -> controller.api.resources.sessionrecordings.v1.VaultSSHCertificateCredentialLibraryAttributes.CriticalOptionsEntry
	20, // 33: controller.api.resources.sessionrecordings.v1.VaultSSHCertificateCredentialLibraryAttributes.extensions:type_name -> controller.api.resources.sessionrecordings.v1.VaultSSHCertificateCredentialLibraryAttributes.ExtensionsEntry
	2,  // 34: controller.api.resources.sessionrecordings.v1.ValuesAtTime.user:type_name -> controller.api.resources.sessionrecordings.v1.User
	6,  // 35: controller.api.resources.sessionrecordings.v1.ValuesAtTime.target:type_name -> controller.api.resources.sessionrecordings.v1.Target
	4,  // 36: controller.api.resources.sessionrecordings.v1.ValuesAtTime.host:type_name -> controller.api.resources.sessionrecordings.v1.Host
	10, // 37: controller.api.resources.sessionrecordings.v1.ValuesAtTime.credentials:type_name -> controller.api.resources.sessionrecordings.v1.Credential
	14, // 38: controller.api.resources.sessionrecordings.v1.ValuesAtTime.credential_libraries:type_name -> controller.api.resources.sessionrecordings.v1.CredentialLibrary
	23, // 39: controller.api.resources.sessionrecordings.v1.SessionRecording.scope:type_name -> controller.api.resources.scopes.v1.ScopeInfo
	21, // 40: controller.api.resources.sessionrecordings.v1.SessionRecording.created_time:type_name -> google.protobuf.Timestamp
	21, // 41: controller.api.resources.sessionrecordings.v1.SessionRecording.updated_time:type_name -> google.protobuf.Timestamp
	21, // 42: controller.api.resources.sessionrecordings.v1.SessionRecording.start_time:type_name -> google.protobuf.Timestamp
	21, // 43: controller.api.resources.sessionrecordings.v1.SessionRecording.end_time:type_name -> google.protobuf.Timestamp
	22, // 44: controller.api.resources.sessionrecordings.v1.SessionRecording.duration:type_name -> google.protobuf.Duration
	1,  // 45: controller.api.resources.sessionrecordings.v1.SessionRecording.connection_recordings:type_name -> controller.api.resources.sessionrecordings.v1.ConnectionRecording
	17, // 46: controller.api.resources.sessionrecordings.v1.SessionRecording.create_time_values:type_name -> controller.api.resources.sessionrecordings.v1.ValuesAtTime
	21, // 47: controller.api.resources.sessionrecordings.v1.SessionRecording.retain_until:type_name -> google.protobuf.Timestamp
	21, // 48: controller.api.resources.sessionrecordings.v1.SessionRecording.delete_after:type_name -> google.protobuf.Timestamp
	49, // [49:49] is the sub-list for method output_type
	49, // [49:49] is the sub-list for method input_type
	49, // [49:49] is the sub-list for extension type_name
	49, // [49:49] is the sub-list for extension extendee
	0,  // [0:49] is the sub-list for field type_name
}

func init() { file_controller_api_resources_sessionrecordings_v1_session_recording_proto_init() }
func file_controller_api_resources_sessionrecordings_v1_session_recording_proto_init() {
	if File_controller_api_resources_sessionrecordings_v1_session_recording_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_controller_api_resources_sessionrecordings_v1_session_recording_proto_msgTypes[0].Exporter = func(v any, i int) any {
			switch v := v.(*ChannelRecording); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_controller_api_resources_sessionrecordings_v1_session_recording_proto_msgTypes[1].Exporter = func(v any, i int) any {
			switch v := v.(*ConnectionRecording); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_controller_api_resources_sessionrecordings_v1_session_recording_proto_msgTypes[2].Exporter = func(v any, i int) any {
			switch v := v.(*User); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_controller_api_resources_sessionrecordings_v1_session_recording_proto_msgTypes[3].Exporter = func(v any, i int) any {
			switch v := v.(*HostCatalog); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_controller_api_resources_sessionrecordings_v1_session_recording_proto_msgTypes[4].Exporter = func(v any, i int) any {
			switch v := v.(*Host); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_controller_api_resources_sessionrecordings_v1_session_recording_proto_msgTypes[5].Exporter = func(v any, i int) any {
			switch v := v.(*StaticHostAttributes); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_controller_api_resources_sessionrecordings_v1_session_recording_proto_msgTypes[6].Exporter = func(v any, i int) any {
			switch v := v.(*Target); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_controller_api_resources_sessionrecordings_v1_session_recording_proto_msgTypes[7].Exporter = func(v any, i int) any {
			switch v := v.(*SshTargetAttributes); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_controller_api_resources_sessionrecordings_v1_session_recording_proto_msgTypes[8].Exporter = func(v any, i int) any {
			switch v := v.(*CredentialStore); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_controller_api_resources_sessionrecordings_v1_session_recording_proto_msgTypes[9].Exporter = func(v any, i int) any {
			switch v := v.(*VaultCredentialStoreAttributes); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_controller_api_resources_sessionrecordings_v1_session_recording_proto_msgTypes[10].Exporter = func(v any, i int) any {
			switch v := v.(*Credential); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_controller_api_resources_sessionrecordings_v1_session_recording_proto_msgTypes[11].Exporter = func(v any, i int) any {
			switch v := v.(*UsernamePasswordCredentialAttributes); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_controller_api_resources_sessionrecordings_v1_session_recording_proto_msgTypes[12].Exporter = func(v any, i int) any {
			switch v := v.(*SshPrivateKeyCredentialAttributes); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_controller_api_resources_sessionrecordings_v1_session_recording_proto_msgTypes[13].Exporter = func(v any, i int) any {
			switch v := v.(*JsonCredentialAttributes); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_controller_api_resources_sessionrecordings_v1_session_recording_proto_msgTypes[14].Exporter = func(v any, i int) any {
			switch v := v.(*CredentialLibrary); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_controller_api_resources_sessionrecordings_v1_session_recording_proto_msgTypes[15].Exporter = func(v any, i int) any {
			switch v := v.(*VaultCredentialLibraryAttributes); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_controller_api_resources_sessionrecordings_v1_session_recording_proto_msgTypes[16].Exporter = func(v any, i int) any {
			switch v := v.(*VaultSSHCertificateCredentialLibraryAttributes); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_controller_api_resources_sessionrecordings_v1_session_recording_proto_msgTypes[17].Exporter = func(v any, i int) any {
			switch v := v.(*ValuesAtTime); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_controller_api_resources_sessionrecordings_v1_session_recording_proto_msgTypes[18].Exporter = func(v any, i int) any {
			switch v := v.(*SessionRecording); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_controller_api_resources_sessionrecordings_v1_session_recording_proto_msgTypes[3].OneofWrappers = []any{
		(*HostCatalog_Attributes)(nil),
	}
	file_controller_api_resources_sessionrecordings_v1_session_recording_proto_msgTypes[4].OneofWrappers = []any{
		(*Host_Attributes)(nil),
		(*Host_StaticHostAttributes)(nil),
	}
	file_controller_api_resources_sessionrecordings_v1_session_recording_proto_msgTypes[6].OneofWrappers = []any{
		(*Target_Attributes)(nil),
		(*Target_SshTargetAttributes)(nil),
	}
	file_controller_api_resources_sessionrecordings_v1_session_recording_proto_msgTypes[8].OneofWrappers = []any{
		(*CredentialStore_Attributes)(nil),
		(*CredentialStore_VaultCredentialStoreAttributes)(nil),
	}
	file_controller_api_resources_sessionrecordings_v1_session_recording_proto_msgTypes[10].OneofWrappers = []any{
		(*Credential_Attributes)(nil),
		(*Credential_UsernamePasswordAttributes)(nil),
		(*Credential_SshPrivateKeyAttributes)(nil),
		(*Credential_JsonAttributes)(nil),
	}
	file_controller_api_resources_sessionrecordings_v1_session_recording_proto_msgTypes[14].OneofWrappers = []any{
		(*CredentialLibrary_Attributes)(nil),
		(*CredentialLibrary_VaultCredentialLibraryAttributes)(nil),
		(*CredentialLibrary_VaultGenericCredentialLibraryAttributes)(nil),
		(*CredentialLibrary_VaultSshCertificateCredentialLibraryAttributes)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_controller_api_resources_sessionrecordings_v1_session_recording_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   21,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_controller_api_resources_sessionrecordings_v1_session_recording_proto_goTypes,
		DependencyIndexes: file_controller_api_resources_sessionrecordings_v1_session_recording_proto_depIdxs,
		MessageInfos:      file_controller_api_resources_sessionrecordings_v1_session_recording_proto_msgTypes,
	}.Build()
	File_controller_api_resources_sessionrecordings_v1_session_recording_proto = out.File
	file_controller_api_resources_sessionrecordings_v1_session_recording_proto_rawDesc = nil
	file_controller_api_resources_sessionrecordings_v1_session_recording_proto_goTypes = nil
	file_controller_api_resources_sessionrecordings_v1_session_recording_proto_depIdxs = nil
}
