// Copyright (c) HashiCorp, Inc.
// SPDX-License-Identifier: MPL-2.0

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.34.2
// 	protoc        (unknown)
// source: controller/api/resources/authmethods/v1/auth_method.proto

package authmethods

import (
	_ "github.com/grpc-ecosystem/grpc-gateway/v2/protoc-gen-openapiv2/options"
	scopes "github.com/hashicorp/boundary/sdk/pbs/controller/api/resources/scopes"
	_ "github.com/hashicorp/boundary/sdk/pbs/controller/protooptions"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	_ "google.golang.org/genproto/googleapis/api/visibility"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	structpb "google.golang.org/protobuf/types/known/structpb"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
	wrapperspb "google.golang.org/protobuf/types/known/wrapperspb"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// AuthMethod contains all fields related to an auth method resource
type AuthMethod struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The ID of the auth method.
	Id string `protobuf:"bytes,10,opt,name=id,proto3" json:"id,omitempty" class:"public" eventstream:"observation"` // @gotags: `class:"public" eventstream:"observation"`
	// The ID of the Scope of which this auth method is a part.
	ScopeId string `protobuf:"bytes,20,opt,name=scope_id,proto3" json:"scope_id,omitempty" class:"public" eventstream:"observation"` // @gotags: `class:"public" eventstream:"observation"`
	// Scope information for this Auth method.
	Scope *scopes.ScopeInfo `protobuf:"bytes,30,opt,name=scope,proto3" json:"scope,omitempty"`
	// Optional name for identification purposes.
	Name *wrapperspb.StringValue `protobuf:"bytes,40,opt,name=name,proto3" json:"name,omitempty" class:"public"` // @gotags: `class:"public"`
	// Optional user-set description for identification purposes.
	Description *wrapperspb.StringValue `protobuf:"bytes,50,opt,name=description,proto3" json:"description,omitempty" class:"public"` // @gotags: `class:"public"`
	// The time this resource was created.
	CreatedTime *timestamppb.Timestamp `protobuf:"bytes,60,opt,name=created_time,proto3" json:"created_time,omitempty" class:"public" eventstream:"observation"` // @gotags: `class:"public" eventstream:"observation"`
	// The time this resource was last updated.
	UpdatedTime *timestamppb.Timestamp `protobuf:"bytes,70,opt,name=updated_time,proto3" json:"updated_time,omitempty" class:"public" eventstream:"observation"` // @gotags: `class:"public" eventstream:"observation"`
	// Version is used in mutation requests, after the initial creation, to ensure this resource has not changed.
	// The mutation will fail if the version does not match the latest known good version.
	// Version is not required when you create an auth method.
	Version uint32 `protobuf:"varint,80,opt,name=version,proto3" json:"version,omitempty" class:"public"` // @gotags: `class:"public"`
	// The auth method type.
	Type string `protobuf:"bytes,90,opt,name=type,proto3" json:"type,omitempty" class:"public" eventstream:"observation"` // @gotags: `class:"public" eventstream:"observation"`
	// Types that are assignable to Attrs:
	//
	//	*AuthMethod_Attributes
	//	*AuthMethod_PasswordAuthMethodAttributes
	//	*AuthMethod_OidcAuthMethodsAttributes
	//	*AuthMethod_LdapAuthMethodsAttributes
	Attrs isAuthMethod_Attrs `protobuf_oneof:"attrs"`
	// Whether this auth method is the primary auth method for it's scope.
	// To change this value update the primary_auth_method_id field on the scope.
	IsPrimary bool `protobuf:"varint,110,opt,name=is_primary,proto3" json:"is_primary,omitempty" class:"public" eventstream:"observation"` // @gotags: `class:"public" eventstream:"observation"`
	// The available actions on this resource for this user.
	AuthorizedActions []string `protobuf:"bytes,300,rep,name=authorized_actions,proto3" json:"authorized_actions,omitempty" class:"public"` // @gotags: `class:"public"`
	// The authorized actions for the scope's collections.
	AuthorizedCollectionActions map[string]*structpb.ListValue `protobuf:"bytes,310,rep,name=authorized_collection_actions,proto3" json:"authorized_collection_actions,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"` // classified as public via taggable implementation
}

func (x *AuthMethod) Reset() {
	*x = AuthMethod{}
	if protoimpl.UnsafeEnabled {
		mi := &file_controller_api_resources_authmethods_v1_auth_method_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AuthMethod) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AuthMethod) ProtoMessage() {}

func (x *AuthMethod) ProtoReflect() protoreflect.Message {
	mi := &file_controller_api_resources_authmethods_v1_auth_method_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AuthMethod.ProtoReflect.Descriptor instead.
func (*AuthMethod) Descriptor() ([]byte, []int) {
	return file_controller_api_resources_authmethods_v1_auth_method_proto_rawDescGZIP(), []int{0}
}

func (x *AuthMethod) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

func (x *AuthMethod) GetScopeId() string {
	if x != nil {
		return x.ScopeId
	}
	return ""
}

func (x *AuthMethod) GetScope() *scopes.ScopeInfo {
	if x != nil {
		return x.Scope
	}
	return nil
}

func (x *AuthMethod) GetName() *wrapperspb.StringValue {
	if x != nil {
		return x.Name
	}
	return nil
}

func (x *AuthMethod) GetDescription() *wrapperspb.StringValue {
	if x != nil {
		return x.Description
	}
	return nil
}

func (x *AuthMethod) GetCreatedTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreatedTime
	}
	return nil
}

func (x *AuthMethod) GetUpdatedTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdatedTime
	}
	return nil
}

func (x *AuthMethod) GetVersion() uint32 {
	if x != nil {
		return x.Version
	}
	return 0
}

func (x *AuthMethod) GetType() string {
	if x != nil {
		return x.Type
	}
	return ""
}

func (m *AuthMethod) GetAttrs() isAuthMethod_Attrs {
	if m != nil {
		return m.Attrs
	}
	return nil
}

func (x *AuthMethod) GetAttributes() *structpb.Struct {
	if x, ok := x.GetAttrs().(*AuthMethod_Attributes); ok {
		return x.Attributes
	}
	return nil
}

func (x *AuthMethod) GetPasswordAuthMethodAttributes() *PasswordAuthMethodAttributes {
	if x, ok := x.GetAttrs().(*AuthMethod_PasswordAuthMethodAttributes); ok {
		return x.PasswordAuthMethodAttributes
	}
	return nil
}

func (x *AuthMethod) GetOidcAuthMethodsAttributes() *OidcAuthMethodAttributes {
	if x, ok := x.GetAttrs().(*AuthMethod_OidcAuthMethodsAttributes); ok {
		return x.OidcAuthMethodsAttributes
	}
	return nil
}

func (x *AuthMethod) GetLdapAuthMethodsAttributes() *LdapAuthMethodAttributes {
	if x, ok := x.GetAttrs().(*AuthMethod_LdapAuthMethodsAttributes); ok {
		return x.LdapAuthMethodsAttributes
	}
	return nil
}

func (x *AuthMethod) GetIsPrimary() bool {
	if x != nil {
		return x.IsPrimary
	}
	return false
}

func (x *AuthMethod) GetAuthorizedActions() []string {
	if x != nil {
		return x.AuthorizedActions
	}
	return nil
}

func (x *AuthMethod) GetAuthorizedCollectionActions() map[string]*structpb.ListValue {
	if x != nil {
		return x.AuthorizedCollectionActions
	}
	return nil
}

type isAuthMethod_Attrs interface {
	isAuthMethod_Attrs()
}

type AuthMethod_Attributes struct {
	// The attributes that are applicable for the specific auth method type.
	Attributes *structpb.Struct `protobuf:"bytes,100,opt,name=attributes,proto3,oneof"`
}

type AuthMethod_PasswordAuthMethodAttributes struct {
	PasswordAuthMethodAttributes *PasswordAuthMethodAttributes `protobuf:"bytes,101,opt,name=password_auth_method_attributes,json=passwordAuthMethodAttributes,proto3,oneof"`
}

type AuthMethod_OidcAuthMethodsAttributes struct {
	OidcAuthMethodsAttributes *OidcAuthMethodAttributes `protobuf:"bytes,102,opt,name=oidc_auth_methods_attributes,json=oidcAuthMethodsAttributes,proto3,oneof"`
}

type AuthMethod_LdapAuthMethodsAttributes struct {
	LdapAuthMethodsAttributes *LdapAuthMethodAttributes `protobuf:"bytes,103,opt,name=ldap_auth_methods_attributes,json=ldapAuthMethodsAttributes,proto3,oneof"`
}

func (*AuthMethod_Attributes) isAuthMethod_Attrs() {}

func (*AuthMethod_PasswordAuthMethodAttributes) isAuthMethod_Attrs() {}

func (*AuthMethod_OidcAuthMethodsAttributes) isAuthMethod_Attrs() {}

func (*AuthMethod_LdapAuthMethodsAttributes) isAuthMethod_Attrs() {}

// The attributes of a password typed auth method.
type PasswordAuthMethodAttributes struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The minimum length allowed for user names for accounts in this auth method.
	MinLoginNameLength uint32 `protobuf:"varint,10,opt,name=min_login_name_length,proto3" json:"min_login_name_length,omitempty" class:"public"` // @gotags: `class:"public"`
	// The minimum length allowed for passwords for accounts in this auth method.
	MinPasswordLength uint32 `protobuf:"varint,20,opt,name=min_password_length,proto3" json:"min_password_length,omitempty" class:"public"` // @gotags: `class:"public"`
}

func (x *PasswordAuthMethodAttributes) Reset() {
	*x = PasswordAuthMethodAttributes{}
	if protoimpl.UnsafeEnabled {
		mi := &file_controller_api_resources_authmethods_v1_auth_method_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PasswordAuthMethodAttributes) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PasswordAuthMethodAttributes) ProtoMessage() {}

func (x *PasswordAuthMethodAttributes) ProtoReflect() protoreflect.Message {
	mi := &file_controller_api_resources_authmethods_v1_auth_method_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PasswordAuthMethodAttributes.ProtoReflect.Descriptor instead.
func (*PasswordAuthMethodAttributes) Descriptor() ([]byte, []int) {
	return file_controller_api_resources_authmethods_v1_auth_method_proto_rawDescGZIP(), []int{1}
}

func (x *PasswordAuthMethodAttributes) GetMinLoginNameLength() uint32 {
	if x != nil {
		return x.MinLoginNameLength
	}
	return 0
}

func (x *PasswordAuthMethodAttributes) GetMinPasswordLength() uint32 {
	if x != nil {
		return x.MinPasswordLength
	}
	return 0
}

// The attributes of an OIDC typed auth method.
type OidcAuthMethodAttributes struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The state of the auth method. Will be "inactive",
	// "active-private", or "active-public".
	State string `protobuf:"bytes,10,opt,name=state,proto3" json:"state,omitempty" class:"public"` // @gotags: `class:"public"`
	// The issuer URL. Boundary expects only the schema, host, and port and will
	// strip off ".well-known/openid-configuration" if present. This will be
	// used for configuration discovery as well as for validation of the "iss"
	// claim.
	Issuer *wrapperspb.StringValue `protobuf:"bytes,20,opt,name=issuer,proto3" json:"issuer,omitempty" class:"public"` // @gotags: `class:"public"`
	// An OAuth 2.0 Client Identifier valid at the Authorization Server.
	ClientId *wrapperspb.StringValue `protobuf:"bytes,30,opt,name=client_id,proto3" json:"client_id,omitempty" class:"public"` // @gotags: `class:"public"`
	// The client's secret.
	ClientSecret *wrapperspb.StringValue `protobuf:"bytes,40,opt,name=client_secret,proto3" json:"client_secret,omitempty" class:"secret"` // @gotags: `class:"secret"`
	// The HMAC'd value of the clients secret to indicate whether
	// the client secret has changed.
	ClientSecretHmac string `protobuf:"bytes,50,opt,name=client_secret_hmac,proto3" json:"client_secret_hmac,omitempty" class:"public"` // @gotags: `class:"public"`
	// The OIDC "max_age" parameter sent to the Authorization Server indicating
	// a maximum acceptable time in seconds since the user's last authentication
	// before requiring the user to reauthenticate. 0 indicates an immediate
	// need to reauthenticate.
	MaxAge *wrapperspb.UInt32Value `protobuf:"bytes,60,opt,name=max_age,proto3" json:"max_age,omitempty" class:"public"` // @gotags: `class:"public"`
	// The signing algorithms allowed for the auth method.
	SigningAlgorithms []string `protobuf:"bytes,70,rep,name=signing_algorithms,proto3" json:"signing_algorithms,omitempty" class:"public"` // @gotags: `class:"public"`
	// The prefix that should be used for any URLs needed during the
	// authentication flow. This includes the callback URL, the token retrieval
	// URL, and the redirection URL used by the OIDC Authorization Server.
	ApiUrlPrefix *wrapperspb.StringValue `protobuf:"bytes,80,opt,name=api_url_prefix,proto3" json:"api_url_prefix,omitempty" class:"public"` // @gotags: `class:"public"`
	// The callback URL that should be configured on the
	// Authorization Server to use during the authentication flow.
	CallbackUrl string `protobuf:"bytes,90,opt,name=callback_url,proto3" json:"callback_url,omitempty" class:"public"` // @gotags: `class:"public"`
	// Optional PEM-encoded X.509 CA certificates that can be used as trust anchors
	// when connecting to an OIDC provider.
	IdpCaCerts []string `protobuf:"bytes,100,rep,name=idp_ca_certs,proto3" json:"idp_ca_certs,omitempty" class:"public"` // @gotags: `class:"public"`
	// Allowed audience claims for this auth method.
	AllowedAudiences []string `protobuf:"bytes,110,rep,name=allowed_audiences,proto3" json:"allowed_audiences,omitempty" class:"public"` // @gotags: `class:"public"`
	// Optional claims scopes that will be requested during authentication.
	// see: https://openid.net/specs/openid-connect-core-1_0.html#ScopeClaims
	ClaimsScopes []string `protobuf:"bytes,112,rep,name=claims_scopes,proto3" json:"claims_scopes,omitempty" class:"public"` // @gotags: `class:"public"`
	// account_claim_maps are optional claim maps from custom claims to the
	// standard claims of sub, name and email.  These maps are represented as
	// key=value where the key equals the from_claim and the value equals the
	// to_claim.  For example "oid=sub".
	AccountClaimMaps []string `protobuf:"bytes,113,rep,name=account_claim_maps,proto3" json:"account_claim_maps,omitempty" class:"public"` // @gotags: `class:"public"`
	// If the Authorization Server's discovered configuration contains values
	// that do not match the configuration set on this auth method, this can be
	// set to force the local configuration to override the discovered values.
	// This is useful in the case of slow-changing or incorrect values announced
	// by the Authorization Server. NOTE: For safety, not providing this value
	// will be treated the same as "false"; that is, every time the method is
	// updated or the state is changed, this value must be set to "true" or it
	// will be disabled.
	DisableDiscoveredConfigValidation bool `protobuf:"varint,120,opt,name=disable_discovered_config_validation,proto3" json:"disable_discovered_config_validation,omitempty" class:"public"` // @gotags: `class:"public"`
	// dry_run, when set on an update request, indicates that the changes should
	// not be persisted.  Boundary will still perform the normal checks to confirm
	// the auth method is complete and validated against the discovered config.
	// This value will also be set on the returned resource when set in the request
	// along with the updated fields applied to the resource (but not persisted) as
	// a result of the update request.
	DryRun bool `protobuf:"varint,130,opt,name=dry_run,proto3" json:"dry_run,omitempty" class:"public"` // @gotags: `class:"public"`
	// The prompts allowed for the auth method.
	Prompts []string `protobuf:"bytes,140,rep,name=prompts,proto3" json:"prompts,omitempty" class:"public"` // @gotags: `class:"public"`
}

func (x *OidcAuthMethodAttributes) Reset() {
	*x = OidcAuthMethodAttributes{}
	if protoimpl.UnsafeEnabled {
		mi := &file_controller_api_resources_authmethods_v1_auth_method_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *OidcAuthMethodAttributes) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OidcAuthMethodAttributes) ProtoMessage() {}

func (x *OidcAuthMethodAttributes) ProtoReflect() protoreflect.Message {
	mi := &file_controller_api_resources_authmethods_v1_auth_method_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OidcAuthMethodAttributes.ProtoReflect.Descriptor instead.
func (*OidcAuthMethodAttributes) Descriptor() ([]byte, []int) {
	return file_controller_api_resources_authmethods_v1_auth_method_proto_rawDescGZIP(), []int{2}
}

func (x *OidcAuthMethodAttributes) GetState() string {
	if x != nil {
		return x.State
	}
	return ""
}

func (x *OidcAuthMethodAttributes) GetIssuer() *wrapperspb.StringValue {
	if x != nil {
		return x.Issuer
	}
	return nil
}

func (x *OidcAuthMethodAttributes) GetClientId() *wrapperspb.StringValue {
	if x != nil {
		return x.ClientId
	}
	return nil
}

func (x *OidcAuthMethodAttributes) GetClientSecret() *wrapperspb.StringValue {
	if x != nil {
		return x.ClientSecret
	}
	return nil
}

func (x *OidcAuthMethodAttributes) GetClientSecretHmac() string {
	if x != nil {
		return x.ClientSecretHmac
	}
	return ""
}

func (x *OidcAuthMethodAttributes) GetMaxAge() *wrapperspb.UInt32Value {
	if x != nil {
		return x.MaxAge
	}
	return nil
}

func (x *OidcAuthMethodAttributes) GetSigningAlgorithms() []string {
	if x != nil {
		return x.SigningAlgorithms
	}
	return nil
}

func (x *OidcAuthMethodAttributes) GetApiUrlPrefix() *wrapperspb.StringValue {
	if x != nil {
		return x.ApiUrlPrefix
	}
	return nil
}

func (x *OidcAuthMethodAttributes) GetCallbackUrl() string {
	if x != nil {
		return x.CallbackUrl
	}
	return ""
}

func (x *OidcAuthMethodAttributes) GetIdpCaCerts() []string {
	if x != nil {
		return x.IdpCaCerts
	}
	return nil
}

func (x *OidcAuthMethodAttributes) GetAllowedAudiences() []string {
	if x != nil {
		return x.AllowedAudiences
	}
	return nil
}

func (x *OidcAuthMethodAttributes) GetClaimsScopes() []string {
	if x != nil {
		return x.ClaimsScopes
	}
	return nil
}

func (x *OidcAuthMethodAttributes) GetAccountClaimMaps() []string {
	if x != nil {
		return x.AccountClaimMaps
	}
	return nil
}

func (x *OidcAuthMethodAttributes) GetDisableDiscoveredConfigValidation() bool {
	if x != nil {
		return x.DisableDiscoveredConfigValidation
	}
	return false
}

func (x *OidcAuthMethodAttributes) GetDryRun() bool {
	if x != nil {
		return x.DryRun
	}
	return false
}

func (x *OidcAuthMethodAttributes) GetPrompts() []string {
	if x != nil {
		return x.Prompts
	}
	return nil
}

// The structure of the OIDC authenticate start response, in the JSON object
type OidcAuthMethodAuthenticateStartResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The returned authentication URL
	AuthUrl string `protobuf:"bytes,10,opt,name=auth_url,proto3" json:"auth_url,omitempty" class:"public"` // @gotags: `class:"public"`
	// The returned token ID
	TokenId string `protobuf:"bytes,30,opt,name=token_id,proto3" json:"token_id,omitempty" class:"public"` // @gotags: `class:"public"`
}

func (x *OidcAuthMethodAuthenticateStartResponse) Reset() {
	*x = OidcAuthMethodAuthenticateStartResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_controller_api_resources_authmethods_v1_auth_method_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *OidcAuthMethodAuthenticateStartResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OidcAuthMethodAuthenticateStartResponse) ProtoMessage() {}

func (x *OidcAuthMethodAuthenticateStartResponse) ProtoReflect() protoreflect.Message {
	mi := &file_controller_api_resources_authmethods_v1_auth_method_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OidcAuthMethodAuthenticateStartResponse.ProtoReflect.Descriptor instead.
func (*OidcAuthMethodAuthenticateStartResponse) Descriptor() ([]byte, []int) {
	return file_controller_api_resources_authmethods_v1_auth_method_proto_rawDescGZIP(), []int{3}
}

func (x *OidcAuthMethodAuthenticateStartResponse) GetAuthUrl() string {
	if x != nil {
		return x.AuthUrl
	}
	return ""
}

func (x *OidcAuthMethodAuthenticateStartResponse) GetTokenId() string {
	if x != nil {
		return x.TokenId
	}
	return ""
}

// The structure of OIDC callback request parameters
type OidcAuthMethodAuthenticateCallbackRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The returned code
	Code string `protobuf:"bytes,10,opt,name=code,proto3" json:"code,omitempty" class:"secret"` // @gotags: `class:"secret"`
	// The returned state
	State string `protobuf:"bytes,20,opt,name=state,proto3" json:"state,omitempty" class:"public"` // @gotags: `class:"public"`
	// Error parameters, if they are returned
	Error            string `protobuf:"bytes,30,opt,name=error,proto3" json:"error,omitempty" class:"public"`                         // @gotags: `class:"public"`
	ErrorDescription string `protobuf:"bytes,40,opt,name=error_description,proto3" json:"error_description,omitempty" class:"public"` // @gotags: `class:"public"`
	ErrorUri         string `protobuf:"bytes,50,opt,name=error_uri,proto3" json:"error_uri,omitempty" class:"public"`                 // @gotags: `class:"public"`
}

func (x *OidcAuthMethodAuthenticateCallbackRequest) Reset() {
	*x = OidcAuthMethodAuthenticateCallbackRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_controller_api_resources_authmethods_v1_auth_method_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *OidcAuthMethodAuthenticateCallbackRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OidcAuthMethodAuthenticateCallbackRequest) ProtoMessage() {}

func (x *OidcAuthMethodAuthenticateCallbackRequest) ProtoReflect() protoreflect.Message {
	mi := &file_controller_api_resources_authmethods_v1_auth_method_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OidcAuthMethodAuthenticateCallbackRequest.ProtoReflect.Descriptor instead.
func (*OidcAuthMethodAuthenticateCallbackRequest) Descriptor() ([]byte, []int) {
	return file_controller_api_resources_authmethods_v1_auth_method_proto_rawDescGZIP(), []int{4}
}

func (x *OidcAuthMethodAuthenticateCallbackRequest) GetCode() string {
	if x != nil {
		return x.Code
	}
	return ""
}

func (x *OidcAuthMethodAuthenticateCallbackRequest) GetState() string {
	if x != nil {
		return x.State
	}
	return ""
}

func (x *OidcAuthMethodAuthenticateCallbackRequest) GetError() string {
	if x != nil {
		return x.Error
	}
	return ""
}

func (x *OidcAuthMethodAuthenticateCallbackRequest) GetErrorDescription() string {
	if x != nil {
		return x.ErrorDescription
	}
	return ""
}

func (x *OidcAuthMethodAuthenticateCallbackRequest) GetErrorUri() string {
	if x != nil {
		return x.ErrorUri
	}
	return ""
}

// The structure of OIDC callback response parameters
type OidcAuthMethodAuthenticateCallbackResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The final redirection URL
	FinalRedirectUrl string `protobuf:"bytes,10,opt,name=final_redirect_url,proto3" json:"final_redirect_url,omitempty" class:"public"` // @gotags: `class:"public"`
}

func (x *OidcAuthMethodAuthenticateCallbackResponse) Reset() {
	*x = OidcAuthMethodAuthenticateCallbackResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_controller_api_resources_authmethods_v1_auth_method_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *OidcAuthMethodAuthenticateCallbackResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OidcAuthMethodAuthenticateCallbackResponse) ProtoMessage() {}

func (x *OidcAuthMethodAuthenticateCallbackResponse) ProtoReflect() protoreflect.Message {
	mi := &file_controller_api_resources_authmethods_v1_auth_method_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OidcAuthMethodAuthenticateCallbackResponse.ProtoReflect.Descriptor instead.
func (*OidcAuthMethodAuthenticateCallbackResponse) Descriptor() ([]byte, []int) {
	return file_controller_api_resources_authmethods_v1_auth_method_proto_rawDescGZIP(), []int{5}
}

func (x *OidcAuthMethodAuthenticateCallbackResponse) GetFinalRedirectUrl() string {
	if x != nil {
		return x.FinalRedirectUrl
	}
	return ""
}

// The structure of OIDC token request parameters
type OidcAuthMethodAuthenticateTokenRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The ID of the pending token
	TokenId string `protobuf:"bytes,10,opt,name=token_id,proto3" json:"token_id,omitempty" class:"secret"` // @gotags: `class:"secret"`
}

func (x *OidcAuthMethodAuthenticateTokenRequest) Reset() {
	*x = OidcAuthMethodAuthenticateTokenRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_controller_api_resources_authmethods_v1_auth_method_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *OidcAuthMethodAuthenticateTokenRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OidcAuthMethodAuthenticateTokenRequest) ProtoMessage() {}

func (x *OidcAuthMethodAuthenticateTokenRequest) ProtoReflect() protoreflect.Message {
	mi := &file_controller_api_resources_authmethods_v1_auth_method_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OidcAuthMethodAuthenticateTokenRequest.ProtoReflect.Descriptor instead.
func (*OidcAuthMethodAuthenticateTokenRequest) Descriptor() ([]byte, []int) {
	return file_controller_api_resources_authmethods_v1_auth_method_proto_rawDescGZIP(), []int{6}
}

func (x *OidcAuthMethodAuthenticateTokenRequest) GetTokenId() string {
	if x != nil {
		return x.TokenId
	}
	return ""
}

// Internal only: the structure of a token response if it _does not_ contain a
// token.
type OidcAuthMethodAuthenticateTokenResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The status. This will always be "unknown". It will never be forwarded to
	// the consumer.
	Status string `protobuf:"bytes,10,opt,name=status,proto3" json:"status,omitempty" class:"public"` // @gotags: `class:"public"`
}

func (x *OidcAuthMethodAuthenticateTokenResponse) Reset() {
	*x = OidcAuthMethodAuthenticateTokenResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_controller_api_resources_authmethods_v1_auth_method_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *OidcAuthMethodAuthenticateTokenResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OidcAuthMethodAuthenticateTokenResponse) ProtoMessage() {}

func (x *OidcAuthMethodAuthenticateTokenResponse) ProtoReflect() protoreflect.Message {
	mi := &file_controller_api_resources_authmethods_v1_auth_method_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OidcAuthMethodAuthenticateTokenResponse.ProtoReflect.Descriptor instead.
func (*OidcAuthMethodAuthenticateTokenResponse) Descriptor() ([]byte, []int) {
	return file_controller_api_resources_authmethods_v1_auth_method_proto_rawDescGZIP(), []int{7}
}

func (x *OidcAuthMethodAuthenticateTokenResponse) GetStatus() string {
	if x != nil {
		return x.Status
	}
	return ""
}

// The attributes of an LDAP typed auth method.
type LdapAuthMethodAttributes struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The state of the auth method. Will be "inactive",
	// "active-private", or "active-public".
	State string `protobuf:"bytes,10,opt,name=state,proto3" json:"state,omitempty" class:"public"` // @gotags: `class:"public"`
	// start_tls if true, issues a StartTLS command after establishing an
	// unencrypted connection. Defaults to false.
	StartTls bool `protobuf:"varint,20,opt,name=start_tls,proto3" json:"start_tls,omitempty" class:"public"` // @gotags: `class:"public"`
	// insecure_tls if true, skips LDAP server SSL certificate validation -
	// insecure and use with caution. Defaults to false.
	InsecureTls bool `protobuf:"varint,30,opt,name=insecure_tls,proto3" json:"insecure_tls,omitempty" class:"public"` // @gotags: `class:"public"`
	// discover_dn if true, use anon bind to discover the bind DN of a user.
	// Defaults to false.
	DiscoverDn bool `protobuf:"varint,40,opt,name=discover_dn,proto3" json:"discover_dn,omitempty" class:"public"` // @gotags: `class:"public"`
	// anon_group_search if true, use anon bind when performing LDAP group
	// searches. Defaults to false.
	AnonGroupSearch bool `protobuf:"varint,50,opt,name=anon_group_search,proto3" json:"anon_group_search,omitempty" class:"public"` // @gotags: `class:"public"`
	// upn_domain is the userPrincipalDomain used to construct the UPN string for
	// the authenticating user. The constructed UPN will appear as
	// [username]@UPNDomain  Example: example.com, which will cause Boundary to
	// bind as username@example.com when authenticating the user.
	UpnDomain *wrapperspb.StringValue `protobuf:"bytes,60,opt,name=upn_domain,proto3" json:"upn_domain,omitempty" class:"public"` // @gotags: `class:"public"`
	// urls are the LDAP URLS that specify LDAP servers to connection to.  There
	// must be at lease on URL for each LDAP auth method. When attempting to
	// connect, the URLs are tried in the order specified. These are Value Objects
	// that will be stored as Url messages, and are operated on as a complete set
	// (not individually).
	Urls []string `protobuf:"bytes,70,rep,name=urls,proto3" json:"urls,omitempty" class:"public"` // @gotags: `class:"public"`
	// user_dn (optional) is the base DN under which to perform user search.
	// Example: ou=Users,dc=example,dc=com
	UserDn *wrapperspb.StringValue `protobuf:"bytes,80,opt,name=user_dn,proto3" json:"user_dn,omitempty" class:"public"` // @gotags: `class:"public"`
	// user_attr (optional) is the attribute on user attribute entry matching the
	// username passed when authenticating.  Examples: cn, uid
	UserAttr *wrapperspb.StringValue `protobuf:"bytes,90,opt,name=user_attr,proto3" json:"user_attr,omitempty" class:"public"` // @gotags: `class:"public"`
	// user_filter (optional) is a go template used to construct a LDAP user
	// search filter. The template can access the following context variables:
	// [UserAttr, Username]. The default userfilter is
	// ({{.UserAttr}}={{.Username}}) or
	// (userPrincipalName={{.Username}}@UPNDomain) if the upndomain parameter is
	// set.
	UserFilter *wrapperspb.StringValue `protobuf:"bytes,100,opt,name=user_filter,proto3" json:"user_filter,omitempty" class:"public"` // @gotags: `class:"public"`
	// enable_groups if true, an authenticated user's groups will be found during
	// authentication. Defaults to false.
	EnableGroups bool `protobuf:"varint,110,opt,name=enable_groups,proto3" json:"enable_groups,omitempty" class:"public"` // @gotags: `class:"public"`
	// group_dn (optional) is the base DN under which to perform user search.
	// Example: ou=Groups,dc=example,dc=com
	//
	// Note: there is no default, so no base dn will be used for group searches if
	// it's not specified.
	GroupDn *wrapperspb.StringValue `protobuf:"bytes,120,opt,name=group_dn,proto3" json:"group_dn,omitempty" class:"public"` // @gotags: `class:"public"`
	// group_attr (optional) is the LDAP attribute to follow on objects returned
	// by GroupFilter in order to enumerate user group membership. Examples: for
	// GroupFilter queries returning group objects, use: cn. For queries returning
	// user objects, use: memberOf. The default is cn.
	GroupAttr *wrapperspb.StringValue `protobuf:"bytes,130,opt,name=group_attr,proto3" json:"group_attr,omitempty" class:"public"` // @gotags: `class:"public"`
	// group_filter (optional) is a Go template used when constructing the group
	// membership query. The template can access the following context variables:
	// [UserDN, Username]. The default is
	// (|(memberUid={{.Username}})(member={{.UserDN}})(uniqueMember={{.UserDN}})),
	// which is compatible with several common directory schemas.
	GroupFilter *wrapperspb.StringValue `protobuf:"bytes,140,opt,name=group_filter,proto3" json:"group_filter,omitempty" class:"public"` // @gotags: `class:"public"`
	// certificates are optional PEM encoded x509 certificates in ASN.1 DER form
	// that can be used as trust anchors when connecting to an LDAP provider.
	// These are Value Objects that will be stored as Certificate messages, and
	// are operatated on as a complete set (not individually).
	Certificates []string `protobuf:"bytes,150,rep,name=certificates,proto3" json:"certificates,omitempty" class:"public"` // @gotags: `class:"public"`
	// client_certificate is the optional certificate encoded as PEM. It must be
	// set if an optional client_certificate_key specified
	ClientCertificate *wrapperspb.StringValue `protobuf:"bytes,160,opt,name=client_certificate,proto3" json:"client_certificate,omitempty" class:"public"` // @gotags: `class:"public"`
	// The client_certificate_key (optional) is the plain-text of the
	// certificate key data encoded as PEM.
	ClientCertificateKey *wrapperspb.StringValue `protobuf:"bytes,170,opt,name=client_certificate_key,proto3" json:"client_certificate_key,omitempty" class:"secret"` // @gotags: `class:"secret"`
	// The HMAC'd value of the client certificate key to indicate
	// whether the certificate key has changed.
	ClientCertificateKeyHmac string `protobuf:"bytes,180,opt,name=client_certificate_key_hmac,proto3" json:"client_certificate_key_hmac,omitempty" class:"public"` // @gotags: `class:"public"`
	// bind_dn (optional) is the distinguished name of entry to bind when
	// performing user and group search. Example:
	// cn=vault,ou=Users,dc=example,dc=com
	BindDn *wrapperspb.StringValue `protobuf:"bytes,190,opt,name=bind_dn,proto3" json:"bind_dn,omitempty" class:"public"` // @gotags: `class:"public"`
	// The bind_password (optional) is the password to use along with
	// binddn when performing user search.
	BindPassword *wrapperspb.StringValue `protobuf:"bytes,200,opt,name=bind_password,proto3" json:"bind_password,omitempty" class:"secret"` // @gotags: `class:"secret"`
	// The HMAC'd value of the bind password to indicate
	// whether the password has changed.
	BindPasswordHmac string `protobuf:"bytes,210,opt,name=bind_password_hmac,proto3" json:"bind_password_hmac,omitempty" class:"public"` // @gotags: `class:"public"`
	UseTokenGroups   bool   `protobuf:"varint,220,opt,name=use_token_groups,proto3" json:"use_token_groups,omitempty" class:"public"`    // @gotags: `class:"public"`
	// account_attribute_maps are optional attribute maps from custom attributes
	// to the standard attributes of fullname and email.  These maps are
	// represented as key=value where the key equals the from_attribute and the
	// value equals the to_attribute.  For example "preferredName=fullName".  All
	// attribute names are case insensitive.
	AccountAttributeMaps []string `protobuf:"bytes,230,rep,name=account_attribute_maps,proto3" json:"account_attribute_maps,omitempty" class:"public"` // @gotags: `class:"public"`
	// maximum_page_size (optional) specifies a maximum ldap search result size to
	// use when retrieving the authenticated user's group memberships. This can
	// be used to avoid reaching the LDAP server's max result size.
	MaximumPageSize uint32 `protobuf:"varint,240,opt,name=maximum_page_size,proto3" json:"maximum_page_size,omitempty" class:"public"` // @gotags: `class:"public"`
	// dereference_aliases (optional) will control how aliases are dereferenced when
	// performing the search. Possible values are: never, finding, searching,
	// and always. If unset, a default of "never" is used. When set to
	// "finding", it will only dereference aliases during name resolution of the
	// base. When set to "searching", it will dereference aliases after name
	// resolution.
	DereferenceAliases *wrapperspb.StringValue `protobuf:"bytes,250,opt,name=dereference_aliases,proto3" json:"dereference_aliases,omitempty" class:"public"` // @gotags: `class:"public"`
}

func (x *LdapAuthMethodAttributes) Reset() {
	*x = LdapAuthMethodAttributes{}
	if protoimpl.UnsafeEnabled {
		mi := &file_controller_api_resources_authmethods_v1_auth_method_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *LdapAuthMethodAttributes) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LdapAuthMethodAttributes) ProtoMessage() {}

func (x *LdapAuthMethodAttributes) ProtoReflect() protoreflect.Message {
	mi := &file_controller_api_resources_authmethods_v1_auth_method_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LdapAuthMethodAttributes.ProtoReflect.Descriptor instead.
func (*LdapAuthMethodAttributes) Descriptor() ([]byte, []int) {
	return file_controller_api_resources_authmethods_v1_auth_method_proto_rawDescGZIP(), []int{8}
}

func (x *LdapAuthMethodAttributes) GetState() string {
	if x != nil {
		return x.State
	}
	return ""
}

func (x *LdapAuthMethodAttributes) GetStartTls() bool {
	if x != nil {
		return x.StartTls
	}
	return false
}

func (x *LdapAuthMethodAttributes) GetInsecureTls() bool {
	if x != nil {
		return x.InsecureTls
	}
	return false
}

func (x *LdapAuthMethodAttributes) GetDiscoverDn() bool {
	if x != nil {
		return x.DiscoverDn
	}
	return false
}

func (x *LdapAuthMethodAttributes) GetAnonGroupSearch() bool {
	if x != nil {
		return x.AnonGroupSearch
	}
	return false
}

func (x *LdapAuthMethodAttributes) GetUpnDomain() *wrapperspb.StringValue {
	if x != nil {
		return x.UpnDomain
	}
	return nil
}

func (x *LdapAuthMethodAttributes) GetUrls() []string {
	if x != nil {
		return x.Urls
	}
	return nil
}

func (x *LdapAuthMethodAttributes) GetUserDn() *wrapperspb.StringValue {
	if x != nil {
		return x.UserDn
	}
	return nil
}

func (x *LdapAuthMethodAttributes) GetUserAttr() *wrapperspb.StringValue {
	if x != nil {
		return x.UserAttr
	}
	return nil
}

func (x *LdapAuthMethodAttributes) GetUserFilter() *wrapperspb.StringValue {
	if x != nil {
		return x.UserFilter
	}
	return nil
}

func (x *LdapAuthMethodAttributes) GetEnableGroups() bool {
	if x != nil {
		return x.EnableGroups
	}
	return false
}

func (x *LdapAuthMethodAttributes) GetGroupDn() *wrapperspb.StringValue {
	if x != nil {
		return x.GroupDn
	}
	return nil
}

func (x *LdapAuthMethodAttributes) GetGroupAttr() *wrapperspb.StringValue {
	if x != nil {
		return x.GroupAttr
	}
	return nil
}

func (x *LdapAuthMethodAttributes) GetGroupFilter() *wrapperspb.StringValue {
	if x != nil {
		return x.GroupFilter
	}
	return nil
}

func (x *LdapAuthMethodAttributes) GetCertificates() []string {
	if x != nil {
		return x.Certificates
	}
	return nil
}

func (x *LdapAuthMethodAttributes) GetClientCertificate() *wrapperspb.StringValue {
	if x != nil {
		return x.ClientCertificate
	}
	return nil
}

func (x *LdapAuthMethodAttributes) GetClientCertificateKey() *wrapperspb.StringValue {
	if x != nil {
		return x.ClientCertificateKey
	}
	return nil
}

func (x *LdapAuthMethodAttributes) GetClientCertificateKeyHmac() string {
	if x != nil {
		return x.ClientCertificateKeyHmac
	}
	return ""
}

func (x *LdapAuthMethodAttributes) GetBindDn() *wrapperspb.StringValue {
	if x != nil {
		return x.BindDn
	}
	return nil
}

func (x *LdapAuthMethodAttributes) GetBindPassword() *wrapperspb.StringValue {
	if x != nil {
		return x.BindPassword
	}
	return nil
}

func (x *LdapAuthMethodAttributes) GetBindPasswordHmac() string {
	if x != nil {
		return x.BindPasswordHmac
	}
	return ""
}

func (x *LdapAuthMethodAttributes) GetUseTokenGroups() bool {
	if x != nil {
		return x.UseTokenGroups
	}
	return false
}

func (x *LdapAuthMethodAttributes) GetAccountAttributeMaps() []string {
	if x != nil {
		return x.AccountAttributeMaps
	}
	return nil
}

func (x *LdapAuthMethodAttributes) GetMaximumPageSize() uint32 {
	if x != nil {
		return x.MaximumPageSize
	}
	return 0
}

func (x *LdapAuthMethodAttributes) GetDereferenceAliases() *wrapperspb.StringValue {
	if x != nil {
		return x.DereferenceAliases
	}
	return nil
}

var File_controller_api_resources_authmethods_v1_auth_method_proto protoreflect.FileDescriptor

var file_controller_api_resources_authmethods_v1_auth_method_proto_rawDesc = []byte{
	0x0a, 0x39, 0x63, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x6c, 0x65, 0x72, 0x2f, 0x61, 0x70, 0x69,
	0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2f, 0x61, 0x75, 0x74, 0x68, 0x6d,
	0x65, 0x74, 0x68, 0x6f, 0x64, 0x73, 0x2f, 0x76, 0x31, 0x2f, 0x61, 0x75, 0x74, 0x68, 0x5f, 0x6d,
	0x65, 0x74, 0x68, 0x6f, 0x64, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x27, 0x63, 0x6f, 0x6e,
	0x74, 0x72, 0x6f, 0x6c, 0x6c, 0x65, 0x72, 0x2e, 0x61, 0x70, 0x69, 0x2e, 0x72, 0x65, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x73, 0x2e, 0x61, 0x75, 0x74, 0x68, 0x6d, 0x65, 0x74, 0x68, 0x6f, 0x64,
	0x73, 0x2e, 0x76, 0x31, 0x1a, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x6c, 0x65, 0x72,
	0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2f, 0x73,
	0x63, 0x6f, 0x70, 0x65, 0x73, 0x2f, 0x76, 0x31, 0x2f, 0x73, 0x63, 0x6f, 0x70, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x2a, 0x63, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x6c, 0x65, 0x72,
	0x2f, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x5f, 0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f,
	0x76, 0x31, 0x2f, 0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65,
	0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x1a, 0x1b, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x76, 0x69,
	0x73, 0x69, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1c,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f,
	0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74, 0x69,
	0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x77,
	0x72, 0x61, 0x70, 0x70, 0x65, 0x72, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x63, 0x2d, 0x67, 0x65, 0x6e, 0x2d, 0x6f, 0x70, 0x65, 0x6e, 0x61, 0x70,
	0x69, 0x76, 0x32, 0x2f, 0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x61, 0x6e, 0x6e, 0x6f,
	0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0x89, 0x17,
	0x0a, 0x0a, 0x41, 0x75, 0x74, 0x68, 0x4d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x12, 0x14, 0x0a, 0x02,
	0x69, 0x64, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x09, 0x42, 0x04, 0xe2, 0x41, 0x01, 0x03, 0x52, 0x02,
	0x69, 0x64, 0x12, 0x1a, 0x0a, 0x08, 0x73, 0x63, 0x6f, 0x70, 0x65, 0x5f, 0x69, 0x64, 0x18, 0x14,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x73, 0x63, 0x6f, 0x70, 0x65, 0x5f, 0x69, 0x64, 0x12, 0x49,
	0x0a, 0x05, 0x73, 0x63, 0x6f, 0x70, 0x65, 0x18, 0x1e, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2d, 0x2e,
	0x63, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x6c, 0x65, 0x72, 0x2e, 0x61, 0x70, 0x69, 0x2e, 0x72,
	0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2e, 0x73, 0x63, 0x6f, 0x70, 0x65, 0x73, 0x2e,
	0x76, 0x31, 0x2e, 0x53, 0x63, 0x6f, 0x70, 0x65, 0x49, 0x6e, 0x66, 0x6f, 0x42, 0x04, 0xe2, 0x41,
	0x01, 0x03, 0x52, 0x05, 0x73, 0x63, 0x6f, 0x70, 0x65, 0x12, 0x46, 0x0a, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x18, 0x28, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x69, 0x6e, 0x67,
	0x56, 0x61, 0x6c, 0x75, 0x65, 0x42, 0x14, 0xa0, 0xda, 0x29, 0x01, 0xc2, 0xdd, 0x29, 0x0c, 0x0a,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x04, 0x4e, 0x61, 0x6d, 0x65, 0x52, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x12, 0x62, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e,
	0x18, 0x32, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x56,
	0x61, 0x6c, 0x75, 0x65, 0x42, 0x22, 0xa0, 0xda, 0x29, 0x01, 0xc2, 0xdd, 0x29, 0x1a, 0x0a, 0x0b,
	0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x0b, 0x44, 0x65, 0x73,
	0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69,
	0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x44, 0x0a, 0x0c, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x64,
	0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x3c, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69,
	0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x04, 0xe2, 0x41, 0x01, 0x03, 0x52, 0x0c, 0x63,
	0x72, 0x65, 0x61, 0x74, 0x65, 0x64, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x12, 0x44, 0x0a, 0x0c, 0x75,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x64, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x46, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x04, 0xe2,
	0x41, 0x01, 0x03, 0x52, 0x0c, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x64, 0x5f, 0x74, 0x69, 0x6d,
	0x65, 0x12, 0x18, 0x0a, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x50, 0x20, 0x01,
	0x28, 0x0d, 0x52, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x12, 0x0a, 0x04, 0x74,
	0x79, 0x70, 0x65, 0x18, 0x5a, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x12,
	0xa4, 0x0c, 0x0a, 0x0a, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x18, 0x64,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x75, 0x63, 0x74, 0x42, 0xe8, 0x0b,
	0x92, 0x41, 0xd5, 0x0b, 0x32, 0x98, 0x0b, 0x54, 0x68, 0x65, 0x20, 0x61, 0x74, 0x74, 0x72, 0x69,
	0x62, 0x75, 0x74, 0x65, 0x73, 0x20, 0x74, 0x68, 0x61, 0x74, 0x20, 0x61, 0x72, 0x65, 0x20, 0x61,
	0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x62, 0x6c, 0x65, 0x20, 0x66, 0x6f, 0x72, 0x20, 0x74, 0x68,
	0x65, 0x20, 0x73, 0x70, 0x65, 0x63, 0x69, 0x66, 0x69, 0x63, 0x20, 0x61, 0x75, 0x74, 0x68, 0x20,
	0x6d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x20, 0x74, 0x79, 0x70, 0x65, 0x2e, 0x20, 0x54, 0x68, 0x65,
	0x20, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x20, 0x6f, 0x66, 0x20, 0x74, 0x68, 0x69, 0x73, 0x20,
	0x66, 0x69, 0x65, 0x6c, 0x64, 0x20, 0x64, 0x65, 0x70, 0x65, 0x6e, 0x64, 0x73, 0x20, 0x6f, 0x6e,
	0x20, 0x74, 0x68, 0x65, 0x20, 0x74, 0x79, 0x70, 0x65, 0x20, 0x6f, 0x66, 0x20, 0x74, 0x68, 0x65,
	0x20, 0x61, 0x75, 0x74, 0x68, 0x20, 0x6d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x20, 0x74, 0x68, 0x61,
	0x74, 0x20, 0x79, 0x6f, 0x75, 0x20, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x20, 0x77, 0x61, 0x6e,
	0x74, 0x20, 0x74, 0x6f, 0x20, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x2e, 0x0a, 0x46, 0x6f, 0x72,
	0x20, 0x70, 0x61, 0x73, 0x73, 0x77, 0x6f, 0x72, 0x64, 0x20, 0x61, 0x75, 0x74, 0x68, 0x20, 0x6d,
	0x65, 0x74, 0x68, 0x6f, 0x64, 0x73, 0x2c, 0x20, 0x74, 0x68, 0x65, 0x20, 0x70, 0x61, 0x72, 0x61,
	0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x20, 0x61, 0x72, 0x65, 0x3a, 0x0a, 0x60, 0x60, 0x60, 0x6a,
	0x73, 0x6f, 0x6e, 0x0a, 0x7b, 0x0a, 0x20, 0x20, 0x22, 0x6d, 0x69, 0x6e, 0x5f, 0x6c, 0x6f, 0x67,
	0x69, 0x6e, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x5f, 0x6c, 0x65, 0x6e, 0x67, 0x74, 0x68, 0x22, 0x3a,
	0x20, 0x22, 0x6d, 0x69, 0x6e, 0x5f, 0x6c, 0x6f, 0x67, 0x69, 0x6e, 0x5f, 0x6e, 0x61, 0x6d, 0x65,
	0x5f, 0x6c, 0x65, 0x6e, 0x67, 0x74, 0x68, 0x22, 0x2c, 0x0a, 0x20, 0x20, 0x22, 0x6d, 0x69, 0x6e,
	0x5f, 0x70, 0x61, 0x73, 0x73, 0x77, 0x6f, 0x72, 0x64, 0x5f, 0x6c, 0x65, 0x6e, 0x67, 0x74, 0x68,
	0x22, 0x3a, 0x20, 0x22, 0x6d, 0x69, 0x6e, 0x5f, 0x70, 0x61, 0x73, 0x73, 0x77, 0x6f, 0x72, 0x64,
	0x5f, 0x6c, 0x65, 0x6e, 0x67, 0x74, 0x68, 0x22, 0x0a, 0x7d, 0x0a, 0x60, 0x60, 0x60, 0x0a, 0x46,
	0x6f, 0x72, 0x20, 0x4f, 0x49, 0x44, 0x43, 0x20, 0x61, 0x75, 0x74, 0x68, 0x20, 0x6d, 0x65, 0x74,
	0x68, 0x6f, 0x64, 0x73, 0x2c, 0x20, 0x74, 0x68, 0x65, 0x20, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x65,
	0x74, 0x65, 0x72, 0x73, 0x20, 0x61, 0x72, 0x65, 0x3a, 0x0a, 0x60, 0x60, 0x60, 0x6a, 0x73, 0x6f,
	0x6e, 0x0a, 0x7b, 0x0a, 0x20, 0x20, 0x22, 0x69, 0x73, 0x73, 0x75, 0x65, 0x72, 0x22, 0x3a, 0x20,
	0x22, 0x69, 0x73, 0x73, 0x75, 0x65, 0x72, 0x22, 0x2c, 0x0a, 0x20, 0x20, 0x22, 0x63, 0x6c, 0x69,
	0x65, 0x6e, 0x74, 0x5f, 0x69, 0x64, 0x22, 0x3a, 0x20, 0x22, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74,
	0x5f, 0x69, 0x64, 0x22, 0x2c, 0x0a, 0x20, 0x20, 0x22, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x5f,
	0x73, 0x65, 0x63, 0x72, 0x65, 0x74, 0x22, 0x3a, 0x20, 0x22, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74,
	0x5f, 0x73, 0x65, 0x63, 0x72, 0x65, 0x74, 0x22, 0x2c, 0x0a, 0x20, 0x20, 0x22, 0x6d, 0x61, 0x78,
	0x5f, 0x61, 0x67, 0x65, 0x22, 0x3a, 0x20, 0x33, 0x36, 0x30, 0x30, 0x2c, 0x0a, 0x20, 0x20, 0x22,
	0x73, 0x69, 0x67, 0x6e, 0x69, 0x6e, 0x67, 0x5f, 0x61, 0x6c, 0x67, 0x6f, 0x72, 0x69, 0x74, 0x68,
	0x6d, 0x73, 0x22, 0x3a, 0x20, 0x5b, 0x5d, 0x2c, 0x0a, 0x20, 0x20, 0x22, 0x61, 0x70, 0x69, 0x5f,
	0x75, 0x72, 0x6c, 0x5f, 0x70, 0x72, 0x65, 0x66, 0x69, 0x78, 0x22, 0x3a, 0x20, 0x22, 0x61, 0x70,
	0x69, 0x5f, 0x75, 0x72, 0x6c, 0x5f, 0x70, 0x72, 0x65, 0x66, 0x69, 0x78, 0x22, 0x2c, 0x0a, 0x20,
	0x20, 0x22, 0x69, 0x64, 0x70, 0x5f, 0x63, 0x61, 0x5f, 0x63, 0x65, 0x72, 0x74, 0x73, 0x22, 0x3a,
	0x20, 0x5b, 0x5d, 0x2c, 0x0a, 0x20, 0x20, 0x22, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x65, 0x64, 0x5f,
	0x61, 0x75, 0x64, 0x69, 0x65, 0x6e, 0x63, 0x65, 0x73, 0x22, 0x3a, 0x20, 0x5b, 0x5d, 0x2c, 0x0a,
	0x20, 0x20, 0x22, 0x63, 0x6c, 0x61, 0x69, 0x6d, 0x73, 0x5f, 0x73, 0x63, 0x6f, 0x70, 0x65, 0x73,
	0x22, 0x3a, 0x20, 0x5b, 0x5d, 0x2c, 0x0a, 0x20, 0x20, 0x22, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e,
	0x74, 0x5f, 0x63, 0x6c, 0x61, 0x69, 0x6d, 0x5f, 0x6d, 0x61, 0x70, 0x73, 0x22, 0x3a, 0x20, 0x5b,
	0x5d, 0x2c, 0x0a, 0x20, 0x20, 0x22, 0x64, 0x69, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x64, 0x69,
	0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x65, 0x64, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x5f,
	0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x3a, 0x20, 0x66, 0x61, 0x6c,
	0x73, 0x65, 0x2c, 0x0a, 0x20, 0x20, 0x22, 0x70, 0x72, 0x6f, 0x6d, 0x70, 0x74, 0x73, 0x22, 0x3a,
	0x20, 0x5b, 0x5d, 0x0a, 0x7d, 0x0a, 0x60, 0x60, 0x60, 0x0a, 0x46, 0x6f, 0x72, 0x20, 0x4c, 0x44,
	0x41, 0x50, 0x20, 0x61, 0x75, 0x74, 0x68, 0x20, 0x6d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x73, 0x2c,
	0x20, 0x74, 0x68, 0x65, 0x20, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x20,
	0x61, 0x72, 0x65, 0x3a, 0x0a, 0x60, 0x60, 0x60, 0x6a, 0x73, 0x6f, 0x6e, 0x0a, 0x7b, 0x0a, 0x20,
	0x20, 0x22, 0x73, 0x74, 0x61, 0x72, 0x74, 0x5f, 0x74, 0x6c, 0x73, 0x22, 0x3a, 0x20, 0x66, 0x61,
	0x6c, 0x73, 0x65, 0x2c, 0x0a, 0x20, 0x20, 0x22, 0x69, 0x6e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x65,
	0x5f, 0x74, 0x6c, 0x73, 0x22, 0x3a, 0x20, 0x66, 0x61, 0x6c, 0x73, 0x65, 0x2c, 0x0a, 0x20, 0x20,
	0x22, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x5f, 0x64, 0x6e, 0x22, 0x3a, 0x20, 0x66,
	0x61, 0x6c, 0x73, 0x65, 0x2c, 0x0a, 0x20, 0x20, 0x22, 0x61, 0x6e, 0x6f, 0x6e, 0x5f, 0x67, 0x72,
	0x6f, 0x75, 0x70, 0x5f, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x22, 0x3a, 0x20, 0x66, 0x61, 0x6c,
	0x73, 0x65, 0x2c, 0x0a, 0x20, 0x20, 0x22, 0x75, 0x70, 0x6e, 0x5f, 0x64, 0x6f, 0x6d, 0x61, 0x69,
	0x6e, 0x22, 0x3a, 0x20, 0x22, 0x75, 0x70, 0x6e, 0x5f, 0x64, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x22,
	0x2c, 0x0a, 0x20, 0x20, 0x22, 0x75, 0x72, 0x6c, 0x73, 0x22, 0x3a, 0x20, 0x5b, 0x5d, 0x2c, 0x0a,
	0x20, 0x20, 0x22, 0x75, 0x73, 0x65, 0x72, 0x5f, 0x64, 0x6e, 0x22, 0x3a, 0x20, 0x22, 0x75, 0x73,
	0x65, 0x72, 0x5f, 0x64, 0x6e, 0x22, 0x2c, 0x0a, 0x20, 0x20, 0x22, 0x75, 0x73, 0x65, 0x72, 0x5f,
	0x61, 0x74, 0x74, 0x72, 0x22, 0x3a, 0x20, 0x22, 0x75, 0x73, 0x65, 0x72, 0x5f, 0x61, 0x74, 0x74,
	0x72, 0x22, 0x2c, 0x0a, 0x20, 0x20, 0x22, 0x75, 0x73, 0x65, 0x72, 0x5f, 0x66, 0x69, 0x6c, 0x74,
	0x65, 0x72, 0x22, 0x3a, 0x20, 0x22, 0x75, 0x73, 0x65, 0x72, 0x5f, 0x66, 0x69, 0x6c, 0x74, 0x65,
	0x72, 0x22, 0x2c, 0x0a, 0x20, 0x20, 0x22, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x67, 0x72,
	0x6f, 0x75, 0x70, 0x73, 0x22, 0x3a, 0x20, 0x66, 0x61, 0x6c, 0x73, 0x65, 0x2c, 0x0a, 0x20, 0x20,
	0x22, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x5f, 0x64, 0x6e, 0x22, 0x3a, 0x20, 0x22, 0x67, 0x72, 0x6f,
	0x75, 0x70, 0x5f, 0x64, 0x6e, 0x22, 0x2c, 0x0a, 0x20, 0x20, 0x22, 0x67, 0x72, 0x6f, 0x75, 0x70,
	0x5f, 0x61, 0x74, 0x74, 0x72, 0x22, 0x3a, 0x20, 0x22, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x5f, 0x61,
	0x74, 0x74, 0x72, 0x22, 0x2c, 0x0a, 0x20, 0x20, 0x22, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x5f, 0x66,
	0x69, 0x6c, 0x74, 0x65, 0x72, 0x22, 0x3a, 0x20, 0x22, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x5f, 0x66,
	0x69, 0x6c, 0x74, 0x65, 0x72, 0x22, 0x2c, 0x0a, 0x20, 0x20, 0x22, 0x63, 0x65, 0x72, 0x74, 0x69,
	0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x73, 0x22, 0x3a, 0x20, 0x5b, 0x5d, 0x2c, 0x0a, 0x20, 0x20,
	0x22, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x5f, 0x63, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63,
	0x61, 0x74, 0x65, 0x22, 0x3a, 0x20, 0x22, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x5f, 0x63, 0x65,
	0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x22, 0x2c, 0x0a, 0x20, 0x20, 0x22, 0x63,
	0x6c, 0x69, 0x65, 0x6e, 0x74, 0x5f, 0x63, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74,
	0x65, 0x5f, 0x6b, 0x65, 0x79, 0x22, 0x3a, 0x20, 0x22, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x5f,
	0x63, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x5f, 0x6b, 0x65, 0x79, 0x22,
	0x2c, 0x0a, 0x20, 0x20, 0x22, 0x62, 0x69, 0x6e, 0x64, 0x5f, 0x64, 0x6e, 0x22, 0x3a, 0x20, 0x22,
	0x62, 0x69, 0x6e, 0x64, 0x5f, 0x64, 0x6e, 0x22, 0x2c, 0x0a, 0x20, 0x20, 0x22, 0x62, 0x69, 0x6e,
	0x64, 0x5f, 0x70, 0x61, 0x73, 0x73, 0x77, 0x6f, 0x72, 0x64, 0x22, 0x3a, 0x20, 0x22, 0x62, 0x69,
	0x6e, 0x64, 0x5f, 0x70, 0x61, 0x73, 0x73, 0x77, 0x6f, 0x72, 0x64, 0x22, 0x2c, 0x0a, 0x20, 0x20,
	0x22, 0x75, 0x73, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x5f, 0x67, 0x72, 0x6f, 0x75, 0x70,
	0x73, 0x22, 0x3a, 0x20, 0x66, 0x61, 0x6c, 0x73, 0x65, 0x2c, 0x0a, 0x20, 0x20, 0x22, 0x61, 0x63,
	0x63, 0x6f, 0x75, 0x6e, 0x74, 0x5f, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x5f,
	0x6d, 0x61, 0x70, 0x73, 0x22, 0x3a, 0x20, 0x5b, 0x5d, 0x2c, 0x0a, 0x20, 0x20, 0x22, 0x6d, 0x61,
	0x78, 0x69, 0x6d, 0x75, 0x6d, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x22,
	0x3a, 0x20, 0x31, 0x30, 0x30, 0x30, 0x2c, 0x0a, 0x20, 0x20, 0x22, 0x64, 0x65, 0x72, 0x65, 0x66,
	0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x5f, 0x61, 0x6c, 0x69, 0x61, 0x73, 0x65, 0x73, 0x22, 0x3a,
	0x20, 0x22, 0x6e, 0x65, 0x76, 0x65, 0x72, 0x22, 0x0a, 0x7d, 0x0a, 0x60, 0x60, 0x60, 0x0a, 0x4a,
	0x38, 0x7b, 0x22, 0x6d, 0x69, 0x6e, 0x5f, 0x6c, 0x6f, 0x67, 0x69, 0x6e, 0x5f, 0x6e, 0x61, 0x6d,
	0x65, 0x5f, 0x6c, 0x65, 0x6e, 0x67, 0x74, 0x68, 0x22, 0x3a, 0x20, 0x31, 0x30, 0x2c, 0x20, 0x22,
	0x6d, 0x69, 0x6e, 0x5f, 0x70, 0x61, 0x73, 0x73, 0x77, 0x6f, 0x72, 0x64, 0x5f, 0x6c, 0x65, 0x6e,
	0x67, 0x74, 0x68, 0x22, 0x3a, 0x20, 0x31, 0x36, 0x7d, 0xa0, 0xda, 0x29, 0x01, 0x9a, 0xe3, 0x29,
	0x07, 0x64, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x48, 0x00, 0x52, 0x0a, 0x61, 0x74, 0x74, 0x72,
	0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x12, 0xb0, 0x01, 0x0a, 0x1f, 0x70, 0x61, 0x73, 0x73, 0x77,
	0x6f, 0x72, 0x64, 0x5f, 0x61, 0x75, 0x74, 0x68, 0x5f, 0x6d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x5f,
	0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x18, 0x65, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x45, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x6c, 0x65, 0x72, 0x2e, 0x61, 0x70,
	0x69, 0x2e, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2e, 0x61, 0x75, 0x74, 0x68,
	0x6d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x61, 0x73, 0x73, 0x77,
	0x6f, 0x72, 0x64, 0x41, 0x75, 0x74, 0x68, 0x4d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x41, 0x74, 0x74,
	0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x42, 0x20, 0xa0, 0xda, 0x29, 0x01, 0x9a, 0xe3, 0x29,
	0x08, 0x70, 0x61, 0x73, 0x73, 0x77, 0x6f, 0x72, 0x64, 0xfa, 0xd2, 0xe4, 0x93, 0x02, 0x0a, 0x12,
	0x08, 0x49, 0x4e, 0x54, 0x45, 0x52, 0x4e, 0x41, 0x4c, 0x48, 0x00, 0x52, 0x1c, 0x70, 0x61, 0x73,
	0x73, 0x77, 0x6f, 0x72, 0x64, 0x41, 0x75, 0x74, 0x68, 0x4d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x41,
	0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x12, 0xa2, 0x01, 0x0a, 0x1c, 0x6f, 0x69,
	0x64, 0x63, 0x5f, 0x61, 0x75, 0x74, 0x68, 0x5f, 0x6d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x73, 0x5f,
	0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x18, 0x66, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x41, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x6c, 0x65, 0x72, 0x2e, 0x61, 0x70,
	0x69, 0x2e, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2e, 0x61, 0x75, 0x74, 0x68,
	0x6d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x4f, 0x69, 0x64, 0x63, 0x41,
	0x75, 0x74, 0x68, 0x4d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75,
	0x74, 0x65, 0x73, 0x42, 0x1c, 0xa0, 0xda, 0x29, 0x01, 0x9a, 0xe3, 0x29, 0x04, 0x6f, 0x69, 0x64,
	0x63, 0xfa, 0xd2, 0xe4, 0x93, 0x02, 0x0a, 0x12, 0x08, 0x49, 0x4e, 0x54, 0x45, 0x52, 0x4e, 0x41,
	0x4c, 0x48, 0x00, 0x52, 0x19, 0x6f, 0x69, 0x64, 0x63, 0x41, 0x75, 0x74, 0x68, 0x4d, 0x65, 0x74,
	0x68, 0x6f, 0x64, 0x73, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x12, 0xa2,
	0x01, 0x0a, 0x1c, 0x6c, 0x64, 0x61, 0x70, 0x5f, 0x61, 0x75, 0x74, 0x68, 0x5f, 0x6d, 0x65, 0x74,
	0x68, 0x6f, 0x64, 0x73, 0x5f, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x18,
	0x67, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x41, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x6c,
	0x65, 0x72, 0x2e, 0x61, 0x70, 0x69, 0x2e, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73,
	0x2e, 0x61, 0x75, 0x74, 0x68, 0x6d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x73, 0x2e, 0x76, 0x31, 0x2e,
	0x4c, 0x64, 0x61, 0x70, 0x41, 0x75, 0x74, 0x68, 0x4d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x41, 0x74,
	0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x42, 0x1c, 0xa0, 0xda, 0x29, 0x01, 0x9a, 0xe3,
	0x29, 0x04, 0x6c, 0x64, 0x61, 0x70, 0xfa, 0xd2, 0xe4, 0x93, 0x02, 0x0a, 0x12, 0x08, 0x49, 0x4e,
	0x54, 0x45, 0x52, 0x4e, 0x41, 0x4c, 0x48, 0x00, 0x52, 0x19, 0x6c, 0x64, 0x61, 0x70, 0x41, 0x75,
	0x74, 0x68, 0x4d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x73, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75,
	0x74, 0x65, 0x73, 0x12, 0x24, 0x0a, 0x0a, 0x69, 0x73, 0x5f, 0x70, 0x72, 0x69, 0x6d, 0x61, 0x72,
	0x79, 0x18, 0x6e, 0x20, 0x01, 0x28, 0x08, 0x42, 0x04, 0xe2, 0x41, 0x01, 0x03, 0x52, 0x0a, 0x69,
	0x73, 0x5f, 0x70, 0x72, 0x69, 0x6d, 0x61, 0x72, 0x79, 0x12, 0x35, 0x0a, 0x12, 0x61, 0x75, 0x74,
	0x68, 0x6f, 0x72, 0x69, 0x7a, 0x65, 0x64, 0x5f, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18,
	0xac, 0x02, 0x20, 0x03, 0x28, 0x09, 0x42, 0x04, 0xe2, 0x41, 0x01, 0x03, 0x52, 0x12, 0x61, 0x75,
	0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x65, 0x64, 0x5f, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x12, 0xa1, 0x01, 0x0a, 0x1d, 0x61, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x65, 0x64, 0x5f,
	0x63, 0x6f, 0x6c, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x61, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x18, 0xb6, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x54, 0x2e, 0x63, 0x6f, 0x6e, 0x74,
	0x72, 0x6f, 0x6c, 0x6c, 0x65, 0x72, 0x2e, 0x61, 0x70, 0x69, 0x2e, 0x72, 0x65, 0x73, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x73, 0x2e, 0x61, 0x75, 0x74, 0x68, 0x6d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x73,
	0x2e, 0x76, 0x31, 0x2e, 0x41, 0x75, 0x74, 0x68, 0x4d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x2e, 0x41,
	0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x65, 0x64, 0x43, 0x6f, 0x6c, 0x6c, 0x65, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x42,
	0x04, 0xe2, 0x41, 0x01, 0x03, 0x52, 0x1d, 0x61, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x65,
	0x64, 0x5f, 0x63, 0x6f, 0x6c, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x61, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x1a, 0x6a, 0x0a, 0x20, 0x41, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a,
	0x65, 0x64, 0x43, 0x6f, 0x6c, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x41, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x30, 0x0a, 0x05, 0x76, 0x61,
	0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x4c, 0x69, 0x73, 0x74,
	0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01,
	0x42, 0x07, 0x0a, 0x05, 0x61, 0x74, 0x74, 0x72, 0x73, 0x22, 0x83, 0x02, 0x0a, 0x1c, 0x50, 0x61,
	0x73, 0x73, 0x77, 0x6f, 0x72, 0x64, 0x41, 0x75, 0x74, 0x68, 0x4d, 0x65, 0x74, 0x68, 0x6f, 0x64,
	0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x12, 0x74, 0x0a, 0x15, 0x6d, 0x69,
	0x6e, 0x5f, 0x6c, 0x6f, 0x67, 0x69, 0x6e, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x5f, 0x6c, 0x65, 0x6e,
	0x67, 0x74, 0x68, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0d, 0x42, 0x3e, 0xa0, 0xda, 0x29, 0x01, 0xc2,
	0xdd, 0x29, 0x36, 0x0a, 0x20, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x2e,
	0x6d, 0x69, 0x6e, 0x5f, 0x6c, 0x6f, 0x67, 0x69, 0x6e, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x5f, 0x6c,
	0x65, 0x6e, 0x67, 0x74, 0x68, 0x12, 0x12, 0x4d, 0x69, 0x6e, 0x4c, 0x6f, 0x67, 0x69, 0x6e, 0x4e,
	0x61, 0x6d, 0x65, 0x4c, 0x65, 0x6e, 0x67, 0x74, 0x68, 0x52, 0x15, 0x6d, 0x69, 0x6e, 0x5f, 0x6c,
	0x6f, 0x67, 0x69, 0x6e, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x5f, 0x6c, 0x65, 0x6e, 0x67, 0x74, 0x68,
	0x12, 0x6d, 0x0a, 0x13, 0x6d, 0x69, 0x6e, 0x5f, 0x70, 0x61, 0x73, 0x73, 0x77, 0x6f, 0x72, 0x64,
	0x5f, 0x6c, 0x65, 0x6e, 0x67, 0x74, 0x68, 0x18, 0x14, 0x20, 0x01, 0x28, 0x0d, 0x42, 0x3b, 0xa0,
	0xda, 0x29, 0x01, 0xc2, 0xdd, 0x29, 0x33, 0x0a, 0x1e, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75,
	0x74, 0x65, 0x73, 0x2e, 0x6d, 0x69, 0x6e, 0x5f, 0x70, 0x61, 0x73, 0x73, 0x77, 0x6f, 0x72, 0x64,
	0x5f, 0x6c, 0x65, 0x6e, 0x67, 0x74, 0x68, 0x12, 0x11, 0x4d, 0x69, 0x6e, 0x50, 0x61, 0x73, 0x73,
	0x77, 0x6f, 0x72, 0x64, 0x4c, 0x65, 0x6e, 0x67, 0x74, 0x68, 0x52, 0x13, 0x6d, 0x69, 0x6e, 0x5f,
	0x70, 0x61, 0x73, 0x73, 0x77, 0x6f, 0x72, 0x64, 0x5f, 0x6c, 0x65, 0x6e, 0x67, 0x74, 0x68, 0x22,
	0xbe, 0x0a, 0x0a, 0x18, 0x4f, 0x69, 0x64, 0x63, 0x41, 0x75, 0x74, 0x68, 0x4d, 0x65, 0x74, 0x68,
	0x6f, 0x64, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x12, 0x1a, 0x0a, 0x05,
	0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x09, 0x42, 0x04, 0xe2, 0x41, 0x01,
	0x03, 0x52, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x12, 0x59, 0x0a, 0x06, 0x69, 0x73, 0x73, 0x75,
	0x65, 0x72, 0x18, 0x14, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x69, 0x6e,
	0x67, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x42, 0x23, 0xa0, 0xda, 0x29, 0x01, 0xc2, 0xdd, 0x29, 0x1b,
	0x0a, 0x11, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x2e, 0x69, 0x73, 0x73,
	0x75, 0x65, 0x72, 0x12, 0x06, 0x49, 0x73, 0x73, 0x75, 0x65, 0x72, 0x52, 0x06, 0x69, 0x73, 0x73,
	0x75, 0x65, 0x72, 0x12, 0x64, 0x0a, 0x09, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x5f, 0x69, 0x64,
	0x18, 0x1e, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x56,
	0x61, 0x6c, 0x75, 0x65, 0x42, 0x28, 0xa0, 0xda, 0x29, 0x01, 0xc2, 0xdd, 0x29, 0x20, 0x0a, 0x14,
	0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x2e, 0x63, 0x6c, 0x69, 0x65, 0x6e,
	0x74, 0x5f, 0x69, 0x64, 0x12, 0x08, 0x43, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x49, 0x64, 0x52, 0x09,
	0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x5f, 0x69, 0x64, 0x12, 0x78, 0x0a, 0x0d, 0x63, 0x6c, 0x69,
	0x65, 0x6e, 0x74, 0x5f, 0x73, 0x65, 0x63, 0x72, 0x65, 0x74, 0x18, 0x28, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x42, 0x34,
	0xe2, 0x41, 0x01, 0x04, 0xa0, 0xda, 0x29, 0x01, 0xc2, 0xdd, 0x29, 0x28, 0x0a, 0x18, 0x61, 0x74,
	0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x2e, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x5f,
	0x73, 0x65, 0x63, 0x72, 0x65, 0x74, 0x12, 0x0c, 0x43, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x53, 0x65,
	0x63, 0x72, 0x65, 0x74, 0x52, 0x0d, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x5f, 0x73, 0x65, 0x63,
	0x72, 0x65, 0x74, 0x12, 0x34, 0x0a, 0x12, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x5f, 0x73, 0x65,
	0x63, 0x72, 0x65, 0x74, 0x5f, 0x68, 0x6d, 0x61, 0x63, 0x18, 0x32, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x04, 0xe2, 0x41, 0x01, 0x03, 0x52, 0x12, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x5f, 0x73, 0x65,
	0x63, 0x72, 0x65, 0x74, 0x5f, 0x68, 0x6d, 0x61, 0x63, 0x12, 0x5c, 0x0a, 0x07, 0x6d, 0x61, 0x78,
	0x5f, 0x61, 0x67, 0x65, 0x18, 0x3c, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x55, 0x49, 0x6e,
	0x74, 0x33, 0x32, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x42, 0x24, 0xa0, 0xda, 0x29, 0x01, 0xc2, 0xdd,
	0x29, 0x1c, 0x0a, 0x12, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x2e, 0x6d,
	0x61, 0x78, 0x5f, 0x61, 0x67, 0x65, 0x12, 0x06, 0x4d, 0x61, 0x78, 0x41, 0x67, 0x65, 0x52, 0x07,
	0x6d, 0x61, 0x78, 0x5f, 0x61, 0x67, 0x65, 0x12, 0x64, 0x0a, 0x12, 0x73, 0x69, 0x67, 0x6e, 0x69,
	0x6e, 0x67, 0x5f, 0x61, 0x6c, 0x67, 0x6f, 0x72, 0x69, 0x74, 0x68, 0x6d, 0x73, 0x18, 0x46, 0x20,
	0x03, 0x28, 0x09, 0x42, 0x34, 0xa0, 0xda, 0x29, 0x01, 0xc2, 0xdd, 0x29, 0x2c, 0x0a, 0x1d, 0x61,
	0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x2e, 0x73, 0x69, 0x67, 0x6e, 0x69, 0x6e,
	0x67, 0x5f, 0x61, 0x6c, 0x67, 0x6f, 0x72, 0x69, 0x74, 0x68, 0x6d, 0x73, 0x12, 0x0b, 0x53, 0x69,
	0x67, 0x6e, 0x69, 0x6e, 0x67, 0x41, 0x6c, 0x67, 0x73, 0x52, 0x12, 0x73, 0x69, 0x67, 0x6e, 0x69,
	0x6e, 0x67, 0x5f, 0x61, 0x6c, 0x67, 0x6f, 0x72, 0x69, 0x74, 0x68, 0x6d, 0x73, 0x12, 0x71, 0x0a,
	0x0e, 0x61, 0x70, 0x69, 0x5f, 0x75, 0x72, 0x6c, 0x5f, 0x70, 0x72, 0x65, 0x66, 0x69, 0x78, 0x18,
	0x50, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x56, 0x61,
	0x6c, 0x75, 0x65, 0x42, 0x2b, 0xa0, 0xda, 0x29, 0x01, 0xc2, 0xdd, 0x29, 0x23, 0x0a, 0x19, 0x61,
	0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x2e, 0x61, 0x70, 0x69, 0x5f, 0x75, 0x72,
	0x6c, 0x5f, 0x70, 0x72, 0x65, 0x66, 0x69, 0x78, 0x12, 0x06, 0x41, 0x70, 0x69, 0x55, 0x72, 0x6c,
	0x52, 0x0e, 0x61, 0x70, 0x69, 0x5f, 0x75, 0x72, 0x6c, 0x5f, 0x70, 0x72, 0x65, 0x66, 0x69, 0x78,
	0x12, 0x28, 0x0a, 0x0c, 0x63, 0x61, 0x6c, 0x6c, 0x62, 0x61, 0x63, 0x6b, 0x5f, 0x75, 0x72, 0x6c,
	0x18, 0x5a, 0x20, 0x01, 0x28, 0x09, 0x42, 0x04, 0xe2, 0x41, 0x01, 0x03, 0x52, 0x0c, 0x63, 0x61,
	0x6c, 0x6c, 0x62, 0x61, 0x63, 0x6b, 0x5f, 0x75, 0x72, 0x6c, 0x12, 0x53, 0x0a, 0x0c, 0x69, 0x64,
	0x70, 0x5f, 0x63, 0x61, 0x5f, 0x63, 0x65, 0x72, 0x74, 0x73, 0x18, 0x64, 0x20, 0x03, 0x28, 0x09,
	0x42, 0x2f, 0xa0, 0xda, 0x29, 0x01, 0xc2, 0xdd, 0x29, 0x27, 0x0a, 0x17, 0x61, 0x74, 0x74, 0x72,
	0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x2e, 0x69, 0x64, 0x70, 0x5f, 0x63, 0x61, 0x5f, 0x63, 0x65,
	0x72, 0x74, 0x73, 0x12, 0x0c, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65,
	0x73, 0x52, 0x0c, 0x69, 0x64, 0x70, 0x5f, 0x63, 0x61, 0x5f, 0x63, 0x65, 0x72, 0x74, 0x73, 0x12,
	0x5f, 0x0a, 0x11, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x65, 0x64, 0x5f, 0x61, 0x75, 0x64, 0x69, 0x65,
	0x6e, 0x63, 0x65, 0x73, 0x18, 0x6e, 0x20, 0x03, 0x28, 0x09, 0x42, 0x31, 0xa0, 0xda, 0x29, 0x01,
	0xc2, 0xdd, 0x29, 0x29, 0x0a, 0x1c, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73,
	0x2e, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x65, 0x64, 0x5f, 0x61, 0x75, 0x64, 0x69, 0x65, 0x6e, 0x63,
	0x65, 0x73, 0x12, 0x09, 0x41, 0x75, 0x64, 0x43, 0x6c, 0x61, 0x69, 0x6d, 0x73, 0x52, 0x11, 0x61,
	0x6c, 0x6c, 0x6f, 0x77, 0x65, 0x64, 0x5f, 0x61, 0x75, 0x64, 0x69, 0x65, 0x6e, 0x63, 0x65, 0x73,
	0x12, 0x56, 0x0a, 0x0d, 0x63, 0x6c, 0x61, 0x69, 0x6d, 0x73, 0x5f, 0x73, 0x63, 0x6f, 0x70, 0x65,
	0x73, 0x18, 0x70, 0x20, 0x03, 0x28, 0x09, 0x42, 0x30, 0xa0, 0xda, 0x29, 0x01, 0xc2, 0xdd, 0x29,
	0x28, 0x0a, 0x18, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x2e, 0x63, 0x6c,
	0x61, 0x69, 0x6d, 0x73, 0x5f, 0x73, 0x63, 0x6f, 0x70, 0x65, 0x73, 0x12, 0x0c, 0x43, 0x6c, 0x61,
	0x69, 0x6d, 0x73, 0x53, 0x63, 0x6f, 0x70, 0x65, 0x73, 0x52, 0x0d, 0x63, 0x6c, 0x61, 0x69, 0x6d,
	0x73, 0x5f, 0x73, 0x63, 0x6f, 0x70, 0x65, 0x73, 0x12, 0x69, 0x0a, 0x12, 0x61, 0x63, 0x63, 0x6f,
	0x75, 0x6e, 0x74, 0x5f, 0x63, 0x6c, 0x61, 0x69, 0x6d, 0x5f, 0x6d, 0x61, 0x70, 0x73, 0x18, 0x71,
	0x20, 0x03, 0x28, 0x09, 0x42, 0x39, 0xa0, 0xda, 0x29, 0x01, 0xc2, 0xdd, 0x29, 0x31, 0x0a, 0x1d,
	0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x2e, 0x61, 0x63, 0x63, 0x6f, 0x75,
	0x6e, 0x74, 0x5f, 0x63, 0x6c, 0x61, 0x69, 0x6d, 0x5f, 0x6d, 0x61, 0x70, 0x73, 0x12, 0x10, 0x41,
	0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x43, 0x6c, 0x61, 0x69, 0x6d, 0x4d, 0x61, 0x70, 0x73, 0x52,
	0x12, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x5f, 0x63, 0x6c, 0x61, 0x69, 0x6d, 0x5f, 0x6d,
	0x61, 0x70, 0x73, 0x12, 0x58, 0x0a, 0x24, 0x64, 0x69, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x64,
	0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x65, 0x64, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x5f, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x78, 0x20, 0x01, 0x28,
	0x08, 0x42, 0x04, 0xa0, 0xda, 0x29, 0x01, 0x52, 0x24, 0x64, 0x69, 0x73, 0x61, 0x62, 0x6c, 0x65,
	0x5f, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x65, 0x64, 0x5f, 0x63, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x5f, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x1f, 0x0a,
	0x07, 0x64, 0x72, 0x79, 0x5f, 0x72, 0x75, 0x6e, 0x18, 0x82, 0x01, 0x20, 0x01, 0x28, 0x08, 0x42,
	0x04, 0xa0, 0xda, 0x29, 0x01, 0x52, 0x07, 0x64, 0x72, 0x79, 0x5f, 0x72, 0x75, 0x6e, 0x12, 0x40,
	0x0a, 0x07, 0x70, 0x72, 0x6f, 0x6d, 0x70, 0x74, 0x73, 0x18, 0x8c, 0x01, 0x20, 0x03, 0x28, 0x09,
	0x42, 0x25, 0xa0, 0xda, 0x29, 0x01, 0xc2, 0xdd, 0x29, 0x1d, 0x0a, 0x12, 0x61, 0x74, 0x74, 0x72,
	0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x6d, 0x70, 0x74, 0x73, 0x12, 0x07,
	0x50, 0x72, 0x6f, 0x6d, 0x70, 0x74, 0x73, 0x52, 0x07, 0x70, 0x72, 0x6f, 0x6d, 0x70, 0x74, 0x73,
	0x22, 0x61, 0x0a, 0x27, 0x4f, 0x69, 0x64, 0x63, 0x41, 0x75, 0x74, 0x68, 0x4d, 0x65, 0x74, 0x68,
	0x6f, 0x64, 0x41, 0x75, 0x74, 0x68, 0x65, 0x6e, 0x74, 0x69, 0x63, 0x61, 0x74, 0x65, 0x53, 0x74,
	0x61, 0x72, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x1a, 0x0a, 0x08, 0x61,
	0x75, 0x74, 0x68, 0x5f, 0x75, 0x72, 0x6c, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x61,
	0x75, 0x74, 0x68, 0x5f, 0x75, 0x72, 0x6c, 0x12, 0x1a, 0x0a, 0x08, 0x74, 0x6f, 0x6b, 0x65, 0x6e,
	0x5f, 0x69, 0x64, 0x18, 0x1e, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x74, 0x6f, 0x6b, 0x65, 0x6e,
	0x5f, 0x69, 0x64, 0x22, 0xb7, 0x01, 0x0a, 0x29, 0x4f, 0x69, 0x64, 0x63, 0x41, 0x75, 0x74, 0x68,
	0x4d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x41, 0x75, 0x74, 0x68, 0x65, 0x6e, 0x74, 0x69, 0x63, 0x61,
	0x74, 0x65, 0x43, 0x61, 0x6c, 0x6c, 0x62, 0x61, 0x63, 0x6b, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x12, 0x0a, 0x04, 0x63, 0x6f, 0x64, 0x65, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x04, 0x63, 0x6f, 0x64, 0x65, 0x12, 0x14, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x14,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x12, 0x14, 0x0a, 0x05, 0x65,
	0x72, 0x72, 0x6f, 0x72, 0x18, 0x1e, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x65, 0x72, 0x72, 0x6f,
	0x72, 0x12, 0x2c, 0x0a, 0x11, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x5f, 0x64, 0x65, 0x73, 0x63, 0x72,
	0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x28, 0x20, 0x01, 0x28, 0x09, 0x52, 0x11, 0x65, 0x72,
	0x72, 0x6f, 0x72, 0x5f, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12,
	0x1c, 0x0a, 0x09, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x5f, 0x75, 0x72, 0x69, 0x18, 0x32, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x09, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x5f, 0x75, 0x72, 0x69, 0x22, 0x5c, 0x0a,
	0x2a, 0x4f, 0x69, 0x64, 0x63, 0x41, 0x75, 0x74, 0x68, 0x4d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x41,
	0x75, 0x74, 0x68, 0x65, 0x6e, 0x74, 0x69, 0x63, 0x61, 0x74, 0x65, 0x43, 0x61, 0x6c, 0x6c, 0x62,
	0x61, 0x63, 0x6b, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x2e, 0x0a, 0x12, 0x66,
	0x69, 0x6e, 0x61, 0x6c, 0x5f, 0x72, 0x65, 0x64, 0x69, 0x72, 0x65, 0x63, 0x74, 0x5f, 0x75, 0x72,
	0x6c, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x09, 0x52, 0x12, 0x66, 0x69, 0x6e, 0x61, 0x6c, 0x5f, 0x72,
	0x65, 0x64, 0x69, 0x72, 0x65, 0x63, 0x74, 0x5f, 0x75, 0x72, 0x6c, 0x22, 0x44, 0x0a, 0x26, 0x4f,
	0x69, 0x64, 0x63, 0x41, 0x75, 0x74, 0x68, 0x4d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x41, 0x75, 0x74,
	0x68, 0x65, 0x6e, 0x74, 0x69, 0x63, 0x61, 0x74, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x1a, 0x0a, 0x08, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x5f, 0x69,
	0x64, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x5f, 0x69,
	0x64, 0x22, 0x41, 0x0a, 0x27, 0x4f, 0x69, 0x64, 0x63, 0x41, 0x75, 0x74, 0x68, 0x4d, 0x65, 0x74,
	0x68, 0x6f, 0x64, 0x41, 0x75, 0x74, 0x68, 0x65, 0x6e, 0x74, 0x69, 0x63, 0x61, 0x74, 0x65, 0x54,
	0x6f, 0x6b, 0x65, 0x6e, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x16, 0x0a, 0x06,
	0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x73, 0x74,
	0x61, 0x74, 0x75, 0x73, 0x22, 0xd1, 0x13, 0x0a, 0x18, 0x4c, 0x64, 0x61, 0x70, 0x41, 0x75, 0x74,
	0x68, 0x4d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65,
	0x73, 0x12, 0x46, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x30, 0xe2, 0x41, 0x01, 0x03, 0xa0, 0xda, 0x29, 0x01, 0xc2, 0xdd, 0x29, 0x24, 0x0a, 0x10,
	0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x2e, 0x73, 0x74, 0x61, 0x74, 0x65,
	0x12, 0x10, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x53, 0x74, 0x61,
	0x74, 0x65, 0x52, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x12, 0x46, 0x0a, 0x09, 0x73, 0x74, 0x61,
	0x72, 0x74, 0x5f, 0x74, 0x6c, 0x73, 0x18, 0x14, 0x20, 0x01, 0x28, 0x08, 0x42, 0x28, 0xa0, 0xda,
	0x29, 0x01, 0xc2, 0xdd, 0x29, 0x20, 0x0a, 0x14, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74,
	0x65, 0x73, 0x2e, 0x73, 0x74, 0x61, 0x72, 0x74, 0x5f, 0x74, 0x6c, 0x73, 0x12, 0x08, 0x53, 0x74,
	0x61, 0x72, 0x74, 0x54, 0x6c, 0x73, 0x52, 0x09, 0x73, 0x74, 0x61, 0x72, 0x74, 0x5f, 0x74, 0x6c,
	0x73, 0x12, 0x52, 0x0a, 0x0c, 0x69, 0x6e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x65, 0x5f, 0x74, 0x6c,
	0x73, 0x18, 0x1e, 0x20, 0x01, 0x28, 0x08, 0x42, 0x2e, 0xa0, 0xda, 0x29, 0x01, 0xc2, 0xdd, 0x29,
	0x26, 0x0a, 0x17, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x2e, 0x69, 0x6e,
	0x73, 0x65, 0x63, 0x75, 0x72, 0x65, 0x5f, 0x74, 0x6c, 0x73, 0x12, 0x0b, 0x49, 0x6e, 0x73, 0x65,
	0x63, 0x75, 0x72, 0x65, 0x54, 0x6c, 0x73, 0x52, 0x0c, 0x69, 0x6e, 0x73, 0x65, 0x63, 0x75, 0x72,
	0x65, 0x5f, 0x74, 0x6c, 0x73, 0x12, 0x4e, 0x0a, 0x0b, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65,
	0x72, 0x5f, 0x64, 0x6e, 0x18, 0x28, 0x20, 0x01, 0x28, 0x08, 0x42, 0x2c, 0xa0, 0xda, 0x29, 0x01,
	0xc2, 0xdd, 0x29, 0x24, 0x0a, 0x16, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73,
	0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x5f, 0x64, 0x6e, 0x12, 0x0a, 0x44, 0x69,
	0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x44, 0x6e, 0x52, 0x0b, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76,
	0x65, 0x72, 0x5f, 0x64, 0x6e, 0x12, 0x65, 0x0a, 0x11, 0x61, 0x6e, 0x6f, 0x6e, 0x5f, 0x67, 0x72,
	0x6f, 0x75, 0x70, 0x5f, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x18, 0x32, 0x20, 0x01, 0x28, 0x08,
	0x42, 0x37, 0xa0, 0xda, 0x29, 0x01, 0xc2, 0xdd, 0x29, 0x2f, 0x0a, 0x1c, 0x61, 0x74, 0x74, 0x72,
	0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x2e, 0x61, 0x6e, 0x6f, 0x6e, 0x5f, 0x67, 0x72, 0x6f, 0x75,
	0x70, 0x5f, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x12, 0x0f, 0x41, 0x6e, 0x6f, 0x6e, 0x47, 0x72,
	0x6f, 0x75, 0x70, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x52, 0x11, 0x61, 0x6e, 0x6f, 0x6e, 0x5f,
	0x67, 0x72, 0x6f, 0x75, 0x70, 0x5f, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x12, 0x68, 0x0a, 0x0a,
	0x75, 0x70, 0x6e, 0x5f, 0x64, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x18, 0x3c, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x42, 0x2a,
	0xa0, 0xda, 0x29, 0x01, 0xc2, 0xdd, 0x29, 0x22, 0x0a, 0x15, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62,
	0x75, 0x74, 0x65, 0x73, 0x2e, 0x75, 0x70, 0x6e, 0x5f, 0x64, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x12,
	0x09, 0x55, 0x70, 0x6e, 0x44, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x52, 0x0a, 0x75, 0x70, 0x6e, 0x5f,
	0x64, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x12, 0x33, 0x0a, 0x04, 0x75, 0x72, 0x6c, 0x73, 0x18, 0x46,
	0x20, 0x03, 0x28, 0x09, 0x42, 0x1f, 0xa0, 0xda, 0x29, 0x01, 0xc2, 0xdd, 0x29, 0x17, 0x0a, 0x0f,
	0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x2e, 0x75, 0x72, 0x6c, 0x73, 0x12,
	0x04, 0x55, 0x72, 0x6c, 0x73, 0x52, 0x04, 0x75, 0x72, 0x6c, 0x73, 0x12, 0x5c, 0x0a, 0x07, 0x75,
	0x73, 0x65, 0x72, 0x5f, 0x64, 0x6e, 0x18, 0x50, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53,
	0x74, 0x72, 0x69, 0x6e, 0x67, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x42, 0x24, 0xa0, 0xda, 0x29, 0x01,
	0xc2, 0xdd, 0x29, 0x1c, 0x0a, 0x12, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73,
	0x2e, 0x75, 0x73, 0x65, 0x72, 0x5f, 0x64, 0x6e, 0x12, 0x06, 0x55, 0x73, 0x65, 0x72, 0x44, 0x6e,
	0x52, 0x07, 0x75, 0x73, 0x65, 0x72, 0x5f, 0x64, 0x6e, 0x12, 0x64, 0x0a, 0x09, 0x75, 0x73, 0x65,
	0x72, 0x5f, 0x61, 0x74, 0x74, 0x72, 0x18, 0x5a, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53,
	0x74, 0x72, 0x69, 0x6e, 0x67, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x42, 0x28, 0xa0, 0xda, 0x29, 0x01,
	0xc2, 0xdd, 0x29, 0x20, 0x0a, 0x14, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73,
	0x2e, 0x75, 0x73, 0x65, 0x72, 0x5f, 0x61, 0x74, 0x74, 0x72, 0x12, 0x08, 0x55, 0x73, 0x65, 0x72,
	0x41, 0x74, 0x74, 0x72, 0x52, 0x09, 0x75, 0x73, 0x65, 0x72, 0x5f, 0x61, 0x74, 0x74, 0x72, 0x12,
	0x6c, 0x0a, 0x0b, 0x75, 0x73, 0x65, 0x72, 0x5f, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x64,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x56, 0x61, 0x6c,
	0x75, 0x65, 0x42, 0x2c, 0xa0, 0xda, 0x29, 0x01, 0xc2, 0xdd, 0x29, 0x24, 0x0a, 0x16, 0x61, 0x74,
	0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x2e, 0x75, 0x73, 0x65, 0x72, 0x5f, 0x66, 0x69,
	0x6c, 0x74, 0x65, 0x72, 0x12, 0x0a, 0x55, 0x73, 0x65, 0x72, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72,
	0x52, 0x0b, 0x75, 0x73, 0x65, 0x72, 0x5f, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x56, 0x0a,
	0x0d, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x73, 0x18, 0x6e,
	0x20, 0x01, 0x28, 0x08, 0x42, 0x30, 0xa0, 0xda, 0x29, 0x01, 0xc2, 0xdd, 0x29, 0x28, 0x0a, 0x18,
	0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x2e, 0x65, 0x6e, 0x61, 0x62, 0x6c,
	0x65, 0x5f, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x73, 0x12, 0x0c, 0x45, 0x6e, 0x61, 0x62, 0x6c, 0x65,
	0x47, 0x72, 0x6f, 0x75, 0x70, 0x73, 0x52, 0x0d, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x67,
	0x72, 0x6f, 0x75, 0x70, 0x73, 0x12, 0x60, 0x0a, 0x08, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x5f, 0x64,
	0x6e, 0x18, 0x78, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x69, 0x6e, 0x67,
	0x56, 0x61, 0x6c, 0x75, 0x65, 0x42, 0x26, 0xa0, 0xda, 0x29, 0x01, 0xc2, 0xdd, 0x29, 0x1e, 0x0a,
	0x13, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x2e, 0x67, 0x72, 0x6f, 0x75,
	0x70, 0x5f, 0x64, 0x6e, 0x12, 0x07, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x44, 0x6e, 0x52, 0x08, 0x67,
	0x72, 0x6f, 0x75, 0x70, 0x5f, 0x64, 0x6e, 0x12, 0x69, 0x0a, 0x0a, 0x67, 0x72, 0x6f, 0x75, 0x70,
	0x5f, 0x61, 0x74, 0x74, 0x72, 0x18, 0x82, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53,
	0x74, 0x72, 0x69, 0x6e, 0x67, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x42, 0x2a, 0xa0, 0xda, 0x29, 0x01,
	0xc2, 0xdd, 0x29, 0x22, 0x0a, 0x15, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73,
	0x2e, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x5f, 0x61, 0x74, 0x74, 0x72, 0x12, 0x09, 0x47, 0x72, 0x6f,
	0x75, 0x70, 0x41, 0x74, 0x74, 0x72, 0x52, 0x0a, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x5f, 0x61, 0x74,
	0x74, 0x72, 0x12, 0x71, 0x0a, 0x0c, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x5f, 0x66, 0x69, 0x6c, 0x74,
	0x65, 0x72, 0x18, 0x8c, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x69,
	0x6e, 0x67, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x42, 0x2e, 0xa0, 0xda, 0x29, 0x01, 0xc2, 0xdd, 0x29,
	0x26, 0x0a, 0x17, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x2e, 0x67, 0x72,
	0x6f, 0x75, 0x70, 0x5f, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x0b, 0x47, 0x72, 0x6f, 0x75,
	0x70, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x52, 0x0c, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x5f, 0x66,
	0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x54, 0x0a, 0x0c, 0x63, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69,
	0x63, 0x61, 0x74, 0x65, 0x73, 0x18, 0x96, 0x01, 0x20, 0x03, 0x28, 0x09, 0x42, 0x2f, 0xa0, 0xda,
	0x29, 0x01, 0xc2, 0xdd, 0x29, 0x27, 0x0a, 0x17, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74,
	0x65, 0x73, 0x2e, 0x63, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x73, 0x12,
	0x0c, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x73, 0x52, 0x0c, 0x63,
	0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x73, 0x12, 0x89, 0x01, 0x0a, 0x12,
	0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x5f, 0x63, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61,
	0x74, 0x65, 0x18, 0xa0, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x69,
	0x6e, 0x67, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x42, 0x3a, 0xa0, 0xda, 0x29, 0x01, 0xc2, 0xdd, 0x29,
	0x32, 0x0a, 0x1d, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x2e, 0x63, 0x6c,
	0x69, 0x65, 0x6e, 0x74, 0x5f, 0x63, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65,
	0x12, 0x11, 0x43, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63,
	0x61, 0x74, 0x65, 0x52, 0x12, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x5f, 0x63, 0x65, 0x72, 0x74,
	0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x12, 0x9c, 0x01, 0x0a, 0x16, 0x63, 0x6c, 0x69, 0x65,
	0x6e, 0x74, 0x5f, 0x63, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x5f, 0x6b,
	0x65, 0x79, 0x18, 0xaa, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x69,
	0x6e, 0x67, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x42, 0x45, 0xe2, 0x41, 0x01, 0x04, 0xa0, 0xda, 0x29,
	0x01, 0xc2, 0xdd, 0x29, 0x39, 0x0a, 0x21, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65,
	0x73, 0x2e, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x5f, 0x63, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69,
	0x63, 0x61, 0x74, 0x65, 0x5f, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x43, 0x6c, 0x69, 0x65, 0x6e, 0x74,
	0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x4b, 0x65, 0x79, 0x52, 0x16,
	0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x5f, 0x63, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61,
	0x74, 0x65, 0x5f, 0x6b, 0x65, 0x79, 0x12, 0x47, 0x0a, 0x1b, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74,
	0x5f, 0x63, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x5f, 0x6b, 0x65, 0x79,
	0x5f, 0x68, 0x6d, 0x61, 0x63, 0x18, 0xb4, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x04, 0xe2, 0x41,
	0x01, 0x03, 0x52, 0x1b, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x5f, 0x63, 0x65, 0x72, 0x74, 0x69,
	0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x5f, 0x6b, 0x65, 0x79, 0x5f, 0x68, 0x6d, 0x61, 0x63, 0x12,
	0x5d, 0x0a, 0x07, 0x62, 0x69, 0x6e, 0x64, 0x5f, 0x64, 0x6e, 0x18, 0xbe, 0x01, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x42,
	0x24, 0xa0, 0xda, 0x29, 0x01, 0xc2, 0xdd, 0x29, 0x1c, 0x0a, 0x12, 0x61, 0x74, 0x74, 0x72, 0x69,
	0x62, 0x75, 0x74, 0x65, 0x73, 0x2e, 0x62, 0x69, 0x6e, 0x64, 0x5f, 0x64, 0x6e, 0x12, 0x06, 0x42,
	0x69, 0x6e, 0x64, 0x44, 0x6e, 0x52, 0x07, 0x62, 0x69, 0x6e, 0x64, 0x5f, 0x64, 0x6e, 0x12, 0x79,
	0x0a, 0x0d, 0x62, 0x69, 0x6e, 0x64, 0x5f, 0x70, 0x61, 0x73, 0x73, 0x77, 0x6f, 0x72, 0x64, 0x18,
	0xc8, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x56,
	0x61, 0x6c, 0x75, 0x65, 0x42, 0x34, 0xe2, 0x41, 0x01, 0x04, 0xa0, 0xda, 0x29, 0x01, 0xc2, 0xdd,
	0x29, 0x28, 0x0a, 0x18, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x2e, 0x62,
	0x69, 0x6e, 0x64, 0x5f, 0x70, 0x61, 0x73, 0x73, 0x77, 0x6f, 0x72, 0x64, 0x12, 0x0c, 0x42, 0x69,
	0x6e, 0x64, 0x50, 0x61, 0x73, 0x73, 0x77, 0x6f, 0x72, 0x64, 0x52, 0x0d, 0x62, 0x69, 0x6e, 0x64,
	0x5f, 0x70, 0x61, 0x73, 0x73, 0x77, 0x6f, 0x72, 0x64, 0x12, 0x35, 0x0a, 0x12, 0x62, 0x69, 0x6e,
	0x64, 0x5f, 0x70, 0x61, 0x73, 0x73, 0x77, 0x6f, 0x72, 0x64, 0x5f, 0x68, 0x6d, 0x61, 0x63, 0x18,
	0xd2, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x04, 0xe2, 0x41, 0x01, 0x03, 0x52, 0x12, 0x62, 0x69,
	0x6e, 0x64, 0x5f, 0x70, 0x61, 0x73, 0x73, 0x77, 0x6f, 0x72, 0x64, 0x5f, 0x68, 0x6d, 0x61, 0x63,
	0x12, 0x62, 0x0a, 0x10, 0x75, 0x73, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x5f, 0x67, 0x72,
	0x6f, 0x75, 0x70, 0x73, 0x18, 0xdc, 0x01, 0x20, 0x01, 0x28, 0x08, 0x42, 0x35, 0xa0, 0xda, 0x29,
	0x01, 0xc2, 0xdd, 0x29, 0x2d, 0x0a, 0x1b, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65,
	0x73, 0x2e, 0x75, 0x73, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x5f, 0x67, 0x72, 0x6f, 0x75,
	0x70, 0x73, 0x12, 0x0e, 0x55, 0x73, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x47, 0x72, 0x6f, 0x75,
	0x70, 0x73, 0x52, 0x10, 0x75, 0x73, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x5f, 0x67, 0x72,
	0x6f, 0x75, 0x70, 0x73, 0x12, 0x7a, 0x0a, 0x16, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x5f,
	0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x70, 0x73, 0x18, 0xe6,
	0x01, 0x20, 0x03, 0x28, 0x09, 0x42, 0x41, 0xa0, 0xda, 0x29, 0x01, 0xc2, 0xdd, 0x29, 0x39, 0x0a,
	0x21, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x2e, 0x61, 0x63, 0x63, 0x6f,
	0x75, 0x6e, 0x74, 0x5f, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x5f, 0x6d, 0x61,
	0x70, 0x73, 0x12, 0x14, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x41, 0x74, 0x74, 0x72, 0x69,
	0x62, 0x75, 0x74, 0x65, 0x4d, 0x61, 0x70, 0x73, 0x52, 0x16, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e,
	0x74, 0x5f, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x70, 0x73,
	0x12, 0x66, 0x0a, 0x11, 0x6d, 0x61, 0x78, 0x69, 0x6d, 0x75, 0x6d, 0x5f, 0x70, 0x61, 0x67, 0x65,
	0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0xf0, 0x01, 0x20, 0x01, 0x28, 0x0d, 0x42, 0x37, 0xa0, 0xda,
	0x29, 0x01, 0xc2, 0xdd, 0x29, 0x2f, 0x0a, 0x1c, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74,
	0x65, 0x73, 0x2e, 0x6d, 0x61, 0x78, 0x69, 0x6d, 0x75, 0x6d, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f,
	0x73, 0x69, 0x7a, 0x65, 0x12, 0x0f, 0x4d, 0x61, 0x78, 0x69, 0x6d, 0x75, 0x6d, 0x50, 0x61, 0x67,
	0x65, 0x53, 0x69, 0x7a, 0x65, 0x52, 0x11, 0x6d, 0x61, 0x78, 0x69, 0x6d, 0x75, 0x6d, 0x5f, 0x70,
	0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x12, 0x8d, 0x01, 0x0a, 0x13, 0x64, 0x65, 0x72,
	0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x5f, 0x61, 0x6c, 0x69, 0x61, 0x73, 0x65, 0x73,
	0x18, 0xfa, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x69, 0x6e, 0x67,
	0x56, 0x61, 0x6c, 0x75, 0x65, 0x42, 0x3c, 0xa0, 0xda, 0x29, 0x01, 0xc2, 0xdd, 0x29, 0x34, 0x0a,
	0x1e, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x2e, 0x64, 0x65, 0x72, 0x65,
	0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x5f, 0x61, 0x6c, 0x69, 0x61, 0x73, 0x65, 0x73, 0x12,
	0x12, 0x44, 0x65, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x41, 0x6c, 0x69, 0x61,
	0x73, 0x65, 0x73, 0x52, 0x13, 0x64, 0x65, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65,
	0x5f, 0x61, 0x6c, 0x69, 0x61, 0x73, 0x65, 0x73, 0x42, 0x60, 0xa2, 0xe3, 0x29, 0x04, 0x61, 0x75,
	0x74, 0x68, 0x5a, 0x56, 0x67, 0x69, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x68,
	0x61, 0x73, 0x68, 0x69, 0x63, 0x6f, 0x72, 0x70, 0x2f, 0x62, 0x6f, 0x75, 0x6e, 0x64, 0x61, 0x72,
	0x79, 0x2f, 0x73, 0x64, 0x6b, 0x2f, 0x70, 0x62, 0x73, 0x2f, 0x63, 0x6f, 0x6e, 0x74, 0x72, 0x6f,
	0x6c, 0x6c, 0x65, 0x72, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x73, 0x2f, 0x61, 0x75, 0x74, 0x68, 0x6d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x73, 0x3b, 0x61,
	0x75, 0x74, 0x68, 0x6d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x73, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x33,
}

var (
	file_controller_api_resources_authmethods_v1_auth_method_proto_rawDescOnce sync.Once
	file_controller_api_resources_authmethods_v1_auth_method_proto_rawDescData = file_controller_api_resources_authmethods_v1_auth_method_proto_rawDesc
)

func file_controller_api_resources_authmethods_v1_auth_method_proto_rawDescGZIP() []byte {
	file_controller_api_resources_authmethods_v1_auth_method_proto_rawDescOnce.Do(func() {
		file_controller_api_resources_authmethods_v1_auth_method_proto_rawDescData = protoimpl.X.CompressGZIP(file_controller_api_resources_authmethods_v1_auth_method_proto_rawDescData)
	})
	return file_controller_api_resources_authmethods_v1_auth_method_proto_rawDescData
}

var file_controller_api_resources_authmethods_v1_auth_method_proto_msgTypes = make([]protoimpl.MessageInfo, 10)
var file_controller_api_resources_authmethods_v1_auth_method_proto_goTypes = []any{
	(*AuthMethod)(nil),                                 // 0: controller.api.resources.authmethods.v1.AuthMethod
	(*PasswordAuthMethodAttributes)(nil),               // 1: controller.api.resources.authmethods.v1.PasswordAuthMethodAttributes
	(*OidcAuthMethodAttributes)(nil),                   // 2: controller.api.resources.authmethods.v1.OidcAuthMethodAttributes
	(*OidcAuthMethodAuthenticateStartResponse)(nil),    // 3: controller.api.resources.authmethods.v1.OidcAuthMethodAuthenticateStartResponse
	(*OidcAuthMethodAuthenticateCallbackRequest)(nil),  // 4: controller.api.resources.authmethods.v1.OidcAuthMethodAuthenticateCallbackRequest
	(*OidcAuthMethodAuthenticateCallbackResponse)(nil), // 5: controller.api.resources.authmethods.v1.OidcAuthMethodAuthenticateCallbackResponse
	(*OidcAuthMethodAuthenticateTokenRequest)(nil),     // 6: controller.api.resources.authmethods.v1.OidcAuthMethodAuthenticateTokenRequest
	(*OidcAuthMethodAuthenticateTokenResponse)(nil),    // 7: controller.api.resources.authmethods.v1.OidcAuthMethodAuthenticateTokenResponse
	(*LdapAuthMethodAttributes)(nil),                   // 8: controller.api.resources.authmethods.v1.LdapAuthMethodAttributes
	nil,                                                // 9: controller.api.resources.authmethods.v1.AuthMethod.AuthorizedCollectionActionsEntry
	(*scopes.ScopeInfo)(nil),                           // 10: controller.api.resources.scopes.v1.ScopeInfo
	(*wrapperspb.StringValue)(nil),                     // 11: google.protobuf.StringValue
	(*timestamppb.Timestamp)(nil),                      // 12: google.protobuf.Timestamp
	(*structpb.Struct)(nil),                            // 13: google.protobuf.Struct
	(*wrapperspb.UInt32Value)(nil),                     // 14: google.protobuf.UInt32Value
	(*structpb.ListValue)(nil),                         // 15: google.protobuf.ListValue
}
var file_controller_api_resources_authmethods_v1_auth_method_proto_depIdxs = []int32{
	10, // 0: controller.api.resources.authmethods.v1.AuthMethod.scope:type_name -> controller.api.resources.scopes.v1.ScopeInfo
	11, // 1: controller.api.resources.authmethods.v1.AuthMethod.name:type_name -> google.protobuf.StringValue
	11, // 2: controller.api.resources.authmethods.v1.AuthMethod.description:type_name -> google.protobuf.StringValue
	12, // 3: controller.api.resources.authmethods.v1.AuthMethod.created_time:type_name -> google.protobuf.Timestamp
	12, // 4: controller.api.resources.authmethods.v1.AuthMethod.updated_time:type_name -> google.protobuf.Timestamp
	13, // 5: controller.api.resources.authmethods.v1.AuthMethod.attributes:type_name -> google.protobuf.Struct
	1,  // 6: controller.api.resources.authmethods.v1.AuthMethod.password_auth_method_attributes:type_name -> controller.api.resources.authmethods.v1.PasswordAuthMethodAttributes
	2,  // 7: controller.api.resources.authmethods.v1.AuthMethod.oidc_auth_methods_attributes:type_name -> controller.api.resources.authmethods.v1.OidcAuthMethodAttributes
	8,  // 8: controller.api.resources.authmethods.v1.AuthMethod.ldap_auth_methods_attributes:type_name -> controller.api.resources.authmethods.v1.LdapAuthMethodAttributes
	9,  // 9: controller.api.resources.authmethods.v1.AuthMethod.authorized_collection_actions:type_name -> controller.api.resources.authmethods.v1.AuthMethod.AuthorizedCollectionActionsEntry
	11, // 10: controller.api.resources.authmethods.v1.OidcAuthMethodAttributes.issuer:type_name -> google.protobuf.StringValue
	11, // 11: controller.api.resources.authmethods.v1.OidcAuthMethodAttributes.client_id:type_name -> google.protobuf.StringValue
	11, // 12: controller.api.resources.authmethods.v1.OidcAuthMethodAttributes.client_secret:type_name -> google.protobuf.StringValue
	14, // 13: controller.api.resources.authmethods.v1.OidcAuthMethodAttributes.max_age:type_name -> google.protobuf.UInt32Value
	11, // 14: controller.api.resources.authmethods.v1.OidcAuthMethodAttributes.api_url_prefix:type_name -> google.protobuf.StringValue
	11, // 15: controller.api.resources.authmethods.v1.LdapAuthMethodAttributes.upn_domain:type_name -> google.protobuf.StringValue
	11, // 16: controller.api.resources.authmethods.v1.LdapAuthMethodAttributes.user_dn:type_name -> google.protobuf.StringValue
	11, // 17: controller.api.resources.authmethods.v1.LdapAuthMethodAttributes.user_attr:type_name -> google.protobuf.StringValue
	11, // 18: controller.api.resources.authmethods.v1.LdapAuthMethodAttributes.user_filter:type_name -> google.protobuf.StringValue
	11, // 19: controller.api.resources.authmethods.v1.LdapAuthMethodAttributes.group_dn:type_name -> google.protobuf.StringValue
	11, // 20: controller.api.resources.authmethods.v1.LdapAuthMethodAttributes.group_attr:type_name -> google.protobuf.StringValue
	11, // 21: controller.api.resources.authmethods.v1.LdapAuthMethodAttributes.group_filter:type_name -> google.protobuf.StringValue
	11, // 22: controller.api.resources.authmethods.v1.LdapAuthMethodAttributes.client_certificate:type_name -> google.protobuf.StringValue
	11, // 23: controller.api.resources.authmethods.v1.LdapAuthMethodAttributes.client_certificate_key:type_name -> google.protobuf.StringValue
	11, // 24: controller.api.resources.authmethods.v1.LdapAuthMethodAttributes.bind_dn:type_name -> google.protobuf.StringValue
	11, // 25: controller.api.resources.authmethods.v1.LdapAuthMethodAttributes.bind_password:type_name -> google.protobuf.StringValue
	11, // 26: controller.api.resources.authmethods.v1.LdapAuthMethodAttributes.dereference_aliases:type_name -> google.protobuf.StringValue
	15, // 27: controller.api.resources.authmethods.v1.AuthMethod.AuthorizedCollectionActionsEntry.value:type_name -> google.protobuf.ListValue
	28, // [28:28] is the sub-list for method output_type
	28, // [28:28] is the sub-list for method input_type
	28, // [28:28] is the sub-list for extension type_name
	28, // [28:28] is the sub-list for extension extendee
	0,  // [0:28] is the sub-list for field type_name
}

func init() { file_controller_api_resources_authmethods_v1_auth_method_proto_init() }
func file_controller_api_resources_authmethods_v1_auth_method_proto_init() {
	if File_controller_api_resources_authmethods_v1_auth_method_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_controller_api_resources_authmethods_v1_auth_method_proto_msgTypes[0].Exporter = func(v any, i int) any {
			switch v := v.(*AuthMethod); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_controller_api_resources_authmethods_v1_auth_method_proto_msgTypes[1].Exporter = func(v any, i int) any {
			switch v := v.(*PasswordAuthMethodAttributes); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_controller_api_resources_authmethods_v1_auth_method_proto_msgTypes[2].Exporter = func(v any, i int) any {
			switch v := v.(*OidcAuthMethodAttributes); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_controller_api_resources_authmethods_v1_auth_method_proto_msgTypes[3].Exporter = func(v any, i int) any {
			switch v := v.(*OidcAuthMethodAuthenticateStartResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_controller_api_resources_authmethods_v1_auth_method_proto_msgTypes[4].Exporter = func(v any, i int) any {
			switch v := v.(*OidcAuthMethodAuthenticateCallbackRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_controller_api_resources_authmethods_v1_auth_method_proto_msgTypes[5].Exporter = func(v any, i int) any {
			switch v := v.(*OidcAuthMethodAuthenticateCallbackResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_controller_api_resources_authmethods_v1_auth_method_proto_msgTypes[6].Exporter = func(v any, i int) any {
			switch v := v.(*OidcAuthMethodAuthenticateTokenRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_controller_api_resources_authmethods_v1_auth_method_proto_msgTypes[7].Exporter = func(v any, i int) any {
			switch v := v.(*OidcAuthMethodAuthenticateTokenResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_controller_api_resources_authmethods_v1_auth_method_proto_msgTypes[8].Exporter = func(v any, i int) any {
			switch v := v.(*LdapAuthMethodAttributes); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_controller_api_resources_authmethods_v1_auth_method_proto_msgTypes[0].OneofWrappers = []any{
		(*AuthMethod_Attributes)(nil),
		(*AuthMethod_PasswordAuthMethodAttributes)(nil),
		(*AuthMethod_OidcAuthMethodsAttributes)(nil),
		(*AuthMethod_LdapAuthMethodsAttributes)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_controller_api_resources_authmethods_v1_auth_method_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   10,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_controller_api_resources_authmethods_v1_auth_method_proto_goTypes,
		DependencyIndexes: file_controller_api_resources_authmethods_v1_auth_method_proto_depIdxs,
		MessageInfos:      file_controller_api_resources_authmethods_v1_auth_method_proto_msgTypes,
	}.Build()
	File_controller_api_resources_authmethods_v1_auth_method_proto = out.File
	file_controller_api_resources_authmethods_v1_auth_method_proto_rawDesc = nil
	file_controller_api_resources_authmethods_v1_auth_method_proto_goTypes = nil
	file_controller_api_resources_authmethods_v1_auth_method_proto_depIdxs = nil
}
