#!/usr/bin/env bash
# Copyright (c) HashiCorp, Inc.
# SPDX-License-Identifier: BUSL-1.1


# TERM isn't set automatically in CI so we need to make sure it's always there.
export TERM=${TERM:=dumb}

function die {
    echo $*
    exit -1
}

# error out early if missing a command
which boundary || die "missing boundary"
which jq       || die "missing jq"
which bats     || die "missing bats"
which nc       || die "missing nc"

echo "starting boundary dev in background"
boundary dev --create-loopback-plugin &>/dev/null &
boundary_pid=$!

function cleanup {
    rv=$?
    echo "stopping boundary dev"
    if [[ -n ${boundary_pid} ]]; then
        kill ${boundary_pid}
    fi
    exit $rv
}

trap cleanup EXIT

max=120
c=0
until boundary scopes list; do
    echo 'waiting for boundary to be up'
    ((c+=1))
    if [[ $c -ge $max ]]; then
        die "timeout waiting for boundary controller to get healthy"
    fi
    sleep 1
done

echo "running bats tests"
bats -p ./boundary
