// Copyright (c) HashiCorp, Inc.
// SPDX-License-Identifier: BUSL-1.1

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.34.2
// 	protoc        (unknown)
// source: controller/servers/services/v1/server_coordination_service.proto

package services

import (
	servers "github.com/hashicorp/boundary/internal/gen/controller/servers"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

type CONNECTIONSTATUS int32

const (
	CONNECTIONSTATUS_CONNECTIONSTATUS_UNSPECIFIED CONNECTIONSTATUS = 0
	CONNECTIONSTATUS_CONNECTIONSTATUS_AUTHORIZED  CONNECTIONSTATUS = 1
	CONNECTIONSTATUS_CONNECTIONSTATUS_CONNECTED   CONNECTIONSTATUS = 2
	CONNECTIONSTATUS_CONNECTIONSTATUS_CLOSED      CONNECTIONSTATUS = 3
)

// Enum value maps for CONNECTIONSTATUS.
var (
	CONNECTIONSTATUS_name = map[int32]string{
		0: "CONNECTIONSTATUS_UNSPECIFIED",
		1: "CONNECTIONSTATUS_AUTHORIZED",
		2: "CONNECTIONSTATUS_CONNECTED",
		3: "CONNECTIONSTATUS_CLOSED",
	}
	CONNECTIONSTATUS_value = map[string]int32{
		"CONNECTIONSTATUS_UNSPECIFIED": 0,
		"CONNECTIONSTATUS_AUTHORIZED":  1,
		"CONNECTIONSTATUS_CONNECTED":   2,
		"CONNECTIONSTATUS_CLOSED":      3,
	}
)

func (x CONNECTIONSTATUS) Enum() *CONNECTIONSTATUS {
	p := new(CONNECTIONSTATUS)
	*p = x
	return p
}

func (x CONNECTIONSTATUS) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (CONNECTIONSTATUS) Descriptor() protoreflect.EnumDescriptor {
	return file_controller_servers_services_v1_server_coordination_service_proto_enumTypes[0].Descriptor()
}

func (CONNECTIONSTATUS) Type() protoreflect.EnumType {
	return &file_controller_servers_services_v1_server_coordination_service_proto_enumTypes[0]
}

func (x CONNECTIONSTATUS) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use CONNECTIONSTATUS.Descriptor instead.
func (CONNECTIONSTATUS) EnumDescriptor() ([]byte, []int) {
	return file_controller_servers_services_v1_server_coordination_service_proto_rawDescGZIP(), []int{0}
}

type SESSIONSTATUS int32

const (
	SESSIONSTATUS_SESSIONSTATUS_UNSPECIFIED SESSIONSTATUS = 0
	SESSIONSTATUS_SESSIONSTATUS_PENDING     SESSIONSTATUS = 1
	SESSIONSTATUS_SESSIONSTATUS_ACTIVE      SESSIONSTATUS = 2
	SESSIONSTATUS_SESSIONSTATUS_CANCELING   SESSIONSTATUS = 3
	SESSIONSTATUS_SESSIONSTATUS_TERMINATED  SESSIONSTATUS = 4
)

// Enum value maps for SESSIONSTATUS.
var (
	SESSIONSTATUS_name = map[int32]string{
		0: "SESSIONSTATUS_UNSPECIFIED",
		1: "SESSIONSTATUS_PENDING",
		2: "SESSIONSTATUS_ACTIVE",
		3: "SESSIONSTATUS_CANCELING",
		4: "SESSIONSTATUS_TERMINATED",
	}
	SESSIONSTATUS_value = map[string]int32{
		"SESSIONSTATUS_UNSPECIFIED": 0,
		"SESSIONSTATUS_PENDING":     1,
		"SESSIONSTATUS_ACTIVE":      2,
		"SESSIONSTATUS_CANCELING":   3,
		"SESSIONSTATUS_TERMINATED":  4,
	}
)

func (x SESSIONSTATUS) Enum() *SESSIONSTATUS {
	p := new(SESSIONSTATUS)
	*p = x
	return p
}

func (x SESSIONSTATUS) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (SESSIONSTATUS) Descriptor() protoreflect.EnumDescriptor {
	return file_controller_servers_services_v1_server_coordination_service_proto_enumTypes[1].Descriptor()
}

func (SESSIONSTATUS) Type() protoreflect.EnumType {
	return &file_controller_servers_services_v1_server_coordination_service_proto_enumTypes[1]
}

func (x SESSIONSTATUS) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use SESSIONSTATUS.Descriptor instead.
func (SESSIONSTATUS) EnumDescriptor() ([]byte, []int) {
	return file_controller_servers_services_v1_server_coordination_service_proto_rawDescGZIP(), []int{1}
}

type SessionProcessingError int32

const (
	SessionProcessingError_SESSION_PROCESSING_ERROR_UNSPECIFIED  SessionProcessingError = 0
	SessionProcessingError_SESSION_PROCESSING_ERROR_UNRECOGNIZED SessionProcessingError = 1
)

// Enum value maps for SessionProcessingError.
var (
	SessionProcessingError_name = map[int32]string{
		0: "SESSION_PROCESSING_ERROR_UNSPECIFIED",
		1: "SESSION_PROCESSING_ERROR_UNRECOGNIZED",
	}
	SessionProcessingError_value = map[string]int32{
		"SESSION_PROCESSING_ERROR_UNSPECIFIED":  0,
		"SESSION_PROCESSING_ERROR_UNRECOGNIZED": 1,
	}
)

func (x SessionProcessingError) Enum() *SessionProcessingError {
	p := new(SessionProcessingError)
	*p = x
	return p
}

func (x SessionProcessingError) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (SessionProcessingError) Descriptor() protoreflect.EnumDescriptor {
	return file_controller_servers_services_v1_server_coordination_service_proto_enumTypes[2].Descriptor()
}

func (SessionProcessingError) Type() protoreflect.EnumType {
	return &file_controller_servers_services_v1_server_coordination_service_proto_enumTypes[2]
}

func (x SessionProcessingError) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use SessionProcessingError.Descriptor instead.
func (SessionProcessingError) EnumDescriptor() ([]byte, []int) {
	return file_controller_servers_services_v1_server_coordination_service_proto_rawDescGZIP(), []int{2}
}

type JOBTYPE int32

const (
	JOBTYPE_JOBTYPE_UNSPECIFIED     JOBTYPE = 0
	JOBTYPE_JOBTYPE_SESSION         JOBTYPE = 1
	JOBTYPE_JOBTYPE_MONITOR_SESSION JOBTYPE = 2
)

// Enum value maps for JOBTYPE.
var (
	JOBTYPE_name = map[int32]string{
		0: "JOBTYPE_UNSPECIFIED",
		1: "JOBTYPE_SESSION",
		2: "JOBTYPE_MONITOR_SESSION",
	}
	JOBTYPE_value = map[string]int32{
		"JOBTYPE_UNSPECIFIED":     0,
		"JOBTYPE_SESSION":         1,
		"JOBTYPE_MONITOR_SESSION": 2,
	}
)

func (x JOBTYPE) Enum() *JOBTYPE {
	p := new(JOBTYPE)
	*p = x
	return p
}

func (x JOBTYPE) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (JOBTYPE) Descriptor() protoreflect.EnumDescriptor {
	return file_controller_servers_services_v1_server_coordination_service_proto_enumTypes[3].Descriptor()
}

func (JOBTYPE) Type() protoreflect.EnumType {
	return &file_controller_servers_services_v1_server_coordination_service_proto_enumTypes[3]
}

func (x JOBTYPE) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use JOBTYPE.Descriptor instead.
func (JOBTYPE) EnumDescriptor() ([]byte, []int) {
	return file_controller_servers_services_v1_server_coordination_service_proto_rawDescGZIP(), []int{3}
}

type CHANGETYPE int32

const (
	CHANGETYPE_CHANGETYPE_UNSPECIFIED CHANGETYPE = 0
	// Indicates to the worker to update its knowledge of the state, which may
	// cause action to be taken.
	CHANGETYPE_CHANGETYPE_UPDATE_STATE CHANGETYPE = 1
)

// Enum value maps for CHANGETYPE.
var (
	CHANGETYPE_name = map[int32]string{
		0: "CHANGETYPE_UNSPECIFIED",
		1: "CHANGETYPE_UPDATE_STATE",
	}
	CHANGETYPE_value = map[string]int32{
		"CHANGETYPE_UNSPECIFIED":  0,
		"CHANGETYPE_UPDATE_STATE": 1,
	}
)

func (x CHANGETYPE) Enum() *CHANGETYPE {
	p := new(CHANGETYPE)
	*p = x
	return p
}

func (x CHANGETYPE) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (CHANGETYPE) Descriptor() protoreflect.EnumDescriptor {
	return file_controller_servers_services_v1_server_coordination_service_proto_enumTypes[4].Descriptor()
}

func (CHANGETYPE) Type() protoreflect.EnumType {
	return &file_controller_servers_services_v1_server_coordination_service_proto_enumTypes[4]
}

func (x CHANGETYPE) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use CHANGETYPE.Descriptor instead.
func (CHANGETYPE) EnumDescriptor() ([]byte, []int) {
	return file_controller_servers_services_v1_server_coordination_service_proto_rawDescGZIP(), []int{4}
}

type UpstreamServer_TYPE int32

const (
	UpstreamServer_TYPE_UNSPECIFIED UpstreamServer_TYPE = 0
	UpstreamServer_TYPE_CONTROLLER  UpstreamServer_TYPE = 1
	UpstreamServer_TYPE_WORKER      UpstreamServer_TYPE = 2
)

// Enum value maps for UpstreamServer_TYPE.
var (
	UpstreamServer_TYPE_name = map[int32]string{
		0: "TYPE_UNSPECIFIED",
		1: "TYPE_CONTROLLER",
		2: "TYPE_WORKER",
	}
	UpstreamServer_TYPE_value = map[string]int32{
		"TYPE_UNSPECIFIED": 0,
		"TYPE_CONTROLLER":  1,
		"TYPE_WORKER":      2,
	}
)

func (x UpstreamServer_TYPE) Enum() *UpstreamServer_TYPE {
	p := new(UpstreamServer_TYPE)
	*p = x
	return p
}

func (x UpstreamServer_TYPE) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (UpstreamServer_TYPE) Descriptor() protoreflect.EnumDescriptor {
	return file_controller_servers_services_v1_server_coordination_service_proto_enumTypes[5].Descriptor()
}

func (UpstreamServer_TYPE) Type() protoreflect.EnumType {
	return &file_controller_servers_services_v1_server_coordination_service_proto_enumTypes[5]
}

func (x UpstreamServer_TYPE) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use UpstreamServer_TYPE.Descriptor instead.
func (UpstreamServer_TYPE) EnumDescriptor() ([]byte, []int) {
	return file_controller_servers_services_v1_server_coordination_service_proto_rawDescGZIP(), []int{5, 0}
}

type Connection struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	ConnectionId string           `protobuf:"bytes,1,opt,name=connection_id,json=connectionId,proto3" json:"connection_id,omitempty" class:"public" eventstream:"observation"` // @gotags: `class:"public" eventstream:"observation"`
	Status       CONNECTIONSTATUS `protobuf:"varint,2,opt,name=status,proto3,enum=controller.servers.services.v1.CONNECTIONSTATUS" json:"status,omitempty"`
	BytesUp      int64            `protobuf:"varint,3,opt,name=bytes_up,json=bytesUp,proto3" json:"bytes_up,omitempty" class:"public"`       // @gotags: `class:"public"`
	BytesDown    int64            `protobuf:"varint,4,opt,name=bytes_down,json=bytesDown,proto3" json:"bytes_down,omitempty" class:"public"` // @gotags: `class:"public"`
}

func (x *Connection) Reset() {
	*x = Connection{}
	if protoimpl.UnsafeEnabled {
		mi := &file_controller_servers_services_v1_server_coordination_service_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Connection) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Connection) ProtoMessage() {}

func (x *Connection) ProtoReflect() protoreflect.Message {
	mi := &file_controller_servers_services_v1_server_coordination_service_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Connection.ProtoReflect.Descriptor instead.
func (*Connection) Descriptor() ([]byte, []int) {
	return file_controller_servers_services_v1_server_coordination_service_proto_rawDescGZIP(), []int{0}
}

func (x *Connection) GetConnectionId() string {
	if x != nil {
		return x.ConnectionId
	}
	return ""
}

func (x *Connection) GetStatus() CONNECTIONSTATUS {
	if x != nil {
		return x.Status
	}
	return CONNECTIONSTATUS_CONNECTIONSTATUS_UNSPECIFIED
}

func (x *Connection) GetBytesUp() int64 {
	if x != nil {
		return x.BytesUp
	}
	return 0
}

func (x *Connection) GetBytesDown() int64 {
	if x != nil {
		return x.BytesDown
	}
	return 0
}

type SessionJobInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	SessionId       string                 `protobuf:"bytes,1,opt,name=session_id,json=sessionId,proto3" json:"session_id,omitempty" class:"public" eventstream:"observation"` // @gotags: `class:"public" eventstream:"observation"`
	Status          SESSIONSTATUS          `protobuf:"varint,2,opt,name=status,proto3,enum=controller.servers.services.v1.SESSIONSTATUS" json:"status,omitempty"`
	Connections     []*Connection          `protobuf:"bytes,3,rep,name=connections,proto3" json:"connections,omitempty"`
	ProcessingError SessionProcessingError `protobuf:"varint,4,opt,name=processing_error,json=processingError,proto3,enum=controller.servers.services.v1.SessionProcessingError" json:"processing_error,omitempty" class:"public"` // @gotags: `class:"public"`
}

func (x *SessionJobInfo) Reset() {
	*x = SessionJobInfo{}
	if protoimpl.UnsafeEnabled {
		mi := &file_controller_servers_services_v1_server_coordination_service_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SessionJobInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SessionJobInfo) ProtoMessage() {}

func (x *SessionJobInfo) ProtoReflect() protoreflect.Message {
	mi := &file_controller_servers_services_v1_server_coordination_service_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SessionJobInfo.ProtoReflect.Descriptor instead.
func (*SessionJobInfo) Descriptor() ([]byte, []int) {
	return file_controller_servers_services_v1_server_coordination_service_proto_rawDescGZIP(), []int{1}
}

func (x *SessionJobInfo) GetSessionId() string {
	if x != nil {
		return x.SessionId
	}
	return ""
}

func (x *SessionJobInfo) GetStatus() SESSIONSTATUS {
	if x != nil {
		return x.Status
	}
	return SESSIONSTATUS_SESSIONSTATUS_UNSPECIFIED
}

func (x *SessionJobInfo) GetConnections() []*Connection {
	if x != nil {
		return x.Connections
	}
	return nil
}

func (x *SessionJobInfo) GetProcessingError() SessionProcessingError {
	if x != nil {
		return x.ProcessingError
	}
	return SessionProcessingError_SESSION_PROCESSING_ERROR_UNSPECIFIED
}

type MonitorSessionJobInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	SessionId       string                 `protobuf:"bytes,1,opt,name=session_id,json=sessionId,proto3" json:"session_id,omitempty" class:"public" eventstream:"observation"`                                                                               // @gotags: `class:"public" eventstream:"observation"`
	Status          SESSIONSTATUS          `protobuf:"varint,2,opt,name=status,proto3,enum=controller.servers.services.v1.SESSIONSTATUS" json:"status,omitempty" class:"public"`                                                   // @gotags: `class:"public"`
	ProcessingError SessionProcessingError `protobuf:"varint,3,opt,name=processing_error,json=processingError,proto3,enum=controller.servers.services.v1.SessionProcessingError" json:"processing_error,omitempty" class:"public"` // @gotags: `class:"public"`
}

func (x *MonitorSessionJobInfo) Reset() {
	*x = MonitorSessionJobInfo{}
	if protoimpl.UnsafeEnabled {
		mi := &file_controller_servers_services_v1_server_coordination_service_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MonitorSessionJobInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MonitorSessionJobInfo) ProtoMessage() {}

func (x *MonitorSessionJobInfo) ProtoReflect() protoreflect.Message {
	mi := &file_controller_servers_services_v1_server_coordination_service_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MonitorSessionJobInfo.ProtoReflect.Descriptor instead.
func (*MonitorSessionJobInfo) Descriptor() ([]byte, []int) {
	return file_controller_servers_services_v1_server_coordination_service_proto_rawDescGZIP(), []int{2}
}

func (x *MonitorSessionJobInfo) GetSessionId() string {
	if x != nil {
		return x.SessionId
	}
	return ""
}

func (x *MonitorSessionJobInfo) GetStatus() SESSIONSTATUS {
	if x != nil {
		return x.Status
	}
	return SESSIONSTATUS_SESSIONSTATUS_UNSPECIFIED
}

func (x *MonitorSessionJobInfo) GetProcessingError() SessionProcessingError {
	if x != nil {
		return x.ProcessingError
	}
	return SessionProcessingError_SESSION_PROCESSING_ERROR_UNSPECIFIED
}

type Job struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Type JOBTYPE `protobuf:"varint,1,opt,name=type,proto3,enum=controller.servers.services.v1.JOBTYPE" json:"type,omitempty"`
	// Types that are assignable to JobInfo:
	//
	//	*Job_SessionInfo
	//	*Job_MonitorSessionInfo
	JobInfo isJob_JobInfo `protobuf_oneof:"job_info"`
}

func (x *Job) Reset() {
	*x = Job{}
	if protoimpl.UnsafeEnabled {
		mi := &file_controller_servers_services_v1_server_coordination_service_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Job) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Job) ProtoMessage() {}

func (x *Job) ProtoReflect() protoreflect.Message {
	mi := &file_controller_servers_services_v1_server_coordination_service_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Job.ProtoReflect.Descriptor instead.
func (*Job) Descriptor() ([]byte, []int) {
	return file_controller_servers_services_v1_server_coordination_service_proto_rawDescGZIP(), []int{3}
}

func (x *Job) GetType() JOBTYPE {
	if x != nil {
		return x.Type
	}
	return JOBTYPE_JOBTYPE_UNSPECIFIED
}

func (m *Job) GetJobInfo() isJob_JobInfo {
	if m != nil {
		return m.JobInfo
	}
	return nil
}

func (x *Job) GetSessionInfo() *SessionJobInfo {
	if x, ok := x.GetJobInfo().(*Job_SessionInfo); ok {
		return x.SessionInfo
	}
	return nil
}

func (x *Job) GetMonitorSessionInfo() *MonitorSessionJobInfo {
	if x, ok := x.GetJobInfo().(*Job_MonitorSessionInfo); ok {
		return x.MonitorSessionInfo
	}
	return nil
}

type isJob_JobInfo interface {
	isJob_JobInfo()
}

type Job_SessionInfo struct {
	// This value is specified when type is JOBTYPE_SESSION.
	SessionInfo *SessionJobInfo `protobuf:"bytes,2,opt,name=session_info,json=sessionInfo,proto3,oneof"`
}

type Job_MonitorSessionInfo struct {
	MonitorSessionInfo *MonitorSessionJobInfo `protobuf:"bytes,3,opt,name=monitor_session_info,json=monitorSessionInfo,proto3,oneof"`
}

func (*Job_SessionInfo) isJob_JobInfo() {}

func (*Job_MonitorSessionInfo) isJob_JobInfo() {}

type JobStatus struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Job *Job `protobuf:"bytes,1,opt,name=job,proto3" json:"job,omitempty"`
}

func (x *JobStatus) Reset() {
	*x = JobStatus{}
	if protoimpl.UnsafeEnabled {
		mi := &file_controller_servers_services_v1_server_coordination_service_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *JobStatus) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*JobStatus) ProtoMessage() {}

func (x *JobStatus) ProtoReflect() protoreflect.Message {
	mi := &file_controller_servers_services_v1_server_coordination_service_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use JobStatus.ProtoReflect.Descriptor instead.
func (*JobStatus) Descriptor() ([]byte, []int) {
	return file_controller_servers_services_v1_server_coordination_service_proto_rawDescGZIP(), []int{4}
}

func (x *JobStatus) GetJob() *Job {
	if x != nil {
		return x.Job
	}
	return nil
}

// UpstreamServer returns the controller address in the StatusResponse but may be used in the future to return
// worker address.
type UpstreamServer struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// type specifies between controller or worker.
	Type UpstreamServer_TYPE `protobuf:"varint,10,opt,name=type,proto3,enum=controller.servers.services.v1.UpstreamServer_TYPE" json:"type,omitempty"`
	// Address of the daemon
	Address string `protobuf:"bytes,20,opt,name=address,proto3" json:"address,omitempty" class:"public"` // @gotags: `class:"public"`
}

func (x *UpstreamServer) Reset() {
	*x = UpstreamServer{}
	if protoimpl.UnsafeEnabled {
		mi := &file_controller_servers_services_v1_server_coordination_service_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpstreamServer) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpstreamServer) ProtoMessage() {}

func (x *UpstreamServer) ProtoReflect() protoreflect.Message {
	mi := &file_controller_servers_services_v1_server_coordination_service_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpstreamServer.ProtoReflect.Descriptor instead.
func (*UpstreamServer) Descriptor() ([]byte, []int) {
	return file_controller_servers_services_v1_server_coordination_service_proto_rawDescGZIP(), []int{5}
}

func (x *UpstreamServer) GetType() UpstreamServer_TYPE {
	if x != nil {
		return x.Type
	}
	return UpstreamServer_TYPE_UNSPECIFIED
}

func (x *UpstreamServer) GetAddress() string {
	if x != nil {
		return x.Address
	}
	return ""
}

type StatusRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Jobs which this worker wants to report the status.
	Jobs []*JobStatus `protobuf:"bytes,20,rep,name=jobs,proto3" json:"jobs,omitempty"`
	// Whether to update tags from the Server block on this RPC. We only need to
	// do this at startup or (at some point) SIGHUP, so specifying when it's
	// changed allows us to avoid constant database operations for something that
	// won't change very often, if ever.
	UpdateTags bool `protobuf:"varint,30,opt,name=update_tags,json=updateTags,proto3" json:"update_tags,omitempty"`
	// Replaces the old worker field:
	// The worker info. We could use information from the TLS connection but this
	// is easier and going the other route doesn't provide much benefit -- if you
	// get access to the key and spoof the connection, you're already compromised.
	WorkerStatus *servers.ServerWorkerStatus `protobuf:"bytes,40,opt,name=worker_status,json=workerStatus,proto3" json:"worker_status,omitempty"`
	// The worker key identifiers presented by all downstreams connected to this
	// worker.
	// Deprecated. Should be removed in 0.15.0 at which time
	// connected_unmapped_worker_key_identifiers should be used exclusively.
	//
	// Deprecated: Marked as deprecated in controller/servers/services/v1/server_coordination_service.proto.
	ConnectedWorkerKeyIdentifiers []string `protobuf:"bytes,50,rep,name=connected_worker_key_identifiers,json=connectedWorkerKeyIdentifiers,proto3" json:"connected_worker_key_identifiers,omitempty"`
	// The worker key identifiers for downstream workers for which there
	// is not a known worker id mapping for them yet.
	ConnectedUnmappedWorkerKeyIdentifiers []string `protobuf:"bytes,51,rep,name=connected_unmapped_worker_key_identifiers,json=connectedUnmappedWorkerKeyIdentifiers,proto3" json:"connected_unmapped_worker_key_identifiers,omitempty"`
	// The worker public ids of all downstreams connected to this worker if known.
	// While there may be workers with key ids in the connected_worker_key_identifiers
	// list and their public ids in this list, once the requesting worker is aware
	// of the association, it should only populate this field.
	ConnectedWorkerPublicIds []string `protobuf:"bytes,55,rep,name=connected_worker_public_ids,json=connectedWorkerPublicIds,proto3" json:"connected_worker_public_ids,omitempty"`
}

func (x *StatusRequest) Reset() {
	*x = StatusRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_controller_servers_services_v1_server_coordination_service_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *StatusRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StatusRequest) ProtoMessage() {}

func (x *StatusRequest) ProtoReflect() protoreflect.Message {
	mi := &file_controller_servers_services_v1_server_coordination_service_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StatusRequest.ProtoReflect.Descriptor instead.
func (*StatusRequest) Descriptor() ([]byte, []int) {
	return file_controller_servers_services_v1_server_coordination_service_proto_rawDescGZIP(), []int{6}
}

func (x *StatusRequest) GetJobs() []*JobStatus {
	if x != nil {
		return x.Jobs
	}
	return nil
}

func (x *StatusRequest) GetUpdateTags() bool {
	if x != nil {
		return x.UpdateTags
	}
	return false
}

func (x *StatusRequest) GetWorkerStatus() *servers.ServerWorkerStatus {
	if x != nil {
		return x.WorkerStatus
	}
	return nil
}

// Deprecated: Marked as deprecated in controller/servers/services/v1/server_coordination_service.proto.
func (x *StatusRequest) GetConnectedWorkerKeyIdentifiers() []string {
	if x != nil {
		return x.ConnectedWorkerKeyIdentifiers
	}
	return nil
}

func (x *StatusRequest) GetConnectedUnmappedWorkerKeyIdentifiers() []string {
	if x != nil {
		return x.ConnectedUnmappedWorkerKeyIdentifiers
	}
	return nil
}

func (x *StatusRequest) GetConnectedWorkerPublicIds() []string {
	if x != nil {
		return x.ConnectedWorkerPublicIds
	}
	return nil
}

type JobChangeRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Job         *Job       `protobuf:"bytes,1,opt,name=job,proto3" json:"job,omitempty"`
	RequestType CHANGETYPE `protobuf:"varint,2,opt,name=request_type,json=requestType,proto3,enum=controller.servers.services.v1.CHANGETYPE" json:"request_type,omitempty"`
}

func (x *JobChangeRequest) Reset() {
	*x = JobChangeRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_controller_servers_services_v1_server_coordination_service_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *JobChangeRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*JobChangeRequest) ProtoMessage() {}

func (x *JobChangeRequest) ProtoReflect() protoreflect.Message {
	mi := &file_controller_servers_services_v1_server_coordination_service_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use JobChangeRequest.ProtoReflect.Descriptor instead.
func (*JobChangeRequest) Descriptor() ([]byte, []int) {
	return file_controller_servers_services_v1_server_coordination_service_proto_rawDescGZIP(), []int{7}
}

func (x *JobChangeRequest) GetJob() *Job {
	if x != nil {
		return x.Job
	}
	return nil
}

func (x *JobChangeRequest) GetRequestType() CHANGETYPE {
	if x != nil {
		return x.RequestType
	}
	return CHANGETYPE_CHANGETYPE_UNSPECIFIED
}

// Deprecated: Marked as deprecated in controller/servers/services/v1/server_coordination_service.proto.
type AuthorizedWorkerList struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// the key id of authorized workers
	//
	// Deprecated: Marked as deprecated in controller/servers/services/v1/server_coordination_service.proto.
	WorkerKeyIdentifiers []string `protobuf:"bytes,1,rep,name=worker_key_identifiers,json=workerKeyIdentifiers,proto3" json:"worker_key_identifiers,omitempty"`
}

func (x *AuthorizedWorkerList) Reset() {
	*x = AuthorizedWorkerList{}
	if protoimpl.UnsafeEnabled {
		mi := &file_controller_servers_services_v1_server_coordination_service_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AuthorizedWorkerList) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AuthorizedWorkerList) ProtoMessage() {}

func (x *AuthorizedWorkerList) ProtoReflect() protoreflect.Message {
	mi := &file_controller_servers_services_v1_server_coordination_service_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AuthorizedWorkerList.ProtoReflect.Descriptor instead.
func (*AuthorizedWorkerList) Descriptor() ([]byte, []int) {
	return file_controller_servers_services_v1_server_coordination_service_proto_rawDescGZIP(), []int{8}
}

// Deprecated: Marked as deprecated in controller/servers/services/v1/server_coordination_service.proto.
func (x *AuthorizedWorkerList) GetWorkerKeyIdentifiers() []string {
	if x != nil {
		return x.WorkerKeyIdentifiers
	}
	return nil
}

type AuthorizedDownstreamWorkerList struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// the key id of authorized workers which do not have a worker id known yet
	// to the requester.
	UnmappedWorkerKeyIdentifiers []string `protobuf:"bytes,1,rep,name=unmapped_worker_key_identifiers,json=unmappedWorkerKeyIdentifiers,proto3" json:"unmapped_worker_key_identifiers,omitempty"`
	// the public id of workers that were reported as being connected and which
	// are known by the controller.
	WorkerPublicIds []string `protobuf:"bytes,2,rep,name=worker_public_ids,json=workerPublicIds,proto3" json:"worker_public_ids,omitempty"`
}

func (x *AuthorizedDownstreamWorkerList) Reset() {
	*x = AuthorizedDownstreamWorkerList{}
	if protoimpl.UnsafeEnabled {
		mi := &file_controller_servers_services_v1_server_coordination_service_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AuthorizedDownstreamWorkerList) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AuthorizedDownstreamWorkerList) ProtoMessage() {}

func (x *AuthorizedDownstreamWorkerList) ProtoReflect() protoreflect.Message {
	mi := &file_controller_servers_services_v1_server_coordination_service_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AuthorizedDownstreamWorkerList.ProtoReflect.Descriptor instead.
func (*AuthorizedDownstreamWorkerList) Descriptor() ([]byte, []int) {
	return file_controller_servers_services_v1_server_coordination_service_proto_rawDescGZIP(), []int{9}
}

func (x *AuthorizedDownstreamWorkerList) GetUnmappedWorkerKeyIdentifiers() []string {
	if x != nil {
		return x.UnmappedWorkerKeyIdentifiers
	}
	return nil
}

func (x *AuthorizedDownstreamWorkerList) GetWorkerPublicIds() []string {
	if x != nil {
		return x.WorkerPublicIds
	}
	return nil
}

type StatusResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// List of jobs and the expected state changes.  For example, this will
	// include jobs witch change type of canceled for jobs which are active on a
	// worker but should be canceled. This could also contain a request to start a
	// job such as a worker -> worker proxy for establishing a session through an
	// enclave.
	JobsRequests []*JobChangeRequest `protobuf:"bytes,20,rep,name=jobs_requests,json=jobsRequests,proto3" json:"jobs_requests,omitempty"`
	// UpstreamServer currently returns the controller address in the StatusResponse.
	CalculatedUpstreams []*UpstreamServer `protobuf:"bytes,30,rep,name=calculated_upstreams,json=calculatedUpstreams,proto3" json:"calculated_upstreams,omitempty"`
	// The ID of the worker which made the request. The worker can send this value in subsequent requests so the
	// controller does not need to do a database lookup for the id using the name field.
	WorkerId string `protobuf:"bytes,40,opt,name=worker_id,json=workerId,proto3" json:"worker_id,omitempty" class:"public" eventstream:"observation"` // @gotags: `class:"public" eventstream:"observation"`
	// Of the worker key identifiers provided in the request, these are the ones
	// which are authorized to remain connected.
	// This is deprecated.  Use authorized_downstream_workers instead. This
	// should be removed in version 0.15.0.
	//
	// Deprecated: Marked as deprecated in controller/servers/services/v1/server_coordination_service.proto.
	AuthorizedWorkers *AuthorizedWorkerList `protobuf:"bytes,50,opt,name=authorized_workers,json=authorizedWorkers,proto3" json:"authorized_workers,omitempty"`
	// Of the downstream workers in the request, these are the ones
	// which are authorized to remain connected.
	AuthorizedDownstreamWorkers *AuthorizedDownstreamWorkerList `protobuf:"bytes,51,opt,name=authorized_downstream_workers,json=authorizedDownstreamWorkers,proto3" json:"authorized_downstream_workers,omitempty"`
}

func (x *StatusResponse) Reset() {
	*x = StatusResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_controller_servers_services_v1_server_coordination_service_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *StatusResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StatusResponse) ProtoMessage() {}

func (x *StatusResponse) ProtoReflect() protoreflect.Message {
	mi := &file_controller_servers_services_v1_server_coordination_service_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StatusResponse.ProtoReflect.Descriptor instead.
func (*StatusResponse) Descriptor() ([]byte, []int) {
	return file_controller_servers_services_v1_server_coordination_service_proto_rawDescGZIP(), []int{10}
}

func (x *StatusResponse) GetJobsRequests() []*JobChangeRequest {
	if x != nil {
		return x.JobsRequests
	}
	return nil
}

func (x *StatusResponse) GetCalculatedUpstreams() []*UpstreamServer {
	if x != nil {
		return x.CalculatedUpstreams
	}
	return nil
}

func (x *StatusResponse) GetWorkerId() string {
	if x != nil {
		return x.WorkerId
	}
	return ""
}

// Deprecated: Marked as deprecated in controller/servers/services/v1/server_coordination_service.proto.
func (x *StatusResponse) GetAuthorizedWorkers() *AuthorizedWorkerList {
	if x != nil {
		return x.AuthorizedWorkers
	}
	return nil
}

func (x *StatusResponse) GetAuthorizedDownstreamWorkers() *AuthorizedDownstreamWorkerList {
	if x != nil {
		return x.AuthorizedDownstreamWorkers
	}
	return nil
}

// WorkerInfo contains information about workers for the HcpbWorkerResponse message
type WorkerInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The id of the worker
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// The public address of the worker
	Address string `protobuf:"bytes,2,opt,name=address,proto3" json:"address,omitempty"`
}

func (x *WorkerInfo) Reset() {
	*x = WorkerInfo{}
	if protoimpl.UnsafeEnabled {
		mi := &file_controller_servers_services_v1_server_coordination_service_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *WorkerInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*WorkerInfo) ProtoMessage() {}

func (x *WorkerInfo) ProtoReflect() protoreflect.Message {
	mi := &file_controller_servers_services_v1_server_coordination_service_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use WorkerInfo.ProtoReflect.Descriptor instead.
func (*WorkerInfo) Descriptor() ([]byte, []int) {
	return file_controller_servers_services_v1_server_coordination_service_proto_rawDescGZIP(), []int{11}
}

func (x *WorkerInfo) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

func (x *WorkerInfo) GetAddress() string {
	if x != nil {
		return x.Address
	}
	return ""
}

// A HCP Boundary workers request. Empty for now.
type ListHcpbWorkersRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *ListHcpbWorkersRequest) Reset() {
	*x = ListHcpbWorkersRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_controller_servers_services_v1_server_coordination_service_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListHcpbWorkersRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListHcpbWorkersRequest) ProtoMessage() {}

func (x *ListHcpbWorkersRequest) ProtoReflect() protoreflect.Message {
	mi := &file_controller_servers_services_v1_server_coordination_service_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListHcpbWorkersRequest.ProtoReflect.Descriptor instead.
func (*ListHcpbWorkersRequest) Descriptor() ([]byte, []int) {
	return file_controller_servers_services_v1_server_coordination_service_proto_rawDescGZIP(), []int{12}
}

// A response containing worker information
type ListHcpbWorkersResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Workers []*WorkerInfo `protobuf:"bytes,1,rep,name=workers,proto3" json:"workers,omitempty"`
}

func (x *ListHcpbWorkersResponse) Reset() {
	*x = ListHcpbWorkersResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_controller_servers_services_v1_server_coordination_service_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListHcpbWorkersResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListHcpbWorkersResponse) ProtoMessage() {}

func (x *ListHcpbWorkersResponse) ProtoReflect() protoreflect.Message {
	mi := &file_controller_servers_services_v1_server_coordination_service_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListHcpbWorkersResponse.ProtoReflect.Descriptor instead.
func (*ListHcpbWorkersResponse) Descriptor() ([]byte, []int) {
	return file_controller_servers_services_v1_server_coordination_service_proto_rawDescGZIP(), []int{13}
}

func (x *ListHcpbWorkersResponse) GetWorkers() []*WorkerInfo {
	if x != nil {
		return x.Workers
	}
	return nil
}

var File_controller_servers_services_v1_server_coordination_service_proto protoreflect.FileDescriptor

var file_controller_servers_services_v1_server_coordination_service_proto_rawDesc = []byte{
	0x0a, 0x40, 0x63, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x6c, 0x65, 0x72, 0x2f, 0x73, 0x65, 0x72,
	0x76, 0x65, 0x72, 0x73, 0x2f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2f, 0x76, 0x31,
	0x2f, 0x73, 0x65, 0x72, 0x76, 0x65, 0x72, 0x5f, 0x63, 0x6f, 0x6f, 0x72, 0x64, 0x69, 0x6e, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x12, 0x1e, 0x63, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x6c, 0x65, 0x72, 0x2e, 0x73,
	0x65, 0x72, 0x76, 0x65, 0x72, 0x73, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2e,
	0x76, 0x31, 0x1a, 0x23, 0x63, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x6c, 0x65, 0x72, 0x2f, 0x73,
	0x65, 0x72, 0x76, 0x65, 0x72, 0x73, 0x2f, 0x76, 0x31, 0x2f, 0x73, 0x65, 0x72, 0x76, 0x65, 0x72,
	0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xb5, 0x01, 0x0a, 0x0a, 0x43, 0x6f, 0x6e, 0x6e,
	0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x23, 0x0a, 0x0d, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x63,
	0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x12, 0x48, 0x0a, 0x06, 0x73,
	0x74, 0x61, 0x74, 0x75, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x30, 0x2e, 0x63, 0x6f,
	0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x6c, 0x65, 0x72, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x65, 0x72, 0x73,
	0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x4f, 0x4e,
	0x4e, 0x45, 0x43, 0x54, 0x49, 0x4f, 0x4e, 0x53, 0x54, 0x41, 0x54, 0x55, 0x53, 0x52, 0x06, 0x73,
	0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x19, 0x0a, 0x08, 0x62, 0x79, 0x74, 0x65, 0x73, 0x5f, 0x75,
	0x70, 0x18, 0x03, 0x20, 0x01, 0x28, 0x03, 0x52, 0x07, 0x62, 0x79, 0x74, 0x65, 0x73, 0x55, 0x70,
	0x12, 0x1d, 0x0a, 0x0a, 0x62, 0x79, 0x74, 0x65, 0x73, 0x5f, 0x64, 0x6f, 0x77, 0x6e, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x03, 0x52, 0x09, 0x62, 0x79, 0x74, 0x65, 0x73, 0x44, 0x6f, 0x77, 0x6e, 0x22,
	0xa7, 0x02, 0x0a, 0x0e, 0x53, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x4a, 0x6f, 0x62, 0x49, 0x6e,
	0x66, 0x6f, 0x12, 0x1d, 0x0a, 0x0a, 0x73, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x73, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x49,
	0x64, 0x12, 0x45, 0x0a, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0e, 0x32, 0x2d, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x6c, 0x65, 0x72, 0x2e, 0x73,
	0x65, 0x72, 0x76, 0x65, 0x72, 0x73, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2e,
	0x76, 0x31, 0x2e, 0x53, 0x45, 0x53, 0x53, 0x49, 0x4f, 0x4e, 0x53, 0x54, 0x41, 0x54, 0x55, 0x53,
	0x52, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x4c, 0x0a, 0x0b, 0x63, 0x6f, 0x6e, 0x6e,
	0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2a, 0x2e,
	0x63, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x6c, 0x65, 0x72, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x65,
	0x72, 0x73, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x43,
	0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0b, 0x63, 0x6f, 0x6e, 0x6e, 0x65,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x61, 0x0a, 0x10, 0x70, 0x72, 0x6f, 0x63, 0x65, 0x73,
	0x73, 0x69, 0x6e, 0x67, 0x5f, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0e,
	0x32, 0x36, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x6c, 0x65, 0x72, 0x2e, 0x73, 0x65,
	0x72, 0x76, 0x65, 0x72, 0x73, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2e, 0x76,
	0x31, 0x2e, 0x53, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73,
	0x69, 0x6e, 0x67, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x52, 0x0f, 0x70, 0x72, 0x6f, 0x63, 0x65, 0x73,
	0x73, 0x69, 0x6e, 0x67, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x22, 0xe0, 0x01, 0x0a, 0x15, 0x4d, 0x6f,
	0x6e, 0x69, 0x74, 0x6f, 0x72, 0x53, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x4a, 0x6f, 0x62, 0x49,
	0x6e, 0x66, 0x6f, 0x12, 0x1d, 0x0a, 0x0a, 0x73, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x69,
	0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x73, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e,
	0x49, 0x64, 0x12, 0x45, 0x0a, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0e, 0x32, 0x2d, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x6c, 0x65, 0x72, 0x2e,
	0x73, 0x65, 0x72, 0x76, 0x65, 0x72, 0x73, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73,
	0x2e, 0x76, 0x31, 0x2e, 0x53, 0x45, 0x53, 0x53, 0x49, 0x4f, 0x4e, 0x53, 0x54, 0x41, 0x54, 0x55,
	0x53, 0x52, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x61, 0x0a, 0x10, 0x70, 0x72, 0x6f,
	0x63, 0x65, 0x73, 0x73, 0x69, 0x6e, 0x67, 0x5f, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x0e, 0x32, 0x36, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x6c, 0x65, 0x72,
	0x2e, 0x73, 0x65, 0x72, 0x76, 0x65, 0x72, 0x73, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65,
	0x73, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x50, 0x72, 0x6f, 0x63,
	0x65, 0x73, 0x73, 0x69, 0x6e, 0x67, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x52, 0x0f, 0x70, 0x72, 0x6f,
	0x63, 0x65, 0x73, 0x73, 0x69, 0x6e, 0x67, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x22, 0x8e, 0x02, 0x0a,
	0x03, 0x4a, 0x6f, 0x62, 0x12, 0x3b, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0e, 0x32, 0x27, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x6c, 0x65, 0x72, 0x2e,
	0x73, 0x65, 0x72, 0x76, 0x65, 0x72, 0x73, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73,
	0x2e, 0x76, 0x31, 0x2e, 0x4a, 0x4f, 0x42, 0x54, 0x59, 0x50, 0x45, 0x52, 0x04, 0x74, 0x79, 0x70,
	0x65, 0x12, 0x53, 0x0a, 0x0c, 0x73, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x6e, 0x66,
	0x6f, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x72, 0x6f,
	0x6c, 0x6c, 0x65, 0x72, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x65, 0x72, 0x73, 0x2e, 0x73, 0x65, 0x72,
	0x76, 0x69, 0x63, 0x65, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e,
	0x4a, 0x6f, 0x62, 0x49, 0x6e, 0x66, 0x6f, 0x48, 0x00, 0x52, 0x0b, 0x73, 0x65, 0x73, 0x73, 0x69,
	0x6f, 0x6e, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x69, 0x0a, 0x14, 0x6d, 0x6f, 0x6e, 0x69, 0x74, 0x6f,
	0x72, 0x5f, 0x73, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x6e, 0x66, 0x6f, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x35, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x6c, 0x65,
	0x72, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x65, 0x72, 0x73, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63,
	0x65, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72, 0x53, 0x65, 0x73,
	0x73, 0x69, 0x6f, 0x6e, 0x4a, 0x6f, 0x62, 0x49, 0x6e, 0x66, 0x6f, 0x48, 0x00, 0x52, 0x12, 0x6d,
	0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72, 0x53, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x49, 0x6e, 0x66,
	0x6f, 0x42, 0x0a, 0x0a, 0x08, 0x6a, 0x6f, 0x62, 0x5f, 0x69, 0x6e, 0x66, 0x6f, 0x22, 0x42, 0x0a,
	0x09, 0x4a, 0x6f, 0x62, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x35, 0x0a, 0x03, 0x6a, 0x6f,
	0x62, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x23, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x72, 0x6f,
	0x6c, 0x6c, 0x65, 0x72, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x65, 0x72, 0x73, 0x2e, 0x73, 0x65, 0x72,
	0x76, 0x69, 0x63, 0x65, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x4a, 0x6f, 0x62, 0x52, 0x03, 0x6a, 0x6f,
	0x62, 0x22, 0xb7, 0x01, 0x0a, 0x0e, 0x55, 0x70, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x53, 0x65,
	0x72, 0x76, 0x65, 0x72, 0x12, 0x47, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x0a, 0x20, 0x01,
	0x28, 0x0e, 0x32, 0x33, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x6c, 0x65, 0x72, 0x2e,
	0x73, 0x65, 0x72, 0x76, 0x65, 0x72, 0x73, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73,
	0x2e, 0x76, 0x31, 0x2e, 0x55, 0x70, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x53, 0x65, 0x72, 0x76,
	0x65, 0x72, 0x2e, 0x54, 0x59, 0x50, 0x45, 0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x12, 0x18, 0x0a,
	0x07, 0x61, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x18, 0x14, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07,
	0x61, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x22, 0x42, 0x0a, 0x04, 0x54, 0x59, 0x50, 0x45, 0x12,
	0x14, 0x0a, 0x10, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46,
	0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x13, 0x0a, 0x0f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x43, 0x4f,
	0x4e, 0x54, 0x52, 0x4f, 0x4c, 0x4c, 0x45, 0x52, 0x10, 0x01, 0x12, 0x0f, 0x0a, 0x0b, 0x54, 0x59,
	0x50, 0x45, 0x5f, 0x57, 0x4f, 0x52, 0x4b, 0x45, 0x52, 0x10, 0x02, 0x22, 0xb3, 0x03, 0x0a, 0x0d,
	0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3d, 0x0a,
	0x04, 0x6a, 0x6f, 0x62, 0x73, 0x18, 0x14, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x63, 0x6f,
	0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x6c, 0x65, 0x72, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x65, 0x72, 0x73,
	0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x4a, 0x6f, 0x62,
	0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x04, 0x6a, 0x6f, 0x62, 0x73, 0x12, 0x1f, 0x0a, 0x0b,
	0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x61, 0x67, 0x73, 0x18, 0x1e, 0x20, 0x01, 0x28,
	0x08, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x61, 0x67, 0x73, 0x12, 0x4e, 0x0a,
	0x0d, 0x77, 0x6f, 0x72, 0x6b, 0x65, 0x72, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x18, 0x28,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x6c, 0x65,
	0x72, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x65, 0x72, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x65, 0x72,
	0x76, 0x65, 0x72, 0x57, 0x6f, 0x72, 0x6b, 0x65, 0x72, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52,
	0x0c, 0x77, 0x6f, 0x72, 0x6b, 0x65, 0x72, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x4b, 0x0a,
	0x20, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x65, 0x64, 0x5f, 0x77, 0x6f, 0x72, 0x6b, 0x65,
	0x72, 0x5f, 0x6b, 0x65, 0x79, 0x5f, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x69, 0x65, 0x72,
	0x73, 0x18, 0x32, 0x20, 0x03, 0x28, 0x09, 0x42, 0x02, 0x18, 0x01, 0x52, 0x1d, 0x63, 0x6f, 0x6e,
	0x6e, 0x65, 0x63, 0x74, 0x65, 0x64, 0x57, 0x6f, 0x72, 0x6b, 0x65, 0x72, 0x4b, 0x65, 0x79, 0x49,
	0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x69, 0x65, 0x72, 0x73, 0x12, 0x58, 0x0a, 0x29, 0x63, 0x6f,
	0x6e, 0x6e, 0x65, 0x63, 0x74, 0x65, 0x64, 0x5f, 0x75, 0x6e, 0x6d, 0x61, 0x70, 0x70, 0x65, 0x64,
	0x5f, 0x77, 0x6f, 0x72, 0x6b, 0x65, 0x72, 0x5f, 0x6b, 0x65, 0x79, 0x5f, 0x69, 0x64, 0x65, 0x6e,
	0x74, 0x69, 0x66, 0x69, 0x65, 0x72, 0x73, 0x18, 0x33, 0x20, 0x03, 0x28, 0x09, 0x52, 0x25, 0x63,
	0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x65, 0x64, 0x55, 0x6e, 0x6d, 0x61, 0x70, 0x70, 0x65, 0x64,
	0x57, 0x6f, 0x72, 0x6b, 0x65, 0x72, 0x4b, 0x65, 0x79, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66,
	0x69, 0x65, 0x72, 0x73, 0x12, 0x3d, 0x0a, 0x1b, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x65,
	0x64, 0x5f, 0x77, 0x6f, 0x72, 0x6b, 0x65, 0x72, 0x5f, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x63, 0x5f,
	0x69, 0x64, 0x73, 0x18, 0x37, 0x20, 0x03, 0x28, 0x09, 0x52, 0x18, 0x63, 0x6f, 0x6e, 0x6e, 0x65,
	0x63, 0x74, 0x65, 0x64, 0x57, 0x6f, 0x72, 0x6b, 0x65, 0x72, 0x50, 0x75, 0x62, 0x6c, 0x69, 0x63,
	0x49, 0x64, 0x73, 0x4a, 0x04, 0x08, 0x0a, 0x10, 0x0b, 0x52, 0x06, 0x77, 0x6f, 0x72, 0x6b, 0x65,
	0x72, 0x22, 0x98, 0x01, 0x0a, 0x10, 0x4a, 0x6f, 0x62, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x35, 0x0a, 0x03, 0x6a, 0x6f, 0x62, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x23, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x6c, 0x65, 0x72,
	0x2e, 0x73, 0x65, 0x72, 0x76, 0x65, 0x72, 0x73, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65,
	0x73, 0x2e, 0x76, 0x31, 0x2e, 0x4a, 0x6f, 0x62, 0x52, 0x03, 0x6a, 0x6f, 0x62, 0x12, 0x4d, 0x0a,
	0x0c, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0e, 0x32, 0x2a, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x6c, 0x65, 0x72,
	0x2e, 0x73, 0x65, 0x72, 0x76, 0x65, 0x72, 0x73, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65,
	0x73, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x48, 0x41, 0x4e, 0x47, 0x45, 0x54, 0x59, 0x50, 0x45, 0x52,
	0x0b, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x54, 0x79, 0x70, 0x65, 0x22, 0x54, 0x0a, 0x14,
	0x41, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x65, 0x64, 0x57, 0x6f, 0x72, 0x6b, 0x65, 0x72,
	0x4c, 0x69, 0x73, 0x74, 0x12, 0x38, 0x0a, 0x16, 0x77, 0x6f, 0x72, 0x6b, 0x65, 0x72, 0x5f, 0x6b,
	0x65, 0x79, 0x5f, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x69, 0x65, 0x72, 0x73, 0x18, 0x01,
	0x20, 0x03, 0x28, 0x09, 0x42, 0x02, 0x18, 0x01, 0x52, 0x14, 0x77, 0x6f, 0x72, 0x6b, 0x65, 0x72,
	0x4b, 0x65, 0x79, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x69, 0x65, 0x72, 0x73, 0x3a, 0x02,
	0x18, 0x01, 0x22, 0x93, 0x01, 0x0a, 0x1e, 0x41, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x65,
	0x64, 0x44, 0x6f, 0x77, 0x6e, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x57, 0x6f, 0x72, 0x6b, 0x65,
	0x72, 0x4c, 0x69, 0x73, 0x74, 0x12, 0x45, 0x0a, 0x1f, 0x75, 0x6e, 0x6d, 0x61, 0x70, 0x70, 0x65,
	0x64, 0x5f, 0x77, 0x6f, 0x72, 0x6b, 0x65, 0x72, 0x5f, 0x6b, 0x65, 0x79, 0x5f, 0x69, 0x64, 0x65,
	0x6e, 0x74, 0x69, 0x66, 0x69, 0x65, 0x72, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x09, 0x52, 0x1c,
	0x75, 0x6e, 0x6d, 0x61, 0x70, 0x70, 0x65, 0x64, 0x57, 0x6f, 0x72, 0x6b, 0x65, 0x72, 0x4b, 0x65,
	0x79, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x69, 0x65, 0x72, 0x73, 0x12, 0x2a, 0x0a, 0x11,
	0x77, 0x6f, 0x72, 0x6b, 0x65, 0x72, 0x5f, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x63, 0x5f, 0x69, 0x64,
	0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0f, 0x77, 0x6f, 0x72, 0x6b, 0x65, 0x72, 0x50,
	0x75, 0x62, 0x6c, 0x69, 0x63, 0x49, 0x64, 0x73, 0x22, 0xe8, 0x03, 0x0a, 0x0e, 0x53, 0x74, 0x61,
	0x74, 0x75, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x55, 0x0a, 0x0d, 0x6a,
	0x6f, 0x62, 0x73, 0x5f, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x73, 0x18, 0x14, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x30, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x6c, 0x65, 0x72, 0x2e,
	0x73, 0x65, 0x72, 0x76, 0x65, 0x72, 0x73, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73,
	0x2e, 0x76, 0x31, 0x2e, 0x4a, 0x6f, 0x62, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x52, 0x0c, 0x6a, 0x6f, 0x62, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x73, 0x12, 0x61, 0x0a, 0x14, 0x63, 0x61, 0x6c, 0x63, 0x75, 0x6c, 0x61, 0x74, 0x65, 0x64,
	0x5f, 0x75, 0x70, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x73, 0x18, 0x1e, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x2e, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x6c, 0x65, 0x72, 0x2e, 0x73, 0x65,
	0x72, 0x76, 0x65, 0x72, 0x73, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2e, 0x76,
	0x31, 0x2e, 0x55, 0x70, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72,
	0x52, 0x13, 0x63, 0x61, 0x6c, 0x63, 0x75, 0x6c, 0x61, 0x74, 0x65, 0x64, 0x55, 0x70, 0x73, 0x74,
	0x72, 0x65, 0x61, 0x6d, 0x73, 0x12, 0x1b, 0x0a, 0x09, 0x77, 0x6f, 0x72, 0x6b, 0x65, 0x72, 0x5f,
	0x69, 0x64, 0x18, 0x28, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x77, 0x6f, 0x72, 0x6b, 0x65, 0x72,
	0x49, 0x64, 0x12, 0x67, 0x0a, 0x12, 0x61, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x65, 0x64,
	0x5f, 0x77, 0x6f, 0x72, 0x6b, 0x65, 0x72, 0x73, 0x18, 0x32, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x34,
	0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x6c, 0x65, 0x72, 0x2e, 0x73, 0x65, 0x72, 0x76,
	0x65, 0x72, 0x73, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2e, 0x76, 0x31, 0x2e,
	0x41, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x65, 0x64, 0x57, 0x6f, 0x72, 0x6b, 0x65, 0x72,
	0x4c, 0x69, 0x73, 0x74, 0x42, 0x02, 0x18, 0x01, 0x52, 0x11, 0x61, 0x75, 0x74, 0x68, 0x6f, 0x72,
	0x69, 0x7a, 0x65, 0x64, 0x57, 0x6f, 0x72, 0x6b, 0x65, 0x72, 0x73, 0x12, 0x82, 0x01, 0x0a, 0x1d,
	0x61, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x65, 0x64, 0x5f, 0x64, 0x6f, 0x77, 0x6e, 0x73,
	0x74, 0x72, 0x65, 0x61, 0x6d, 0x5f, 0x77, 0x6f, 0x72, 0x6b, 0x65, 0x72, 0x73, 0x18, 0x33, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x3e, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x6c, 0x65, 0x72,
	0x2e, 0x73, 0x65, 0x72, 0x76, 0x65, 0x72, 0x73, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65,
	0x73, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x65, 0x64, 0x44,
	0x6f, 0x77, 0x6e, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x57, 0x6f, 0x72, 0x6b, 0x65, 0x72, 0x4c,
	0x69, 0x73, 0x74, 0x52, 0x1b, 0x61, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x65, 0x64, 0x44,
	0x6f, 0x77, 0x6e, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x57, 0x6f, 0x72, 0x6b, 0x65, 0x72, 0x73,
	0x4a, 0x04, 0x08, 0x0a, 0x10, 0x0b, 0x52, 0x0b, 0x63, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x6c,
	0x65, 0x72, 0x73, 0x22, 0x36, 0x0a, 0x0a, 0x57, 0x6f, 0x72, 0x6b, 0x65, 0x72, 0x49, 0x6e, 0x66,
	0x6f, 0x12, 0x0e, 0x0a, 0x02, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x02, 0x69,
	0x64, 0x12, 0x18, 0x0a, 0x07, 0x61, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x07, 0x61, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x22, 0x18, 0x0a, 0x16, 0x4c,
	0x69, 0x73, 0x74, 0x48, 0x63, 0x70, 0x62, 0x57, 0x6f, 0x72, 0x6b, 0x65, 0x72, 0x73, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x22, 0x5f, 0x0a, 0x17, 0x4c, 0x69, 0x73, 0x74, 0x48, 0x63, 0x70,
	0x62, 0x57, 0x6f, 0x72, 0x6b, 0x65, 0x72, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x12, 0x44, 0x0a, 0x07, 0x77, 0x6f, 0x72, 0x6b, 0x65, 0x72, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x2a, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x6c, 0x65, 0x72, 0x2e, 0x73,
	0x65, 0x72, 0x76, 0x65, 0x72, 0x73, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2e,
	0x76, 0x31, 0x2e, 0x57, 0x6f, 0x72, 0x6b, 0x65, 0x72, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x07, 0x77,
	0x6f, 0x72, 0x6b, 0x65, 0x72, 0x73, 0x2a, 0x92, 0x01, 0x0a, 0x10, 0x43, 0x4f, 0x4e, 0x4e, 0x45,
	0x43, 0x54, 0x49, 0x4f, 0x4e, 0x53, 0x54, 0x41, 0x54, 0x55, 0x53, 0x12, 0x20, 0x0a, 0x1c, 0x43,
	0x4f, 0x4e, 0x4e, 0x45, 0x43, 0x54, 0x49, 0x4f, 0x4e, 0x53, 0x54, 0x41, 0x54, 0x55, 0x53, 0x5f,
	0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x1f, 0x0a,
	0x1b, 0x43, 0x4f, 0x4e, 0x4e, 0x45, 0x43, 0x54, 0x49, 0x4f, 0x4e, 0x53, 0x54, 0x41, 0x54, 0x55,
	0x53, 0x5f, 0x41, 0x55, 0x54, 0x48, 0x4f, 0x52, 0x49, 0x5a, 0x45, 0x44, 0x10, 0x01, 0x12, 0x1e,
	0x0a, 0x1a, 0x43, 0x4f, 0x4e, 0x4e, 0x45, 0x43, 0x54, 0x49, 0x4f, 0x4e, 0x53, 0x54, 0x41, 0x54,
	0x55, 0x53, 0x5f, 0x43, 0x4f, 0x4e, 0x4e, 0x45, 0x43, 0x54, 0x45, 0x44, 0x10, 0x02, 0x12, 0x1b,
	0x0a, 0x17, 0x43, 0x4f, 0x4e, 0x4e, 0x45, 0x43, 0x54, 0x49, 0x4f, 0x4e, 0x53, 0x54, 0x41, 0x54,
	0x55, 0x53, 0x5f, 0x43, 0x4c, 0x4f, 0x53, 0x45, 0x44, 0x10, 0x03, 0x2a, 0x9e, 0x01, 0x0a, 0x0d,
	0x53, 0x45, 0x53, 0x53, 0x49, 0x4f, 0x4e, 0x53, 0x54, 0x41, 0x54, 0x55, 0x53, 0x12, 0x1d, 0x0a,
	0x19, 0x53, 0x45, 0x53, 0x53, 0x49, 0x4f, 0x4e, 0x53, 0x54, 0x41, 0x54, 0x55, 0x53, 0x5f, 0x55,
	0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x19, 0x0a, 0x15,
	0x53, 0x45, 0x53, 0x53, 0x49, 0x4f, 0x4e, 0x53, 0x54, 0x41, 0x54, 0x55, 0x53, 0x5f, 0x50, 0x45,
	0x4e, 0x44, 0x49, 0x4e, 0x47, 0x10, 0x01, 0x12, 0x18, 0x0a, 0x14, 0x53, 0x45, 0x53, 0x53, 0x49,
	0x4f, 0x4e, 0x53, 0x54, 0x41, 0x54, 0x55, 0x53, 0x5f, 0x41, 0x43, 0x54, 0x49, 0x56, 0x45, 0x10,
	0x02, 0x12, 0x1b, 0x0a, 0x17, 0x53, 0x45, 0x53, 0x53, 0x49, 0x4f, 0x4e, 0x53, 0x54, 0x41, 0x54,
	0x55, 0x53, 0x5f, 0x43, 0x41, 0x4e, 0x43, 0x45, 0x4c, 0x49, 0x4e, 0x47, 0x10, 0x03, 0x12, 0x1c,
	0x0a, 0x18, 0x53, 0x45, 0x53, 0x53, 0x49, 0x4f, 0x4e, 0x53, 0x54, 0x41, 0x54, 0x55, 0x53, 0x5f,
	0x54, 0x45, 0x52, 0x4d, 0x49, 0x4e, 0x41, 0x54, 0x45, 0x44, 0x10, 0x04, 0x2a, 0x6d, 0x0a, 0x16,
	0x53, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x69, 0x6e,
	0x67, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x12, 0x28, 0x0a, 0x24, 0x53, 0x45, 0x53, 0x53, 0x49, 0x4f,
	0x4e, 0x5f, 0x50, 0x52, 0x4f, 0x43, 0x45, 0x53, 0x53, 0x49, 0x4e, 0x47, 0x5f, 0x45, 0x52, 0x52,
	0x4f, 0x52, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00,
	0x12, 0x29, 0x0a, 0x25, 0x53, 0x45, 0x53, 0x53, 0x49, 0x4f, 0x4e, 0x5f, 0x50, 0x52, 0x4f, 0x43,
	0x45, 0x53, 0x53, 0x49, 0x4e, 0x47, 0x5f, 0x45, 0x52, 0x52, 0x4f, 0x52, 0x5f, 0x55, 0x4e, 0x52,
	0x45, 0x43, 0x4f, 0x47, 0x4e, 0x49, 0x5a, 0x45, 0x44, 0x10, 0x01, 0x2a, 0x54, 0x0a, 0x07, 0x4a,
	0x4f, 0x42, 0x54, 0x59, 0x50, 0x45, 0x12, 0x17, 0x0a, 0x13, 0x4a, 0x4f, 0x42, 0x54, 0x59, 0x50,
	0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12,
	0x13, 0x0a, 0x0f, 0x4a, 0x4f, 0x42, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x53, 0x45, 0x53, 0x53, 0x49,
	0x4f, 0x4e, 0x10, 0x01, 0x12, 0x1b, 0x0a, 0x17, 0x4a, 0x4f, 0x42, 0x54, 0x59, 0x50, 0x45, 0x5f,
	0x4d, 0x4f, 0x4e, 0x49, 0x54, 0x4f, 0x52, 0x5f, 0x53, 0x45, 0x53, 0x53, 0x49, 0x4f, 0x4e, 0x10,
	0x02, 0x2a, 0x45, 0x0a, 0x0a, 0x43, 0x48, 0x41, 0x4e, 0x47, 0x45, 0x54, 0x59, 0x50, 0x45, 0x12,
	0x1a, 0x0a, 0x16, 0x43, 0x48, 0x41, 0x4e, 0x47, 0x45, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e,
	0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x1b, 0x0a, 0x17, 0x43,
	0x48, 0x41, 0x4e, 0x47, 0x45, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x50, 0x44, 0x41, 0x54, 0x45,
	0x5f, 0x53, 0x54, 0x41, 0x54, 0x45, 0x10, 0x01, 0x32, 0x8d, 0x02, 0x0a, 0x19, 0x53, 0x65, 0x72,
	0x76, 0x65, 0x72, 0x43, 0x6f, 0x6f, 0x72, 0x64, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53,
	0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x12, 0x69, 0x0a, 0x06, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73,
	0x12, 0x2d, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x6c, 0x65, 0x72, 0x2e, 0x73, 0x65,
	0x72, 0x76, 0x65, 0x72, 0x73, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2e, 0x76,
	0x31, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x2e, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x6c, 0x65, 0x72, 0x2e, 0x73, 0x65, 0x72,
	0x76, 0x65, 0x72, 0x73, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2e, 0x76, 0x31,
	0x2e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22,
	0x00, 0x12, 0x84, 0x01, 0x0a, 0x0f, 0x4c, 0x69, 0x73, 0x74, 0x48, 0x63, 0x70, 0x62, 0x57, 0x6f,
	0x72, 0x6b, 0x65, 0x72, 0x73, 0x12, 0x36, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x6c,
	0x65, 0x72, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x65, 0x72, 0x73, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69,
	0x63, 0x65, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x48, 0x63, 0x70, 0x62, 0x57,
	0x6f, 0x72, 0x6b, 0x65, 0x72, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x37, 0x2e,
	0x63, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x6c, 0x65, 0x72, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x65,
	0x72, 0x73, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x4c,
	0x69, 0x73, 0x74, 0x48, 0x63, 0x70, 0x62, 0x57, 0x6f, 0x72, 0x6b, 0x65, 0x72, 0x73, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x00, 0x42, 0x51, 0x5a, 0x4f, 0x67, 0x69, 0x74, 0x68,
	0x75, 0x62, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x68, 0x61, 0x73, 0x68, 0x69, 0x63, 0x6f, 0x72, 0x70,
	0x2f, 0x62, 0x6f, 0x75, 0x6e, 0x64, 0x61, 0x72, 0x79, 0x2f, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x6e,
	0x61, 0x6c, 0x2f, 0x67, 0x65, 0x6e, 0x2f, 0x63, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x6c, 0x65,
	0x72, 0x2f, 0x73, 0x65, 0x72, 0x76, 0x65, 0x72, 0x73, 0x2f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63,
	0x65, 0x73, 0x3b, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x62, 0x06, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x33,
}

var (
	file_controller_servers_services_v1_server_coordination_service_proto_rawDescOnce sync.Once
	file_controller_servers_services_v1_server_coordination_service_proto_rawDescData = file_controller_servers_services_v1_server_coordination_service_proto_rawDesc
)

func file_controller_servers_services_v1_server_coordination_service_proto_rawDescGZIP() []byte {
	file_controller_servers_services_v1_server_coordination_service_proto_rawDescOnce.Do(func() {
		file_controller_servers_services_v1_server_coordination_service_proto_rawDescData = protoimpl.X.CompressGZIP(file_controller_servers_services_v1_server_coordination_service_proto_rawDescData)
	})
	return file_controller_servers_services_v1_server_coordination_service_proto_rawDescData
}

var file_controller_servers_services_v1_server_coordination_service_proto_enumTypes = make([]protoimpl.EnumInfo, 6)
var file_controller_servers_services_v1_server_coordination_service_proto_msgTypes = make([]protoimpl.MessageInfo, 14)
var file_controller_servers_services_v1_server_coordination_service_proto_goTypes = []any{
	(CONNECTIONSTATUS)(0),                  // 0: controller.servers.services.v1.CONNECTIONSTATUS
	(SESSIONSTATUS)(0),                     // 1: controller.servers.services.v1.SESSIONSTATUS
	(SessionProcessingError)(0),            // 2: controller.servers.services.v1.SessionProcessingError
	(JOBTYPE)(0),                           // 3: controller.servers.services.v1.JOBTYPE
	(CHANGETYPE)(0),                        // 4: controller.servers.services.v1.CHANGETYPE
	(UpstreamServer_TYPE)(0),               // 5: controller.servers.services.v1.UpstreamServer.TYPE
	(*Connection)(nil),                     // 6: controller.servers.services.v1.Connection
	(*SessionJobInfo)(nil),                 // 7: controller.servers.services.v1.SessionJobInfo
	(*MonitorSessionJobInfo)(nil),          // 8: controller.servers.services.v1.MonitorSessionJobInfo
	(*Job)(nil),                            // 9: controller.servers.services.v1.Job
	(*JobStatus)(nil),                      // 10: controller.servers.services.v1.JobStatus
	(*UpstreamServer)(nil),                 // 11: controller.servers.services.v1.UpstreamServer
	(*StatusRequest)(nil),                  // 12: controller.servers.services.v1.StatusRequest
	(*JobChangeRequest)(nil),               // 13: controller.servers.services.v1.JobChangeRequest
	(*AuthorizedWorkerList)(nil),           // 14: controller.servers.services.v1.AuthorizedWorkerList
	(*AuthorizedDownstreamWorkerList)(nil), // 15: controller.servers.services.v1.AuthorizedDownstreamWorkerList
	(*StatusResponse)(nil),                 // 16: controller.servers.services.v1.StatusResponse
	(*WorkerInfo)(nil),                     // 17: controller.servers.services.v1.WorkerInfo
	(*ListHcpbWorkersRequest)(nil),         // 18: controller.servers.services.v1.ListHcpbWorkersRequest
	(*ListHcpbWorkersResponse)(nil),        // 19: controller.servers.services.v1.ListHcpbWorkersResponse
	(*servers.ServerWorkerStatus)(nil),     // 20: controller.servers.v1.ServerWorkerStatus
}
var file_controller_servers_services_v1_server_coordination_service_proto_depIdxs = []int32{
	0,  // 0: controller.servers.services.v1.Connection.status:type_name -> controller.servers.services.v1.CONNECTIONSTATUS
	1,  // 1: controller.servers.services.v1.SessionJobInfo.status:type_name -> controller.servers.services.v1.SESSIONSTATUS
	6,  // 2: controller.servers.services.v1.SessionJobInfo.connections:type_name -> controller.servers.services.v1.Connection
	2,  // 3: controller.servers.services.v1.SessionJobInfo.processing_error:type_name -> controller.servers.services.v1.SessionProcessingError
	1,  // 4: controller.servers.services.v1.MonitorSessionJobInfo.status:type_name -> controller.servers.services.v1.SESSIONSTATUS
	2,  // 5: controller.servers.services.v1.MonitorSessionJobInfo.processing_error:type_name -> controller.servers.services.v1.SessionProcessingError
	3,  // 6: controller.servers.services.v1.Job.type:type_name -> controller.servers.services.v1.JOBTYPE
	7,  // 7: controller.servers.services.v1.Job.session_info:type_name -> controller.servers.services.v1.SessionJobInfo
	8,  // 8: controller.servers.services.v1.Job.monitor_session_info:type_name -> controller.servers.services.v1.MonitorSessionJobInfo
	9,  // 9: controller.servers.services.v1.JobStatus.job:type_name -> controller.servers.services.v1.Job
	5,  // 10: controller.servers.services.v1.UpstreamServer.type:type_name -> controller.servers.services.v1.UpstreamServer.TYPE
	10, // 11: controller.servers.services.v1.StatusRequest.jobs:type_name -> controller.servers.services.v1.JobStatus
	20, // 12: controller.servers.services.v1.StatusRequest.worker_status:type_name -> controller.servers.v1.ServerWorkerStatus
	9,  // 13: controller.servers.services.v1.JobChangeRequest.job:type_name -> controller.servers.services.v1.Job
	4,  // 14: controller.servers.services.v1.JobChangeRequest.request_type:type_name -> controller.servers.services.v1.CHANGETYPE
	13, // 15: controller.servers.services.v1.StatusResponse.jobs_requests:type_name -> controller.servers.services.v1.JobChangeRequest
	11, // 16: controller.servers.services.v1.StatusResponse.calculated_upstreams:type_name -> controller.servers.services.v1.UpstreamServer
	14, // 17: controller.servers.services.v1.StatusResponse.authorized_workers:type_name -> controller.servers.services.v1.AuthorizedWorkerList
	15, // 18: controller.servers.services.v1.StatusResponse.authorized_downstream_workers:type_name -> controller.servers.services.v1.AuthorizedDownstreamWorkerList
	17, // 19: controller.servers.services.v1.ListHcpbWorkersResponse.workers:type_name -> controller.servers.services.v1.WorkerInfo
	12, // 20: controller.servers.services.v1.ServerCoordinationService.Status:input_type -> controller.servers.services.v1.StatusRequest
	18, // 21: controller.servers.services.v1.ServerCoordinationService.ListHcpbWorkers:input_type -> controller.servers.services.v1.ListHcpbWorkersRequest
	16, // 22: controller.servers.services.v1.ServerCoordinationService.Status:output_type -> controller.servers.services.v1.StatusResponse
	19, // 23: controller.servers.services.v1.ServerCoordinationService.ListHcpbWorkers:output_type -> controller.servers.services.v1.ListHcpbWorkersResponse
	22, // [22:24] is the sub-list for method output_type
	20, // [20:22] is the sub-list for method input_type
	20, // [20:20] is the sub-list for extension type_name
	20, // [20:20] is the sub-list for extension extendee
	0,  // [0:20] is the sub-list for field type_name
}

func init() { file_controller_servers_services_v1_server_coordination_service_proto_init() }
func file_controller_servers_services_v1_server_coordination_service_proto_init() {
	if File_controller_servers_services_v1_server_coordination_service_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_controller_servers_services_v1_server_coordination_service_proto_msgTypes[0].Exporter = func(v any, i int) any {
			switch v := v.(*Connection); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_controller_servers_services_v1_server_coordination_service_proto_msgTypes[1].Exporter = func(v any, i int) any {
			switch v := v.(*SessionJobInfo); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_controller_servers_services_v1_server_coordination_service_proto_msgTypes[2].Exporter = func(v any, i int) any {
			switch v := v.(*MonitorSessionJobInfo); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_controller_servers_services_v1_server_coordination_service_proto_msgTypes[3].Exporter = func(v any, i int) any {
			switch v := v.(*Job); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_controller_servers_services_v1_server_coordination_service_proto_msgTypes[4].Exporter = func(v any, i int) any {
			switch v := v.(*JobStatus); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_controller_servers_services_v1_server_coordination_service_proto_msgTypes[5].Exporter = func(v any, i int) any {
			switch v := v.(*UpstreamServer); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_controller_servers_services_v1_server_coordination_service_proto_msgTypes[6].Exporter = func(v any, i int) any {
			switch v := v.(*StatusRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_controller_servers_services_v1_server_coordination_service_proto_msgTypes[7].Exporter = func(v any, i int) any {
			switch v := v.(*JobChangeRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_controller_servers_services_v1_server_coordination_service_proto_msgTypes[8].Exporter = func(v any, i int) any {
			switch v := v.(*AuthorizedWorkerList); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_controller_servers_services_v1_server_coordination_service_proto_msgTypes[9].Exporter = func(v any, i int) any {
			switch v := v.(*AuthorizedDownstreamWorkerList); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_controller_servers_services_v1_server_coordination_service_proto_msgTypes[10].Exporter = func(v any, i int) any {
			switch v := v.(*StatusResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_controller_servers_services_v1_server_coordination_service_proto_msgTypes[11].Exporter = func(v any, i int) any {
			switch v := v.(*WorkerInfo); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_controller_servers_services_v1_server_coordination_service_proto_msgTypes[12].Exporter = func(v any, i int) any {
			switch v := v.(*ListHcpbWorkersRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_controller_servers_services_v1_server_coordination_service_proto_msgTypes[13].Exporter = func(v any, i int) any {
			switch v := v.(*ListHcpbWorkersResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_controller_servers_services_v1_server_coordination_service_proto_msgTypes[3].OneofWrappers = []any{
		(*Job_SessionInfo)(nil),
		(*Job_MonitorSessionInfo)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_controller_servers_services_v1_server_coordination_service_proto_rawDesc,
			NumEnums:      6,
			NumMessages:   14,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_controller_servers_services_v1_server_coordination_service_proto_goTypes,
		DependencyIndexes: file_controller_servers_services_v1_server_coordination_service_proto_depIdxs,
		EnumInfos:         file_controller_servers_services_v1_server_coordination_service_proto_enumTypes,
		MessageInfos:      file_controller_servers_services_v1_server_coordination_service_proto_msgTypes,
	}.Build()
	File_controller_servers_services_v1_server_coordination_service_proto = out.File
	file_controller_servers_services_v1_server_coordination_service_proto_rawDesc = nil
	file_controller_servers_services_v1_server_coordination_service_proto_goTypes = nil
	file_controller_servers_services_v1_server_coordination_service_proto_depIdxs = nil
}
