// Copyright (c) HashiCorp, Inc.
// SPDX-License-Identifier: MPL-2.0

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.3.0
// - protoc             (unknown)
// source: controller/api/services/v1/worker_service.proto

package services

import (
	context "context"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

const (
	WorkerService_GetWorker_FullMethodName                        = "/controller.api.services.v1.WorkerService/GetWorker"
	WorkerService_ListWorkers_FullMethodName                      = "/controller.api.services.v1.WorkerService/ListWorkers"
	WorkerService_CreateWorkerLed_FullMethodName                  = "/controller.api.services.v1.WorkerService/CreateWorkerLed"
	WorkerService_CreateControllerLed_FullMethodName              = "/controller.api.services.v1.WorkerService/CreateControllerLed"
	WorkerService_UpdateWorker_FullMethodName                     = "/controller.api.services.v1.WorkerService/UpdateWorker"
	WorkerService_DeleteWorker_FullMethodName                     = "/controller.api.services.v1.WorkerService/DeleteWorker"
	WorkerService_AddWorkerTags_FullMethodName                    = "/controller.api.services.v1.WorkerService/AddWorkerTags"
	WorkerService_SetWorkerTags_FullMethodName                    = "/controller.api.services.v1.WorkerService/SetWorkerTags"
	WorkerService_RemoveWorkerTags_FullMethodName                 = "/controller.api.services.v1.WorkerService/RemoveWorkerTags"
	WorkerService_ReadCertificateAuthority_FullMethodName         = "/controller.api.services.v1.WorkerService/ReadCertificateAuthority"
	WorkerService_ReinitializeCertificateAuthority_FullMethodName = "/controller.api.services.v1.WorkerService/ReinitializeCertificateAuthority"
)

// WorkerServiceClient is the client API for WorkerService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type WorkerServiceClient interface {
	// GetWorker returns a stored Worker if present.  The provided request
	// must include the Worker ID for the Worker being retrieved. If
	// that ID is missing, malformed or reference a non existing
	// resource an error is returned.
	GetWorker(ctx context.Context, in *GetWorkerRequest, opts ...grpc.CallOption) (*GetWorkerResponse, error)
	// ListWorkers returns a list of stored Workers which exist inside the provided
	// scope. The request must include the scope ID for the Workers being listed.
	// If the scope ID is missing, malformed, or reference a non existing scope,
	// an error is returned.
	ListWorkers(ctx context.Context, in *ListWorkersRequest, opts ...grpc.CallOption) (*ListWorkersResponse, error)
	// CreateWorkerLed creates and stores a Worker in Boundary. The provided
	// request must include the Scope ID in which the Worker will be created. If
	// the Scope ID is missing, malformed or references a non existing resource,
	// an error is returned. If a name is provided that is in use in another
	// Worker in the same scope, an error is returned.
	CreateWorkerLed(ctx context.Context, in *CreateWorkerLedRequest, opts ...grpc.CallOption) (*CreateWorkerLedResponse, error)
	// CreateControllerLed creates and stores a Worker in Boundary and returns an
	// activation token that can be used by a worker binary to claim the created
	// Worker's identity. The provided request must include the Scope ID in which
	// the Worker will be created. If the Scope ID is missing, malformed or
	// references a non existing resource, an error is returned. If a name is
	// provided that is in use in another Worker in the same scope, an error is
	// returned.
	CreateControllerLed(ctx context.Context, in *CreateControllerLedRequest, opts ...grpc.CallOption) (*CreateControllerLedResponse, error)
	// UpdateWorker updates an existing Worker in boundary.  The provided
	// Worker must not have any read only fields set.  The update mask must be
	// included in the request and contain at least 1 mutable field.  To unset
	// a field's value, include the field in the update mask and don't set it
	// in the provided Worker. An error is returned if either the Worker id is
	// missing or reference a non existing resource.  An error is also returned
	// if the request attempts to update the name to one that is already in use
	// in this Scope.
	UpdateWorker(ctx context.Context, in *UpdateWorkerRequest, opts ...grpc.CallOption) (*UpdateWorkerResponse, error)
	// DeleteWorker removes a Worker from Boundary. If the provided Worker ID
	// is malformed or not provided an error is returned.
	DeleteWorker(ctx context.Context, in *DeleteWorkerRequest, opts ...grpc.CallOption) (*DeleteWorkerResponse, error)
	// AddWorkerTags adds api tags to an existing Worker. If missing, malformed,
	// or referencing a non-existing resource, an error is returned.
	AddWorkerTags(ctx context.Context, in *AddWorkerTagsRequest, opts ...grpc.CallOption) (*AddWorkerTagsResponse, error)
	// SetWorkerTags sets api tags for an existing Worker. Any existing tags are overridden
	// if they are not included in this request. If missing, malformed, or referencing a
	// non-existing resource, an error is returned.
	SetWorkerTags(ctx context.Context, in *SetWorkerTagsRequest, opts ...grpc.CallOption) (*SetWorkerTagsResponse, error)
	// RemoveWorkerTags removes api tags from an existing Worker. If missing, malformed,
	// or referencing a non-existing resource, an error is returned.
	RemoveWorkerTags(ctx context.Context, in *RemoveWorkerTagsRequest, opts ...grpc.CallOption) (*RemoveWorkerTagsResponse, error)
	// ReadCertificateAuthority returns the current and next set of root certificates
	ReadCertificateAuthority(ctx context.Context, in *ReadCertificateAuthorityRequest, opts ...grpc.CallOption) (*ReadCertificateAuthorityResponse, error)
	// ReinitializeCas removes both current and next root certs and replaces them with a new set
	ReinitializeCertificateAuthority(ctx context.Context, in *ReinitializeCertificateAuthorityRequest, opts ...grpc.CallOption) (*ReinitializeCertificateAuthorityResponse, error)
}

type workerServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewWorkerServiceClient(cc grpc.ClientConnInterface) WorkerServiceClient {
	return &workerServiceClient{cc}
}

func (c *workerServiceClient) GetWorker(ctx context.Context, in *GetWorkerRequest, opts ...grpc.CallOption) (*GetWorkerResponse, error) {
	out := new(GetWorkerResponse)
	err := c.cc.Invoke(ctx, WorkerService_GetWorker_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *workerServiceClient) ListWorkers(ctx context.Context, in *ListWorkersRequest, opts ...grpc.CallOption) (*ListWorkersResponse, error) {
	out := new(ListWorkersResponse)
	err := c.cc.Invoke(ctx, WorkerService_ListWorkers_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *workerServiceClient) CreateWorkerLed(ctx context.Context, in *CreateWorkerLedRequest, opts ...grpc.CallOption) (*CreateWorkerLedResponse, error) {
	out := new(CreateWorkerLedResponse)
	err := c.cc.Invoke(ctx, WorkerService_CreateWorkerLed_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *workerServiceClient) CreateControllerLed(ctx context.Context, in *CreateControllerLedRequest, opts ...grpc.CallOption) (*CreateControllerLedResponse, error) {
	out := new(CreateControllerLedResponse)
	err := c.cc.Invoke(ctx, WorkerService_CreateControllerLed_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *workerServiceClient) UpdateWorker(ctx context.Context, in *UpdateWorkerRequest, opts ...grpc.CallOption) (*UpdateWorkerResponse, error) {
	out := new(UpdateWorkerResponse)
	err := c.cc.Invoke(ctx, WorkerService_UpdateWorker_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *workerServiceClient) DeleteWorker(ctx context.Context, in *DeleteWorkerRequest, opts ...grpc.CallOption) (*DeleteWorkerResponse, error) {
	out := new(DeleteWorkerResponse)
	err := c.cc.Invoke(ctx, WorkerService_DeleteWorker_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *workerServiceClient) AddWorkerTags(ctx context.Context, in *AddWorkerTagsRequest, opts ...grpc.CallOption) (*AddWorkerTagsResponse, error) {
	out := new(AddWorkerTagsResponse)
	err := c.cc.Invoke(ctx, WorkerService_AddWorkerTags_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *workerServiceClient) SetWorkerTags(ctx context.Context, in *SetWorkerTagsRequest, opts ...grpc.CallOption) (*SetWorkerTagsResponse, error) {
	out := new(SetWorkerTagsResponse)
	err := c.cc.Invoke(ctx, WorkerService_SetWorkerTags_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *workerServiceClient) RemoveWorkerTags(ctx context.Context, in *RemoveWorkerTagsRequest, opts ...grpc.CallOption) (*RemoveWorkerTagsResponse, error) {
	out := new(RemoveWorkerTagsResponse)
	err := c.cc.Invoke(ctx, WorkerService_RemoveWorkerTags_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *workerServiceClient) ReadCertificateAuthority(ctx context.Context, in *ReadCertificateAuthorityRequest, opts ...grpc.CallOption) (*ReadCertificateAuthorityResponse, error) {
	out := new(ReadCertificateAuthorityResponse)
	err := c.cc.Invoke(ctx, WorkerService_ReadCertificateAuthority_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *workerServiceClient) ReinitializeCertificateAuthority(ctx context.Context, in *ReinitializeCertificateAuthorityRequest, opts ...grpc.CallOption) (*ReinitializeCertificateAuthorityResponse, error) {
	out := new(ReinitializeCertificateAuthorityResponse)
	err := c.cc.Invoke(ctx, WorkerService_ReinitializeCertificateAuthority_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// WorkerServiceServer is the server API for WorkerService service.
// All implementations must embed UnimplementedWorkerServiceServer
// for forward compatibility
type WorkerServiceServer interface {
	// GetWorker returns a stored Worker if present.  The provided request
	// must include the Worker ID for the Worker being retrieved. If
	// that ID is missing, malformed or reference a non existing
	// resource an error is returned.
	GetWorker(context.Context, *GetWorkerRequest) (*GetWorkerResponse, error)
	// ListWorkers returns a list of stored Workers which exist inside the provided
	// scope. The request must include the scope ID for the Workers being listed.
	// If the scope ID is missing, malformed, or reference a non existing scope,
	// an error is returned.
	ListWorkers(context.Context, *ListWorkersRequest) (*ListWorkersResponse, error)
	// CreateWorkerLed creates and stores a Worker in Boundary. The provided
	// request must include the Scope ID in which the Worker will be created. If
	// the Scope ID is missing, malformed or references a non existing resource,
	// an error is returned. If a name is provided that is in use in another
	// Worker in the same scope, an error is returned.
	CreateWorkerLed(context.Context, *CreateWorkerLedRequest) (*CreateWorkerLedResponse, error)
	// CreateControllerLed creates and stores a Worker in Boundary and returns an
	// activation token that can be used by a worker binary to claim the created
	// Worker's identity. The provided request must include the Scope ID in which
	// the Worker will be created. If the Scope ID is missing, malformed or
	// references a non existing resource, an error is returned. If a name is
	// provided that is in use in another Worker in the same scope, an error is
	// returned.
	CreateControllerLed(context.Context, *CreateControllerLedRequest) (*CreateControllerLedResponse, error)
	// UpdateWorker updates an existing Worker in boundary.  The provided
	// Worker must not have any read only fields set.  The update mask must be
	// included in the request and contain at least 1 mutable field.  To unset
	// a field's value, include the field in the update mask and don't set it
	// in the provided Worker. An error is returned if either the Worker id is
	// missing or reference a non existing resource.  An error is also returned
	// if the request attempts to update the name to one that is already in use
	// in this Scope.
	UpdateWorker(context.Context, *UpdateWorkerRequest) (*UpdateWorkerResponse, error)
	// DeleteWorker removes a Worker from Boundary. If the provided Worker ID
	// is malformed or not provided an error is returned.
	DeleteWorker(context.Context, *DeleteWorkerRequest) (*DeleteWorkerResponse, error)
	// AddWorkerTags adds api tags to an existing Worker. If missing, malformed,
	// or referencing a non-existing resource, an error is returned.
	AddWorkerTags(context.Context, *AddWorkerTagsRequest) (*AddWorkerTagsResponse, error)
	// SetWorkerTags sets api tags for an existing Worker. Any existing tags are overridden
	// if they are not included in this request. If missing, malformed, or referencing a
	// non-existing resource, an error is returned.
	SetWorkerTags(context.Context, *SetWorkerTagsRequest) (*SetWorkerTagsResponse, error)
	// RemoveWorkerTags removes api tags from an existing Worker. If missing, malformed,
	// or referencing a non-existing resource, an error is returned.
	RemoveWorkerTags(context.Context, *RemoveWorkerTagsRequest) (*RemoveWorkerTagsResponse, error)
	// ReadCertificateAuthority returns the current and next set of root certificates
	ReadCertificateAuthority(context.Context, *ReadCertificateAuthorityRequest) (*ReadCertificateAuthorityResponse, error)
	// ReinitializeCas removes both current and next root certs and replaces them with a new set
	ReinitializeCertificateAuthority(context.Context, *ReinitializeCertificateAuthorityRequest) (*ReinitializeCertificateAuthorityResponse, error)
	mustEmbedUnimplementedWorkerServiceServer()
}

// UnimplementedWorkerServiceServer must be embedded to have forward compatible implementations.
type UnimplementedWorkerServiceServer struct {
}

func (UnimplementedWorkerServiceServer) GetWorker(context.Context, *GetWorkerRequest) (*GetWorkerResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetWorker not implemented")
}
func (UnimplementedWorkerServiceServer) ListWorkers(context.Context, *ListWorkersRequest) (*ListWorkersResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListWorkers not implemented")
}
func (UnimplementedWorkerServiceServer) CreateWorkerLed(context.Context, *CreateWorkerLedRequest) (*CreateWorkerLedResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateWorkerLed not implemented")
}
func (UnimplementedWorkerServiceServer) CreateControllerLed(context.Context, *CreateControllerLedRequest) (*CreateControllerLedResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateControllerLed not implemented")
}
func (UnimplementedWorkerServiceServer) UpdateWorker(context.Context, *UpdateWorkerRequest) (*UpdateWorkerResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateWorker not implemented")
}
func (UnimplementedWorkerServiceServer) DeleteWorker(context.Context, *DeleteWorkerRequest) (*DeleteWorkerResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteWorker not implemented")
}
func (UnimplementedWorkerServiceServer) AddWorkerTags(context.Context, *AddWorkerTagsRequest) (*AddWorkerTagsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method AddWorkerTags not implemented")
}
func (UnimplementedWorkerServiceServer) SetWorkerTags(context.Context, *SetWorkerTagsRequest) (*SetWorkerTagsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SetWorkerTags not implemented")
}
func (UnimplementedWorkerServiceServer) RemoveWorkerTags(context.Context, *RemoveWorkerTagsRequest) (*RemoveWorkerTagsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method RemoveWorkerTags not implemented")
}
func (UnimplementedWorkerServiceServer) ReadCertificateAuthority(context.Context, *ReadCertificateAuthorityRequest) (*ReadCertificateAuthorityResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ReadCertificateAuthority not implemented")
}
func (UnimplementedWorkerServiceServer) ReinitializeCertificateAuthority(context.Context, *ReinitializeCertificateAuthorityRequest) (*ReinitializeCertificateAuthorityResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ReinitializeCertificateAuthority not implemented")
}
func (UnimplementedWorkerServiceServer) mustEmbedUnimplementedWorkerServiceServer() {}

// UnsafeWorkerServiceServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to WorkerServiceServer will
// result in compilation errors.
type UnsafeWorkerServiceServer interface {
	mustEmbedUnimplementedWorkerServiceServer()
}

func RegisterWorkerServiceServer(s grpc.ServiceRegistrar, srv WorkerServiceServer) {
	s.RegisterService(&WorkerService_ServiceDesc, srv)
}

func _WorkerService_GetWorker_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetWorkerRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WorkerServiceServer).GetWorker(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: WorkerService_GetWorker_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WorkerServiceServer).GetWorker(ctx, req.(*GetWorkerRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _WorkerService_ListWorkers_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListWorkersRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WorkerServiceServer).ListWorkers(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: WorkerService_ListWorkers_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WorkerServiceServer).ListWorkers(ctx, req.(*ListWorkersRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _WorkerService_CreateWorkerLed_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateWorkerLedRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WorkerServiceServer).CreateWorkerLed(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: WorkerService_CreateWorkerLed_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WorkerServiceServer).CreateWorkerLed(ctx, req.(*CreateWorkerLedRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _WorkerService_CreateControllerLed_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateControllerLedRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WorkerServiceServer).CreateControllerLed(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: WorkerService_CreateControllerLed_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WorkerServiceServer).CreateControllerLed(ctx, req.(*CreateControllerLedRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _WorkerService_UpdateWorker_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateWorkerRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WorkerServiceServer).UpdateWorker(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: WorkerService_UpdateWorker_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WorkerServiceServer).UpdateWorker(ctx, req.(*UpdateWorkerRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _WorkerService_DeleteWorker_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteWorkerRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WorkerServiceServer).DeleteWorker(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: WorkerService_DeleteWorker_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WorkerServiceServer).DeleteWorker(ctx, req.(*DeleteWorkerRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _WorkerService_AddWorkerTags_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AddWorkerTagsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WorkerServiceServer).AddWorkerTags(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: WorkerService_AddWorkerTags_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WorkerServiceServer).AddWorkerTags(ctx, req.(*AddWorkerTagsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _WorkerService_SetWorkerTags_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SetWorkerTagsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WorkerServiceServer).SetWorkerTags(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: WorkerService_SetWorkerTags_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WorkerServiceServer).SetWorkerTags(ctx, req.(*SetWorkerTagsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _WorkerService_RemoveWorkerTags_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RemoveWorkerTagsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WorkerServiceServer).RemoveWorkerTags(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: WorkerService_RemoveWorkerTags_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WorkerServiceServer).RemoveWorkerTags(ctx, req.(*RemoveWorkerTagsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _WorkerService_ReadCertificateAuthority_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ReadCertificateAuthorityRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WorkerServiceServer).ReadCertificateAuthority(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: WorkerService_ReadCertificateAuthority_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WorkerServiceServer).ReadCertificateAuthority(ctx, req.(*ReadCertificateAuthorityRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _WorkerService_ReinitializeCertificateAuthority_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ReinitializeCertificateAuthorityRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WorkerServiceServer).ReinitializeCertificateAuthority(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: WorkerService_ReinitializeCertificateAuthority_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WorkerServiceServer).ReinitializeCertificateAuthority(ctx, req.(*ReinitializeCertificateAuthorityRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// WorkerService_ServiceDesc is the grpc.ServiceDesc for WorkerService service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var WorkerService_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "controller.api.services.v1.WorkerService",
	HandlerType: (*WorkerServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "GetWorker",
			Handler:    _WorkerService_GetWorker_Handler,
		},
		{
			MethodName: "ListWorkers",
			Handler:    _WorkerService_ListWorkers_Handler,
		},
		{
			MethodName: "CreateWorkerLed",
			Handler:    _WorkerService_CreateWorkerLed_Handler,
		},
		{
			MethodName: "CreateControllerLed",
			Handler:    _WorkerService_CreateControllerLed_Handler,
		},
		{
			MethodName: "UpdateWorker",
			Handler:    _WorkerService_UpdateWorker_Handler,
		},
		{
			MethodName: "DeleteWorker",
			Handler:    _WorkerService_DeleteWorker_Handler,
		},
		{
			MethodName: "AddWorkerTags",
			Handler:    _WorkerService_AddWorkerTags_Handler,
		},
		{
			MethodName: "SetWorkerTags",
			Handler:    _WorkerService_SetWorkerTags_Handler,
		},
		{
			MethodName: "RemoveWorkerTags",
			Handler:    _WorkerService_RemoveWorkerTags_Handler,
		},
		{
			MethodName: "ReadCertificateAuthority",
			Handler:    _WorkerService_ReadCertificateAuthority_Handler,
		},
		{
			MethodName: "ReinitializeCertificateAuthority",
			Handler:    _WorkerService_ReinitializeCertificateAuthority_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "controller/api/services/v1/worker_service.proto",
}
