// Copyright (c) HashiCorp, Inc.
// SPDX-License-Identifier: MPL-2.0

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.3.0
// - protoc             (unknown)
// source: controller/api/services/v1/storage_bucket_service.proto

package services

import (
	context "context"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

const (
	StorageBucketService_GetStorageBucket_FullMethodName    = "/controller.api.services.v1.StorageBucketService/GetStorageBucket"
	StorageBucketService_ListStorageBuckets_FullMethodName  = "/controller.api.services.v1.StorageBucketService/ListStorageBuckets"
	StorageBucketService_CreateStorageBucket_FullMethodName = "/controller.api.services.v1.StorageBucketService/CreateStorageBucket"
	StorageBucketService_UpdateStorageBucket_FullMethodName = "/controller.api.services.v1.StorageBucketService/UpdateStorageBucket"
	StorageBucketService_DeleteStorageBucket_FullMethodName = "/controller.api.services.v1.StorageBucketService/DeleteStorageBucket"
)

// StorageBucketServiceClient is the client API for StorageBucketService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type StorageBucketServiceClient interface {
	// GetStorageBucket returns a stored Storage Bucket if present.  The provided
	// request must include the ID for the Storage Bucket being retrieved.
	// If missing, malformed, or referencing a non-existing resource an error is
	// returned.
	GetStorageBucket(ctx context.Context, in *GetStorageBucketRequest, opts ...grpc.CallOption) (*GetStorageBucketResponse, error)
	// ListStorageBuckets returns a list of stored Storage Buckets which exist inside
	// the scope referenced in the request. The request must include the scope
	// ID and if it is  missing, malformed, or references a non-existing resource
	// an error is returned.
	ListStorageBuckets(ctx context.Context, in *ListStorageBucketsRequest, opts ...grpc.CallOption) (*ListStorageBucketsResponse, error)
	// CreateStorageBucket creates and stores a Storage Bucket in boundary.  The
	// provided request must include the scope ID in which the Storage Bucket will be
	// created. If any of these required fields are missing, malformed, or reference a
	// non-existing parent resource an error is returned.
	CreateStorageBucket(ctx context.Context, in *CreateStorageBucketRequest, opts ...grpc.CallOption) (*CreateStorageBucketResponse, error)
	// UpdateStorageBucket updates an existing Storage Bucket in Boundary. The
	// provided Storage Bucket must not have any read only fields set. The update
	// mask must be provided and include at least 1 mutable field. To unset a
	// field's value include that field name in the update mask and don't set the
	// field in the Storage Bucket.
	UpdateStorageBucket(ctx context.Context, in *UpdateStorageBucketRequest, opts ...grpc.CallOption) (*UpdateStorageBucketResponse, error)
	// DeleteStorageBucket removes a Storage Bucket  from Boundary.
	// If the provided Storage Bucket ID is malformed or not
	// provided DeleteStorageBucket returns an error.
	DeleteStorageBucket(ctx context.Context, in *DeleteStorageBucketRequest, opts ...grpc.CallOption) (*DeleteStorageBucketResponse, error)
}

type storageBucketServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewStorageBucketServiceClient(cc grpc.ClientConnInterface) StorageBucketServiceClient {
	return &storageBucketServiceClient{cc}
}

func (c *storageBucketServiceClient) GetStorageBucket(ctx context.Context, in *GetStorageBucketRequest, opts ...grpc.CallOption) (*GetStorageBucketResponse, error) {
	out := new(GetStorageBucketResponse)
	err := c.cc.Invoke(ctx, StorageBucketService_GetStorageBucket_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *storageBucketServiceClient) ListStorageBuckets(ctx context.Context, in *ListStorageBucketsRequest, opts ...grpc.CallOption) (*ListStorageBucketsResponse, error) {
	out := new(ListStorageBucketsResponse)
	err := c.cc.Invoke(ctx, StorageBucketService_ListStorageBuckets_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *storageBucketServiceClient) CreateStorageBucket(ctx context.Context, in *CreateStorageBucketRequest, opts ...grpc.CallOption) (*CreateStorageBucketResponse, error) {
	out := new(CreateStorageBucketResponse)
	err := c.cc.Invoke(ctx, StorageBucketService_CreateStorageBucket_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *storageBucketServiceClient) UpdateStorageBucket(ctx context.Context, in *UpdateStorageBucketRequest, opts ...grpc.CallOption) (*UpdateStorageBucketResponse, error) {
	out := new(UpdateStorageBucketResponse)
	err := c.cc.Invoke(ctx, StorageBucketService_UpdateStorageBucket_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *storageBucketServiceClient) DeleteStorageBucket(ctx context.Context, in *DeleteStorageBucketRequest, opts ...grpc.CallOption) (*DeleteStorageBucketResponse, error) {
	out := new(DeleteStorageBucketResponse)
	err := c.cc.Invoke(ctx, StorageBucketService_DeleteStorageBucket_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// StorageBucketServiceServer is the server API for StorageBucketService service.
// All implementations must embed UnimplementedStorageBucketServiceServer
// for forward compatibility
type StorageBucketServiceServer interface {
	// GetStorageBucket returns a stored Storage Bucket if present.  The provided
	// request must include the ID for the Storage Bucket being retrieved.
	// If missing, malformed, or referencing a non-existing resource an error is
	// returned.
	GetStorageBucket(context.Context, *GetStorageBucketRequest) (*GetStorageBucketResponse, error)
	// ListStorageBuckets returns a list of stored Storage Buckets which exist inside
	// the scope referenced in the request. The request must include the scope
	// ID and if it is  missing, malformed, or references a non-existing resource
	// an error is returned.
	ListStorageBuckets(context.Context, *ListStorageBucketsRequest) (*ListStorageBucketsResponse, error)
	// CreateStorageBucket creates and stores a Storage Bucket in boundary.  The
	// provided request must include the scope ID in which the Storage Bucket will be
	// created. If any of these required fields are missing, malformed, or reference a
	// non-existing parent resource an error is returned.
	CreateStorageBucket(context.Context, *CreateStorageBucketRequest) (*CreateStorageBucketResponse, error)
	// UpdateStorageBucket updates an existing Storage Bucket in Boundary. The
	// provided Storage Bucket must not have any read only fields set. The update
	// mask must be provided and include at least 1 mutable field. To unset a
	// field's value include that field name in the update mask and don't set the
	// field in the Storage Bucket.
	UpdateStorageBucket(context.Context, *UpdateStorageBucketRequest) (*UpdateStorageBucketResponse, error)
	// DeleteStorageBucket removes a Storage Bucket  from Boundary.
	// If the provided Storage Bucket ID is malformed or not
	// provided DeleteStorageBucket returns an error.
	DeleteStorageBucket(context.Context, *DeleteStorageBucketRequest) (*DeleteStorageBucketResponse, error)
	mustEmbedUnimplementedStorageBucketServiceServer()
}

// UnimplementedStorageBucketServiceServer must be embedded to have forward compatible implementations.
type UnimplementedStorageBucketServiceServer struct {
}

func (UnimplementedStorageBucketServiceServer) GetStorageBucket(context.Context, *GetStorageBucketRequest) (*GetStorageBucketResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetStorageBucket not implemented")
}
func (UnimplementedStorageBucketServiceServer) ListStorageBuckets(context.Context, *ListStorageBucketsRequest) (*ListStorageBucketsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListStorageBuckets not implemented")
}
func (UnimplementedStorageBucketServiceServer) CreateStorageBucket(context.Context, *CreateStorageBucketRequest) (*CreateStorageBucketResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateStorageBucket not implemented")
}
func (UnimplementedStorageBucketServiceServer) UpdateStorageBucket(context.Context, *UpdateStorageBucketRequest) (*UpdateStorageBucketResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateStorageBucket not implemented")
}
func (UnimplementedStorageBucketServiceServer) DeleteStorageBucket(context.Context, *DeleteStorageBucketRequest) (*DeleteStorageBucketResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteStorageBucket not implemented")
}
func (UnimplementedStorageBucketServiceServer) mustEmbedUnimplementedStorageBucketServiceServer() {}

// UnsafeStorageBucketServiceServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to StorageBucketServiceServer will
// result in compilation errors.
type UnsafeStorageBucketServiceServer interface {
	mustEmbedUnimplementedStorageBucketServiceServer()
}

func RegisterStorageBucketServiceServer(s grpc.ServiceRegistrar, srv StorageBucketServiceServer) {
	s.RegisterService(&StorageBucketService_ServiceDesc, srv)
}

func _StorageBucketService_GetStorageBucket_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetStorageBucketRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StorageBucketServiceServer).GetStorageBucket(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: StorageBucketService_GetStorageBucket_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StorageBucketServiceServer).GetStorageBucket(ctx, req.(*GetStorageBucketRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _StorageBucketService_ListStorageBuckets_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListStorageBucketsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StorageBucketServiceServer).ListStorageBuckets(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: StorageBucketService_ListStorageBuckets_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StorageBucketServiceServer).ListStorageBuckets(ctx, req.(*ListStorageBucketsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _StorageBucketService_CreateStorageBucket_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateStorageBucketRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StorageBucketServiceServer).CreateStorageBucket(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: StorageBucketService_CreateStorageBucket_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StorageBucketServiceServer).CreateStorageBucket(ctx, req.(*CreateStorageBucketRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _StorageBucketService_UpdateStorageBucket_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateStorageBucketRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StorageBucketServiceServer).UpdateStorageBucket(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: StorageBucketService_UpdateStorageBucket_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StorageBucketServiceServer).UpdateStorageBucket(ctx, req.(*UpdateStorageBucketRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _StorageBucketService_DeleteStorageBucket_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteStorageBucketRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StorageBucketServiceServer).DeleteStorageBucket(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: StorageBucketService_DeleteStorageBucket_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StorageBucketServiceServer).DeleteStorageBucket(ctx, req.(*DeleteStorageBucketRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// StorageBucketService_ServiceDesc is the grpc.ServiceDesc for StorageBucketService service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var StorageBucketService_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "controller.api.services.v1.StorageBucketService",
	HandlerType: (*StorageBucketServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "GetStorageBucket",
			Handler:    _StorageBucketService_GetStorageBucket_Handler,
		},
		{
			MethodName: "ListStorageBuckets",
			Handler:    _StorageBucketService_ListStorageBuckets_Handler,
		},
		{
			MethodName: "CreateStorageBucket",
			Handler:    _StorageBucketService_CreateStorageBucket_Handler,
		},
		{
			MethodName: "UpdateStorageBucket",
			Handler:    _StorageBucketService_UpdateStorageBucket_Handler,
		},
		{
			MethodName: "DeleteStorageBucket",
			Handler:    _StorageBucketService_DeleteStorageBucket_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "controller/api/services/v1/storage_bucket_service.proto",
}
