// Copyright (c) HashiCorp, Inc.
// SPDX-License-Identifier: MPL-2.0

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.3.0
// - protoc             (unknown)
// source: controller/api/services/v1/scope_service.proto

package services

import (
	context "context"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

const (
	ScopeService_GetScope_FullMethodName                      = "/controller.api.services.v1.ScopeService/GetScope"
	ScopeService_ListScopes_FullMethodName                    = "/controller.api.services.v1.ScopeService/ListScopes"
	ScopeService_CreateScope_FullMethodName                   = "/controller.api.services.v1.ScopeService/CreateScope"
	ScopeService_UpdateScope_FullMethodName                   = "/controller.api.services.v1.ScopeService/UpdateScope"
	ScopeService_DeleteScope_FullMethodName                   = "/controller.api.services.v1.ScopeService/DeleteScope"
	ScopeService_ListKeys_FullMethodName                      = "/controller.api.services.v1.ScopeService/ListKeys"
	ScopeService_RotateKeys_FullMethodName                    = "/controller.api.services.v1.ScopeService/RotateKeys"
	ScopeService_ListKeyVersionDestructionJobs_FullMethodName = "/controller.api.services.v1.ScopeService/ListKeyVersionDestructionJobs"
	ScopeService_DestroyKeyVersion_FullMethodName             = "/controller.api.services.v1.ScopeService/DestroyKeyVersion"
	ScopeService_AttachStoragePolicy_FullMethodName           = "/controller.api.services.v1.ScopeService/AttachStoragePolicy"
	ScopeService_DetachStoragePolicy_FullMethodName           = "/controller.api.services.v1.ScopeService/DetachStoragePolicy"
)

// ScopeServiceClient is the client API for ScopeService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type ScopeServiceClient interface {
	// GetScope returns a stored Scope if present.  The provided request
	// must include the scope ID for the scope being retrieved. If
	// that ID is missing, malformed or references a non existing
	// resource an error is returned.
	GetScope(ctx context.Context, in *GetScopeRequest, opts ...grpc.CallOption) (*GetScopeResponse, error)
	// ListScopes returns a list of stored Scopes which exist inside the provided
	// parent Scope id.
	ListScopes(ctx context.Context, in *ListScopesRequest, opts ...grpc.CallOption) (*ListScopesResponse, error)
	// CreateScope creates and stores a Scope in boundary.  The provided request
	// must include the Scope ID in which the new scope will be created. If the Scope
	// ID is missing, malformed or references a non existing scope, an error is
	// returned. If a name is provided that is in use in another Scope in the same
	// parent scope, an error is returned.
	CreateScope(ctx context.Context, in *CreateScopeRequest, opts ...grpc.CallOption) (*CreateScopeResponse, error)
	// UpdateScope updates an existing Scope in boundary.  The provided
	// Scope must not have any read only fields set.  The update mask must be
	// included in the request and contain at least 1 mutable field.  To unset
	// a field's value, include the field in the update mask and don't set it
	// in the provided scope. An error is returned if the Scope Id is
	// missing or reference a non-existing resource.  An error
	// is also returned if the request attempts to update the name to one that is
	// already in use by another scope in the parent scope.
	UpdateScope(ctx context.Context, in *UpdateScopeRequest, opts ...grpc.CallOption) (*UpdateScopeResponse, error)
	// DeleteScope remotes a Scope and all child resources from Boundary. If the
	// provided Scope IDs are malformed or not provided an error is returned.
	DeleteScope(ctx context.Context, in *DeleteScopeRequest, opts ...grpc.CallOption) (*DeleteScopeResponse, error)
	// ListKeys lists all the keys found in the scope specified. If the scope
	// is not found an error is returned.
	ListKeys(ctx context.Context, in *ListKeysRequest, opts ...grpc.CallOption) (*ListKeysResponse, error)
	// RotateKeys rotates and optionally rewraps all the keys found in the
	// scope specified. If the scope is not found an error is returned. If
	// the scope is empty, the global scope is used.
	RotateKeys(ctx context.Context, in *RotateKeysRequest, opts ...grpc.CallOption) (*RotateKeysResponse, error)
	// ListKeyVersionDestructionJobs lists any pending key version destruction jobs in the scope.
	ListKeyVersionDestructionJobs(ctx context.Context, in *ListKeyVersionDestructionJobsRequest, opts ...grpc.CallOption) (*ListKeyVersionDestructionJobsResponse, error)
	// DestroyKeyVersion destroys the specified key version. If this requires re-encrypting
	// existing data, it will start an asynchronous process to complete this operation
	// before destroying the key. Use ListKeyVersionDestructionJobs to monitor pending destruction jobs.
	DestroyKeyVersion(ctx context.Context, in *DestroyKeyVersionRequest, opts ...grpc.CallOption) (*DestroyKeyVersionResponse, error)
	// AttachStoragePolicy sets the Scope's Storage Policy. Any existing Storage
	// Policy on the Scope will be overwritten. The provided request must include
	// the Scope ID and the Storage Policy ID on which the Storage Policy will be
	// set. A Storage Policy created under the global scope may be attached to any
	// global or org scope. A Storage Policy created under a org scope may be attached
	// to the same org scope. If any ID is missing, malformed, or references a
	// non-existing resource, an error is returned.
	AttachStoragePolicy(ctx context.Context, in *AttachStoragePolicyRequest, opts ...grpc.CallOption) (*AttachStoragePolicyResponse, error)
	// DetachStoragePolicy removes the Storage Policy from the specified Scope.
	// The provided request must include the Scope ID for the Scope from which
	// the Storage Policy will be removed. If the ID is missing, malformed, or
	// references a non-existing scope, an error is returned. An error is returned
	// if a Storage Policy is attempted to be removed from the Scope when the Scope
	// does not have the Storage Policy attached to it.
	DetachStoragePolicy(ctx context.Context, in *DetachStoragePolicyRequest, opts ...grpc.CallOption) (*DetachStoragePolicyResponse, error)
}

type scopeServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewScopeServiceClient(cc grpc.ClientConnInterface) ScopeServiceClient {
	return &scopeServiceClient{cc}
}

func (c *scopeServiceClient) GetScope(ctx context.Context, in *GetScopeRequest, opts ...grpc.CallOption) (*GetScopeResponse, error) {
	out := new(GetScopeResponse)
	err := c.cc.Invoke(ctx, ScopeService_GetScope_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *scopeServiceClient) ListScopes(ctx context.Context, in *ListScopesRequest, opts ...grpc.CallOption) (*ListScopesResponse, error) {
	out := new(ListScopesResponse)
	err := c.cc.Invoke(ctx, ScopeService_ListScopes_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *scopeServiceClient) CreateScope(ctx context.Context, in *CreateScopeRequest, opts ...grpc.CallOption) (*CreateScopeResponse, error) {
	out := new(CreateScopeResponse)
	err := c.cc.Invoke(ctx, ScopeService_CreateScope_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *scopeServiceClient) UpdateScope(ctx context.Context, in *UpdateScopeRequest, opts ...grpc.CallOption) (*UpdateScopeResponse, error) {
	out := new(UpdateScopeResponse)
	err := c.cc.Invoke(ctx, ScopeService_UpdateScope_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *scopeServiceClient) DeleteScope(ctx context.Context, in *DeleteScopeRequest, opts ...grpc.CallOption) (*DeleteScopeResponse, error) {
	out := new(DeleteScopeResponse)
	err := c.cc.Invoke(ctx, ScopeService_DeleteScope_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *scopeServiceClient) ListKeys(ctx context.Context, in *ListKeysRequest, opts ...grpc.CallOption) (*ListKeysResponse, error) {
	out := new(ListKeysResponse)
	err := c.cc.Invoke(ctx, ScopeService_ListKeys_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *scopeServiceClient) RotateKeys(ctx context.Context, in *RotateKeysRequest, opts ...grpc.CallOption) (*RotateKeysResponse, error) {
	out := new(RotateKeysResponse)
	err := c.cc.Invoke(ctx, ScopeService_RotateKeys_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *scopeServiceClient) ListKeyVersionDestructionJobs(ctx context.Context, in *ListKeyVersionDestructionJobsRequest, opts ...grpc.CallOption) (*ListKeyVersionDestructionJobsResponse, error) {
	out := new(ListKeyVersionDestructionJobsResponse)
	err := c.cc.Invoke(ctx, ScopeService_ListKeyVersionDestructionJobs_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *scopeServiceClient) DestroyKeyVersion(ctx context.Context, in *DestroyKeyVersionRequest, opts ...grpc.CallOption) (*DestroyKeyVersionResponse, error) {
	out := new(DestroyKeyVersionResponse)
	err := c.cc.Invoke(ctx, ScopeService_DestroyKeyVersion_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *scopeServiceClient) AttachStoragePolicy(ctx context.Context, in *AttachStoragePolicyRequest, opts ...grpc.CallOption) (*AttachStoragePolicyResponse, error) {
	out := new(AttachStoragePolicyResponse)
	err := c.cc.Invoke(ctx, ScopeService_AttachStoragePolicy_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *scopeServiceClient) DetachStoragePolicy(ctx context.Context, in *DetachStoragePolicyRequest, opts ...grpc.CallOption) (*DetachStoragePolicyResponse, error) {
	out := new(DetachStoragePolicyResponse)
	err := c.cc.Invoke(ctx, ScopeService_DetachStoragePolicy_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// ScopeServiceServer is the server API for ScopeService service.
// All implementations must embed UnimplementedScopeServiceServer
// for forward compatibility
type ScopeServiceServer interface {
	// GetScope returns a stored Scope if present.  The provided request
	// must include the scope ID for the scope being retrieved. If
	// that ID is missing, malformed or references a non existing
	// resource an error is returned.
	GetScope(context.Context, *GetScopeRequest) (*GetScopeResponse, error)
	// ListScopes returns a list of stored Scopes which exist inside the provided
	// parent Scope id.
	ListScopes(context.Context, *ListScopesRequest) (*ListScopesResponse, error)
	// CreateScope creates and stores a Scope in boundary.  The provided request
	// must include the Scope ID in which the new scope will be created. If the Scope
	// ID is missing, malformed or references a non existing scope, an error is
	// returned. If a name is provided that is in use in another Scope in the same
	// parent scope, an error is returned.
	CreateScope(context.Context, *CreateScopeRequest) (*CreateScopeResponse, error)
	// UpdateScope updates an existing Scope in boundary.  The provided
	// Scope must not have any read only fields set.  The update mask must be
	// included in the request and contain at least 1 mutable field.  To unset
	// a field's value, include the field in the update mask and don't set it
	// in the provided scope. An error is returned if the Scope Id is
	// missing or reference a non-existing resource.  An error
	// is also returned if the request attempts to update the name to one that is
	// already in use by another scope in the parent scope.
	UpdateScope(context.Context, *UpdateScopeRequest) (*UpdateScopeResponse, error)
	// DeleteScope remotes a Scope and all child resources from Boundary. If the
	// provided Scope IDs are malformed or not provided an error is returned.
	DeleteScope(context.Context, *DeleteScopeRequest) (*DeleteScopeResponse, error)
	// ListKeys lists all the keys found in the scope specified. If the scope
	// is not found an error is returned.
	ListKeys(context.Context, *ListKeysRequest) (*ListKeysResponse, error)
	// RotateKeys rotates and optionally rewraps all the keys found in the
	// scope specified. If the scope is not found an error is returned. If
	// the scope is empty, the global scope is used.
	RotateKeys(context.Context, *RotateKeysRequest) (*RotateKeysResponse, error)
	// ListKeyVersionDestructionJobs lists any pending key version destruction jobs in the scope.
	ListKeyVersionDestructionJobs(context.Context, *ListKeyVersionDestructionJobsRequest) (*ListKeyVersionDestructionJobsResponse, error)
	// DestroyKeyVersion destroys the specified key version. If this requires re-encrypting
	// existing data, it will start an asynchronous process to complete this operation
	// before destroying the key. Use ListKeyVersionDestructionJobs to monitor pending destruction jobs.
	DestroyKeyVersion(context.Context, *DestroyKeyVersionRequest) (*DestroyKeyVersionResponse, error)
	// AttachStoragePolicy sets the Scope's Storage Policy. Any existing Storage
	// Policy on the Scope will be overwritten. The provided request must include
	// the Scope ID and the Storage Policy ID on which the Storage Policy will be
	// set. A Storage Policy created under the global scope may be attached to any
	// global or org scope. A Storage Policy created under a org scope may be attached
	// to the same org scope. If any ID is missing, malformed, or references a
	// non-existing resource, an error is returned.
	AttachStoragePolicy(context.Context, *AttachStoragePolicyRequest) (*AttachStoragePolicyResponse, error)
	// DetachStoragePolicy removes the Storage Policy from the specified Scope.
	// The provided request must include the Scope ID for the Scope from which
	// the Storage Policy will be removed. If the ID is missing, malformed, or
	// references a non-existing scope, an error is returned. An error is returned
	// if a Storage Policy is attempted to be removed from the Scope when the Scope
	// does not have the Storage Policy attached to it.
	DetachStoragePolicy(context.Context, *DetachStoragePolicyRequest) (*DetachStoragePolicyResponse, error)
	mustEmbedUnimplementedScopeServiceServer()
}

// UnimplementedScopeServiceServer must be embedded to have forward compatible implementations.
type UnimplementedScopeServiceServer struct {
}

func (UnimplementedScopeServiceServer) GetScope(context.Context, *GetScopeRequest) (*GetScopeResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetScope not implemented")
}
func (UnimplementedScopeServiceServer) ListScopes(context.Context, *ListScopesRequest) (*ListScopesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListScopes not implemented")
}
func (UnimplementedScopeServiceServer) CreateScope(context.Context, *CreateScopeRequest) (*CreateScopeResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateScope not implemented")
}
func (UnimplementedScopeServiceServer) UpdateScope(context.Context, *UpdateScopeRequest) (*UpdateScopeResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateScope not implemented")
}
func (UnimplementedScopeServiceServer) DeleteScope(context.Context, *DeleteScopeRequest) (*DeleteScopeResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteScope not implemented")
}
func (UnimplementedScopeServiceServer) ListKeys(context.Context, *ListKeysRequest) (*ListKeysResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListKeys not implemented")
}
func (UnimplementedScopeServiceServer) RotateKeys(context.Context, *RotateKeysRequest) (*RotateKeysResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method RotateKeys not implemented")
}
func (UnimplementedScopeServiceServer) ListKeyVersionDestructionJobs(context.Context, *ListKeyVersionDestructionJobsRequest) (*ListKeyVersionDestructionJobsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListKeyVersionDestructionJobs not implemented")
}
func (UnimplementedScopeServiceServer) DestroyKeyVersion(context.Context, *DestroyKeyVersionRequest) (*DestroyKeyVersionResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DestroyKeyVersion not implemented")
}
func (UnimplementedScopeServiceServer) AttachStoragePolicy(context.Context, *AttachStoragePolicyRequest) (*AttachStoragePolicyResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method AttachStoragePolicy not implemented")
}
func (UnimplementedScopeServiceServer) DetachStoragePolicy(context.Context, *DetachStoragePolicyRequest) (*DetachStoragePolicyResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DetachStoragePolicy not implemented")
}
func (UnimplementedScopeServiceServer) mustEmbedUnimplementedScopeServiceServer() {}

// UnsafeScopeServiceServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to ScopeServiceServer will
// result in compilation errors.
type UnsafeScopeServiceServer interface {
	mustEmbedUnimplementedScopeServiceServer()
}

func RegisterScopeServiceServer(s grpc.ServiceRegistrar, srv ScopeServiceServer) {
	s.RegisterService(&ScopeService_ServiceDesc, srv)
}

func _ScopeService_GetScope_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetScopeRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ScopeServiceServer).GetScope(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ScopeService_GetScope_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ScopeServiceServer).GetScope(ctx, req.(*GetScopeRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ScopeService_ListScopes_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListScopesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ScopeServiceServer).ListScopes(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ScopeService_ListScopes_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ScopeServiceServer).ListScopes(ctx, req.(*ListScopesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ScopeService_CreateScope_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateScopeRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ScopeServiceServer).CreateScope(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ScopeService_CreateScope_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ScopeServiceServer).CreateScope(ctx, req.(*CreateScopeRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ScopeService_UpdateScope_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateScopeRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ScopeServiceServer).UpdateScope(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ScopeService_UpdateScope_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ScopeServiceServer).UpdateScope(ctx, req.(*UpdateScopeRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ScopeService_DeleteScope_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteScopeRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ScopeServiceServer).DeleteScope(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ScopeService_DeleteScope_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ScopeServiceServer).DeleteScope(ctx, req.(*DeleteScopeRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ScopeService_ListKeys_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListKeysRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ScopeServiceServer).ListKeys(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ScopeService_ListKeys_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ScopeServiceServer).ListKeys(ctx, req.(*ListKeysRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ScopeService_RotateKeys_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RotateKeysRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ScopeServiceServer).RotateKeys(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ScopeService_RotateKeys_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ScopeServiceServer).RotateKeys(ctx, req.(*RotateKeysRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ScopeService_ListKeyVersionDestructionJobs_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListKeyVersionDestructionJobsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ScopeServiceServer).ListKeyVersionDestructionJobs(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ScopeService_ListKeyVersionDestructionJobs_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ScopeServiceServer).ListKeyVersionDestructionJobs(ctx, req.(*ListKeyVersionDestructionJobsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ScopeService_DestroyKeyVersion_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DestroyKeyVersionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ScopeServiceServer).DestroyKeyVersion(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ScopeService_DestroyKeyVersion_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ScopeServiceServer).DestroyKeyVersion(ctx, req.(*DestroyKeyVersionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ScopeService_AttachStoragePolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AttachStoragePolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ScopeServiceServer).AttachStoragePolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ScopeService_AttachStoragePolicy_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ScopeServiceServer).AttachStoragePolicy(ctx, req.(*AttachStoragePolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ScopeService_DetachStoragePolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DetachStoragePolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ScopeServiceServer).DetachStoragePolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ScopeService_DetachStoragePolicy_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ScopeServiceServer).DetachStoragePolicy(ctx, req.(*DetachStoragePolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// ScopeService_ServiceDesc is the grpc.ServiceDesc for ScopeService service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var ScopeService_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "controller.api.services.v1.ScopeService",
	HandlerType: (*ScopeServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "GetScope",
			Handler:    _ScopeService_GetScope_Handler,
		},
		{
			MethodName: "ListScopes",
			Handler:    _ScopeService_ListScopes_Handler,
		},
		{
			MethodName: "CreateScope",
			Handler:    _ScopeService_CreateScope_Handler,
		},
		{
			MethodName: "UpdateScope",
			Handler:    _ScopeService_UpdateScope_Handler,
		},
		{
			MethodName: "DeleteScope",
			Handler:    _ScopeService_DeleteScope_Handler,
		},
		{
			MethodName: "ListKeys",
			Handler:    _ScopeService_ListKeys_Handler,
		},
		{
			MethodName: "RotateKeys",
			Handler:    _ScopeService_RotateKeys_Handler,
		},
		{
			MethodName: "ListKeyVersionDestructionJobs",
			Handler:    _ScopeService_ListKeyVersionDestructionJobs_Handler,
		},
		{
			MethodName: "DestroyKeyVersion",
			Handler:    _ScopeService_DestroyKeyVersion_Handler,
		},
		{
			MethodName: "AttachStoragePolicy",
			Handler:    _ScopeService_AttachStoragePolicy_Handler,
		},
		{
			MethodName: "DetachStoragePolicy",
			Handler:    _ScopeService_DetachStoragePolicy_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "controller/api/services/v1/scope_service.proto",
}
