// Copyright (c) HashiCorp, Inc.
// SPDX-License-Identifier: MPL-2.0

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.3.0
// - protoc             (unknown)
// source: controller/api/services/v1/role_service.proto

package services

import (
	context "context"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

const (
	RoleService_GetRole_FullMethodName               = "/controller.api.services.v1.RoleService/GetRole"
	RoleService_ListRoles_FullMethodName             = "/controller.api.services.v1.RoleService/ListRoles"
	RoleService_CreateRole_FullMethodName            = "/controller.api.services.v1.RoleService/CreateRole"
	RoleService_UpdateRole_FullMethodName            = "/controller.api.services.v1.RoleService/UpdateRole"
	RoleService_DeleteRole_FullMethodName            = "/controller.api.services.v1.RoleService/DeleteRole"
	RoleService_AddRolePrincipals_FullMethodName     = "/controller.api.services.v1.RoleService/AddRolePrincipals"
	RoleService_SetRolePrincipals_FullMethodName     = "/controller.api.services.v1.RoleService/SetRolePrincipals"
	RoleService_RemoveRolePrincipals_FullMethodName  = "/controller.api.services.v1.RoleService/RemoveRolePrincipals"
	RoleService_AddRoleGrants_FullMethodName         = "/controller.api.services.v1.RoleService/AddRoleGrants"
	RoleService_SetRoleGrants_FullMethodName         = "/controller.api.services.v1.RoleService/SetRoleGrants"
	RoleService_RemoveRoleGrants_FullMethodName      = "/controller.api.services.v1.RoleService/RemoveRoleGrants"
	RoleService_AddRoleGrantScopes_FullMethodName    = "/controller.api.services.v1.RoleService/AddRoleGrantScopes"
	RoleService_SetRoleGrantScopes_FullMethodName    = "/controller.api.services.v1.RoleService/SetRoleGrantScopes"
	RoleService_RemoveRoleGrantScopes_FullMethodName = "/controller.api.services.v1.RoleService/RemoveRoleGrantScopes"
)

// RoleServiceClient is the client API for RoleService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type RoleServiceClient interface {
	// GetRole returns a stored Role if present. The provided request must include
	// the Role ID for the Role being retrieved. If the ID is missing, malformed
	// or reference a non-existing resource an error is returned.
	GetRole(ctx context.Context, in *GetRoleRequest, opts ...grpc.CallOption) (*GetRoleResponse, error)
	// ListRoles returns a list of stored Roles which exist inside the scope
	// referenced inside the request. The request must include the scope ID for
	// the Roles being retrieved. If the scope ID is missing, malformed, or
	// reference a non-existing scope, an error is returned.
	ListRoles(ctx context.Context, in *ListRolesRequest, opts ...grpc.CallOption) (*ListRolesResponse, error)
	// CreateRole creates and stores a Role. The provided request must include the
	// scope ID in which the Role will be created. If the scope ID is missing,
	// malformed, or references a non-existing scope, an error is returned. If a
	// name is provided that is in use in another Role in the same scope, an error
	// is returned.
	CreateRole(ctx context.Context, in *CreateRoleRequest, opts ...grpc.CallOption) (*CreateRoleResponse, error)
	// UpdateRole updates an existing Role in boundary.  The provided
	// Role must not have any read-only fields set. The update mask must be
	// included in the request and contain at least 1 mutable field. To unset
	// a field's value, include the field in the update mask and don't set it
	// in the provided Role. An error is returned if either the scope
	// or Role IDs are missing or reference a non-existing resource. An error
	// is also returned if the request attempts to update the name to one that is
	// already in use in the same scope.
	UpdateRole(ctx context.Context, in *UpdateRoleRequest, opts ...grpc.CallOption) (*UpdateRoleResponse, error)
	// DeleteRole removes a Role from Boundary. If the provided scope or Role IDs
	// are malformed, or not provided an error is returned.
	DeleteRole(ctx context.Context, in *DeleteRoleRequest, opts ...grpc.CallOption) (*DeleteRoleResponse, error)
	// AddRolePrincipals adds users and/or groups to a Role. The provided request
	// must include the Role ID to which the users and/or groups will be added.
	// If the Role ID is missing, malformed, or reference non-existing resources,
	// an error is returned.  An error is also returned if the request attempts to
	// add a principal that is already part of the role.
	AddRolePrincipals(ctx context.Context, in *AddRolePrincipalsRequest, opts ...grpc.CallOption) (*AddRolePrincipalsResponse, error)
	// SetRolePrincipals sets the Role's users and/or groups. Any existing
	// principals on the Role are deleted if they are not included in this
	// request. The provided request must include the Role ID on
	// which the users and/or groups will be set. If the Role ID is
	// missing, malformed, or referencing a non-existing resource, an error is
	// returned.
	SetRolePrincipals(ctx context.Context, in *SetRolePrincipalsRequest, opts ...grpc.CallOption) (*SetRolePrincipalsResponse, error)
	// RemoveRolePrincipals removes the users and/or groups from the specified
	// Role. The provided request must include the Role ID from
	// which the users and/or groups will be removed. If that ID is missing,
	// malformed, or reference a non-existing resource, an error is returned.
	// An error is returned if a remove is called for a principal that is not
	// part of the role.
	RemoveRolePrincipals(ctx context.Context, in *RemoveRolePrincipalsRequest, opts ...grpc.CallOption) (*RemoveRolePrincipalsResponse, error)
	// AddRoleGrants adds grants to a Role. The provided request must include
	// the Role id which the grants will be added to. An error is returned
	// if the provided id is malformed or references a non-existing resource.
	AddRoleGrants(ctx context.Context, in *AddRoleGrantsRequest, opts ...grpc.CallOption) (*AddRoleGrantsResponse, error)
	// SetRoleGrants sets the Role's grants. Any existing grants on the Role are
	// deleted if they are not included in this request. The provided request must
	// include the Role ID on which the grants will be set. If missing, malformed,
	// or referencing a non-existing resource, an error is returned.
	SetRoleGrants(ctx context.Context, in *SetRoleGrantsRequest, opts ...grpc.CallOption) (*SetRoleGrantsResponse, error)
	// RemoveRoleGrants removes the grants from the specified Role.
	// The provided request must include the Role IDs from which the
	// grants will be removed. If missing, malformed, or references a non-existing
	// resource, an error is returned.
	RemoveRoleGrants(ctx context.Context, in *RemoveRoleGrantsRequest, opts ...grpc.CallOption) (*RemoveRoleGrantsResponse, error)
	// AddRoleGrantScopes adds grants scopes to a Role. The provided request must
	// include the Role id which the grant scopes will be added to. An error is
	// returned if the provided id is malformed or references a non-existing
	// resource.
	AddRoleGrantScopes(ctx context.Context, in *AddRoleGrantScopesRequest, opts ...grpc.CallOption) (*AddRoleGrantScopesResponse, error)
	// SetRoleGrants sets the Role's grant scopes. Any existing grant scopes on
	// the Role are deleted if they are not included in this request. The provided
	// request must include the Role ID on which the grants will be set. If
	// missing, malformed, or referencing a non-existing resource, an error is
	// returned.
	SetRoleGrantScopes(ctx context.Context, in *SetRoleGrantScopesRequest, opts ...grpc.CallOption) (*SetRoleGrantScopesResponse, error)
	// RemoveRoleGrantScopes removes the grant scopes from the specified Role. The
	// provided request must include the Role IDs from which the grants will be
	// removed. If missing, malformed, or references a non-existing resource, an
	// error is returned.
	RemoveRoleGrantScopes(ctx context.Context, in *RemoveRoleGrantScopesRequest, opts ...grpc.CallOption) (*RemoveRoleGrantScopesResponse, error)
}

type roleServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewRoleServiceClient(cc grpc.ClientConnInterface) RoleServiceClient {
	return &roleServiceClient{cc}
}

func (c *roleServiceClient) GetRole(ctx context.Context, in *GetRoleRequest, opts ...grpc.CallOption) (*GetRoleResponse, error) {
	out := new(GetRoleResponse)
	err := c.cc.Invoke(ctx, RoleService_GetRole_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *roleServiceClient) ListRoles(ctx context.Context, in *ListRolesRequest, opts ...grpc.CallOption) (*ListRolesResponse, error) {
	out := new(ListRolesResponse)
	err := c.cc.Invoke(ctx, RoleService_ListRoles_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *roleServiceClient) CreateRole(ctx context.Context, in *CreateRoleRequest, opts ...grpc.CallOption) (*CreateRoleResponse, error) {
	out := new(CreateRoleResponse)
	err := c.cc.Invoke(ctx, RoleService_CreateRole_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *roleServiceClient) UpdateRole(ctx context.Context, in *UpdateRoleRequest, opts ...grpc.CallOption) (*UpdateRoleResponse, error) {
	out := new(UpdateRoleResponse)
	err := c.cc.Invoke(ctx, RoleService_UpdateRole_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *roleServiceClient) DeleteRole(ctx context.Context, in *DeleteRoleRequest, opts ...grpc.CallOption) (*DeleteRoleResponse, error) {
	out := new(DeleteRoleResponse)
	err := c.cc.Invoke(ctx, RoleService_DeleteRole_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *roleServiceClient) AddRolePrincipals(ctx context.Context, in *AddRolePrincipalsRequest, opts ...grpc.CallOption) (*AddRolePrincipalsResponse, error) {
	out := new(AddRolePrincipalsResponse)
	err := c.cc.Invoke(ctx, RoleService_AddRolePrincipals_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *roleServiceClient) SetRolePrincipals(ctx context.Context, in *SetRolePrincipalsRequest, opts ...grpc.CallOption) (*SetRolePrincipalsResponse, error) {
	out := new(SetRolePrincipalsResponse)
	err := c.cc.Invoke(ctx, RoleService_SetRolePrincipals_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *roleServiceClient) RemoveRolePrincipals(ctx context.Context, in *RemoveRolePrincipalsRequest, opts ...grpc.CallOption) (*RemoveRolePrincipalsResponse, error) {
	out := new(RemoveRolePrincipalsResponse)
	err := c.cc.Invoke(ctx, RoleService_RemoveRolePrincipals_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *roleServiceClient) AddRoleGrants(ctx context.Context, in *AddRoleGrantsRequest, opts ...grpc.CallOption) (*AddRoleGrantsResponse, error) {
	out := new(AddRoleGrantsResponse)
	err := c.cc.Invoke(ctx, RoleService_AddRoleGrants_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *roleServiceClient) SetRoleGrants(ctx context.Context, in *SetRoleGrantsRequest, opts ...grpc.CallOption) (*SetRoleGrantsResponse, error) {
	out := new(SetRoleGrantsResponse)
	err := c.cc.Invoke(ctx, RoleService_SetRoleGrants_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *roleServiceClient) RemoveRoleGrants(ctx context.Context, in *RemoveRoleGrantsRequest, opts ...grpc.CallOption) (*RemoveRoleGrantsResponse, error) {
	out := new(RemoveRoleGrantsResponse)
	err := c.cc.Invoke(ctx, RoleService_RemoveRoleGrants_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *roleServiceClient) AddRoleGrantScopes(ctx context.Context, in *AddRoleGrantScopesRequest, opts ...grpc.CallOption) (*AddRoleGrantScopesResponse, error) {
	out := new(AddRoleGrantScopesResponse)
	err := c.cc.Invoke(ctx, RoleService_AddRoleGrantScopes_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *roleServiceClient) SetRoleGrantScopes(ctx context.Context, in *SetRoleGrantScopesRequest, opts ...grpc.CallOption) (*SetRoleGrantScopesResponse, error) {
	out := new(SetRoleGrantScopesResponse)
	err := c.cc.Invoke(ctx, RoleService_SetRoleGrantScopes_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *roleServiceClient) RemoveRoleGrantScopes(ctx context.Context, in *RemoveRoleGrantScopesRequest, opts ...grpc.CallOption) (*RemoveRoleGrantScopesResponse, error) {
	out := new(RemoveRoleGrantScopesResponse)
	err := c.cc.Invoke(ctx, RoleService_RemoveRoleGrantScopes_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// RoleServiceServer is the server API for RoleService service.
// All implementations must embed UnimplementedRoleServiceServer
// for forward compatibility
type RoleServiceServer interface {
	// GetRole returns a stored Role if present. The provided request must include
	// the Role ID for the Role being retrieved. If the ID is missing, malformed
	// or reference a non-existing resource an error is returned.
	GetRole(context.Context, *GetRoleRequest) (*GetRoleResponse, error)
	// ListRoles returns a list of stored Roles which exist inside the scope
	// referenced inside the request. The request must include the scope ID for
	// the Roles being retrieved. If the scope ID is missing, malformed, or
	// reference a non-existing scope, an error is returned.
	ListRoles(context.Context, *ListRolesRequest) (*ListRolesResponse, error)
	// CreateRole creates and stores a Role. The provided request must include the
	// scope ID in which the Role will be created. If the scope ID is missing,
	// malformed, or references a non-existing scope, an error is returned. If a
	// name is provided that is in use in another Role in the same scope, an error
	// is returned.
	CreateRole(context.Context, *CreateRoleRequest) (*CreateRoleResponse, error)
	// UpdateRole updates an existing Role in boundary.  The provided
	// Role must not have any read-only fields set. The update mask must be
	// included in the request and contain at least 1 mutable field. To unset
	// a field's value, include the field in the update mask and don't set it
	// in the provided Role. An error is returned if either the scope
	// or Role IDs are missing or reference a non-existing resource. An error
	// is also returned if the request attempts to update the name to one that is
	// already in use in the same scope.
	UpdateRole(context.Context, *UpdateRoleRequest) (*UpdateRoleResponse, error)
	// DeleteRole removes a Role from Boundary. If the provided scope or Role IDs
	// are malformed, or not provided an error is returned.
	DeleteRole(context.Context, *DeleteRoleRequest) (*DeleteRoleResponse, error)
	// AddRolePrincipals adds users and/or groups to a Role. The provided request
	// must include the Role ID to which the users and/or groups will be added.
	// If the Role ID is missing, malformed, or reference non-existing resources,
	// an error is returned.  An error is also returned if the request attempts to
	// add a principal that is already part of the role.
	AddRolePrincipals(context.Context, *AddRolePrincipalsRequest) (*AddRolePrincipalsResponse, error)
	// SetRolePrincipals sets the Role's users and/or groups. Any existing
	// principals on the Role are deleted if they are not included in this
	// request. The provided request must include the Role ID on
	// which the users and/or groups will be set. If the Role ID is
	// missing, malformed, or referencing a non-existing resource, an error is
	// returned.
	SetRolePrincipals(context.Context, *SetRolePrincipalsRequest) (*SetRolePrincipalsResponse, error)
	// RemoveRolePrincipals removes the users and/or groups from the specified
	// Role. The provided request must include the Role ID from
	// which the users and/or groups will be removed. If that ID is missing,
	// malformed, or reference a non-existing resource, an error is returned.
	// An error is returned if a remove is called for a principal that is not
	// part of the role.
	RemoveRolePrincipals(context.Context, *RemoveRolePrincipalsRequest) (*RemoveRolePrincipalsResponse, error)
	// AddRoleGrants adds grants to a Role. The provided request must include
	// the Role id which the grants will be added to. An error is returned
	// if the provided id is malformed or references a non-existing resource.
	AddRoleGrants(context.Context, *AddRoleGrantsRequest) (*AddRoleGrantsResponse, error)
	// SetRoleGrants sets the Role's grants. Any existing grants on the Role are
	// deleted if they are not included in this request. The provided request must
	// include the Role ID on which the grants will be set. If missing, malformed,
	// or referencing a non-existing resource, an error is returned.
	SetRoleGrants(context.Context, *SetRoleGrantsRequest) (*SetRoleGrantsResponse, error)
	// RemoveRoleGrants removes the grants from the specified Role.
	// The provided request must include the Role IDs from which the
	// grants will be removed. If missing, malformed, or references a non-existing
	// resource, an error is returned.
	RemoveRoleGrants(context.Context, *RemoveRoleGrantsRequest) (*RemoveRoleGrantsResponse, error)
	// AddRoleGrantScopes adds grants scopes to a Role. The provided request must
	// include the Role id which the grant scopes will be added to. An error is
	// returned if the provided id is malformed or references a non-existing
	// resource.
	AddRoleGrantScopes(context.Context, *AddRoleGrantScopesRequest) (*AddRoleGrantScopesResponse, error)
	// SetRoleGrants sets the Role's grant scopes. Any existing grant scopes on
	// the Role are deleted if they are not included in this request. The provided
	// request must include the Role ID on which the grants will be set. If
	// missing, malformed, or referencing a non-existing resource, an error is
	// returned.
	SetRoleGrantScopes(context.Context, *SetRoleGrantScopesRequest) (*SetRoleGrantScopesResponse, error)
	// RemoveRoleGrantScopes removes the grant scopes from the specified Role. The
	// provided request must include the Role IDs from which the grants will be
	// removed. If missing, malformed, or references a non-existing resource, an
	// error is returned.
	RemoveRoleGrantScopes(context.Context, *RemoveRoleGrantScopesRequest) (*RemoveRoleGrantScopesResponse, error)
	mustEmbedUnimplementedRoleServiceServer()
}

// UnimplementedRoleServiceServer must be embedded to have forward compatible implementations.
type UnimplementedRoleServiceServer struct {
}

func (UnimplementedRoleServiceServer) GetRole(context.Context, *GetRoleRequest) (*GetRoleResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetRole not implemented")
}
func (UnimplementedRoleServiceServer) ListRoles(context.Context, *ListRolesRequest) (*ListRolesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListRoles not implemented")
}
func (UnimplementedRoleServiceServer) CreateRole(context.Context, *CreateRoleRequest) (*CreateRoleResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateRole not implemented")
}
func (UnimplementedRoleServiceServer) UpdateRole(context.Context, *UpdateRoleRequest) (*UpdateRoleResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateRole not implemented")
}
func (UnimplementedRoleServiceServer) DeleteRole(context.Context, *DeleteRoleRequest) (*DeleteRoleResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteRole not implemented")
}
func (UnimplementedRoleServiceServer) AddRolePrincipals(context.Context, *AddRolePrincipalsRequest) (*AddRolePrincipalsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method AddRolePrincipals not implemented")
}
func (UnimplementedRoleServiceServer) SetRolePrincipals(context.Context, *SetRolePrincipalsRequest) (*SetRolePrincipalsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SetRolePrincipals not implemented")
}
func (UnimplementedRoleServiceServer) RemoveRolePrincipals(context.Context, *RemoveRolePrincipalsRequest) (*RemoveRolePrincipalsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method RemoveRolePrincipals not implemented")
}
func (UnimplementedRoleServiceServer) AddRoleGrants(context.Context, *AddRoleGrantsRequest) (*AddRoleGrantsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method AddRoleGrants not implemented")
}
func (UnimplementedRoleServiceServer) SetRoleGrants(context.Context, *SetRoleGrantsRequest) (*SetRoleGrantsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SetRoleGrants not implemented")
}
func (UnimplementedRoleServiceServer) RemoveRoleGrants(context.Context, *RemoveRoleGrantsRequest) (*RemoveRoleGrantsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method RemoveRoleGrants not implemented")
}
func (UnimplementedRoleServiceServer) AddRoleGrantScopes(context.Context, *AddRoleGrantScopesRequest) (*AddRoleGrantScopesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method AddRoleGrantScopes not implemented")
}
func (UnimplementedRoleServiceServer) SetRoleGrantScopes(context.Context, *SetRoleGrantScopesRequest) (*SetRoleGrantScopesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SetRoleGrantScopes not implemented")
}
func (UnimplementedRoleServiceServer) RemoveRoleGrantScopes(context.Context, *RemoveRoleGrantScopesRequest) (*RemoveRoleGrantScopesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method RemoveRoleGrantScopes not implemented")
}
func (UnimplementedRoleServiceServer) mustEmbedUnimplementedRoleServiceServer() {}

// UnsafeRoleServiceServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to RoleServiceServer will
// result in compilation errors.
type UnsafeRoleServiceServer interface {
	mustEmbedUnimplementedRoleServiceServer()
}

func RegisterRoleServiceServer(s grpc.ServiceRegistrar, srv RoleServiceServer) {
	s.RegisterService(&RoleService_ServiceDesc, srv)
}

func _RoleService_GetRole_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetRoleRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RoleServiceServer).GetRole(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: RoleService_GetRole_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RoleServiceServer).GetRole(ctx, req.(*GetRoleRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RoleService_ListRoles_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListRolesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RoleServiceServer).ListRoles(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: RoleService_ListRoles_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RoleServiceServer).ListRoles(ctx, req.(*ListRolesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RoleService_CreateRole_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateRoleRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RoleServiceServer).CreateRole(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: RoleService_CreateRole_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RoleServiceServer).CreateRole(ctx, req.(*CreateRoleRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RoleService_UpdateRole_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateRoleRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RoleServiceServer).UpdateRole(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: RoleService_UpdateRole_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RoleServiceServer).UpdateRole(ctx, req.(*UpdateRoleRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RoleService_DeleteRole_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteRoleRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RoleServiceServer).DeleteRole(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: RoleService_DeleteRole_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RoleServiceServer).DeleteRole(ctx, req.(*DeleteRoleRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RoleService_AddRolePrincipals_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AddRolePrincipalsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RoleServiceServer).AddRolePrincipals(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: RoleService_AddRolePrincipals_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RoleServiceServer).AddRolePrincipals(ctx, req.(*AddRolePrincipalsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RoleService_SetRolePrincipals_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SetRolePrincipalsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RoleServiceServer).SetRolePrincipals(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: RoleService_SetRolePrincipals_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RoleServiceServer).SetRolePrincipals(ctx, req.(*SetRolePrincipalsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RoleService_RemoveRolePrincipals_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RemoveRolePrincipalsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RoleServiceServer).RemoveRolePrincipals(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: RoleService_RemoveRolePrincipals_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RoleServiceServer).RemoveRolePrincipals(ctx, req.(*RemoveRolePrincipalsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RoleService_AddRoleGrants_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AddRoleGrantsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RoleServiceServer).AddRoleGrants(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: RoleService_AddRoleGrants_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RoleServiceServer).AddRoleGrants(ctx, req.(*AddRoleGrantsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RoleService_SetRoleGrants_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SetRoleGrantsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RoleServiceServer).SetRoleGrants(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: RoleService_SetRoleGrants_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RoleServiceServer).SetRoleGrants(ctx, req.(*SetRoleGrantsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RoleService_RemoveRoleGrants_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RemoveRoleGrantsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RoleServiceServer).RemoveRoleGrants(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: RoleService_RemoveRoleGrants_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RoleServiceServer).RemoveRoleGrants(ctx, req.(*RemoveRoleGrantsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RoleService_AddRoleGrantScopes_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AddRoleGrantScopesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RoleServiceServer).AddRoleGrantScopes(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: RoleService_AddRoleGrantScopes_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RoleServiceServer).AddRoleGrantScopes(ctx, req.(*AddRoleGrantScopesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RoleService_SetRoleGrantScopes_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SetRoleGrantScopesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RoleServiceServer).SetRoleGrantScopes(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: RoleService_SetRoleGrantScopes_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RoleServiceServer).SetRoleGrantScopes(ctx, req.(*SetRoleGrantScopesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RoleService_RemoveRoleGrantScopes_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RemoveRoleGrantScopesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RoleServiceServer).RemoveRoleGrantScopes(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: RoleService_RemoveRoleGrantScopes_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RoleServiceServer).RemoveRoleGrantScopes(ctx, req.(*RemoveRoleGrantScopesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// RoleService_ServiceDesc is the grpc.ServiceDesc for RoleService service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var RoleService_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "controller.api.services.v1.RoleService",
	HandlerType: (*RoleServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "GetRole",
			Handler:    _RoleService_GetRole_Handler,
		},
		{
			MethodName: "ListRoles",
			Handler:    _RoleService_ListRoles_Handler,
		},
		{
			MethodName: "CreateRole",
			Handler:    _RoleService_CreateRole_Handler,
		},
		{
			MethodName: "UpdateRole",
			Handler:    _RoleService_UpdateRole_Handler,
		},
		{
			MethodName: "DeleteRole",
			Handler:    _RoleService_DeleteRole_Handler,
		},
		{
			MethodName: "AddRolePrincipals",
			Handler:    _RoleService_AddRolePrincipals_Handler,
		},
		{
			MethodName: "SetRolePrincipals",
			Handler:    _RoleService_SetRolePrincipals_Handler,
		},
		{
			MethodName: "RemoveRolePrincipals",
			Handler:    _RoleService_RemoveRolePrincipals_Handler,
		},
		{
			MethodName: "AddRoleGrants",
			Handler:    _RoleService_AddRoleGrants_Handler,
		},
		{
			MethodName: "SetRoleGrants",
			Handler:    _RoleService_SetRoleGrants_Handler,
		},
		{
			MethodName: "RemoveRoleGrants",
			Handler:    _RoleService_RemoveRoleGrants_Handler,
		},
		{
			MethodName: "AddRoleGrantScopes",
			Handler:    _RoleService_AddRoleGrantScopes_Handler,
		},
		{
			MethodName: "SetRoleGrantScopes",
			Handler:    _RoleService_SetRoleGrantScopes_Handler,
		},
		{
			MethodName: "RemoveRoleGrantScopes",
			Handler:    _RoleService_RemoveRoleGrantScopes_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "controller/api/services/v1/role_service.proto",
}
