// Copyright (c) HashiCorp, Inc.
// SPDX-License-Identifier: MPL-2.0

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.34.2
// 	protoc        (unknown)
// source: controller/api/services/v1/list.proto

package services

import (
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// ResourceType represents the different list
// endpoint resource types supported.
type ResourceType int32

const (
	ResourceType_RESOURCE_TYPE_UNSPECIFIED        ResourceType = 0
	ResourceType_RESOURCE_TYPE_ACCOUNT            ResourceType = 1
	ResourceType_RESOURCE_TYPE_AUTH_METHOD        ResourceType = 2
	ResourceType_RESOURCE_TYPE_AUTH_TOKEN         ResourceType = 3
	ResourceType_RESOURCE_TYPE_CREDENTIAL         ResourceType = 4
	ResourceType_RESOURCE_TYPE_CREDENTIAL_LIBRARY ResourceType = 5
	ResourceType_RESOURCE_TYPE_CREDENTIAL_STORE   ResourceType = 6
	ResourceType_RESOURCE_TYPE_GROUP              ResourceType = 7
	ResourceType_RESOURCE_TYPE_HOST               ResourceType = 8
	ResourceType_RESOURCE_TYPE_HOST_CATALOG       ResourceType = 9
	ResourceType_RESOURCE_TYPE_HOST_SET           ResourceType = 10
	ResourceType_RESOURCE_TYPE_MANAGED_GROUP      ResourceType = 11
	ResourceType_RESOURCE_TYPE_ROLE               ResourceType = 12
	ResourceType_RESOURCE_TYPE_SCOPE              ResourceType = 13
	ResourceType_RESOURCE_TYPE_SESSION            ResourceType = 14
	ResourceType_RESOURCE_TYPE_SESSION_RECORDING  ResourceType = 15
	ResourceType_RESOURCE_TYPE_STORAGE_BUCKET     ResourceType = 16
	ResourceType_RESOURCE_TYPE_TARGET             ResourceType = 17
	ResourceType_RESOURCE_TYPE_USER               ResourceType = 18
	ResourceType_RESOURCE_TYPE_WORKER             ResourceType = 19
	ResourceType_RESOURCE_TYPE_POLICY             ResourceType = 20
	ResourceType_RESOURCE_TYPE_ALIAS              ResourceType = 21
)

// Enum value maps for ResourceType.
var (
	ResourceType_name = map[int32]string{
		0:  "RESOURCE_TYPE_UNSPECIFIED",
		1:  "RESOURCE_TYPE_ACCOUNT",
		2:  "RESOURCE_TYPE_AUTH_METHOD",
		3:  "RESOURCE_TYPE_AUTH_TOKEN",
		4:  "RESOURCE_TYPE_CREDENTIAL",
		5:  "RESOURCE_TYPE_CREDENTIAL_LIBRARY",
		6:  "RESOURCE_TYPE_CREDENTIAL_STORE",
		7:  "RESOURCE_TYPE_GROUP",
		8:  "RESOURCE_TYPE_HOST",
		9:  "RESOURCE_TYPE_HOST_CATALOG",
		10: "RESOURCE_TYPE_HOST_SET",
		11: "RESOURCE_TYPE_MANAGED_GROUP",
		12: "RESOURCE_TYPE_ROLE",
		13: "RESOURCE_TYPE_SCOPE",
		14: "RESOURCE_TYPE_SESSION",
		15: "RESOURCE_TYPE_SESSION_RECORDING",
		16: "RESOURCE_TYPE_STORAGE_BUCKET",
		17: "RESOURCE_TYPE_TARGET",
		18: "RESOURCE_TYPE_USER",
		19: "RESOURCE_TYPE_WORKER",
		20: "RESOURCE_TYPE_POLICY",
		21: "RESOURCE_TYPE_ALIAS",
	}
	ResourceType_value = map[string]int32{
		"RESOURCE_TYPE_UNSPECIFIED":        0,
		"RESOURCE_TYPE_ACCOUNT":            1,
		"RESOURCE_TYPE_AUTH_METHOD":        2,
		"RESOURCE_TYPE_AUTH_TOKEN":         3,
		"RESOURCE_TYPE_CREDENTIAL":         4,
		"RESOURCE_TYPE_CREDENTIAL_LIBRARY": 5,
		"RESOURCE_TYPE_CREDENTIAL_STORE":   6,
		"RESOURCE_TYPE_GROUP":              7,
		"RESOURCE_TYPE_HOST":               8,
		"RESOURCE_TYPE_HOST_CATALOG":       9,
		"RESOURCE_TYPE_HOST_SET":           10,
		"RESOURCE_TYPE_MANAGED_GROUP":      11,
		"RESOURCE_TYPE_ROLE":               12,
		"RESOURCE_TYPE_SCOPE":              13,
		"RESOURCE_TYPE_SESSION":            14,
		"RESOURCE_TYPE_SESSION_RECORDING":  15,
		"RESOURCE_TYPE_STORAGE_BUCKET":     16,
		"RESOURCE_TYPE_TARGET":             17,
		"RESOURCE_TYPE_USER":               18,
		"RESOURCE_TYPE_WORKER":             19,
		"RESOURCE_TYPE_POLICY":             20,
		"RESOURCE_TYPE_ALIAS":              21,
	}
)

func (x ResourceType) Enum() *ResourceType {
	p := new(ResourceType)
	*p = x
	return p
}

func (x ResourceType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ResourceType) Descriptor() protoreflect.EnumDescriptor {
	return file_controller_api_services_v1_list_proto_enumTypes[0].Descriptor()
}

func (ResourceType) Type() protoreflect.EnumType {
	return &file_controller_api_services_v1_list_proto_enumTypes[0]
}

func (x ResourceType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ResourceType.Descriptor instead.
func (ResourceType) EnumDescriptor() ([]byte, []int) {
	return file_controller_api_services_v1_list_proto_rawDescGZIP(), []int{0}
}

// ListToken is used to maintain state
// between list endpoint invocations. It
// is never exposed to the user directly,
// only in its marshaled form.
type ListToken struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// when the token was created
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,1,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// the resource type listed
	ResourceType ResourceType `protobuf:"varint,2,opt,name=resource_type,json=resourceType,proto3,enum=controller.api.services.v1.ResourceType" json:"resource_type,omitempty"`
	// A hash of the users permissions
	// at the time of the token issuing.
	GrantsHash []byte `protobuf:"bytes,3,opt,name=grants_hash,json=grantsHash,proto3" json:"grants_hash,omitempty"`
	// The subtype of the token. It changes
	// between different stages of the pagination.
	//
	// Types that are assignable to Token:
	//
	//	*ListToken_PaginationToken
	//	*ListToken_StartRefreshToken
	//	*ListToken_RefreshToken
	Token isListToken_Token `protobuf_oneof:"token"`
}

func (x *ListToken) Reset() {
	*x = ListToken{}
	if protoimpl.UnsafeEnabled {
		mi := &file_controller_api_services_v1_list_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListToken) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListToken) ProtoMessage() {}

func (x *ListToken) ProtoReflect() protoreflect.Message {
	mi := &file_controller_api_services_v1_list_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListToken.ProtoReflect.Descriptor instead.
func (*ListToken) Descriptor() ([]byte, []int) {
	return file_controller_api_services_v1_list_proto_rawDescGZIP(), []int{0}
}

func (x *ListToken) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *ListToken) GetResourceType() ResourceType {
	if x != nil {
		return x.ResourceType
	}
	return ResourceType_RESOURCE_TYPE_UNSPECIFIED
}

func (x *ListToken) GetGrantsHash() []byte {
	if x != nil {
		return x.GrantsHash
	}
	return nil
}

func (m *ListToken) GetToken() isListToken_Token {
	if m != nil {
		return m.Token
	}
	return nil
}

func (x *ListToken) GetPaginationToken() *PaginationToken {
	if x, ok := x.GetToken().(*ListToken_PaginationToken); ok {
		return x.PaginationToken
	}
	return nil
}

func (x *ListToken) GetStartRefreshToken() *StartRefreshToken {
	if x, ok := x.GetToken().(*ListToken_StartRefreshToken); ok {
		return x.StartRefreshToken
	}
	return nil
}

func (x *ListToken) GetRefreshToken() *RefreshToken {
	if x, ok := x.GetToken().(*ListToken_RefreshToken); ok {
		return x.RefreshToken
	}
	return nil
}

type isListToken_Token interface {
	isListToken_Token()
}

type ListToken_PaginationToken struct {
	// Set for any responses from the initial pagination phase,
	// except the last.
	PaginationToken *PaginationToken `protobuf:"bytes,4,opt,name=pagination_token,json=paginationToken,proto3,oneof"`
}

type ListToken_StartRefreshToken struct {
	// Set for the final response of either phase to indicate the next request
	// will be a new refresh pagination phase.
	StartRefreshToken *StartRefreshToken `protobuf:"bytes,5,opt,name=start_refresh_token,json=startRefreshToken,proto3,oneof"`
}

type ListToken_RefreshToken struct {
	// Set in any response from a refresh phase pagination,
	// except the last.
	RefreshToken *RefreshToken `protobuf:"bytes,6,opt,name=refresh_token,json=refreshToken,proto3,oneof"`
}

func (*ListToken_PaginationToken) isListToken_Token() {}

func (*ListToken_StartRefreshToken) isListToken_Token() {}

func (*ListToken_RefreshToken) isListToken_Token() {}

// PaginationToken describes the list token subtype
// used during the initial pagination phase.
type PaginationToken struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The public ID of the last item that was included
	// in the page which this token was returned with.
	LastItemId string `protobuf:"bytes,1,opt,name=last_item_id,json=lastItemId,proto3" json:"last_item_id,omitempty"`
	// The create time of the last item that was included
	// in the page which this token was returned with.
	LastItemCreateTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=last_item_create_time,json=lastItemCreateTime,proto3" json:"last_item_create_time,omitempty"`
}

func (x *PaginationToken) Reset() {
	*x = PaginationToken{}
	if protoimpl.UnsafeEnabled {
		mi := &file_controller_api_services_v1_list_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PaginationToken) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PaginationToken) ProtoMessage() {}

func (x *PaginationToken) ProtoReflect() protoreflect.Message {
	mi := &file_controller_api_services_v1_list_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PaginationToken.ProtoReflect.Descriptor instead.
func (*PaginationToken) Descriptor() ([]byte, []int) {
	return file_controller_api_services_v1_list_proto_rawDescGZIP(), []int{1}
}

func (x *PaginationToken) GetLastItemId() string {
	if x != nil {
		return x.LastItemId
	}
	return ""
}

func (x *PaginationToken) GetLastItemCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.LastItemCreateTime
	}
	return nil
}

// StartRefreshToken describes the list token subtype
// used at the end of any pagination phase, both the
// initial and any refresh phases.
type StartRefreshToken struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The end time of the phase previous to this one,
	// which should be used as the lower bound for the
	// new refresh phase.
	PreviousPhaseUpperBound *timestamppb.Timestamp `protobuf:"bytes,1,opt,name=previous_phase_upper_bound,json=previousPhaseUpperBound,proto3" json:"previous_phase_upper_bound,omitempty"`
	// The timestamp of the transaction that last listed the deleted IDs,
	// for use as a lower bound in the next deleted IDs list.
	PreviousDeletedIdsTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=previous_deleted_ids_time,json=previousDeletedIdsTime,proto3" json:"previous_deleted_ids_time,omitempty"`
}

func (x *StartRefreshToken) Reset() {
	*x = StartRefreshToken{}
	if protoimpl.UnsafeEnabled {
		mi := &file_controller_api_services_v1_list_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *StartRefreshToken) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StartRefreshToken) ProtoMessage() {}

func (x *StartRefreshToken) ProtoReflect() protoreflect.Message {
	mi := &file_controller_api_services_v1_list_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StartRefreshToken.ProtoReflect.Descriptor instead.
func (*StartRefreshToken) Descriptor() ([]byte, []int) {
	return file_controller_api_services_v1_list_proto_rawDescGZIP(), []int{2}
}

func (x *StartRefreshToken) GetPreviousPhaseUpperBound() *timestamppb.Timestamp {
	if x != nil {
		return x.PreviousPhaseUpperBound
	}
	return nil
}

func (x *StartRefreshToken) GetPreviousDeletedIdsTime() *timestamppb.Timestamp {
	if x != nil {
		return x.PreviousDeletedIdsTime
	}
	return nil
}

// RefreshToken describes the list token subtype used
// between pages in a refresh pagination phase.
type RefreshToken struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The upper bound for the timestamp comparisons in
	// this refresh phase. This is equal to the time that
	// the first request in this phase was processed.
	// Constant for the lifetime of the refresh phase.
	PhaseUpperBound *timestamppb.Timestamp `protobuf:"bytes,1,opt,name=phase_upper_bound,json=phaseUpperBound,proto3" json:"phase_upper_bound,omitempty"`
	// The lower bound for the timestamp comparisons in
	// this refresh phase. This is equal to the initial
	// create time of the token if the previous phase was
	// the initial pagination phase, or the upper bound of
	// the previous refresh phase otherwise.
	// Constant for the lifetime of the refresh phase.
	PhaseLowerBound *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=phase_lower_bound,json=phaseLowerBound,proto3" json:"phase_lower_bound,omitempty"`
	// The timestamp of the transaction that last listed the deleted IDs,
	// for use as a lower bound in the next deleted IDs list.
	PreviousDeletedIdsTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=previous_deleted_ids_time,json=previousDeletedIdsTime,proto3" json:"previous_deleted_ids_time,omitempty"`
	// The public ID of the last item that was included
	// in the page which this token was returned with.
	LastItemId string `protobuf:"bytes,4,opt,name=last_item_id,json=lastItemId,proto3" json:"last_item_id,omitempty"`
	// The update time of the last item that was included
	// in the page which this token was returned with.
	LastItemUpdateTime *timestamppb.Timestamp `protobuf:"bytes,5,opt,name=last_item_update_time,json=lastItemUpdateTime,proto3" json:"last_item_update_time,omitempty"`
}

func (x *RefreshToken) Reset() {
	*x = RefreshToken{}
	if protoimpl.UnsafeEnabled {
		mi := &file_controller_api_services_v1_list_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RefreshToken) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RefreshToken) ProtoMessage() {}

func (x *RefreshToken) ProtoReflect() protoreflect.Message {
	mi := &file_controller_api_services_v1_list_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RefreshToken.ProtoReflect.Descriptor instead.
func (*RefreshToken) Descriptor() ([]byte, []int) {
	return file_controller_api_services_v1_list_proto_rawDescGZIP(), []int{3}
}

func (x *RefreshToken) GetPhaseUpperBound() *timestamppb.Timestamp {
	if x != nil {
		return x.PhaseUpperBound
	}
	return nil
}

func (x *RefreshToken) GetPhaseLowerBound() *timestamppb.Timestamp {
	if x != nil {
		return x.PhaseLowerBound
	}
	return nil
}

func (x *RefreshToken) GetPreviousDeletedIdsTime() *timestamppb.Timestamp {
	if x != nil {
		return x.PreviousDeletedIdsTime
	}
	return nil
}

func (x *RefreshToken) GetLastItemId() string {
	if x != nil {
		return x.LastItemId
	}
	return ""
}

func (x *RefreshToken) GetLastItemUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.LastItemUpdateTime
	}
	return nil
}

var File_controller_api_services_v1_list_proto protoreflect.FileDescriptor

var file_controller_api_services_v1_list_proto_rawDesc = []byte{
	0x0a, 0x25, 0x63, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x6c, 0x65, 0x72, 0x2f, 0x61, 0x70, 0x69,
	0x2f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2f, 0x76, 0x31, 0x2f, 0x6c, 0x69, 0x73,
	0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x1a, 0x63, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c,
	0x6c, 0x65, 0x72, 0x2e, 0x61, 0x70, 0x69, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73,
	0x2e, 0x76, 0x31, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x22, 0xcd, 0x03, 0x0a, 0x09, 0x4c, 0x69, 0x73, 0x74, 0x54, 0x6f, 0x6b,
	0x65, 0x6e, 0x12, 0x3b, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74,
	0x61, 0x6d, 0x70, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12,
	0x4d, 0x0a, 0x0d, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x74, 0x79, 0x70, 0x65,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x28, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c,
	0x6c, 0x65, 0x72, 0x2e, 0x61, 0x70, 0x69, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73,
	0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x54, 0x79, 0x70, 0x65,
	0x52, 0x0c, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x54, 0x79, 0x70, 0x65, 0x12, 0x1f,
	0x0a, 0x0b, 0x67, 0x72, 0x61, 0x6e, 0x74, 0x73, 0x5f, 0x68, 0x61, 0x73, 0x68, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x0c, 0x52, 0x0a, 0x67, 0x72, 0x61, 0x6e, 0x74, 0x73, 0x48, 0x61, 0x73, 0x68, 0x12,
	0x58, 0x0a, 0x10, 0x70, 0x61, 0x67, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x74, 0x6f,
	0x6b, 0x65, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x63, 0x6f, 0x6e, 0x74,
	0x72, 0x6f, 0x6c, 0x6c, 0x65, 0x72, 0x2e, 0x61, 0x70, 0x69, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69,
	0x63, 0x65, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x61, 0x67, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x48, 0x00, 0x52, 0x0f, 0x70, 0x61, 0x67, 0x69, 0x6e, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x5f, 0x0a, 0x13, 0x73, 0x74, 0x61,
	0x72, 0x74, 0x5f, 0x72, 0x65, 0x66, 0x72, 0x65, 0x73, 0x68, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e,
	0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c,
	0x6c, 0x65, 0x72, 0x2e, 0x61, 0x70, 0x69, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73,
	0x2e, 0x76, 0x31, 0x2e, 0x53, 0x74, 0x61, 0x72, 0x74, 0x52, 0x65, 0x66, 0x72, 0x65, 0x73, 0x68,
	0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x48, 0x00, 0x52, 0x11, 0x73, 0x74, 0x61, 0x72, 0x74, 0x52, 0x65,
	0x66, 0x72, 0x65, 0x73, 0x68, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x4f, 0x0a, 0x0d, 0x72, 0x65,
	0x66, 0x72, 0x65, 0x73, 0x68, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x06, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x28, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x6c, 0x65, 0x72, 0x2e, 0x61,
	0x70, 0x69, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x52,
	0x65, 0x66, 0x72, 0x65, 0x73, 0x68, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x48, 0x00, 0x52, 0x0c, 0x72,
	0x65, 0x66, 0x72, 0x65, 0x73, 0x68, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x42, 0x07, 0x0a, 0x05, 0x74,
	0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x82, 0x01, 0x0a, 0x0f, 0x50, 0x61, 0x67, 0x69, 0x6e, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x20, 0x0a, 0x0c, 0x6c, 0x61, 0x73, 0x74,
	0x5f, 0x69, 0x74, 0x65, 0x6d, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a,
	0x6c, 0x61, 0x73, 0x74, 0x49, 0x74, 0x65, 0x6d, 0x49, 0x64, 0x12, 0x4d, 0x0a, 0x15, 0x6c, 0x61,
	0x73, 0x74, 0x5f, 0x69, 0x74, 0x65, 0x6d, 0x5f, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74,
	0x69, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65,
	0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x12, 0x6c, 0x61, 0x73, 0x74, 0x49, 0x74, 0x65, 0x6d, 0x43,
	0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x22, 0xc3, 0x01, 0x0a, 0x11, 0x53, 0x74,
	0x61, 0x72, 0x74, 0x52, 0x65, 0x66, 0x72, 0x65, 0x73, 0x68, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12,
	0x57, 0x0a, 0x1a, 0x70, 0x72, 0x65, 0x76, 0x69, 0x6f, 0x75, 0x73, 0x5f, 0x70, 0x68, 0x61, 0x73,
	0x65, 0x5f, 0x75, 0x70, 0x70, 0x65, 0x72, 0x5f, 0x62, 0x6f, 0x75, 0x6e, 0x64, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52,
	0x17, 0x70, 0x72, 0x65, 0x76, 0x69, 0x6f, 0x75, 0x73, 0x50, 0x68, 0x61, 0x73, 0x65, 0x55, 0x70,
	0x70, 0x65, 0x72, 0x42, 0x6f, 0x75, 0x6e, 0x64, 0x12, 0x55, 0x0a, 0x19, 0x70, 0x72, 0x65, 0x76,
	0x69, 0x6f, 0x75, 0x73, 0x5f, 0x64, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x64, 0x5f, 0x69, 0x64, 0x73,
	0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69,
	0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x16, 0x70, 0x72, 0x65, 0x76, 0x69, 0x6f, 0x75,
	0x73, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x64, 0x49, 0x64, 0x73, 0x54, 0x69, 0x6d, 0x65, 0x22,
	0xe6, 0x02, 0x0a, 0x0c, 0x52, 0x65, 0x66, 0x72, 0x65, 0x73, 0x68, 0x54, 0x6f, 0x6b, 0x65, 0x6e,
	0x12, 0x46, 0x0a, 0x11, 0x70, 0x68, 0x61, 0x73, 0x65, 0x5f, 0x75, 0x70, 0x70, 0x65, 0x72, 0x5f,
	0x62, 0x6f, 0x75, 0x6e, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69,
	0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0f, 0x70, 0x68, 0x61, 0x73, 0x65, 0x55, 0x70,
	0x70, 0x65, 0x72, 0x42, 0x6f, 0x75, 0x6e, 0x64, 0x12, 0x46, 0x0a, 0x11, 0x70, 0x68, 0x61, 0x73,
	0x65, 0x5f, 0x6c, 0x6f, 0x77, 0x65, 0x72, 0x5f, 0x62, 0x6f, 0x75, 0x6e, 0x64, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52,
	0x0f, 0x70, 0x68, 0x61, 0x73, 0x65, 0x4c, 0x6f, 0x77, 0x65, 0x72, 0x42, 0x6f, 0x75, 0x6e, 0x64,
	0x12, 0x55, 0x0a, 0x19, 0x70, 0x72, 0x65, 0x76, 0x69, 0x6f, 0x75, 0x73, 0x5f, 0x64, 0x65, 0x6c,
	0x65, 0x74, 0x65, 0x64, 0x5f, 0x69, 0x64, 0x73, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52,
	0x16, 0x70, 0x72, 0x65, 0x76, 0x69, 0x6f, 0x75, 0x73, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x64,
	0x49, 0x64, 0x73, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x20, 0x0a, 0x0c, 0x6c, 0x61, 0x73, 0x74, 0x5f,
	0x69, 0x74, 0x65, 0x6d, 0x5f, 0x69, 0x64, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x6c,
	0x61, 0x73, 0x74, 0x49, 0x74, 0x65, 0x6d, 0x49, 0x64, 0x12, 0x4d, 0x0a, 0x15, 0x6c, 0x61, 0x73,
	0x74, 0x5f, 0x69, 0x74, 0x65, 0x6d, 0x5f, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69,
	0x6d, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73,
	0x74, 0x61, 0x6d, 0x70, 0x52, 0x12, 0x6c, 0x61, 0x73, 0x74, 0x49, 0x74, 0x65, 0x6d, 0x55, 0x70,
	0x64, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x2a, 0x8d, 0x05, 0x0a, 0x0c, 0x52, 0x65, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x54, 0x79, 0x70, 0x65, 0x12, 0x1d, 0x0a, 0x19, 0x52, 0x45, 0x53,
	0x4f, 0x55, 0x52, 0x43, 0x45, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45,
	0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x19, 0x0a, 0x15, 0x52, 0x45, 0x53, 0x4f,
	0x55, 0x52, 0x43, 0x45, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x41, 0x43, 0x43, 0x4f, 0x55, 0x4e,
	0x54, 0x10, 0x01, 0x12, 0x1d, 0x0a, 0x19, 0x52, 0x45, 0x53, 0x4f, 0x55, 0x52, 0x43, 0x45, 0x5f,
	0x54, 0x59, 0x50, 0x45, 0x5f, 0x41, 0x55, 0x54, 0x48, 0x5f, 0x4d, 0x45, 0x54, 0x48, 0x4f, 0x44,
	0x10, 0x02, 0x12, 0x1c, 0x0a, 0x18, 0x52, 0x45, 0x53, 0x4f, 0x55, 0x52, 0x43, 0x45, 0x5f, 0x54,
	0x59, 0x50, 0x45, 0x5f, 0x41, 0x55, 0x54, 0x48, 0x5f, 0x54, 0x4f, 0x4b, 0x45, 0x4e, 0x10, 0x03,
	0x12, 0x1c, 0x0a, 0x18, 0x52, 0x45, 0x53, 0x4f, 0x55, 0x52, 0x43, 0x45, 0x5f, 0x54, 0x59, 0x50,
	0x45, 0x5f, 0x43, 0x52, 0x45, 0x44, 0x45, 0x4e, 0x54, 0x49, 0x41, 0x4c, 0x10, 0x04, 0x12, 0x24,
	0x0a, 0x20, 0x52, 0x45, 0x53, 0x4f, 0x55, 0x52, 0x43, 0x45, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f,
	0x43, 0x52, 0x45, 0x44, 0x45, 0x4e, 0x54, 0x49, 0x41, 0x4c, 0x5f, 0x4c, 0x49, 0x42, 0x52, 0x41,
	0x52, 0x59, 0x10, 0x05, 0x12, 0x22, 0x0a, 0x1e, 0x52, 0x45, 0x53, 0x4f, 0x55, 0x52, 0x43, 0x45,
	0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x43, 0x52, 0x45, 0x44, 0x45, 0x4e, 0x54, 0x49, 0x41, 0x4c,
	0x5f, 0x53, 0x54, 0x4f, 0x52, 0x45, 0x10, 0x06, 0x12, 0x17, 0x0a, 0x13, 0x52, 0x45, 0x53, 0x4f,
	0x55, 0x52, 0x43, 0x45, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x47, 0x52, 0x4f, 0x55, 0x50, 0x10,
	0x07, 0x12, 0x16, 0x0a, 0x12, 0x52, 0x45, 0x53, 0x4f, 0x55, 0x52, 0x43, 0x45, 0x5f, 0x54, 0x59,
	0x50, 0x45, 0x5f, 0x48, 0x4f, 0x53, 0x54, 0x10, 0x08, 0x12, 0x1e, 0x0a, 0x1a, 0x52, 0x45, 0x53,
	0x4f, 0x55, 0x52, 0x43, 0x45, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x48, 0x4f, 0x53, 0x54, 0x5f,
	0x43, 0x41, 0x54, 0x41, 0x4c, 0x4f, 0x47, 0x10, 0x09, 0x12, 0x1a, 0x0a, 0x16, 0x52, 0x45, 0x53,
	0x4f, 0x55, 0x52, 0x43, 0x45, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x48, 0x4f, 0x53, 0x54, 0x5f,
	0x53, 0x45, 0x54, 0x10, 0x0a, 0x12, 0x1f, 0x0a, 0x1b, 0x52, 0x45, 0x53, 0x4f, 0x55, 0x52, 0x43,
	0x45, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x4d, 0x41, 0x4e, 0x41, 0x47, 0x45, 0x44, 0x5f, 0x47,
	0x52, 0x4f, 0x55, 0x50, 0x10, 0x0b, 0x12, 0x16, 0x0a, 0x12, 0x52, 0x45, 0x53, 0x4f, 0x55, 0x52,
	0x43, 0x45, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x52, 0x4f, 0x4c, 0x45, 0x10, 0x0c, 0x12, 0x17,
	0x0a, 0x13, 0x52, 0x45, 0x53, 0x4f, 0x55, 0x52, 0x43, 0x45, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f,
	0x53, 0x43, 0x4f, 0x50, 0x45, 0x10, 0x0d, 0x12, 0x19, 0x0a, 0x15, 0x52, 0x45, 0x53, 0x4f, 0x55,
	0x52, 0x43, 0x45, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x53, 0x45, 0x53, 0x53, 0x49, 0x4f, 0x4e,
	0x10, 0x0e, 0x12, 0x23, 0x0a, 0x1f, 0x52, 0x45, 0x53, 0x4f, 0x55, 0x52, 0x43, 0x45, 0x5f, 0x54,
	0x59, 0x50, 0x45, 0x5f, 0x53, 0x45, 0x53, 0x53, 0x49, 0x4f, 0x4e, 0x5f, 0x52, 0x45, 0x43, 0x4f,
	0x52, 0x44, 0x49, 0x4e, 0x47, 0x10, 0x0f, 0x12, 0x20, 0x0a, 0x1c, 0x52, 0x45, 0x53, 0x4f, 0x55,
	0x52, 0x43, 0x45, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x53, 0x54, 0x4f, 0x52, 0x41, 0x47, 0x45,
	0x5f, 0x42, 0x55, 0x43, 0x4b, 0x45, 0x54, 0x10, 0x10, 0x12, 0x18, 0x0a, 0x14, 0x52, 0x45, 0x53,
	0x4f, 0x55, 0x52, 0x43, 0x45, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x54, 0x41, 0x52, 0x47, 0x45,
	0x54, 0x10, 0x11, 0x12, 0x16, 0x0a, 0x12, 0x52, 0x45, 0x53, 0x4f, 0x55, 0x52, 0x43, 0x45, 0x5f,
	0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x53, 0x45, 0x52, 0x10, 0x12, 0x12, 0x18, 0x0a, 0x14, 0x52,
	0x45, 0x53, 0x4f, 0x55, 0x52, 0x43, 0x45, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x57, 0x4f, 0x52,
	0x4b, 0x45, 0x52, 0x10, 0x13, 0x12, 0x18, 0x0a, 0x14, 0x52, 0x45, 0x53, 0x4f, 0x55, 0x52, 0x43,
	0x45, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x50, 0x4f, 0x4c, 0x49, 0x43, 0x59, 0x10, 0x14, 0x12,
	0x17, 0x0a, 0x13, 0x52, 0x45, 0x53, 0x4f, 0x55, 0x52, 0x43, 0x45, 0x5f, 0x54, 0x59, 0x50, 0x45,
	0x5f, 0x41, 0x4c, 0x49, 0x41, 0x53, 0x10, 0x15, 0x42, 0x4d, 0x5a, 0x4b, 0x67, 0x69, 0x74, 0x68,
	0x75, 0x62, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x68, 0x61, 0x73, 0x68, 0x69, 0x63, 0x6f, 0x72, 0x70,
	0x2f, 0x62, 0x6f, 0x75, 0x6e, 0x64, 0x61, 0x72, 0x79, 0x2f, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x6e,
	0x61, 0x6c, 0x2f, 0x67, 0x65, 0x6e, 0x2f, 0x63, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x6c, 0x65,
	0x72, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x3b, 0x73,
	0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_controller_api_services_v1_list_proto_rawDescOnce sync.Once
	file_controller_api_services_v1_list_proto_rawDescData = file_controller_api_services_v1_list_proto_rawDesc
)

func file_controller_api_services_v1_list_proto_rawDescGZIP() []byte {
	file_controller_api_services_v1_list_proto_rawDescOnce.Do(func() {
		file_controller_api_services_v1_list_proto_rawDescData = protoimpl.X.CompressGZIP(file_controller_api_services_v1_list_proto_rawDescData)
	})
	return file_controller_api_services_v1_list_proto_rawDescData
}

var file_controller_api_services_v1_list_proto_enumTypes = make([]protoimpl.EnumInfo, 1)
var file_controller_api_services_v1_list_proto_msgTypes = make([]protoimpl.MessageInfo, 4)
var file_controller_api_services_v1_list_proto_goTypes = []any{
	(ResourceType)(0),             // 0: controller.api.services.v1.ResourceType
	(*ListToken)(nil),             // 1: controller.api.services.v1.ListToken
	(*PaginationToken)(nil),       // 2: controller.api.services.v1.PaginationToken
	(*StartRefreshToken)(nil),     // 3: controller.api.services.v1.StartRefreshToken
	(*RefreshToken)(nil),          // 4: controller.api.services.v1.RefreshToken
	(*timestamppb.Timestamp)(nil), // 5: google.protobuf.Timestamp
}
var file_controller_api_services_v1_list_proto_depIdxs = []int32{
	5,  // 0: controller.api.services.v1.ListToken.create_time:type_name -> google.protobuf.Timestamp
	0,  // 1: controller.api.services.v1.ListToken.resource_type:type_name -> controller.api.services.v1.ResourceType
	2,  // 2: controller.api.services.v1.ListToken.pagination_token:type_name -> controller.api.services.v1.PaginationToken
	3,  // 3: controller.api.services.v1.ListToken.start_refresh_token:type_name -> controller.api.services.v1.StartRefreshToken
	4,  // 4: controller.api.services.v1.ListToken.refresh_token:type_name -> controller.api.services.v1.RefreshToken
	5,  // 5: controller.api.services.v1.PaginationToken.last_item_create_time:type_name -> google.protobuf.Timestamp
	5,  // 6: controller.api.services.v1.StartRefreshToken.previous_phase_upper_bound:type_name -> google.protobuf.Timestamp
	5,  // 7: controller.api.services.v1.StartRefreshToken.previous_deleted_ids_time:type_name -> google.protobuf.Timestamp
	5,  // 8: controller.api.services.v1.RefreshToken.phase_upper_bound:type_name -> google.protobuf.Timestamp
	5,  // 9: controller.api.services.v1.RefreshToken.phase_lower_bound:type_name -> google.protobuf.Timestamp
	5,  // 10: controller.api.services.v1.RefreshToken.previous_deleted_ids_time:type_name -> google.protobuf.Timestamp
	5,  // 11: controller.api.services.v1.RefreshToken.last_item_update_time:type_name -> google.protobuf.Timestamp
	12, // [12:12] is the sub-list for method output_type
	12, // [12:12] is the sub-list for method input_type
	12, // [12:12] is the sub-list for extension type_name
	12, // [12:12] is the sub-list for extension extendee
	0,  // [0:12] is the sub-list for field type_name
}

func init() { file_controller_api_services_v1_list_proto_init() }
func file_controller_api_services_v1_list_proto_init() {
	if File_controller_api_services_v1_list_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_controller_api_services_v1_list_proto_msgTypes[0].Exporter = func(v any, i int) any {
			switch v := v.(*ListToken); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_controller_api_services_v1_list_proto_msgTypes[1].Exporter = func(v any, i int) any {
			switch v := v.(*PaginationToken); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_controller_api_services_v1_list_proto_msgTypes[2].Exporter = func(v any, i int) any {
			switch v := v.(*StartRefreshToken); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_controller_api_services_v1_list_proto_msgTypes[3].Exporter = func(v any, i int) any {
			switch v := v.(*RefreshToken); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_controller_api_services_v1_list_proto_msgTypes[0].OneofWrappers = []any{
		(*ListToken_PaginationToken)(nil),
		(*ListToken_StartRefreshToken)(nil),
		(*ListToken_RefreshToken)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_controller_api_services_v1_list_proto_rawDesc,
			NumEnums:      1,
			NumMessages:   4,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_controller_api_services_v1_list_proto_goTypes,
		DependencyIndexes: file_controller_api_services_v1_list_proto_depIdxs,
		EnumInfos:         file_controller_api_services_v1_list_proto_enumTypes,
		MessageInfos:      file_controller_api_services_v1_list_proto_msgTypes,
	}.Build()
	File_controller_api_services_v1_list_proto = out.File
	file_controller_api_services_v1_list_proto_rawDesc = nil
	file_controller_api_services_v1_list_proto_goTypes = nil
	file_controller_api_services_v1_list_proto_depIdxs = nil
}
