// Copyright (c) HashiCorp, Inc.
// SPDX-License-Identifier: MPL-2.0

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.3.0
// - protoc             (unknown)
// source: controller/api/services/v1/host_set_service.proto

package services

import (
	context "context"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

const (
	HostSetService_GetHostSet_FullMethodName         = "/controller.api.services.v1.HostSetService/GetHostSet"
	HostSetService_ListHostSets_FullMethodName       = "/controller.api.services.v1.HostSetService/ListHostSets"
	HostSetService_CreateHostSet_FullMethodName      = "/controller.api.services.v1.HostSetService/CreateHostSet"
	HostSetService_UpdateHostSet_FullMethodName      = "/controller.api.services.v1.HostSetService/UpdateHostSet"
	HostSetService_DeleteHostSet_FullMethodName      = "/controller.api.services.v1.HostSetService/DeleteHostSet"
	HostSetService_AddHostSetHosts_FullMethodName    = "/controller.api.services.v1.HostSetService/AddHostSetHosts"
	HostSetService_SetHostSetHosts_FullMethodName    = "/controller.api.services.v1.HostSetService/SetHostSetHosts"
	HostSetService_RemoveHostSetHosts_FullMethodName = "/controller.api.services.v1.HostSetService/RemoveHostSetHosts"
)

// HostSetServiceClient is the client API for HostSetService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type HostSetServiceClient interface {
	// GetHostSet returns a stored Host Set if present.  The provided request
	// must include the Host Set ID for the resource being retrieved. If missing,
	// malformed or reference a non existing resource an error is returned.
	GetHostSet(ctx context.Context, in *GetHostSetRequest, opts ...grpc.CallOption) (*GetHostSetResponse, error)
	// ListHostSets returns a list of stored Host Sets which exist inside the
	// Host Catalog provided. The request must include a properly formatted
	// Host Catalog id or an error is returned.
	ListHostSets(ctx context.Context, in *ListHostSetsRequest, opts ...grpc.CallOption) (*ListHostSetsResponse, error)
	// CreateHostSet creates and stores a Host Set in boundary.  The provided
	// request must include the Host Catalog id in which the Host Set
	// will be created.  If the Host Catalog id is missing, malformed or
	// references a non existing resource, an error is returned.  If a name is
	// provided that is in use by another Host Set in the same Host Catalog, an
	// error is returned.
	CreateHostSet(ctx context.Context, in *CreateHostSetRequest, opts ...grpc.CallOption) (*CreateHostSetResponse, error)
	// UpdateHostSet updates an existing Host Set in boundary.  The provided
	// Host Set must not have any read only fields set.  The update mask must be
	// included in the request and contain at least 1 mutable field.  To unset
	// a field's value, include the field in the update mask and don't set it
	// in the provided Host Set. An error is returned if the Host Set id is
	// missing or reference a non-existing resource.
	// An error is also returned if the request attempts to update the name to
	// one that is already in use in this Host Catalog.
	UpdateHostSet(ctx context.Context, in *UpdateHostSetRequest, opts ...grpc.CallOption) (*UpdateHostSetResponse, error)
	// DeleteHostSet removes a Host Set from Boundary. If the provided
	// Host Set id is malformed or not provided an error is returned.
	DeleteHostSet(ctx context.Context, in *DeleteHostSetRequest, opts ...grpc.CallOption) (*DeleteHostSetResponse, error)
	// AddHostSetHosts adds a Host to a Host Set. The provided request must
	// include the Host Set ID to which the Host will be added.
	// All hosts added to the provided Host Set must be a child of the same
	// Catalog that this Host Set is a child of. If the Host Set IDs is
	// missing, malformed, or reference non-existing resources, an error is
	// returned.  It is an error to add a Host which already exists in the
	// Host Set.
	AddHostSetHosts(ctx context.Context, in *AddHostSetHostsRequest, opts ...grpc.CallOption) (*AddHostSetHostsResponse, error)
	// SetHostSetHosts sets the Host Set's hosts. Any existing hosts on the
	// Host Set are deleted if they are not included in this request. The
	// provided request must include the Host Set ID on which the hosts will be
	// set.  All Hosts in the request must be a child of the same Catalog that
	// the provided Host Set is. An error is returned if any of the provided
	// ids are malformed or references a non-existing resource.
	SetHostSetHosts(ctx context.Context, in *SetHostSetHostsRequest, opts ...grpc.CallOption) (*SetHostSetHostsResponse, error)
	// RemoveHostSetHosts removes the Hosts from the specified Host Set. The
	// provided request must include the Host Set ID which the Host will be
	// removed. An error is a returned if any of the provided IDs are malformed,
	// or references a non-existing scope or catalog, or if a Host id is included
	// which is not in the provided Host Set.
	RemoveHostSetHosts(ctx context.Context, in *RemoveHostSetHostsRequest, opts ...grpc.CallOption) (*RemoveHostSetHostsResponse, error)
}

type hostSetServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewHostSetServiceClient(cc grpc.ClientConnInterface) HostSetServiceClient {
	return &hostSetServiceClient{cc}
}

func (c *hostSetServiceClient) GetHostSet(ctx context.Context, in *GetHostSetRequest, opts ...grpc.CallOption) (*GetHostSetResponse, error) {
	out := new(GetHostSetResponse)
	err := c.cc.Invoke(ctx, HostSetService_GetHostSet_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *hostSetServiceClient) ListHostSets(ctx context.Context, in *ListHostSetsRequest, opts ...grpc.CallOption) (*ListHostSetsResponse, error) {
	out := new(ListHostSetsResponse)
	err := c.cc.Invoke(ctx, HostSetService_ListHostSets_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *hostSetServiceClient) CreateHostSet(ctx context.Context, in *CreateHostSetRequest, opts ...grpc.CallOption) (*CreateHostSetResponse, error) {
	out := new(CreateHostSetResponse)
	err := c.cc.Invoke(ctx, HostSetService_CreateHostSet_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *hostSetServiceClient) UpdateHostSet(ctx context.Context, in *UpdateHostSetRequest, opts ...grpc.CallOption) (*UpdateHostSetResponse, error) {
	out := new(UpdateHostSetResponse)
	err := c.cc.Invoke(ctx, HostSetService_UpdateHostSet_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *hostSetServiceClient) DeleteHostSet(ctx context.Context, in *DeleteHostSetRequest, opts ...grpc.CallOption) (*DeleteHostSetResponse, error) {
	out := new(DeleteHostSetResponse)
	err := c.cc.Invoke(ctx, HostSetService_DeleteHostSet_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *hostSetServiceClient) AddHostSetHosts(ctx context.Context, in *AddHostSetHostsRequest, opts ...grpc.CallOption) (*AddHostSetHostsResponse, error) {
	out := new(AddHostSetHostsResponse)
	err := c.cc.Invoke(ctx, HostSetService_AddHostSetHosts_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *hostSetServiceClient) SetHostSetHosts(ctx context.Context, in *SetHostSetHostsRequest, opts ...grpc.CallOption) (*SetHostSetHostsResponse, error) {
	out := new(SetHostSetHostsResponse)
	err := c.cc.Invoke(ctx, HostSetService_SetHostSetHosts_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *hostSetServiceClient) RemoveHostSetHosts(ctx context.Context, in *RemoveHostSetHostsRequest, opts ...grpc.CallOption) (*RemoveHostSetHostsResponse, error) {
	out := new(RemoveHostSetHostsResponse)
	err := c.cc.Invoke(ctx, HostSetService_RemoveHostSetHosts_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// HostSetServiceServer is the server API for HostSetService service.
// All implementations must embed UnimplementedHostSetServiceServer
// for forward compatibility
type HostSetServiceServer interface {
	// GetHostSet returns a stored Host Set if present.  The provided request
	// must include the Host Set ID for the resource being retrieved. If missing,
	// malformed or reference a non existing resource an error is returned.
	GetHostSet(context.Context, *GetHostSetRequest) (*GetHostSetResponse, error)
	// ListHostSets returns a list of stored Host Sets which exist inside the
	// Host Catalog provided. The request must include a properly formatted
	// Host Catalog id or an error is returned.
	ListHostSets(context.Context, *ListHostSetsRequest) (*ListHostSetsResponse, error)
	// CreateHostSet creates and stores a Host Set in boundary.  The provided
	// request must include the Host Catalog id in which the Host Set
	// will be created.  If the Host Catalog id is missing, malformed or
	// references a non existing resource, an error is returned.  If a name is
	// provided that is in use by another Host Set in the same Host Catalog, an
	// error is returned.
	CreateHostSet(context.Context, *CreateHostSetRequest) (*CreateHostSetResponse, error)
	// UpdateHostSet updates an existing Host Set in boundary.  The provided
	// Host Set must not have any read only fields set.  The update mask must be
	// included in the request and contain at least 1 mutable field.  To unset
	// a field's value, include the field in the update mask and don't set it
	// in the provided Host Set. An error is returned if the Host Set id is
	// missing or reference a non-existing resource.
	// An error is also returned if the request attempts to update the name to
	// one that is already in use in this Host Catalog.
	UpdateHostSet(context.Context, *UpdateHostSetRequest) (*UpdateHostSetResponse, error)
	// DeleteHostSet removes a Host Set from Boundary. If the provided
	// Host Set id is malformed or not provided an error is returned.
	DeleteHostSet(context.Context, *DeleteHostSetRequest) (*DeleteHostSetResponse, error)
	// AddHostSetHosts adds a Host to a Host Set. The provided request must
	// include the Host Set ID to which the Host will be added.
	// All hosts added to the provided Host Set must be a child of the same
	// Catalog that this Host Set is a child of. If the Host Set IDs is
	// missing, malformed, or reference non-existing resources, an error is
	// returned.  It is an error to add a Host which already exists in the
	// Host Set.
	AddHostSetHosts(context.Context, *AddHostSetHostsRequest) (*AddHostSetHostsResponse, error)
	// SetHostSetHosts sets the Host Set's hosts. Any existing hosts on the
	// Host Set are deleted if they are not included in this request. The
	// provided request must include the Host Set ID on which the hosts will be
	// set.  All Hosts in the request must be a child of the same Catalog that
	// the provided Host Set is. An error is returned if any of the provided
	// ids are malformed or references a non-existing resource.
	SetHostSetHosts(context.Context, *SetHostSetHostsRequest) (*SetHostSetHostsResponse, error)
	// RemoveHostSetHosts removes the Hosts from the specified Host Set. The
	// provided request must include the Host Set ID which the Host will be
	// removed. An error is a returned if any of the provided IDs are malformed,
	// or references a non-existing scope or catalog, or if a Host id is included
	// which is not in the provided Host Set.
	RemoveHostSetHosts(context.Context, *RemoveHostSetHostsRequest) (*RemoveHostSetHostsResponse, error)
	mustEmbedUnimplementedHostSetServiceServer()
}

// UnimplementedHostSetServiceServer must be embedded to have forward compatible implementations.
type UnimplementedHostSetServiceServer struct {
}

func (UnimplementedHostSetServiceServer) GetHostSet(context.Context, *GetHostSetRequest) (*GetHostSetResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetHostSet not implemented")
}
func (UnimplementedHostSetServiceServer) ListHostSets(context.Context, *ListHostSetsRequest) (*ListHostSetsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListHostSets not implemented")
}
func (UnimplementedHostSetServiceServer) CreateHostSet(context.Context, *CreateHostSetRequest) (*CreateHostSetResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateHostSet not implemented")
}
func (UnimplementedHostSetServiceServer) UpdateHostSet(context.Context, *UpdateHostSetRequest) (*UpdateHostSetResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateHostSet not implemented")
}
func (UnimplementedHostSetServiceServer) DeleteHostSet(context.Context, *DeleteHostSetRequest) (*DeleteHostSetResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteHostSet not implemented")
}
func (UnimplementedHostSetServiceServer) AddHostSetHosts(context.Context, *AddHostSetHostsRequest) (*AddHostSetHostsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method AddHostSetHosts not implemented")
}
func (UnimplementedHostSetServiceServer) SetHostSetHosts(context.Context, *SetHostSetHostsRequest) (*SetHostSetHostsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SetHostSetHosts not implemented")
}
func (UnimplementedHostSetServiceServer) RemoveHostSetHosts(context.Context, *RemoveHostSetHostsRequest) (*RemoveHostSetHostsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method RemoveHostSetHosts not implemented")
}
func (UnimplementedHostSetServiceServer) mustEmbedUnimplementedHostSetServiceServer() {}

// UnsafeHostSetServiceServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to HostSetServiceServer will
// result in compilation errors.
type UnsafeHostSetServiceServer interface {
	mustEmbedUnimplementedHostSetServiceServer()
}

func RegisterHostSetServiceServer(s grpc.ServiceRegistrar, srv HostSetServiceServer) {
	s.RegisterService(&HostSetService_ServiceDesc, srv)
}

func _HostSetService_GetHostSet_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetHostSetRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(HostSetServiceServer).GetHostSet(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: HostSetService_GetHostSet_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(HostSetServiceServer).GetHostSet(ctx, req.(*GetHostSetRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _HostSetService_ListHostSets_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListHostSetsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(HostSetServiceServer).ListHostSets(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: HostSetService_ListHostSets_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(HostSetServiceServer).ListHostSets(ctx, req.(*ListHostSetsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _HostSetService_CreateHostSet_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateHostSetRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(HostSetServiceServer).CreateHostSet(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: HostSetService_CreateHostSet_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(HostSetServiceServer).CreateHostSet(ctx, req.(*CreateHostSetRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _HostSetService_UpdateHostSet_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateHostSetRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(HostSetServiceServer).UpdateHostSet(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: HostSetService_UpdateHostSet_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(HostSetServiceServer).UpdateHostSet(ctx, req.(*UpdateHostSetRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _HostSetService_DeleteHostSet_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteHostSetRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(HostSetServiceServer).DeleteHostSet(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: HostSetService_DeleteHostSet_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(HostSetServiceServer).DeleteHostSet(ctx, req.(*DeleteHostSetRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _HostSetService_AddHostSetHosts_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AddHostSetHostsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(HostSetServiceServer).AddHostSetHosts(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: HostSetService_AddHostSetHosts_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(HostSetServiceServer).AddHostSetHosts(ctx, req.(*AddHostSetHostsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _HostSetService_SetHostSetHosts_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SetHostSetHostsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(HostSetServiceServer).SetHostSetHosts(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: HostSetService_SetHostSetHosts_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(HostSetServiceServer).SetHostSetHosts(ctx, req.(*SetHostSetHostsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _HostSetService_RemoveHostSetHosts_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RemoveHostSetHostsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(HostSetServiceServer).RemoveHostSetHosts(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: HostSetService_RemoveHostSetHosts_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(HostSetServiceServer).RemoveHostSetHosts(ctx, req.(*RemoveHostSetHostsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// HostSetService_ServiceDesc is the grpc.ServiceDesc for HostSetService service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var HostSetService_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "controller.api.services.v1.HostSetService",
	HandlerType: (*HostSetServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "GetHostSet",
			Handler:    _HostSetService_GetHostSet_Handler,
		},
		{
			MethodName: "ListHostSets",
			Handler:    _HostSetService_ListHostSets_Handler,
		},
		{
			MethodName: "CreateHostSet",
			Handler:    _HostSetService_CreateHostSet_Handler,
		},
		{
			MethodName: "UpdateHostSet",
			Handler:    _HostSetService_UpdateHostSet_Handler,
		},
		{
			MethodName: "DeleteHostSet",
			Handler:    _HostSetService_DeleteHostSet_Handler,
		},
		{
			MethodName: "AddHostSetHosts",
			Handler:    _HostSetService_AddHostSetHosts_Handler,
		},
		{
			MethodName: "SetHostSetHosts",
			Handler:    _HostSetService_SetHostSetHosts_Handler,
		},
		{
			MethodName: "RemoveHostSetHosts",
			Handler:    _HostSetService_RemoveHostSetHosts_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "controller/api/services/v1/host_set_service.proto",
}
