// Copyright (c) HashiCorp, Inc.
// SPDX-License-Identifier: MPL-2.0

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.3.0
// - protoc             (unknown)
// source: controller/api/services/v1/host_service.proto

package services

import (
	context "context"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

const (
	HostService_GetHost_FullMethodName    = "/controller.api.services.v1.HostService/GetHost"
	HostService_ListHosts_FullMethodName  = "/controller.api.services.v1.HostService/ListHosts"
	HostService_CreateHost_FullMethodName = "/controller.api.services.v1.HostService/CreateHost"
	HostService_UpdateHost_FullMethodName = "/controller.api.services.v1.HostService/UpdateHost"
	HostService_DeleteHost_FullMethodName = "/controller.api.services.v1.HostService/DeleteHost"
)

// HostServiceClient is the client API for HostService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type HostServiceClient interface {
	// GetHost returns a stored Host if present.  The provided request
	// must include the host ID for the resource being retrieved. If the ID is
	// missing, malformed or referencing anon existing resource an error is
	// returned.
	GetHost(ctx context.Context, in *GetHostRequest, opts ...grpc.CallOption) (*GetHostResponse, error)
	// ListHosts returns a list of stored hosts which exist inside the provided
	// Host Catalog. The request must include the Host Catalog id containing the
	// Hosts being listed.  If the id is missing, malformed, or reference a
	// non-existing resource, an error is returned.
	ListHosts(ctx context.Context, in *ListHostsRequest, opts ...grpc.CallOption) (*ListHostsResponse, error)
	// CreateHost creates and stores a Host in boundary.  The provided
	// request must include the Host Catalog id in which the Host
	// will be created.  If the Catalog id is missing, malformed or references a
	// non-existing resource, an error is returned.  If a name is provided that
	// is in use by another Host in the same Host Catalog, an error is returned.
	CreateHost(ctx context.Context, in *CreateHostRequest, opts ...grpc.CallOption) (*CreateHostResponse, error)
	// UpdateHost updates an existing Host in boundary.  The provided
	// Host must not have any read only fields set.  The update mask must be
	// included in the request and contain at least 1 mutable field.  To unset
	// a field's value, include the field in the update mask and don't set it
	// in the provided Host. An error is returned if the Host id is missing or
	// reference a non-existing resource.  An error is also returned if the
	// request attempts to update the name to one that is already in use in
	// the same Host Catalog.
	UpdateHost(ctx context.Context, in *UpdateHostRequest, opts ...grpc.CallOption) (*UpdateHostResponse, error)
	// DeleteHost removes a Host from Boundary. If the provided Host ID
	// is malformed or not provided an error is returned.
	DeleteHost(ctx context.Context, in *DeleteHostRequest, opts ...grpc.CallOption) (*DeleteHostResponse, error)
}

type hostServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewHostServiceClient(cc grpc.ClientConnInterface) HostServiceClient {
	return &hostServiceClient{cc}
}

func (c *hostServiceClient) GetHost(ctx context.Context, in *GetHostRequest, opts ...grpc.CallOption) (*GetHostResponse, error) {
	out := new(GetHostResponse)
	err := c.cc.Invoke(ctx, HostService_GetHost_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *hostServiceClient) ListHosts(ctx context.Context, in *ListHostsRequest, opts ...grpc.CallOption) (*ListHostsResponse, error) {
	out := new(ListHostsResponse)
	err := c.cc.Invoke(ctx, HostService_ListHosts_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *hostServiceClient) CreateHost(ctx context.Context, in *CreateHostRequest, opts ...grpc.CallOption) (*CreateHostResponse, error) {
	out := new(CreateHostResponse)
	err := c.cc.Invoke(ctx, HostService_CreateHost_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *hostServiceClient) UpdateHost(ctx context.Context, in *UpdateHostRequest, opts ...grpc.CallOption) (*UpdateHostResponse, error) {
	out := new(UpdateHostResponse)
	err := c.cc.Invoke(ctx, HostService_UpdateHost_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *hostServiceClient) DeleteHost(ctx context.Context, in *DeleteHostRequest, opts ...grpc.CallOption) (*DeleteHostResponse, error) {
	out := new(DeleteHostResponse)
	err := c.cc.Invoke(ctx, HostService_DeleteHost_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// HostServiceServer is the server API for HostService service.
// All implementations must embed UnimplementedHostServiceServer
// for forward compatibility
type HostServiceServer interface {
	// GetHost returns a stored Host if present.  The provided request
	// must include the host ID for the resource being retrieved. If the ID is
	// missing, malformed or referencing anon existing resource an error is
	// returned.
	GetHost(context.Context, *GetHostRequest) (*GetHostResponse, error)
	// ListHosts returns a list of stored hosts which exist inside the provided
	// Host Catalog. The request must include the Host Catalog id containing the
	// Hosts being listed.  If the id is missing, malformed, or reference a
	// non-existing resource, an error is returned.
	ListHosts(context.Context, *ListHostsRequest) (*ListHostsResponse, error)
	// CreateHost creates and stores a Host in boundary.  The provided
	// request must include the Host Catalog id in which the Host
	// will be created.  If the Catalog id is missing, malformed or references a
	// non-existing resource, an error is returned.  If a name is provided that
	// is in use by another Host in the same Host Catalog, an error is returned.
	CreateHost(context.Context, *CreateHostRequest) (*CreateHostResponse, error)
	// UpdateHost updates an existing Host in boundary.  The provided
	// Host must not have any read only fields set.  The update mask must be
	// included in the request and contain at least 1 mutable field.  To unset
	// a field's value, include the field in the update mask and don't set it
	// in the provided Host. An error is returned if the Host id is missing or
	// reference a non-existing resource.  An error is also returned if the
	// request attempts to update the name to one that is already in use in
	// the same Host Catalog.
	UpdateHost(context.Context, *UpdateHostRequest) (*UpdateHostResponse, error)
	// DeleteHost removes a Host from Boundary. If the provided Host ID
	// is malformed or not provided an error is returned.
	DeleteHost(context.Context, *DeleteHostRequest) (*DeleteHostResponse, error)
	mustEmbedUnimplementedHostServiceServer()
}

// UnimplementedHostServiceServer must be embedded to have forward compatible implementations.
type UnimplementedHostServiceServer struct {
}

func (UnimplementedHostServiceServer) GetHost(context.Context, *GetHostRequest) (*GetHostResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetHost not implemented")
}
func (UnimplementedHostServiceServer) ListHosts(context.Context, *ListHostsRequest) (*ListHostsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListHosts not implemented")
}
func (UnimplementedHostServiceServer) CreateHost(context.Context, *CreateHostRequest) (*CreateHostResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateHost not implemented")
}
func (UnimplementedHostServiceServer) UpdateHost(context.Context, *UpdateHostRequest) (*UpdateHostResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateHost not implemented")
}
func (UnimplementedHostServiceServer) DeleteHost(context.Context, *DeleteHostRequest) (*DeleteHostResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteHost not implemented")
}
func (UnimplementedHostServiceServer) mustEmbedUnimplementedHostServiceServer() {}

// UnsafeHostServiceServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to HostServiceServer will
// result in compilation errors.
type UnsafeHostServiceServer interface {
	mustEmbedUnimplementedHostServiceServer()
}

func RegisterHostServiceServer(s grpc.ServiceRegistrar, srv HostServiceServer) {
	s.RegisterService(&HostService_ServiceDesc, srv)
}

func _HostService_GetHost_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetHostRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(HostServiceServer).GetHost(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: HostService_GetHost_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(HostServiceServer).GetHost(ctx, req.(*GetHostRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _HostService_ListHosts_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListHostsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(HostServiceServer).ListHosts(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: HostService_ListHosts_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(HostServiceServer).ListHosts(ctx, req.(*ListHostsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _HostService_CreateHost_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateHostRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(HostServiceServer).CreateHost(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: HostService_CreateHost_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(HostServiceServer).CreateHost(ctx, req.(*CreateHostRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _HostService_UpdateHost_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateHostRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(HostServiceServer).UpdateHost(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: HostService_UpdateHost_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(HostServiceServer).UpdateHost(ctx, req.(*UpdateHostRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _HostService_DeleteHost_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteHostRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(HostServiceServer).DeleteHost(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: HostService_DeleteHost_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(HostServiceServer).DeleteHost(ctx, req.(*DeleteHostRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// HostService_ServiceDesc is the grpc.ServiceDesc for HostService service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var HostService_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "controller.api.services.v1.HostService",
	HandlerType: (*HostServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "GetHost",
			Handler:    _HostService_GetHost_Handler,
		},
		{
			MethodName: "ListHosts",
			Handler:    _HostService_ListHosts_Handler,
		},
		{
			MethodName: "CreateHost",
			Handler:    _HostService_CreateHost_Handler,
		},
		{
			MethodName: "UpdateHost",
			Handler:    _HostService_UpdateHost_Handler,
		},
		{
			MethodName: "DeleteHost",
			Handler:    _HostService_DeleteHost_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "controller/api/services/v1/host_service.proto",
}
